/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.sourcesSinks.manager;

import heros.solver.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.manager.AbstractSourceSinkInfo;
import soot.util.HashMultiMap;

public class SourceInfo
extends AbstractSourceSinkInfo {
    protected final HashMultiMap<AccessPath, ISourceSinkDefinition> accessPathsToDefinitions;

    public SourceInfo(ISourceSinkDefinition definition, AccessPath ap) {
        this(definition, ap, null);
    }

    public SourceInfo(AccessPath ap) {
        this(Collections.singleton(new Pair<AccessPath, Object>(ap, null)));
    }

    public SourceInfo(ISourceSinkDefinition definition, Collection<AccessPath> aps) {
        this(aps.stream().map(ap -> new Pair<AccessPath, ISourceSinkDefinition>((AccessPath)ap, definition)).collect(Collectors.toSet()), null);
    }

    public SourceInfo(ISourceSinkDefinition definition, AccessPath ap, Object userData) {
        this(Collections.singleton(new Pair<AccessPath, ISourceSinkDefinition>(ap, definition)), userData);
    }

    public SourceInfo(Collection<Pair<AccessPath, ISourceSinkDefinition>> apAndDefs) {
        this(apAndDefs, null);
    }

    public SourceInfo(Collection<Pair<AccessPath, ISourceSinkDefinition>> apAndDefs, Object userData) {
        super(userData);
        assert (apAndDefs.size() > 0);
        this.accessPathsToDefinitions = new HashMultiMap();
        for (Pair<AccessPath, ISourceSinkDefinition> apAndDef : apAndDefs) {
            this.accessPathsToDefinitions.put(apAndDef.getO1(), apAndDef.getO2());
        }
    }

    public Set<AccessPath> getAccessPaths() {
        return this.accessPathsToDefinitions.keySet();
    }

    public Collection<ISourceSinkDefinition> getDefinitionsForAccessPath(AccessPath ap) {
        return this.accessPathsToDefinitions.get(ap);
    }

    public Collection<ISourceSinkDefinition> getAllDefinitions() {
        return this.accessPathsToDefinitions.values();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.accessPathsToDefinitions == null ? 0 : this.accessPathsToDefinitions.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourceInfo other = (SourceInfo)obj;
        return !(this.accessPathsToDefinitions == null ? other.accessPathsToDefinitions != null : !this.accessPathsToDefinitions.equals(other.accessPathsToDefinitions));
    }
}

