/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.sourcesSinks.manager;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.solver.IDESolver;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinitionProvider;
import soot.jimple.infoflow.sourcesSinks.definitions.MethodSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.manager.IReversibleSourceSinkManager;
import soot.jimple.infoflow.sourcesSinks.manager.SinkInfo;
import soot.jimple.infoflow.sourcesSinks.manager.SourceInfo;
import soot.jimple.infoflow.util.SystemClassHandler;

public class DefaultSourceSinkManager
implements IReversibleSourceSinkManager {
    protected Collection<String> sourceDefs;
    protected Collection<String> sinkDefs;
    private Collection<SootMethod> sources;
    private Collection<SootMethod> sinks;
    private Collection<String> returnTaintMethodDefs;
    private Collection<String> parameterTaintMethodDefs;
    private Collection<SootMethod> returnTaintMethods;
    private Collection<SootMethod> parameterTaintMethods;
    protected final LoadingCache<SootClass, Collection<SootClass>> interfacesOf = IDESolver.DEFAULT_CACHE_BUILDER.build(new CacheLoader<SootClass, Collection<SootClass>>(){

        @Override
        public Collection<SootClass> load(SootClass sc) throws Exception {
            HashSet<SootClass> set = new HashSet<SootClass>(sc.getInterfaceCount());
            for (SootClass i : sc.getInterfaces()) {
                set.add(i);
                set.addAll(DefaultSourceSinkManager.this.interfacesOf.getUnchecked(i));
            }
            SootClass superClass = sc.getSuperclassUnsafe();
            if (superClass != null) {
                set.addAll(DefaultSourceSinkManager.this.interfacesOf.getUnchecked(superClass));
            }
            return set;
        }
    });

    public DefaultSourceSinkManager(Collection<String> sources, Collection<String> sinks) {
        this(sources, sinks, null, null);
    }

    public DefaultSourceSinkManager(Collection<String> sources, Collection<String> sinks, Collection<String> parameterTaintMethods, Collection<String> returnTaintMethods) {
        this.sourceDefs = sources;
        this.sinkDefs = sinks;
        this.parameterTaintMethodDefs = parameterTaintMethods != null ? parameterTaintMethods : new HashSet();
        this.returnTaintMethodDefs = returnTaintMethods != null ? returnTaintMethods : new HashSet();
    }

    public DefaultSourceSinkManager(ISourceSinkDefinitionProvider sourceSinkProvider) {
        MethodSourceSinkDefinition mssd;
        this.sourceDefs = new HashSet<String>();
        this.sinkDefs = new HashSet<String>();
        for (ISourceSinkDefinition iSourceSinkDefinition : sourceSinkProvider.getSources()) {
            if (!(iSourceSinkDefinition instanceof MethodSourceSinkDefinition)) continue;
            mssd = (MethodSourceSinkDefinition)iSourceSinkDefinition;
            this.sourceDefs.add(mssd.getMethod().getSignature());
        }
        for (ISourceSinkDefinition iSourceSinkDefinition : sourceSinkProvider.getSinks()) {
            if (!(iSourceSinkDefinition instanceof MethodSourceSinkDefinition)) continue;
            mssd = (MethodSourceSinkDefinition)iSourceSinkDefinition;
            this.sinkDefs.add(mssd.getMethod().getSignature());
        }
    }

    public void setSources(List<String> sources) {
        this.sourceDefs = sources;
    }

    public void setSinks(List<String> sinks) {
        this.sinkDefs = sinks;
    }

    private SootMethod getMethodInSet(InfoflowManager manager, Stmt callStmt, Collection<SootMethod> set) {
        if (!callStmt.containsInvokeExpr() || set == null) {
            return null;
        }
        SootMethod callee = callStmt.getInvokeExpr().getMethod();
        if (set.contains(callee)) {
            return callee;
        }
        String subSig = callee.getSubSignature();
        for (SootClass i : this.interfacesOf.getUnchecked(callee.getDeclaringClass())) {
            SootMethod sm = i.getMethodUnsafe(subSig);
            if (sm == null || !set.contains(sm)) continue;
            return sm;
        }
        for (SootMethod sm : manager.getICFG().getCalleesOfCallAt(callStmt)) {
            if (!set.contains(sm)) continue;
            return sm;
        }
        return null;
    }

    protected boolean isSourceMethod(InfoflowManager manager, Stmt sCallSite) {
        return this.getMethodInSet(manager, sCallSite, this.sources) != null;
    }

    protected SootMethodAndClass isInverseSourceMethod(InfoflowManager manager, Stmt sCallSite) {
        SootMethod sm = this.getMethodInSet(manager, sCallSite, this.sources);
        return sm == null ? null : new SootMethodAndClass(sm);
    }

    protected SootMethodAndClass isSinkMethod(InfoflowManager manager, Stmt sCallSite) {
        SootMethod sm = this.getMethodInSet(manager, sCallSite, this.sinks);
        return sm == null ? null : new SootMethodAndClass(sm);
    }

    protected boolean isInverseSinkMethod(InfoflowManager manager, Stmt sCallSite) {
        return this.getMethodInSet(manager, sCallSite, this.sinks) != null;
    }

    @Override
    public SourceInfo getSourceInfo(Stmt sCallSite, InfoflowManager manager) {
        IdentityStmt istmt;
        SootMethod callee = sCallSite.containsInvokeExpr() ? sCallSite.getInvokeExpr().getMethod() : null;
        AccessPath targetAP = null;
        if (this.isSourceMethod(manager, sCallSite)) {
            if (callee.getReturnType() != null && sCallSite instanceof DefinitionStmt) {
                Value leftOp = ((DefinitionStmt)sCallSite).getLeftOp();
                targetAP = manager.getAccessPathFactory().createAccessPath(leftOp, true);
            } else if (sCallSite.getInvokeExpr() instanceof InstanceInvokeExpr) {
                Value base = ((InstanceInvokeExpr)sCallSite.getInvokeExpr()).getBase();
                targetAP = manager.getAccessPathFactory().createAccessPath(base, true);
            }
        } else if (sCallSite instanceof IdentityStmt && (istmt = (IdentityStmt)sCallSite).getRightOp() instanceof ParameterRef) {
            ParameterRef pref = (ParameterRef)istmt.getRightOp();
            SootMethod currentMethod = (SootMethod)manager.getICFG().getMethodOf(istmt);
            if (this.parameterTaintMethods != null && this.parameterTaintMethods.contains(currentMethod)) {
                targetAP = manager.getAccessPathFactory().createAccessPath(currentMethod.getActiveBody().getParameterLocal(pref.getIndex()), true);
            }
        }
        if (targetAP == null) {
            return null;
        }
        return new SourceInfo((ISourceSinkDefinition)(callee == null ? null : new MethodSourceSinkDefinition(new SootMethodAndClass(callee))), targetAP);
    }

    @Override
    public SinkInfo getSinkInfo(Stmt sCallSite, InfoflowManager manager, AccessPath ap) {
        if (this.returnTaintMethods != null && sCallSite instanceof ReturnStmt) {
            SootMethod sm = (SootMethod)manager.getICFG().getMethodOf(sCallSite);
            if (this.returnTaintMethods != null && this.returnTaintMethods.contains(sm)) {
                return new SinkInfo(new MethodSourceSinkDefinition(new SootMethodAndClass(sm)));
            }
        }
        if (this.sinks != null && !this.sinks.isEmpty() && sCallSite.containsInvokeExpr()) {
            InvokeExpr iexpr = sCallSite.getInvokeExpr();
            SootMethodAndClass smac = this.isSinkMethod(manager, sCallSite);
            if (smac != null && SystemClassHandler.v().isTaintVisible(ap, iexpr.getMethod())) {
                if (ap == null) {
                    return new SinkInfo(new MethodSourceSinkDefinition(smac));
                }
                if (!ap.isStaticFieldRef()) {
                    for (int i = 0; i < iexpr.getArgCount(); ++i) {
                        if (iexpr.getArg(i) != ap.getPlainValue() || !ap.getTaintSubFields() && !ap.isLocal()) continue;
                        return new SinkInfo(new MethodSourceSinkDefinition(smac));
                    }
                    if (iexpr instanceof InstanceInvokeExpr && ((InstanceInvokeExpr)iexpr).getBase() == ap.getPlainValue()) {
                        return new SinkInfo(new MethodSourceSinkDefinition(smac));
                    }
                }
            }
        }
        return null;
    }

    @Override
    public SinkInfo getInverseSourceInfo(Stmt sCallSite, InfoflowManager manager, AccessPath ap) {
        IdentityStmt istmt;
        SootMethodAndClass smac = this.isInverseSourceMethod(manager, sCallSite);
        if (smac != null) {
            InvokeExpr ie = sCallSite.getInvokeExpr();
            if (!SystemClassHandler.v().isTaintVisible(ap, ie.getMethod())) {
                return null;
            }
            if (ap == null) {
                return new SinkInfo(new MethodSourceSinkDefinition(smac));
            }
            if (!ap.isStaticFieldRef() && (sCallSite instanceof AssignStmt ? ((AssignStmt)sCallSite).getLeftOp() == ap.getPlainValue() : ie instanceof InstanceInvokeExpr && ((InstanceInvokeExpr)ie).getBase() == ap.getPlainValue())) {
                return new SinkInfo(new MethodSourceSinkDefinition(smac));
            }
        } else if (sCallSite instanceof IdentityStmt && (istmt = (IdentityStmt)sCallSite).getRightOp() instanceof ParameterRef) {
            SootMethod currentMethod = (SootMethod)manager.getICFG().getMethodOf(istmt);
            if (this.parameterTaintMethods != null && this.parameterTaintMethods.contains(currentMethod)) {
                SootMethodAndClass pSmac = new SootMethodAndClass(currentMethod);
                return new SinkInfo(new MethodSourceSinkDefinition(pSmac));
            }
        }
        return null;
    }

    @Override
    public SourceInfo getInverseSinkInfo(Stmt sCallSite, InfoflowManager manager) {
        SootMethod callee = sCallSite.containsInvokeExpr() ? sCallSite.getInvokeExpr().getMethod() : null;
        HashSet<AccessPath> aps = new HashSet<AccessPath>();
        if (this.returnTaintMethods != null && sCallSite instanceof ReturnStmt) {
            Object op;
            SootMethod sm = (SootMethod)manager.getICFG().getMethodOf(sCallSite);
            if (this.returnTaintMethods != null && this.returnTaintMethods.contains(sm) && !((op = ((ReturnStmt)sCallSite).getOp()) instanceof Constant)) {
                aps.add(manager.getAccessPathFactory().createAccessPath((Value)op, true));
            }
        }
        if (this.isInverseSinkMethod(manager, sCallSite)) {
            InvokeExpr ie = sCallSite.getInvokeExpr();
            for (Value arg : ie.getArgs()) {
                if (arg instanceof Constant) continue;
                aps.add(manager.getAccessPathFactory().createAccessPath(arg, true));
            }
            if (ie instanceof InstanceInvokeExpr) {
                Value base = ((InstanceInvokeExpr)sCallSite.getInvokeExpr()).getBase();
                aps.add(manager.getAccessPathFactory().createAccessPath(base, true));
            }
        }
        aps.remove(null);
        if (aps.isEmpty()) {
            return null;
        }
        return new SourceInfo((ISourceSinkDefinition)(callee == null ? null : new MethodSourceSinkDefinition(new SootMethodAndClass(callee))), aps);
    }

    public void setParameterTaintMethods(List<String> parameterTaintMethods) {
        this.parameterTaintMethodDefs = parameterTaintMethods;
    }

    public void setReturnTaintMethods(List<String> returnTaintMethods) {
        this.returnTaintMethodDefs = returnTaintMethods;
    }

    @Override
    public void initialize() {
        SootMethod sm;
        if (this.sourceDefs != null) {
            this.sources = new HashSet<SootMethod>();
            for (String signature : this.sourceDefs) {
                sm = Scene.v().grabMethod(signature);
                if (sm == null) continue;
                this.sources.add(sm);
            }
            this.sourceDefs = null;
        }
        if (this.sinkDefs != null) {
            this.sinks = new HashSet<SootMethod>();
            for (String signature : this.sinkDefs) {
                sm = Scene.v().grabMethod(signature);
                if (sm == null) continue;
                this.sinks.add(sm);
            }
            this.sinkDefs = null;
        }
        if (this.returnTaintMethodDefs != null) {
            this.returnTaintMethods = new HashSet<SootMethod>();
            for (String signature : this.returnTaintMethodDefs) {
                sm = Scene.v().grabMethod(signature);
                if (sm == null) continue;
                this.returnTaintMethods.add(sm);
            }
            this.returnTaintMethodDefs = null;
        }
        if (this.parameterTaintMethodDefs != null) {
            this.parameterTaintMethods = new HashSet<SootMethod>();
            for (String signature : this.parameterTaintMethodDefs) {
                sm = Scene.v().grabMethod(signature);
                if (sm == null) continue;
                this.parameterTaintMethods.add(sm);
            }
            this.parameterTaintMethodDefs = null;
        }
    }
}

