/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver.sparseSolver.propagation;

import java.util.Collection;
import java.util.stream.Collectors;
import soot.Local;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.DefinitionStmt;
import soot.jimple.NewExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.problems.AbstractInfoflowProblem;
import soot.jimple.infoflow.solver.sparseSolver.propagation.AbstractSparsePropagation;

public class SimpleSparsePropagation
extends AbstractSparsePropagation {
    public SimpleSparsePropagation(AbstractInfoflowProblem problem) {
        super(problem);
    }

    @Override
    public Collection<Unit> getSuccsOf(Unit unit, Abstraction abstraction) {
        assert (!abstraction.getAccessPath().isEmpty());
        if (abstraction.getExceptionThrown()) {
            return this.getSuccessors(new AbstractSparsePropagation.SCFGExceptionNode(this, unit, abstraction));
        }
        if (abstraction.getAccessPath().isStaticFieldRef()) {
            return this.getSuccessors(new StaticNode(unit, abstraction));
        }
        return this.getSuccessors(new LocalNode(unit, abstraction));
    }

    @Override
    public Collection<Unit> getStartPointsOf(SootMethod sm, Abstraction abstraction) {
        assert (!abstraction.getAccessPath().isEmpty());
        if (abstraction.getExceptionThrown()) {
            return this.iCfg.getStartPointsOf(sm).stream().flatMap(sP -> this.getSuccessors(new AbstractSparsePropagation.SCFGExceptionNode(this, (Unit)sP, abstraction)).stream()).collect(Collectors.toSet());
        }
        if (abstraction.getAccessPath().isStaticFieldRef()) {
            return this.iCfg.getStartPointsOf(sm).stream().flatMap(sP -> this.getSuccessors(new StaticNode((Unit)sP, abstraction)).stream()).collect(Collectors.toSet());
        }
        return this.iCfg.getStartPointsOf(sm).stream().flatMap(sP -> this.getSuccessors(new LocalNode((Unit)sP, abstraction)).stream()).collect(Collectors.toSet());
    }

    private class StaticNode
    extends AbstractSparsePropagation.SCFGNode {
        StaticNode(Unit unit, Abstraction abs) {
            super(SimpleSparsePropagation.this, unit, null, abs.getAccessPath().getFirstField(), abs.getActivationUnit(), abs.getTurnUnit());
            assert (abs.getAccessPath().isStaticFieldRef());
        }

        @Override
        protected boolean isAffectedByInternal(Unit unit) {
            Stmt stmt = (Stmt)unit;
            if (this.turnUnit != null && stmt instanceof DefinitionStmt && ((DefinitionStmt)stmt).getRightOp() instanceof NewExpr) {
                return true;
            }
            return stmt.containsInvokeExpr() || stmt.containsFieldRef() && stmt.getFieldRef().getField() == this.field;
        }
    }

    private class LocalNode
    extends AbstractSparsePropagation.SCFGNode {
        LocalNode(Unit unit, Abstraction abs) {
            super(SimpleSparsePropagation.this, unit, abs.getAccessPath().getPlainValue(), abs.getAccessPath().getFirstField(), abs.getActivationUnit(), abs.getTurnUnit());
        }

        @Override
        protected boolean isAffectedByInternal(Unit unit) {
            Stmt stmt = (Stmt)unit;
            Aliasing aliasing = SimpleSparsePropagation.this.problem.getManager().getAliasing();
            if (aliasing == null) {
                return stmt.getUseAndDefBoxes().stream().anyMatch(vb -> vb.getValue() == this.local);
            }
            return stmt.getUseBoxes().stream().anyMatch(vb -> vb.getValue() == this.local) || stmt.getDefBoxes().stream().anyMatch(vb -> vb.getValue() instanceof Local && aliasing.mustAlias(this.local, (Local)vb.getValue(), (Stmt)unit));
        }
    }
}

