/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver.sparseSolver.propagation;

import java.util.Collection;
import java.util.stream.Collectors;
import soot.Local;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.ParameterRef;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;
import soot.jimple.UnopExpr;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPathFragment;
import soot.jimple.infoflow.problems.AbstractInfoflowProblem;
import soot.jimple.infoflow.solver.sparseSolver.propagation.AbstractSparsePropagation;

public class PreciseSparsePropagation
extends AbstractSparsePropagation {
    public PreciseSparsePropagation(AbstractInfoflowProblem problem) {
        super(problem);
    }

    @Override
    public Collection<Unit> getSuccsOf(Unit unit, Abstraction abstraction) {
        assert (!abstraction.getAccessPath().isEmpty());
        if (abstraction.getExceptionThrown()) {
            return this.getSuccessors(new AbstractSparsePropagation.SCFGExceptionNode(this, unit, abstraction));
        }
        return this.getSuccessors(new NormalSCFGNode(unit, abstraction));
    }

    @Override
    public Collection<Unit> getStartPointsOf(SootMethod sm, Abstraction abstraction) {
        assert (!abstraction.getAccessPath().isEmpty());
        if (abstraction.getExceptionThrown()) {
            return this.iCfg.getStartPointsOf(sm).stream().flatMap(sP -> this.getSuccessors(new AbstractSparsePropagation.SCFGExceptionNode(this, (Unit)sP, abstraction)).stream()).collect(Collectors.toSet());
        }
        return this.iCfg.getStartPointsOf(sm).stream().flatMap(sP -> this.getSuccessors(new NormalSCFGNode((Unit)sP, abstraction)).stream()).collect(Collectors.toSet());
    }

    private class NormalSCFGNode
    extends AbstractSparsePropagation.SCFGNode {
        NormalSCFGNode(Unit unit, Abstraction abs) {
            super(PreciseSparsePropagation.this, unit, abs.getAccessPath().getPlainValue(), abs.getAccessPath().getFirstField(), abs.getActivationUnit(), abs.getTurnUnit());
        }

        @Override
        protected boolean isAffectedByInternal(Unit unit) {
            if (this.turnUnit == null && unit instanceof IdentityStmt) {
                return false;
            }
            if (unit instanceof DefinitionStmt) {
                DefinitionStmt def = (DefinitionStmt)unit;
                return this.matchesLhs(def.getLeftOp(), def, def instanceof AssignStmt) || this.matchesRhs(def.getRightOp());
            }
            Stmt stmt = (Stmt)unit;
            if (stmt.containsInvokeExpr()) {
                return this.isPartOfCall(this.local, stmt.getInvokeExpr());
            }
            if (stmt instanceof IfStmt) {
                return this.matchesRhs(((IfStmt)stmt).getCondition());
            }
            return false;
        }

        private boolean matchesLhs(Value lhs, DefinitionStmt stmt, boolean mustAlias) {
            Aliasing aliasing;
            Aliasing aliasing2 = aliasing = mustAlias ? PreciseSparsePropagation.this.problem.getManager().getAliasing() : null;
            if (lhs instanceof StaticFieldRef) {
                return this.local == null && ((StaticFieldRef)lhs).getField() == this.field;
            }
            if (lhs instanceof InstanceFieldRef) {
                InstanceFieldRef ref = (InstanceFieldRef)lhs;
                if (aliasing == null ? this.local != ref.getBase() : this.local == null || !aliasing.mustAlias(this.local, (Local)ref.getBase(), stmt)) {
                    return false;
                }
                if (this.field == null || this.field == ref.getField()) {
                    return true;
                }
                return this.matchesRegisteredBase(ref.getField());
            }
            if (lhs instanceof ArrayRef) {
                ArrayRef arrayRef = (ArrayRef)lhs;
                return arrayRef.getBase() == this.local || arrayRef.getIndex() == this.local;
            }
            if (lhs instanceof Local) {
                if (this.turnUnit != null && this.local == null && stmt.getRightOp() instanceof NewExpr) {
                    return true;
                }
                return aliasing == null ? this.local == lhs : this.local != null && aliasing.mustAlias(this.local, (Local)lhs, stmt);
            }
            throw new RuntimeException("Unexpected lhs: !" + lhs.getClass().getName());
        }

        private boolean matchesRhs(Value rhs) {
            if (rhs instanceof StaticFieldRef) {
                return this.local == null && ((StaticFieldRef)rhs).getField() == this.field;
            }
            if (rhs instanceof InstanceFieldRef) {
                InstanceFieldRef ref = (InstanceFieldRef)rhs;
                if (this.local != ref.getBase()) {
                    return false;
                }
                if (this.field == null || this.field == ref.getField()) {
                    return true;
                }
                return this.matchesRegisteredBase(ref.getField());
            }
            if (rhs instanceof InvokeExpr) {
                return this.isPartOfCall(this.local, (InvokeExpr)rhs);
            }
            if (rhs instanceof CastExpr) {
                return ((CastExpr)rhs).getOp() == this.local;
            }
            if (rhs instanceof UnopExpr) {
                return ((UnopExpr)rhs).getOp() == this.local;
            }
            if (rhs instanceof BinopExpr) {
                BinopExpr binop = (BinopExpr)rhs;
                return binop.getOp1() == this.local || binop.getOp2() == this.local;
            }
            if (rhs instanceof ArrayRef) {
                ArrayRef arrayRef = (ArrayRef)rhs;
                return arrayRef.getBase() == this.local || arrayRef.getIndex() == this.local;
            }
            if (rhs instanceof Local) {
                return this.local == rhs;
            }
            if (rhs instanceof NewArrayExpr) {
                return ((NewArrayExpr)rhs).getSize() == this.local;
            }
            if (rhs instanceof NewMultiArrayExpr) {
                for (Value size : ((NewMultiArrayExpr)rhs).getSizes()) {
                    if (size != this.local) continue;
                    return true;
                }
                return false;
            }
            if (rhs instanceof InstanceOfExpr) {
                return ((InstanceOfExpr)rhs).getOp() == this.local;
            }
            if (rhs instanceof Constant || rhs instanceof NewExpr || rhs instanceof ParameterRef || rhs instanceof ThisRef || rhs instanceof CaughtExceptionRef) {
                return false;
            }
            throw new RuntimeException("Unexpected rhs: !" + rhs.getClass().getName());
        }

        private boolean isPartOfCall(Local local, InvokeExpr ie) {
            if (local == null) {
                return true;
            }
            for (int i = 0; i < ie.getArgCount(); ++i) {
                if (ie.getArg(i) != local) continue;
                return true;
            }
            return ie instanceof InstanceInvokeExpr && ((InstanceInvokeExpr)ie).getBase() == local;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean matchesRegisteredBase(SootField field) {
            Collection<AccessPathFragment[]> bases = PreciseSparsePropagation.this.problem.getManager().getAccessPathFactory().getBaseForType(this.local.getType());
            if (bases != null) {
                Collection<AccessPathFragment[]> collection = bases;
                synchronized (collection) {
                    for (AccessPathFragment[] base : bases) {
                        if (base[0].getField() != field) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

