/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver.gcSolver.fpc;

import heros.solver.Pair;
import heros.solver.PathEdge;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.jimple.infoflow.collect.MyConcurrentHashMap;
import soot.jimple.infoflow.solver.EndSummary;
import soot.jimple.infoflow.solver.cfg.BackwardsInfoflowCFG;
import soot.jimple.infoflow.solver.fastSolver.FastSolverLinkedNode;
import soot.jimple.infoflow.solver.gcSolver.IGCReferenceProvider;
import soot.jimple.infoflow.solver.gcSolver.fpc.AbstrationDependencyGraph;
import soot.jimple.infoflow.solver.gcSolver.fpc.FineGrainedReferenceCountingGarbageCollector;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;
import soot.util.ConcurrentHashMultiMap;

public class NormalGarbageCollector<N, D extends FastSolverLinkedNode<D, N>>
extends FineGrainedReferenceCountingGarbageCollector<N, D> {
    protected static final Logger logger = LoggerFactory.getLogger(NormalGarbageCollector.class);
    protected final AbstrationDependencyGraph<D> abstDependencyGraph;
    protected final MyConcurrentHashMap<Pair<SootMethod, D>, Map<EndSummary<N, D>, EndSummary<N, D>>> endSummary;

    public NormalGarbageCollector(BiDiInterproceduralCFG<N, SootMethod> icfg, ConcurrentHashMultiMap<Pair<SootMethod, D>, PathEdge<N, D>> jumpFunctions, MyConcurrentHashMap<Pair<SootMethod, D>, Map<EndSummary<N, D>, EndSummary<N, D>>> endSummary, AbstrationDependencyGraph<D> adg) {
        super(icfg, jumpFunctions, null);
        this.abstDependencyGraph = adg;
        this.endSummary = endSummary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasActiveDependencies(Pair<SootMethod, D> abstraction) {
        int changeCounter = -1;
        try {
            this.abstDependencyGraph.lock();
            do {
                changeCounter = this.jumpFnCounter.getChangeCounter();
                if (this.jumpFnCounter.get(abstraction) > 0) {
                    boolean bl = true;
                    return bl;
                }
                Set<Pair<SootMethod, D>> references = this.abstDependencyGraph.reachableClosure(abstraction);
                for (Pair<SootMethod, D> ref : references) {
                    if (this.jumpFnCounter.get(ref) <= 0) continue;
                    boolean bl = true;
                    return bl;
                }
            } while (this.checkChangeCounter && changeCounter != this.jumpFnCounter.getChangeCounter());
        }
        finally {
            this.abstDependencyGraph.unlock();
        }
        return false;
    }

    @Override
    protected IGCReferenceProvider<Pair<SootMethod, D>> createReferenceProvider() {
        return null;
    }

    @Override
    public void notifySolverTerminated() {
        super.notifySolverTerminated();
        String s2 = "forward";
        if (this.icfg instanceof BackwardsInfoflowCFG) {
            s2 = "backward";
        }
        logger.info(this.icfg.getClass().toString());
        logger.info(String.format("#nodes of %s Abstraction Dependency Graph: %d", s2, this.abstDependencyGraph.nodeSize()));
        logger.info(String.format("#edges of %s Abstraction Dependency Graph: %d", s2, this.abstDependencyGraph.edgeSize()));
        logger.info(String.format("#dummy end summary edges of %s: %d", s2, ((ConcurrentHashMap.CollectionView)((Object)this.endSummary.keySet())).size()));
        long v = 0L;
        for (Map map : this.endSummary.values()) {
            v += (long)map.size();
        }
        logger.info(String.format("#end summary edges of %s: %d", s2, v));
    }
}

