/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver.gcSolver;

import com.google.common.cache.CacheBuilder;
import heros.DontSynchronize;
import heros.FlowFunction;
import heros.FlowFunctionCache;
import heros.FlowFunctions;
import heros.IFDSTabulationProblem;
import heros.SynchronizedBy;
import heros.ZeroedFlowFunctions;
import heros.solver.Pair;
import heros.solver.PathEdge;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.jimple.infoflow.collect.MyConcurrentHashMap;
import soot.jimple.infoflow.memory.IMemoryBoundedSolver;
import soot.jimple.infoflow.memory.ISolverTerminationReason;
import soot.jimple.infoflow.solver.AbstractIFDSSolver;
import soot.jimple.infoflow.solver.EndSummary;
import soot.jimple.infoflow.solver.SolverPeerGroup;
import soot.jimple.infoflow.solver.executors.InterruptableExecutor;
import soot.jimple.infoflow.solver.executors.SetPoolExecutor;
import soot.jimple.infoflow.solver.fastSolver.FastSolverLinkedNode;
import soot.jimple.infoflow.solver.gcSolver.GCSolverPeerGroup;
import soot.jimple.infoflow.solver.gcSolver.IGarbageCollector;
import soot.jimple.infoflow.solver.gcSolver.ThreadedGarbageCollector;
import soot.jimple.infoflow.solver.memory.IMemoryManager;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;
import soot.util.ConcurrentHashMultiMap;

public class IFDSSolver<N, D extends FastSolverLinkedNode<D, N>, I extends BiDiInterproceduralCFG<N, SootMethod>>
extends AbstractIFDSSolver<N, D>
implements IMemoryBoundedSolver {
    public static CacheBuilder<Object, Object> DEFAULT_CACHE_BUILDER = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).initialCapacity(10000).softValues();
    protected static final Logger logger = LoggerFactory.getLogger(IFDSSolver.class);
    public static final boolean DEBUG = logger.isDebugEnabled();
    protected InterruptableExecutor executor;
    @DontSynchronize(value="only used by single thread")
    protected int numThreads;
    @SynchronizedBy(value="thread safe data structure, consistent locking when used")
    protected ConcurrentHashMultiMap<SootMethod, PathEdge<N, D>> jumpFunctions = new ConcurrentHashMultiMap();
    @SynchronizedBy(value="thread safe data structure")
    protected volatile IGarbageCollector<N, D> garbageCollector;
    @SynchronizedBy(value="thread safe data structure, only modified internally")
    protected final I icfg;
    @SynchronizedBy(value="consistent lock on 'incoming'")
    protected final MyConcurrentHashMap<Pair<SootMethod, D>, Map<EndSummary<N, D>, EndSummary<N, D>>> endSummary = new MyConcurrentHashMap();
    @SynchronizedBy(value="consistent lock on field")
    protected final ConcurrentHashMultiMap<Pair<SootMethod, D>, IncomingRecord<N, D>> incoming = new ConcurrentHashMultiMap();
    @DontSynchronize(value="stateless")
    protected final FlowFunctions<N, D, SootMethod> flowFunctions;
    @DontSynchronize(value="only used by single thread")
    protected final Map<N, Set<D>> initialSeeds;
    @DontSynchronize(value="benign races")
    public long propagationCount;
    @DontSynchronize(value="stateless")
    protected final D zeroValue;
    @DontSynchronize(value="readOnly")
    protected final FlowFunctionCache<N, D, SootMethod> ffCache;
    @DontSynchronize(value="readOnly")
    protected final boolean followReturnsPastSeeds;
    @DontSynchronize(value="readOnly")
    private int maxJoinPointAbstractions = -1;
    @DontSynchronize(value="readOnly")
    protected IMemoryManager<D, N> memoryManager = null;
    protected boolean solverId;
    private Set<IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification> notificationListeners = new HashSet<IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification>();
    private ISolverTerminationReason killFlag = null;
    private int maxCalleesPerCallSite = 75;
    private int maxAbstractionPathLength = 100;
    protected SolverPeerGroup solverPeerGroup;
    protected int sleepTime = 1;

    public IFDSSolver(IFDSTabulationProblem<N, D, SootMethod, I> tabulationProblem, int sleepTime) {
        this(tabulationProblem, DEFAULT_CACHE_BUILDER, sleepTime);
    }

    public IFDSSolver(IFDSTabulationProblem<N, D, SootMethod, I> tabulationProblem, CacheBuilder flowFunctionCacheBuilder, int sleepTime) {
        FlowFunctions<N, D, SootMethod> flowFunctions;
        if (logger.isDebugEnabled()) {
            flowFunctionCacheBuilder = flowFunctionCacheBuilder.recordStats();
        }
        this.zeroValue = (FastSolverLinkedNode)tabulationProblem.zeroValue();
        this.icfg = (BiDiInterproceduralCFG)tabulationProblem.interproceduralCFG();
        FlowFunctions<N, D, SootMethod> flowFunctions2 = flowFunctions = tabulationProblem.autoAddZero() ? new ZeroedFlowFunctions<N, D, SootMethod>(tabulationProblem.flowFunctions(), this.zeroValue) : tabulationProblem.flowFunctions();
        if (flowFunctionCacheBuilder != null) {
            this.ffCache = new FlowFunctionCache<N, D, SootMethod>(flowFunctions, flowFunctionCacheBuilder);
            flowFunctions = this.ffCache;
        } else {
            this.ffCache = null;
        }
        this.sleepTime = sleepTime;
        this.flowFunctions = flowFunctions;
        this.initialSeeds = tabulationProblem.initialSeeds();
        this.followReturnsPastSeeds = tabulationProblem.followReturnsPastSeeds();
        this.numThreads = Math.max(1, tabulationProblem.numThreads());
        this.executor = this.getExecutor();
    }

    protected IGarbageCollector<N, D> createGarbageCollector() {
        if (this.garbageCollector != null) {
            return this.garbageCollector;
        }
        ThreadedGarbageCollector<N, D> gc = new ThreadedGarbageCollector<N, D>(this.icfg, this.jumpFunctions);
        gc.setSleepTimeSeconds(this.sleepTime);
        GCSolverPeerGroup gcSolverGroup = (GCSolverPeerGroup)this.solverPeerGroup;
        gc.setPeerGroup(gcSolverGroup.getGCPeerGroup());
        this.garbageCollector = gc;
        return this.garbageCollector;
    }

    public void setSolverId(boolean solverId) {
        this.solverId = solverId;
    }

    public void solve() {
        this.reset();
        if (this.garbageCollector == null) {
            this.garbageCollector = this.createGarbageCollector();
        }
        for (IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification listener : this.notificationListeners) {
            listener.notifySolverStarted(this);
        }
        this.submitInitialSeeds();
        this.awaitCompletionComputeValuesAndShutdown();
        for (IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification listener : this.notificationListeners) {
            listener.notifySolverTerminated(this);
        }
        logger.info(String.format("GC removed abstractions for %d methods", this.garbageCollector.getGcedAbstractions()));
        logger.info(String.format("GC removed abstractions for %d edges", this.garbageCollector.getGcedEdges()));
        if (this.garbageCollector instanceof ThreadedGarbageCollector) {
            ThreadedGarbageCollector threadedgc = (ThreadedGarbageCollector)this.garbageCollector;
            int fwEndSumCnt = 0;
            for (Map map : this.endSummary.values()) {
                fwEndSumCnt += map.size();
            }
            boolean bwEndSumCnt = false;
            logger.info(String.format("forward end Summary size: %d", fwEndSumCnt));
            logger.info(String.format("Recorded Maximum Path edges count is %d", threadedgc.getMaxPathEdgeCount()));
        }
        GCSolverPeerGroup gcSolverGroup = (GCSolverPeerGroup)this.solverPeerGroup;
        gcSolverGroup.getGCPeerGroup().notifySolverTerminated();
    }

    protected void submitInitialSeeds() {
        for (Map.Entry<N, Set<D>> seed : this.initialSeeds.entrySet()) {
            N startPoint = seed.getKey();
            for (FastSolverLinkedNode val : seed.getValue()) {
                this.propagate(this.zeroValue, startPoint, val, null, false);
            }
            this.addFunction(new PathEdge<N, D>(this.zeroValue, startPoint, this.zeroValue));
        }
    }

    protected void awaitCompletionComputeValuesAndShutdown() {
        this.runExecutorAndAwaitCompletion();
        if (logger.isDebugEnabled()) {
            this.printStats();
        }
        this.executor.shutdown();
        while (!this.executor.isTerminated()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void runExecutorAndAwaitCompletion() {
        try {
            this.executor.awaitCompletion();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Throwable exception = this.executor.getException();
        if (exception != null) {
            throw new RuntimeException("There were exceptions during IFDS analysis. Exiting.", exception);
        }
    }

    protected void scheduleEdgeProcessing(PathEdge<N, D> edge) {
        if (this.killFlag != null || this.executor.isTerminating() || this.executor.isTerminated()) {
            return;
        }
        this.garbageCollector.notifyEdgeSchedule(edge);
        this.executor.execute(new PathEdgeProcessingTask(edge, this.solverId));
        ++this.propagationCount;
        this.garbageCollector.gc();
    }

    private void processCall(PathEdge<N, D> edge) {
        final FastSolverLinkedNode d1 = (FastSolverLinkedNode)edge.factAtSource();
        final N n = edge.getTarget();
        final FastSolverLinkedNode d2 = (FastSolverLinkedNode)edge.factAtTarget();
        assert (d2 != null);
        final Collection<N> returnSiteNs = this.icfg.getReturnSitesOfCallAt(n);
        Collection callees = this.icfg.getCalleesOfCallAt(n);
        if (this.maxCalleesPerCallSite < 0 || callees.size() <= this.maxCalleesPerCallSite) {
            callees.stream().filter(m4 -> m4.isConcrete()).forEach(new Consumer<SootMethod>(){

                @Override
                public void accept(SootMethod sCalledProcN) {
                    if (IFDSSolver.this.killFlag != null) {
                        return;
                    }
                    FlowFunction function = IFDSSolver.this.flowFunctions.getCallFlowFunction(n, sCalledProcN);
                    Set<FastSolverLinkedNode> res = IFDSSolver.this.computeCallFlowFunction(function, d1, d2);
                    if (res != null && !res.isEmpty()) {
                        Collection startPointsOf = IFDSSolver.this.icfg.getStartPointsOf((SootMethod)sCalledProcN);
                        for (FastSolverLinkedNode d3 : res) {
                            if (IFDSSolver.this.memoryManager != null) {
                                d3 = IFDSSolver.this.memoryManager.handleGeneratedMemoryObject(d2, d3);
                            }
                            if (d3 == null || !IFDSSolver.this.addIncoming(sCalledProcN, d3, n, d1, d2) || IFDSSolver.this.applyEndSummaryOnCall(d1, n, d2, returnSiteNs, sCalledProcN, d3)) continue;
                            for (Object sP : startPointsOf) {
                                IFDSSolver.this.propagate(d3, sP, d3, n, false);
                            }
                        }
                    }
                }
            });
        }
        for (N returnSiteN : returnSiteNs) {
            FlowFunction<D> callToReturnFlowFunction = this.flowFunctions.getCallToReturnFlowFunction(n, returnSiteN);
            Set<FastSolverLinkedNode> res = this.computeCallToReturnFlowFunction(callToReturnFlowFunction, d1, d2);
            if (res == null || res.isEmpty()) continue;
            for (FastSolverLinkedNode d3 : res) {
                if (this.memoryManager != null) {
                    d3 = this.memoryManager.handleGeneratedMemoryObject(d2, d3);
                }
                if (d3 == null) continue;
                this.propagate(d1, returnSiteN, d3, n, false);
            }
        }
    }

    protected boolean applyEndSummaryOnCall(D d1, N n, D d2, Collection<N> returnSiteNs, SootMethod sCalledProcN, D d3) {
        Set<EndSummary<N, D>> endSumm = this.endSummary(sCalledProcN, d3);
        if (endSumm != null && !endSumm.isEmpty()) {
            for (EndSummary<N, D> entry : endSumm) {
                Object eP = entry.eP;
                Object d4 = entry.d4;
                entry.calleeD1.addNeighbor(d3);
                for (N retSiteN : returnSiteNs) {
                    FlowFunction<D> retFunction = this.flowFunctions.getReturnFlowFunction(n, sCalledProcN, eP, retSiteN);
                    Set<D> retFlowRes = this.computeReturnFlowFunction(retFunction, d3, d4, n, Collections.singleton(d1));
                    if (retFlowRes == null || retFlowRes.isEmpty()) continue;
                    for (FastSolverLinkedNode d5 : retFlowRes) {
                        if (this.memoryManager != null) {
                            d5 = this.memoryManager.handleGeneratedMemoryObject((FastSolverLinkedNode)d4, d5);
                        }
                        FastSolverLinkedNode d5p = this.shortenPredecessors(d5, d2, d3, eP, n);
                        this.propagate(d1, retSiteN, d5p, n, false);
                    }
                }
            }
            return true;
        }
        return false;
    }

    protected Set<D> computeCallFlowFunction(FlowFunction<D> callFlowFunction, D d1, D d2) {
        return callFlowFunction.computeTargets(d2);
    }

    protected Set<D> computeCallToReturnFlowFunction(FlowFunction<D> callToReturnFlowFunction, D d1, D d2) {
        return callToReturnFlowFunction.computeTargets(d2);
    }

    protected void processExit(PathEdge<N, D> edge) {
        FastSolverLinkedNode d2;
        FastSolverLinkedNode d1;
        N n = edge.getTarget();
        SootMethod methodThatNeedsSummary = (SootMethod)this.icfg.getMethodOf(n);
        if (!this.addEndSummary(methodThatNeedsSummary, d1 = (FastSolverLinkedNode)edge.factAtSource(), n, d2 = (FastSolverLinkedNode)edge.factAtTarget())) {
            return;
        }
        Set<IncomingRecord<N, FastSolverLinkedNode>> inc = this.incoming(d1, methodThatNeedsSummary);
        if (inc != null && !inc.isEmpty()) {
            for (IncomingRecord<N, FastSolverLinkedNode> incomingRecord : inc) {
                if (this.killFlag != null) {
                    return;
                }
                Object c = incomingRecord.n;
                Set callerSideDs = Collections.singleton(incomingRecord.d1);
                for (Object retSiteC : this.icfg.getReturnSitesOfCallAt(c)) {
                    FlowFunction<D> retFunction = this.flowFunctions.getReturnFlowFunction(c, methodThatNeedsSummary, n, retSiteC);
                    Set<FastSolverLinkedNode> targets = this.computeReturnFlowFunction(retFunction, d1, d2, c, callerSideDs);
                    if (targets == null || targets.isEmpty()) continue;
                    Object d4 = incomingRecord.d1;
                    Object predVal = incomingRecord.d2;
                    for (FastSolverLinkedNode d5 : targets) {
                        if (this.memoryManager != null) {
                            d5 = this.memoryManager.handleGeneratedMemoryObject(d2, d5);
                        }
                        if (d5 == null) continue;
                        FastSolverLinkedNode d5p = this.shortenPredecessors(d5, predVal, d1, n, c);
                        this.propagate(d4, retSiteC, d5p, c, false);
                        d1.addNeighbor(incomingRecord.d3);
                    }
                }
            }
        }
        if (this.followReturnsPastSeeds && d1 == this.zeroValue && (inc == null || inc.isEmpty())) {
            Collection callers = this.icfg.getCallersOf((SootMethod)methodThatNeedsSummary);
            for (Object c : callers) {
                for (Object retSiteC : this.icfg.getReturnSitesOfCallAt(c)) {
                    FlowFunction<D> retFunction = this.flowFunctions.getReturnFlowFunction(c, methodThatNeedsSummary, n, retSiteC);
                    Set<FastSolverLinkedNode> targets = this.computeReturnFlowFunction(retFunction, d1, d2, c, Collections.singleton(this.zeroValue));
                    if (targets == null || targets.isEmpty()) continue;
                    for (FastSolverLinkedNode d5 : targets) {
                        if (this.memoryManager != null) {
                            d5 = this.memoryManager.handleGeneratedMemoryObject(d2, d5);
                        }
                        if (d5 == null) continue;
                        this.propagate(this.zeroValue, retSiteC, d5, c, true);
                    }
                }
            }
            if (callers.isEmpty()) {
                FlowFunction<FastSolverLinkedNode> flowFunction = this.flowFunctions.getReturnFlowFunction(null, methodThatNeedsSummary, n, null);
                flowFunction.computeTargets(d2);
            }
        }
    }

    protected Set<D> computeReturnFlowFunction(FlowFunction<D> retFunction, D d1, D d2, N callSite, Collection<D> callerSideDs) {
        return retFunction.computeTargets(d2);
    }

    private void processNormalFlow(PathEdge<N, D> edge) {
        FastSolverLinkedNode d1 = (FastSolverLinkedNode)edge.factAtSource();
        N n = edge.getTarget();
        FastSolverLinkedNode d2 = (FastSolverLinkedNode)edge.factAtTarget();
        for (N m4 : this.icfg.getSuccsOf(n)) {
            if (this.killFlag != null) {
                return;
            }
            FlowFunction<D> flowFunction = this.flowFunctions.getNormalFlowFunction(n, m4);
            Set<FastSolverLinkedNode> res = this.computeNormalFlowFunction(flowFunction, d1, d2);
            if (res == null || res.isEmpty()) continue;
            for (FastSolverLinkedNode d3 : res) {
                if (this.memoryManager != null && d2 != d3) {
                    d3 = this.memoryManager.handleGeneratedMemoryObject(d2, d3);
                }
                if (d3 == null) continue;
                this.propagate(d1, m4, d3, null, false);
            }
        }
    }

    protected Set<D> computeNormalFlowFunction(FlowFunction<D> flowFunction, D d1, D d2) {
        return flowFunction.computeTargets(d2);
    }

    protected void propagate(D sourceVal, N target, D targetVal, N relatedCallSite, boolean isUnbalancedReturn) {
        if (this.memoryManager != null) {
            sourceVal = (FastSolverLinkedNode)this.memoryManager.handleMemoryObject(sourceVal);
            if ((targetVal = (FastSolverLinkedNode)this.memoryManager.handleMemoryObject(targetVal)) == null) {
                return;
            }
        }
        if (this.maxAbstractionPathLength >= 0 && targetVal.getPathLength() > this.maxAbstractionPathLength) {
            return;
        }
        PathEdge<N, D> edge = new PathEdge<N, D>(sourceVal, target, targetVal);
        D existingVal = this.addFunction(edge);
        if (existingVal != null) {
            if (existingVal != targetVal) {
                boolean isEssential = this.memoryManager == null ? relatedCallSite != null && this.icfg.isCallStmt(relatedCallSite) : this.memoryManager.isEssentialJoinPoint(targetVal, relatedCallSite);
                if (this.maxJoinPointAbstractions < 0 || existingVal.getNeighborCount() < this.maxJoinPointAbstractions || isEssential) {
                    existingVal.addNeighbor(targetVal);
                }
            }
        } else {
            this.scheduleEdgeProcessing(edge);
        }
    }

    public D addFunction(PathEdge<N, D> edge) {
        PathEdge<N, D> oldEdge = this.jumpFunctions.putIfAbsent((SootMethod)this.icfg.getMethodOf(edge.getTarget()), edge);
        return (D)(oldEdge == null ? null : (FastSolverLinkedNode)oldEdge.factAtTarget());
    }

    protected Set<EndSummary<N, D>> endSummary(SootMethod m4, D d3) {
        Map map = (Map)this.endSummary.get(new Pair<SootMethod, D>(m4, d3));
        return map == null ? null : map.keySet();
    }

    private boolean addEndSummary(SootMethod m4, D d1, N eP, D d2) {
        EndSummary<N, D> newSummary;
        if (d1 == this.zeroValue) {
            return true;
        }
        Map summaries = this.endSummary.putIfAbsentElseGet(new Pair<SootMethod, D>(m4, d1), () -> new ConcurrentHashMap());
        EndSummary<N, D> existingSummary = summaries.putIfAbsent(newSummary = new EndSummary<N, D>(eP, d2, d1), newSummary);
        if (existingSummary != null) {
            existingSummary.calleeD1.addNeighbor(d2);
            return false;
        }
        return true;
    }

    protected Set<IncomingRecord<N, D>> incoming(D d1, SootMethod m4) {
        Set<IncomingRecord<N, D>> inc = this.incoming.get(new Pair<SootMethod, D>(m4, d1));
        return inc;
    }

    protected boolean addIncoming(SootMethod m4, D d3, N n, D d1, D d2) {
        IncomingRecord<N, D> newRecord = new IncomingRecord<N, D>(n, d1, d2, d3);
        IncomingRecord<N, D> rec = this.incoming.putIfAbsent(new Pair<SootMethod, D>(m4, d3), newRecord);
        return rec == null;
    }

    protected InterruptableExecutor getExecutor() {
        SetPoolExecutor executor = new SetPoolExecutor(1, this.numThreads, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        executor.setThreadFactory(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thrIFDS = new Thread(r);
                thrIFDS.setDaemon(true);
                thrIFDS.setName("IFDS Solver");
                return thrIFDS;
            }
        });
        return executor;
    }

    protected String getDebugName() {
        return "FAST IFDS SOLVER";
    }

    public void printStats() {
        if (logger.isDebugEnabled()) {
            if (this.ffCache != null) {
                this.ffCache.printStats();
            }
        } else {
            logger.info("No statistics were collected, as DEBUG is disabled.");
        }
    }

    public void setMaxJoinPointAbstractions(int maxJoinPointAbstractions) {
        this.maxJoinPointAbstractions = maxJoinPointAbstractions;
    }

    public void setMemoryManager(IMemoryManager<D, N> memoryManager) {
        this.memoryManager = memoryManager;
    }

    public IMemoryManager<D, N> getMemoryManager() {
        return this.memoryManager;
    }

    @Override
    public void forceTerminate(ISolverTerminationReason reason) {
        this.killFlag = reason;
        this.executor.interrupt();
        this.executor.shutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.killFlag != null || this.executor.isFinished();
    }

    @Override
    public boolean isKilled() {
        return this.killFlag != null;
    }

    @Override
    public void reset() {
        this.killFlag = null;
    }

    @Override
    public void addStatusListener(IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification listener) {
        this.notificationListeners.add(listener);
    }

    @Override
    public ISolverTerminationReason getTerminationReason() {
        return this.killFlag;
    }

    public void setMaxCalleesPerCallSite(int maxCalleesPerCallSite) {
        this.maxCalleesPerCallSite = maxCalleesPerCallSite;
    }

    public void setMaxAbstractionPathLength(int maxAbstractionPathLength) {
        this.maxAbstractionPathLength = maxAbstractionPathLength;
    }

    public void setPeerGroup(SolverPeerGroup solverPeerGroup) {
        this.solverPeerGroup = solverPeerGroup;
    }

    public void terminate() {
        if (this.garbageCollector != null) {
            this.garbageCollector.notifySolverTerminated();
        }
    }

    private class PathEdgeProcessingTask
    implements Runnable {
        private final PathEdge<N, D> edge;
        private final boolean solverId;

        public PathEdgeProcessingTask(PathEdge<N, D> edge, boolean solverId) {
            this.edge = edge;
            this.solverId = solverId;
        }

        @Override
        public void run() {
            if (IFDSSolver.this.icfg.isCallStmt(this.edge.getTarget())) {
                IFDSSolver.this.processCall(this.edge);
            } else {
                if (IFDSSolver.this.icfg.isExitStmt(this.edge.getTarget())) {
                    IFDSSolver.this.processExit(this.edge);
                }
                if (!IFDSSolver.this.icfg.getSuccsOf(this.edge.getTarget()).isEmpty()) {
                    IFDSSolver.this.processNormalFlow(this.edge);
                }
            }
            IFDSSolver.this.garbageCollector.notifyTaskProcessed(this.edge);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.edge == null ? 0 : this.edge.hashCode());
            result = 31 * result + (this.solverId ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathEdgeProcessingTask other = (PathEdgeProcessingTask)obj;
            if (this.edge == null ? other.edge != null : !this.edge.equals(other.edge)) {
                return false;
            }
            return this.solverId == other.solverId;
        }
    }

    protected static class IncomingRecord<N, D extends FastSolverLinkedNode<D, N>> {
        public final N n;
        public final D d1;
        public final D d2;
        public final D d3;

        public IncomingRecord(N n, D d1, D d2, D d3) {
            this.n = n;
            this.d1 = d1;
            this.d2 = d2;
            this.d3 = d3;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.d1 == null ? 0 : this.d1.hashCode());
            result = 31 * result + (this.d2 == null ? 0 : this.d2.hashCode());
            result = 31 * result + (this.d3 == null ? 0 : this.d3.hashCode());
            result = 31 * result + (this.n == null ? 0 : this.n.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IncomingRecord other = (IncomingRecord)obj;
            if (this.d1 == null ? other.d1 != null : !this.d1.equals(other.d1)) {
                return false;
            }
            if (this.d2 == null ? other.d2 != null : !this.d2.equals(other.d2)) {
                return false;
            }
            if (this.d3 == null ? other.d3 != null : !this.d3.equals(other.d3)) {
                return false;
            }
            return !(this.n == null ? other.n != null : !this.n.equals(other.n));
        }
    }
}

