/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver;

import heros.DontSynchronize;
import soot.jimple.infoflow.solver.PredecessorShorteningMode;
import soot.jimple.infoflow.solver.fastSolver.FastSolverLinkedNode;

public class AbstractIFDSSolver<N, D extends FastSolverLinkedNode<D, N>> {
    @DontSynchronize(value="readOnly")
    protected PredecessorShorteningMode shorteningMode = PredecessorShorteningMode.NeverShorten;

    public void setPredecessorShorteningMode(PredecessorShorteningMode mode) {
        this.shorteningMode = mode;
    }

    protected D shortenPredecessors(D returnD, D incomingD, D calleeD, N currentUnit, N callSite) {
        switch (this.shorteningMode) {
            case AlwaysShorten: {
                if (returnD == calleeD) break;
                FastSolverLinkedNode res = (FastSolverLinkedNode)returnD.clone(currentUnit, callSite);
                res.setPredecessor(calleeD);
                return (D)res;
            }
            case ShortenIfEqual: {
                if (!returnD.equals(incomingD)) break;
                return incomingD;
            }
        }
        return returnD;
    }
}

