/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.river;

import soot.Local;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;

public class AdditionalFlowInfoSpecification {
    private final Local local;
    private final Stmt stmt;
    private final ISourceSinkDefinition def;

    public AdditionalFlowInfoSpecification(Local base, Stmt stmt) {
        this.local = base;
        this.stmt = stmt;
        this.def = null;
    }

    public AdditionalFlowInfoSpecification(Local base, Stmt stmt, ISourceSinkDefinition def) {
        this.local = base;
        this.stmt = stmt;
        this.def = def;
    }

    public Local getLocal() {
        return this.local;
    }

    public Stmt getStmt() {
        return this.stmt;
    }

    public AccessPath toAccessPath(InfoflowManager manager) {
        return manager.getAccessPathFactory().createAccessPath(this.local, true);
    }

    public ISourceSinkDefinition getDefinition() {
        return this.def;
    }

    public String toString() {
        return String.format("%s @ %s", this.local.toString(), this.stmt.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.local == null ? 0 : this.local.hashCode());
        result = 31 * result + (this.stmt == null ? 0 : this.stmt.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AdditionalFlowInfoSpecification other = (AdditionalFlowInfoSpecification)obj;
        if (this.local == null ? other.local != null : !this.local.equals(other.local)) {
            return false;
        }
        return !(this.stmt == null ? other.stmt != null : !this.stmt.equals(other.stmt));
    }
}

