/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems.rules.forward;

import java.util.Collection;
import java.util.Collections;
import soot.Scene;
import soot.SootMethod;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.AbstractTaintPropagationRule;
import soot.jimple.infoflow.util.ByReferenceBoolean;

public class SkipSystemClassRule
extends AbstractTaintPropagationRule {
    private final SootMethod objectCons = Scene.v().getObjectType().getSootClass().getMethodUnsafe("void <init>()");
    private final SootMethod objectClinit = Scene.v().getObjectType().getSootClass().getMethodUnsafe("void <clinit>()");
    private final SootMethod objectGetClass = Scene.v().getObjectType().getSootClass().getMethodUnsafe("java.lang.Class getClass()");
    private final SootMethod threadCons = Scene.v().grabMethod("<java.lang.Thread: void <init>()>");

    public SkipSystemClassRule(InfoflowManager manager, Abstraction zeroValue, TaintPropagationResults results) {
        super(manager, zeroValue, results);
    }

    @Override
    public Collection<Abstraction> propagateNormalFlow(Abstraction d1, Abstraction source, Stmt stmt, Stmt destStmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        return null;
    }

    @Override
    public Collection<Abstraction> propagateCallFlow(Abstraction d1, Abstraction source, Stmt stmt, SootMethod dest, ByReferenceBoolean killAll) {
        if (this.isSystemClassDest(dest)) {
            killAll.value = true;
        }
        return null;
    }

    private boolean isSystemClassDest(SootMethod dest) {
        return dest == this.objectCons || dest == this.objectClinit || dest == this.objectGetClass || dest == this.threadCons;
    }

    @Override
    public Collection<Abstraction> propagateCallToReturnFlow(Abstraction d1, Abstraction source, Stmt stmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        Collection callees = this.getManager().getICFG().getCalleesOfCallAt(stmt);
        if (callees.isEmpty()) {
            return null;
        }
        for (SootMethod callee : this.getManager().getICFG().getCalleesOfCallAt(stmt)) {
            if (this.isSystemClassDest(callee)) continue;
            return null;
        }
        return Collections.singleton(source);
    }

    @Override
    public Collection<Abstraction> propagateReturnFlow(Collection<Abstraction> callerD1s, Abstraction calleeD1, Abstraction source, Stmt stmt, Stmt retSite, Stmt callSite, ByReferenceBoolean killAll) {
        return null;
    }
}

