/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems.rules.backward;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import soot.ArrayType;
import soot.Local;
import soot.PrimType;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AnyNewExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.AbstractTaintPropagationRule;
import soot.jimple.infoflow.typing.TypeUtils;
import soot.jimple.infoflow.util.BaseSelector;
import soot.jimple.infoflow.util.ByReferenceBoolean;

public class BackwardsStrongUpdatePropagationRule
extends AbstractTaintPropagationRule {
    public BackwardsStrongUpdatePropagationRule(InfoflowManager manager, Abstraction zeroValue, TaintPropagationResults results) {
        super(manager, zeroValue, results);
    }

    @Override
    public Collection<Abstraction> propagateNormalFlow(Abstraction d1, Abstraction source, Stmt stmt, Stmt destStmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        FieldRef leftRef;
        if (!(stmt instanceof AssignStmt)) {
            return null;
        }
        AssignStmt assignStmt = (AssignStmt)stmt;
        Value leftOp = assignStmt.getLeftOp();
        Aliasing aliasing = this.getAliasing();
        if (aliasing == null) {
            return null;
        }
        if (source.getCurrentStmt() == stmt) {
            return null;
        }
        if (source.getPredecessor() != null && !source.getPredecessor().isAbstractionActive() && source.isAbstractionActive() && source.getAccessPath().equals(source.getPredecessor().getAccessPath())) {
            return null;
        }
        if (aliasing.mayAlias(BaseSelector.selectBase(leftOp, false), (Value)source.getAccessPath().getPlainValue())) {
            return null;
        }
        boolean addRightValue = false;
        boolean cutFirstField = false;
        Type type = null;
        if (source.getAccessPath().isInstanceFieldRef()) {
            if (leftOp instanceof InstanceFieldRef) {
                leftRef = (InstanceFieldRef)leftOp;
                if (aliasing.mustAlias((Local)leftRef.getBase(), source.getAccessPath().getPlainValue(), assignStmt) && aliasing.mustAlias(leftRef.getField(), source.getAccessPath().getFirstField())) {
                    addRightValue = true;
                    cutFirstField = true;
                    type = leftRef.getField().getType();
                }
            } else if (leftOp instanceof Local && aliasing.mustAlias((Local)leftOp, source.getAccessPath().getPlainValue(), stmt)) {
                addRightValue = true;
            }
        } else if (source.getAccessPath().isStaticFieldRef() && leftOp instanceof StaticFieldRef) {
            leftRef = (StaticFieldRef)leftOp;
            if (aliasing.mustAlias(((StaticFieldRef)leftRef).getField(), source.getAccessPath().getFirstField())) {
                addRightValue = true;
                cutFirstField = true;
                type = ((StaticFieldRef)leftRef).getField().getType();
            }
        } else if (source.getAccessPath().isLocal() && leftOp instanceof Local) {
            if (leftOp instanceof ArrayRef && source.getAccessPath().getArrayTaintType() != AccessPath.ArrayTaintType.Length) {
                Value base = ((ArrayRef)leftOp).getBase();
                if (base instanceof Local && aliasing.mustAlias((Local)base, source.getAccessPath().getPlainValue(), stmt)) {
                    addRightValue = true;
                    type = ((ArrayType)((ArrayRef)leftOp).getBase().getType()).getElementType();
                }
            } else if (aliasing.mustAlias((Local)leftOp, source.getAccessPath().getPlainValue(), stmt)) {
                addRightValue = true;
            }
        }
        if (addRightValue) {
            killSource.value = !(leftOp instanceof ArrayRef);
            Value rightOp = assignStmt.getRightOp();
            if (rightOp instanceof Constant || rightOp instanceof AnyNewExpr) {
                return null;
            }
            Value rightVal = BaseSelector.selectBase(assignStmt.getRightOp(), true);
            AccessPath newAp = this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), rightVal, type, cutFirstField);
            Abstraction newAbs = source.deriveNewAbstraction(newAp, assignStmt);
            if (newAbs != null) {
                if (type instanceof PrimType || TypeUtils.isStringType(type)) {
                    newAbs = newAbs.deriveNewAbstractionWithTurnUnit(assignStmt);
                } else if (this.getAliasing().canHaveAliasesRightSide(assignStmt, rightVal, newAbs)) {
                    for (Unit unit : this.manager.getICFG().getPredsOf(assignStmt)) {
                        this.getAliasing().computeAliases(d1, (Stmt)unit, rightVal, Collections.singleton(newAbs), (SootMethod)this.manager.getICFG().getMethodOf(unit), newAbs);
                    }
                }
                return Collections.singleton(newAbs);
            }
        }
        return null;
    }

    @Override
    public Collection<Abstraction> propagateCallFlow(Abstraction d1, Abstraction source, Stmt stmt, SootMethod dest, ByReferenceBoolean killAll) {
        if (source.getAccessPath().isEmpty()) {
            return null;
        }
        if (!(stmt instanceof AssignStmt)) {
            return null;
        }
        AssignStmt assignStmt = (AssignStmt)stmt;
        Value leftOp = assignStmt.getLeftOp();
        Aliasing aliasing = this.getAliasing();
        if (aliasing == null) {
            return null;
        }
        if (source.getAccessPath().isStaticFieldRef()) {
            return null;
        }
        if (aliasing.mayAlias(BaseSelector.selectBase(leftOp, false), (Value)source.getAccessPath().getPlainValue())) {
            return null;
        }
        if (aliasing.mustAlias((Local)leftOp, source.getAccessPath().getPlainValue(), stmt)) {
            HashSet<Abstraction> res = new HashSet<Abstraction>();
            for (Unit unit : dest.getActiveBody().getUnits()) {
                ReturnStmt returnStmt;
                Value retVal;
                if (!(unit instanceof ReturnStmt) || !((retVal = (returnStmt = (ReturnStmt)unit).getOp()) instanceof Local) && !(retVal instanceof FieldRef) || !this.manager.getTypeUtils().checkCast(source.getAccessPath().getBaseType(), retVal.getType())) continue;
                Type type = returnStmt.getOp().getType();
                AccessPath ap = this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), retVal, type, false);
                Abstraction abs = source.deriveNewAbstraction(ap, stmt);
                if (abs == null) continue;
                if (type instanceof PrimType || TypeUtils.isStringType(type)) {
                    abs = abs.deriveNewAbstractionWithTurnUnit(stmt);
                }
                abs.setCorrespondingCallSite(stmt);
                res.add(abs);
            }
            return res;
        }
        return null;
    }

    @Override
    public Collection<Abstraction> propagateCallToReturnFlow(Abstraction d1, Abstraction source, Stmt stmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        return null;
    }

    @Override
    public Collection<Abstraction> propagateReturnFlow(Collection<Abstraction> callerD1s, Abstraction calleeD1, Abstraction source, Stmt stmt, Stmt retSite, Stmt callSite, ByReferenceBoolean killAll) {
        return null;
    }
}

