/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems.rules.backward;

import java.util.Collection;
import java.util.HashSet;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.LengthExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.AbstractTaintPropagationRule;
import soot.jimple.infoflow.typing.TypeUtils;
import soot.jimple.infoflow.util.ByReferenceBoolean;

public class BackwardsArrayPropagationRule
extends AbstractTaintPropagationRule {
    public BackwardsArrayPropagationRule(InfoflowManager manager, Abstraction zeroValue, TaintPropagationResults results) {
        super(manager, zeroValue, results);
    }

    @Override
    public Collection<Abstraction> propagateNormalFlow(Abstraction d1, Abstraction source, Stmt stmt, Stmt destStmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        if (!(stmt instanceof AssignStmt)) {
            return null;
        }
        AssignStmt assignStmt = (AssignStmt)stmt;
        Aliasing aliasing = this.manager.getAliasing();
        if (aliasing == null) {
            return null;
        }
        Abstraction newAbs = null;
        Value leftVal = assignStmt.getLeftOp();
        Value rightVal = assignStmt.getRightOp();
        HashSet<Abstraction> res = new HashSet<Abstraction>();
        if (rightVal instanceof LengthExpr) {
            LengthExpr lengthExpr = (LengthExpr)rightVal;
            if (aliasing.mayAlias(leftVal, (Value)source.getAccessPath().getPlainValue())) {
                AccessPath ap = this.getManager().getAccessPathFactory().createAccessPath(lengthExpr.getOp(), lengthExpr.getOp().getType(), true, AccessPath.ArrayTaintType.Length);
                newAbs = source.deriveNewAbstraction(ap, assignStmt);
            }
        } else if (rightVal instanceof NewArrayExpr && this.getManager().getConfig().getEnableArraySizeTainting()) {
            NewArrayExpr newArrayExpr = (NewArrayExpr)rightVal;
            if (!(newArrayExpr.getSize() instanceof Constant) && source.getAccessPath().getArrayTaintType() != AccessPath.ArrayTaintType.Contents && aliasing.mayAlias(source.getAccessPath().getPlainValue(), leftVal)) {
                AccessPath ap = this.getManager().getAccessPathFactory().createAccessPath(newArrayExpr.getSize(), true);
                newAbs = source.deriveNewAbstraction(ap, assignStmt);
            }
        } else if (rightVal instanceof ArrayRef) {
            Value rightBase = ((ArrayRef)rightVal).getBase();
            Value rightIndex = ((ArrayRef)rightVal).getIndex();
            if (source.getAccessPath().getArrayTaintType() != AccessPath.ArrayTaintType.Length && aliasing.mayAlias(leftVal, (Value)source.getAccessPath().getPlainValue())) {
                AccessPath ap;
                if (this.getManager().getConfig().getImplicitFlowMode().trackArrayAccesses()) {
                    ap = this.getManager().getAccessPathFactory().createAccessPath(rightIndex, false);
                    newAbs = source.deriveNewAbstraction(ap, assignStmt);
                    res.add(newAbs);
                }
                Type baseType = source.getAccessPath().getBaseType();
                Type targetType = TypeUtils.buildArrayOrAddDimension(baseType, baseType.getArrayType());
                ap = this.getManager().getAccessPathFactory().copyWithNewValue(source.getAccessPath(), rightBase, targetType, false, true, AccessPath.ArrayTaintType.Contents);
                newAbs = source.deriveNewAbstraction(ap, assignStmt);
            }
        }
        if (newAbs == null) {
            return null;
        }
        killSource.value = !(leftVal instanceof ArrayRef);
        res.add(newAbs);
        if (aliasing.canHaveAliases(assignStmt, leftVal, newAbs)) {
            aliasing.computeAliases(d1, assignStmt, leftVal, res, (SootMethod)this.manager.getICFG().getMethodOf(assignStmt), newAbs);
        }
        return res;
    }

    @Override
    public Collection<Abstraction> propagateCallFlow(Abstraction d1, Abstraction source, Stmt stmt, SootMethod dest, ByReferenceBoolean killAll) {
        return null;
    }

    @Override
    public Collection<Abstraction> propagateCallToReturnFlow(Abstraction d1, Abstraction source, Stmt stmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        return null;
    }

    @Override
    public Collection<Abstraction> propagateReturnFlow(Collection<Abstraction> callerD1s, Abstraction calleeD1, Abstraction source, Stmt stmt, Stmt retSite, Stmt callSite, ByReferenceBoolean killAll) {
        return null;
    }
}

