/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems;

import heros.FlowFunction;
import heros.FlowFunctions;
import heros.flowfunc.Identity;
import heros.flowfunc.KillAll;
import heros.solver.PathEdge;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import soot.ArrayType;
import soot.Local;
import soot.PrimType;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.UnopExpr;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.collect.MutableTwoElementSet;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.handlers.TaintPropagationHandler;
import soot.jimple.infoflow.problems.AbstractInfoflowProblem;
import soot.jimple.infoflow.problems.rules.EmptyPropagationRuleManagerFactory;
import soot.jimple.infoflow.solver.functions.SolverCallFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverCallToReturnFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverNormalFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverReturnFlowFunction;
import soot.jimple.infoflow.typing.TypeUtils;
import soot.jimple.infoflow.util.BaseSelector;

public class BackwardsAliasProblem
extends AbstractInfoflowProblem {
    private static final boolean DEBUG_PRINT = false;

    public BackwardsAliasProblem(InfoflowManager manager) {
        super(manager, null, EmptyPropagationRuleManagerFactory.INSTANCE);
    }

    @Override
    protected FlowFunctions<Unit, Abstraction, SootMethod> createFlowFunctionsFactory() {
        return new FlowFunctions<Unit, Abstraction, SootMethod>(){

            private Abstraction checkAbstraction(Abstraction abs) {
                if (abs == null) {
                    return null;
                }
                if (!abs.getAccessPath().isStaticFieldRef() ? abs.getAccessPath().getBaseType() instanceof PrimType : abs.getAccessPath().getFirstFieldType() instanceof PrimType) {
                    return null;
                }
                return abs;
            }

            private boolean isCircularType(Value val) {
                if (!(val instanceof InstanceFieldRef)) {
                    return false;
                }
                InstanceFieldRef ref = (InstanceFieldRef)val;
                return ref.getBase().getType() == ref.getField().getType();
            }

            @Override
            public FlowFunction<Abstraction> getNormalFlowFunction(final Unit srcUnit, Unit destUnit) {
                if (!(srcUnit instanceof DefinitionStmt)) {
                    return Identity.v();
                }
                final DefinitionStmt defStmt = (DefinitionStmt)srcUnit;
                return new SolverNormalFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                        if (source == BackwardsAliasProblem.this.getZeroValue()) {
                            return null;
                        }
                        assert (!source.getAccessPath().isEmpty());
                        if (BackwardsAliasProblem.this.taintPropagationHandler != null) {
                            BackwardsAliasProblem.this.taintPropagationHandler.notifyFlowIn(srcUnit, source, BackwardsAliasProblem.this.manager, TaintPropagationHandler.FlowFunctionType.NormalFlowFunction);
                        }
                        if (source.getTurnUnit() == srcUnit) {
                            return BackwardsAliasProblem.this.notifyOutFlowHandlers(srcUnit, d1, source, null, TaintPropagationHandler.FlowFunctionType.NormalFlowFunction);
                        }
                        Set<Abstraction> res = this.computeAliases(defStmt, d1, source);
                        return BackwardsAliasProblem.this.notifyOutFlowHandlers(srcUnit, d1, source, res, TaintPropagationHandler.FlowFunctionType.NormalFlowFunction);
                    }

                    private Set<Abstraction> computeAliases(DefinitionStmt defStmt2, Abstraction d1, Abstraction source) {
                        boolean fieldAliases;
                        if (defStmt2 instanceof IdentityStmt) {
                            return Collections.singleton(source);
                        }
                        if (!(defStmt2 instanceof AssignStmt)) {
                            return null;
                        }
                        MutableTwoElementSet<Abstraction> res = new MutableTwoElementSet<Abstraction>();
                        AssignStmt assignStmt = (AssignStmt)defStmt2;
                        Value leftOp = assignStmt.getLeftOp();
                        Value rightOp = assignStmt.getRightOp();
                        Value leftVal = BaseSelector.selectBase(leftOp, false);
                        Value rightVal = BaseSelector.selectBase(rightOp, false);
                        AccessPath ap = source.getAccessPath();
                        Local sourceBase = ap.getPlainValue();
                        Type rightType = rightOp.getType();
                        boolean handoverLeftValue = false;
                        boolean cutSubfield = false;
                        boolean leftSideOverwritten = false;
                        if (leftOp instanceof StaticFieldRef) {
                            if (BackwardsAliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && ap.firstFieldMatches(((StaticFieldRef)leftOp).getField())) {
                                handoverLeftValue = true;
                                cutSubfield = true;
                            }
                        } else if (leftOp instanceof InstanceFieldRef) {
                            Object mappedAp;
                            InstanceFieldRef instRef = (InstanceFieldRef)leftOp;
                            if (instRef.getBase() == sourceBase && (mappedAp = Aliasing.getReferencedAPBase(ap, new SootField[]{instRef.getField()}, BackwardsAliasProblem.this.manager)) != null) {
                                handoverLeftValue = true;
                                cutSubfield = true;
                                if (!((AccessPath)mappedAp).equals(ap)) {
                                    ap = mappedAp;
                                }
                            }
                        } else if (leftVal == sourceBase) {
                            handoverLeftValue = leftOp instanceof ArrayRef && ap.getArrayTaintType() != AccessPath.ArrayTaintType.Length;
                            boolean bl = leftSideOverwritten = !handoverLeftValue;
                        }
                        if (handoverLeftValue) {
                            Abstraction newAbs = null;
                            if (rightVal instanceof Constant) {
                                if (BackwardsAliasProblem.this.manager.getConfig().getImplicitFlowMode().trackControlFlowDependencies()) {
                                    newAbs = source.deriveConditionalUpdate(assignStmt);
                                    for (Unit pred : BackwardsAliasProblem.this.manager.getICFG().getPredsOf(srcUnit)) {
                                        this.handOver(d1, pred, newAbs);
                                    }
                                }
                            } else {
                                AccessPath newAp = BackwardsAliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(ap, rightOp, rightType, cutSubfield);
                                newAbs = source.deriveNewAbstraction(newAp, assignStmt);
                            }
                            if (newAbs != null && !newAbs.equals(source)) {
                                for (Unit pred : BackwardsAliasProblem.this.manager.getICFG().getPredsOf(srcUnit)) {
                                    this.handOver(d1, pred, newAbs);
                                }
                            }
                        }
                        if (leftSideOverwritten) {
                            return null;
                        }
                        res.add(source);
                        if (rightOp instanceof BinopExpr || rightOp instanceof UnopExpr || rightOp instanceof NewArrayExpr) {
                            return res;
                        }
                        boolean localAliases = (leftOp instanceof Local || leftOp instanceof ArrayRef) && !(leftOp.getType() instanceof PrimType);
                        boolean bl = fieldAliases = leftOp instanceof FieldRef && !(((FieldRef)leftOp).getField().getType() instanceof PrimType);
                        if ((localAliases || fieldAliases) && !(rightVal.getType() instanceof PrimType)) {
                            AccessPath newAp;
                            Abstraction newAbs;
                            boolean addLeftValue = false;
                            boolean cutFirstFieldLeft = false;
                            Type leftType = null;
                            boolean createNewVal = false;
                            if (rightVal instanceof StaticFieldRef) {
                                if (BackwardsAliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && ap.firstFieldMatches(((StaticFieldRef)rightVal).getField())) {
                                    addLeftValue = true;
                                }
                            } else if (rightVal instanceof InstanceFieldRef) {
                                AccessPath mappedAp;
                                InstanceFieldRef instRef = (InstanceFieldRef)rightVal;
                                if (instRef.getBase() == sourceBase && ap.isInstanceFieldRef() && (mappedAp = Aliasing.getReferencedAPBase(ap, new SootField[]{instRef.getField()}, BackwardsAliasProblem.this.manager)) != null) {
                                    addLeftValue = true;
                                    cutFirstFieldLeft = true;
                                    if (!mappedAp.equals(ap)) {
                                        ap = mappedAp;
                                        source = source.deriveNewAbstraction(mappedAp, null);
                                    }
                                }
                            } else if (rightVal == sourceBase) {
                                addLeftValue = true;
                                leftType = ap.getBaseType();
                                if (rightOp instanceof ArrayRef) {
                                    leftType = ((ArrayType)leftType).getElementType();
                                } else if (leftOp instanceof ArrayRef) {
                                    ArrayRef arrayRef = (ArrayRef)leftOp;
                                    leftType = TypeUtils.buildArrayOrAddDimension(leftType, arrayRef.getType().getArrayType());
                                } else if (!BackwardsAliasProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath().getBaseType(), leftOp.getType())) {
                                    return null;
                                }
                                if (rightVal instanceof CastExpr) {
                                    CastExpr ce = (CastExpr)rightOp;
                                    if (!BackwardsAliasProblem.this.manager.getHierarchy().canStoreType(leftType, ce.getCastType())) {
                                        leftType = ce.getCastType();
                                    }
                                } else if (rightVal instanceof InstanceOfExpr) {
                                    addLeftValue = false;
                                }
                            }
                            if (addLeftValue && (newAbs = this.checkAbstraction(source.deriveNewAbstraction(newAp = createNewVal ? BackwardsAliasProblem.this.manager.getAccessPathFactory().createAccessPath(leftVal, true) : BackwardsAliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(ap, leftOp, leftType, cutFirstFieldLeft), assignStmt))) != null && newAbs != source) {
                                if (rightVal instanceof StaticFieldRef && BackwardsAliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() == InfoflowConfiguration.StaticFieldTrackingMode.ContextFlowInsensitive) {
                                    BackwardsAliasProblem.this.manager.getGlobalTaintManager().addToGlobalTaintState(newAbs);
                                } else {
                                    res.add(newAbs);
                                }
                            }
                        }
                        return res;
                    }
                };
            }

            @Override
            public FlowFunction<Abstraction> getCallFlowFunction(final Unit callSite, final SootMethod dest) {
                if (!dest.isConcrete()) {
                    BackwardsAliasProblem.this.logger.debug("Call skipped because target has no body: {} -> {}", (Object)callSite, (Object)dest);
                    return KillAll.v();
                }
                if (!(callSite instanceof Stmt)) {
                    return KillAll.v();
                }
                final Stmt callStmt = (Stmt)callSite;
                final InvokeExpr ie = callStmt.containsInvokeExpr() ? callStmt.getInvokeExpr() : null;
                final Local[] paramLocals = dest.getActiveBody().getParameterLocals().toArray(new Local[0]);
                final Local thisLocal = dest.isStatic() ? null : dest.getActiveBody().getThisLocal();
                final boolean isSource = BackwardsAliasProblem.this.manager.getSourceSinkManager() != null && BackwardsAliasProblem.this.manager.getSourceSinkManager().getSourceInfo((Stmt)callSite, BackwardsAliasProblem.this.manager) != null;
                final boolean isSink = BackwardsAliasProblem.this.manager.getSourceSinkManager() != null && BackwardsAliasProblem.this.manager.getSourceSinkManager().getSinkInfo(callStmt, BackwardsAliasProblem.this.manager, null) != null;
                final boolean isExecutorExecute = BackwardsAliasProblem.this.interproceduralCFG().isExecutorExecute(ie, dest);
                final boolean isReflectiveCallSite = BackwardsAliasProblem.this.interproceduralCFG().isReflectiveCallSite(ie);
                return new SolverCallFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                        if (source == BackwardsAliasProblem.this.getZeroValue()) {
                            return null;
                        }
                        if (BackwardsAliasProblem.this.taintPropagationHandler != null) {
                            BackwardsAliasProblem.this.taintPropagationHandler.notifyFlowIn(callStmt, source, BackwardsAliasProblem.this.manager, TaintPropagationHandler.FlowFunctionType.CallFlowFunction);
                        }
                        if (source.getTurnUnit() == callSite) {
                            return BackwardsAliasProblem.this.notifyOutFlowHandlers(callSite, d1, source, null, TaintPropagationHandler.FlowFunctionType.CallFlowFunction);
                        }
                        Set<Abstraction> res = this.computeTargetsInternal(d1, source);
                        return BackwardsAliasProblem.this.notifyOutFlowHandlers(callStmt, d1, source, res, TaintPropagationHandler.FlowFunctionType.CallFlowFunction);
                    }

                    private Set<Abstraction> computeTargetsInternal(Abstraction d1, Abstraction source) {
                        Abstraction abs;
                        if (!BackwardsAliasProblem.this.manager.getConfig().getInspectSources() && isSource) {
                            return null;
                        }
                        if (!BackwardsAliasProblem.this.manager.getConfig().getInspectSinks() && isSink) {
                            return null;
                        }
                        if (BackwardsAliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() == InfoflowConfiguration.StaticFieldTrackingMode.None && dest.isStaticInitializer()) {
                            return null;
                        }
                        if (BackwardsAliasProblem.this.isExcluded(dest)) {
                            return null;
                        }
                        if (BackwardsAliasProblem.this.taintWrapper != null && BackwardsAliasProblem.this.taintWrapper.isExclusive(callStmt, source)) {
                            return null;
                        }
                        if (BackwardsAliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef() && !BackwardsAliasProblem.this.interproceduralCFG().isStaticFieldRead(dest, source.getAccessPath().getFirstField())) {
                            return null;
                        }
                        HashSet<Abstraction> res = new HashSet<Abstraction>();
                        if (BackwardsAliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef() && (abs = this.checkAbstraction(source.deriveNewAbstraction(source.getAccessPath(), callStmt))) != null) {
                            res.add(abs);
                        }
                        if (!(isExecutorExecute || source.getAccessPath().isStaticFieldRef() || dest.isStatic())) {
                            AccessPath ap;
                            Abstraction abs2;
                            Local sourceBase;
                            InstanceInvokeExpr instanceInvokeExpr = (InstanceInvokeExpr)callStmt.getInvokeExpr();
                            Value callBase = isReflectiveCallSite ? instanceInvokeExpr.getArg(0) : instanceInvokeExpr.getBase();
                            if (callBase == (sourceBase = source.getAccessPath().getPlainValue()) && BackwardsAliasProblem.this.manager.getTypeUtils().hasCompatibleTypesForCall(source.getAccessPath(), dest.getDeclaringClass()) && (isReflectiveCallSite || instanceInvokeExpr.getArgs().stream().noneMatch(arg -> arg == sourceBase)) && (abs2 = this.checkAbstraction(source.deriveNewAbstraction(ap = BackwardsAliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), thisLocal), (Stmt)callSite))) != null) {
                                res.add(abs2);
                            }
                        }
                        if (isExecutorExecute && ie != null && ie.getArg(0) == source.getAccessPath().getPlainValue()) {
                            AccessPath ap = BackwardsAliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), thisLocal);
                            Local[] abs3 = this.checkAbstraction(source.deriveNewAbstraction(ap, callStmt));
                            if (abs3 != null) {
                                res.add((Abstraction)abs3);
                            }
                        } else if (ie != null && dest.getParameterCount() > 0) {
                            int i;
                            int n = i = isReflectiveCallSite ? 1 : 0;
                            while (i < ie.getArgCount()) {
                                if (ie.getArg(i) == source.getAccessPath().getPlainValue()) {
                                    if (isReflectiveCallSite) {
                                        for (Local param : paramLocals) {
                                            AccessPath ap = BackwardsAliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), param, null, false);
                                            Abstraction abs4 = this.checkAbstraction(source.deriveNewAbstraction(ap, callStmt));
                                            if (abs4 == null) continue;
                                            res.add(abs4);
                                        }
                                    } else {
                                        AccessPath ap = BackwardsAliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), paramLocals[i]);
                                        Abstraction abs5 = this.checkAbstraction(source.deriveNewAbstraction(ap, callStmt));
                                        if (abs5 != null) {
                                            res.add(abs5);
                                        }
                                    }
                                }
                                ++i;
                            }
                        }
                        for (Abstraction d3 : res) {
                            BackwardsAliasProblem.this.manager.getMainSolver().injectContext(BackwardsAliasProblem.this.solver, dest, d3, callSite, source, d1);
                        }
                        return res;
                    }
                };
            }

            @Override
            public FlowFunction<Abstraction> getReturnFlowFunction(final Unit callSite, final SootMethod callee, final Unit exitStmt, final Unit returnSite) {
                if (callSite != null && !(callSite instanceof Stmt)) {
                    return KillAll.v();
                }
                final Value[] paramLocals = new Value[callee.getParameterCount()];
                for (int i = 0; i < callee.getParameterCount(); ++i) {
                    paramLocals[i] = callee.getActiveBody().getParameterLocal(i);
                }
                final Stmt callStmt = (Stmt)callSite;
                final InvokeExpr ie = callStmt != null && callStmt.containsInvokeExpr() ? callStmt.getInvokeExpr() : null;
                final boolean isReflectiveCallSite = BackwardsAliasProblem.this.interproceduralCFG().isReflectiveCallSite(ie);
                final ReturnStmt returnStmt = exitStmt instanceof ReturnStmt ? (ReturnStmt)exitStmt : null;
                final Local thisLocal = callee.isStatic() ? null : callee.getActiveBody().getThisLocal();
                final boolean isExecutorExecute = BackwardsAliasProblem.this.interproceduralCFG().isExecutorExecute(ie, callee);
                return new SolverReturnFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction source, Abstraction calleeD1, Collection<Abstraction> callerD1s) {
                        if (source == BackwardsAliasProblem.this.getZeroValue()) {
                            return null;
                        }
                        if (callSite == null) {
                            return null;
                        }
                        if (BackwardsAliasProblem.this.taintPropagationHandler != null) {
                            BackwardsAliasProblem.this.taintPropagationHandler.notifyFlowIn(callStmt, source, BackwardsAliasProblem.this.manager, TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                        }
                        if (source.getTurnUnit() == callSite) {
                            return BackwardsAliasProblem.this.notifyOutFlowHandlers(callSite, calleeD1, source, null, TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                        }
                        Set<Abstraction> res = this.computeTargetsInternal(source);
                        return BackwardsAliasProblem.this.notifyOutFlowHandlers(exitStmt, calleeD1, source, res, TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                    }

                    private Set<Abstraction> computeTargetsInternal(Abstraction source) {
                        Local sourceBase;
                        AccessPath ap;
                        Abstraction abs;
                        HashSet<Abstraction> res = new HashSet<Abstraction>();
                        if (BackwardsAliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef()) {
                            res.add(source);
                            return res;
                        }
                        if (returnStmt != null && callStmt instanceof AssignStmt) {
                            Value retLocal = returnStmt.getOp();
                            DefinitionStmt defnStmt = (DefinitionStmt)callSite;
                            Value leftOp = defnStmt.getLeftOp();
                            if (retLocal == source.getAccessPath().getPlainValue() && !BackwardsAliasProblem.this.isExceptionHandler(returnSite) && (abs = this.checkAbstraction(source.deriveNewAbstraction(ap = BackwardsAliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), leftOp), (Stmt)exitStmt))) != null) {
                                res.add(abs);
                            }
                        }
                        if (!isExecutorExecute && !callee.isStatic() && thisLocal == (sourceBase = source.getAccessPath().getPlainValue()) && BackwardsAliasProblem.this.manager.getTypeUtils().hasCompatibleTypesForCall(source.getAccessPath(), callee.getDeclaringClass())) {
                            Value callBase;
                            InstanceInvokeExpr instanceInvokeExpr = (InstanceInvokeExpr)callStmt.getInvokeExpr();
                            Value value = callBase = isReflectiveCallSite ? instanceInvokeExpr.getArg(0) : instanceInvokeExpr.getBase();
                            if ((isReflectiveCallSite || instanceInvokeExpr.getArgs().stream().noneMatch(arg -> arg == sourceBase)) && (abs = this.checkAbstraction(source.deriveNewAbstraction(ap = BackwardsAliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), callBase, isReflectiveCallSite ? null : source.getAccessPath().getBaseType(), false), (Stmt)exitStmt))) != null) {
                                res.add(abs);
                            }
                        }
                        if (isExecutorExecute && ie != null && ie.getArg(0) == source.getAccessPath().getPlainValue()) {
                            AccessPath ap2 = BackwardsAliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), thisLocal);
                            Abstraction abs2 = this.checkAbstraction(source.deriveNewAbstraction(ap2, callStmt));
                            if (abs2 != null) {
                                res.add(abs2);
                            }
                        } else if (ie != null) {
                            for (int i = 0; i < callee.getParameterCount(); ++i) {
                                AccessPath ap3;
                                Abstraction abs3;
                                if (source.getAccessPath().getPlainValue() != paramLocals[i] || this.isPrimitiveOrStringBase(source)) continue;
                                Value originalCallArg = ie.getArg(isReflectiveCallSite ? 1 : i);
                                if (callSite instanceof DefinitionStmt && !BackwardsAliasProblem.this.isExceptionHandler(returnSite)) {
                                    DefinitionStmt defnStmt = (DefinitionStmt)callSite;
                                    Value leftOp = defnStmt.getLeftOp();
                                    originalCallArg = defnStmt.getInvokeExpr().getArg(i);
                                    if (originalCallArg == leftOp) continue;
                                }
                                if (BackwardsAliasProblem.this.interproceduralCFG().methodWritesValue(callee, paramLocals[i]) || !AccessPath.canContainValue(originalCallArg) || !isReflectiveCallSite && !BackwardsAliasProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath(), originalCallArg.getType()) || (abs3 = this.checkAbstraction(source.deriveNewAbstraction(ap3 = BackwardsAliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), originalCallArg, isReflectiveCallSite ? null : source.getAccessPath().getBaseType(), false), (Stmt)exitStmt))) == null) continue;
                                res.add(abs3);
                            }
                        }
                        if (res.isEmpty()) {
                            return null;
                        }
                        for (Abstraction abs2 : res) {
                            if (abs2 == source) continue;
                            abs2.setCorrespondingCallSite((Stmt)callSite);
                        }
                        return res;
                    }
                };
            }

            @Override
            public FlowFunction<Abstraction> getCallToReturnFlowFunction(final Unit callSite, Unit returnSite) {
                if (!(callSite instanceof Stmt)) {
                    return KillAll.v();
                }
                final Stmt callStmt = (Stmt)callSite;
                InvokeExpr invExpr = callStmt.getInvokeExpr();
                final Value[] callArgs = new Value[invExpr.getArgCount()];
                for (int i = 0; i < invExpr.getArgCount(); ++i) {
                    callArgs[i] = invExpr.getArg(i);
                }
                final SootMethod callee = invExpr.getMethod();
                final boolean isSource = BackwardsAliasProblem.this.manager.getSourceSinkManager() != null && BackwardsAliasProblem.this.manager.getSourceSinkManager().getSourceInfo(callStmt, BackwardsAliasProblem.this.manager) != null;
                return new SolverCallToReturnFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                        if (source == BackwardsAliasProblem.this.getZeroValue()) {
                            return null;
                        }
                        if (BackwardsAliasProblem.this.taintPropagationHandler != null) {
                            BackwardsAliasProblem.this.taintPropagationHandler.notifyFlowIn(callSite, source, BackwardsAliasProblem.this.manager, TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                        }
                        if (source.getTurnUnit() != null && (source.getTurnUnit() == callSite || BackwardsAliasProblem.this.manager.getICFG().getCalleesOfCallAt(callSite).stream().anyMatch(m4 -> BackwardsAliasProblem.this.manager.getICFG().getMethodOf(source.getTurnUnit()) == m4))) {
                            return BackwardsAliasProblem.this.notifyOutFlowHandlers(callSite, d1, source, null, TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                        }
                        Set<Abstraction> res = this.computeTargetsInternal(d1, source);
                        return BackwardsAliasProblem.this.notifyOutFlowHandlers(callSite, d1, source, res, TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                    }

                    private Set<Abstraction> computeTargetsInternal(Abstraction d1, Abstraction source) {
                        if (BackwardsAliasProblem.this.taintWrapper != null) {
                            Set<Abstraction> wrapperAliases;
                            if (BackwardsAliasProblem.this.taintWrapper.isExclusive(callStmt, source)) {
                                this.handOver(d1, callSite, source);
                            }
                            if ((wrapperAliases = BackwardsAliasProblem.this.taintWrapper.getAliasesForMethod(callStmt, d1, source)) != null && !wrapperAliases.isEmpty()) {
                                HashSet<Abstraction> passOnSet = new HashSet<Abstraction>(wrapperAliases.size());
                                for (Abstraction abs : wrapperAliases) {
                                    passOnSet.add(abs);
                                    if (abs != source) {
                                        abs.setCorrespondingCallSite(callStmt);
                                    }
                                    for (Unit u : BackwardsAliasProblem.this.manager.getICFG().getPredsOf(callSite)) {
                                        this.handOver(d1, u, abs);
                                    }
                                }
                                return passOnSet;
                            }
                        }
                        if (BackwardsAliasProblem.this.interproceduralCFG().getCalleesOfCallAt(callSite).isEmpty()) {
                            return Collections.singleton(source);
                        }
                        if (BackwardsAliasProblem.this.isExcluded(callee)) {
                            return Collections.singleton(source);
                        }
                        if (BackwardsAliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef() && BackwardsAliasProblem.this.interproceduralCFG().isStaticFieldUsed(callee, source.getAccessPath().getFirstField())) {
                            return null;
                        }
                        if (!callee.isNative()) {
                            InstanceInvokeExpr inv;
                            if (callStmt.getInvokeExpr() instanceof InstanceInvokeExpr && (inv = (InstanceInvokeExpr)callStmt.getInvokeExpr()).getBase() == source.getAccessPath().getPlainValue()) {
                                return null;
                            }
                            if (Arrays.stream(callArgs).anyMatch(arg -> !this.isPrimitiveOrStringBase(source) && arg == source.getAccessPath().getPlainValue())) {
                                if (isSource) {
                                    this.handOver(d1, callSite, source);
                                }
                                return null;
                            }
                        } else {
                            for (Value arg2 : callArgs) {
                                if (arg2 != source.getAccessPath().getPlainValue()) continue;
                                Abstraction newSource = source.deriveNewAbstractionWithTurnUnit(callSite);
                                this.handOver(d1, callSite, newSource);
                                return null;
                            }
                        }
                        return Collections.singleton(source);
                    }
                };
            }

            private boolean isPrimitiveOrStringBase(Abstraction abs) {
                Type t2 = abs.getAccessPath().getBaseType();
                return t2 instanceof PrimType || TypeUtils.isStringType(t2) && !abs.getAccessPath().getCanHaveImmutableAliases();
            }

            private void handOver(Abstraction d1, Unit unit, Abstraction in) {
                in = in.getActiveCopy();
                if (BackwardsAliasProblem.this.manager.getConfig().getImplicitFlowMode().trackControlFlowDependencies()) {
                    List<Unit> condUnits = BackwardsAliasProblem.this.manager.getOriginalICFG().getConditionalBranchesInterprocedural(unit);
                    for (Unit condUnit : condUnits) {
                        Abstraction abs = in.deriveNewAbstractionWithDominator(condUnit);
                        if (abs == null) continue;
                        BackwardsAliasProblem.this.manager.getMainSolver().processEdge(new PathEdge<Unit, Abstraction>(d1, unit, abs));
                    }
                } else {
                    BackwardsAliasProblem.this.manager.getMainSolver().processEdge(new PathEdge<Unit, Abstraction>(d1, unit, in));
                }
            }
        };
    }
}

