/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems;

import heros.FlowFunction;
import heros.FlowFunctions;
import heros.flowfunc.Identity;
import heros.flowfunc.KillAll;
import heros.solver.PathEdge;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import soot.ArrayType;
import soot.Local;
import soot.PrimType;
import soot.RefType;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.UnopExpr;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.collect.MutableTwoElementSet;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.handlers.TaintPropagationHandler;
import soot.jimple.infoflow.problems.AbstractInfoflowProblem;
import soot.jimple.infoflow.problems.rules.EmptyPropagationRuleManagerFactory;
import soot.jimple.infoflow.solver.functions.SolverCallFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverCallToReturnFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverNormalFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverReturnFlowFunction;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.typing.TypeUtils;
import soot.jimple.infoflow.util.BaseSelector;

public class AliasProblem
extends AbstractInfoflowProblem {
    @Override
    public void setTaintWrapper(ITaintPropagationWrapper wrapper) {
        this.taintWrapper = wrapper;
    }

    public AliasProblem(InfoflowManager manager) {
        super(manager, null, EmptyPropagationRuleManagerFactory.INSTANCE);
    }

    @Override
    public FlowFunctions<Unit, Abstraction, SootMethod> createFlowFunctionsFactory() {
        return new FlowFunctions<Unit, Abstraction, SootMethod>(){

            private Abstraction checkAbstraction(Abstraction abs) {
                if (abs == null) {
                    return null;
                }
                if (!abs.getAccessPath().isStaticFieldRef() ? abs.getAccessPath().getBaseType() instanceof PrimType : abs.getAccessPath().getFirstFieldType() instanceof PrimType) {
                    return null;
                }
                return abs;
            }

            /*
             * WARNING - void declaration
             */
            private Set<Abstraction> computeAliases(DefinitionStmt defStmt, Value leftValue, Abstraction d1, Abstraction source) {
                boolean aliasOverwritten;
                assert (!source.getAccessPath().isEmpty());
                if (source == AliasProblem.this.getZeroValue()) {
                    return null;
                }
                MutableTwoElementSet<Abstraction> res = new MutableTwoElementSet<Abstraction>();
                if (defStmt instanceof IdentityStmt) {
                    res.add(source);
                    return res;
                }
                if (!(defStmt instanceof AssignStmt)) {
                    return res;
                }
                boolean leftSideMatches = Aliasing.baseMatches(leftValue, source);
                if (!leftSideMatches) {
                    res.add(source);
                }
                Value rightValue = BaseSelector.selectBase(defStmt.getRightOp(), false);
                if (leftSideMatches && !(rightValue instanceof Local) && !(rightValue instanceof FieldRef) && !(rightValue instanceof ArrayRef)) {
                    return res;
                }
                if (rightValue instanceof Constant) {
                    return res;
                }
                if (defStmt.getRightOp() instanceof NewArrayExpr) {
                    return res;
                }
                if (defStmt.getRightOp() instanceof BinopExpr) {
                    return res;
                }
                if (defStmt.getRightOp() instanceof UnopExpr) {
                    return res;
                }
                boolean bl = aliasOverwritten = Aliasing.baseMatchesStrict(rightValue, source) && rightValue.getType() instanceof RefType && !source.dependsOnCutAP();
                if (!aliasOverwritten && !(rightValue.getType() instanceof PrimType)) {
                    FieldRef ref;
                    Abstraction newLeftAbs = null;
                    if (rightValue instanceof InstanceFieldRef) {
                        ref = (InstanceFieldRef)rightValue;
                        if (source.getAccessPath().isInstanceFieldRef() && ref.getBase() == source.getAccessPath().getPlainValue() && source.getAccessPath().firstFieldMatches(ref.getField())) {
                            AccessPath accessPath = AliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), leftValue, source.getAccessPath().getFirstFieldType(), true);
                            newLeftAbs = this.checkAbstraction(source.deriveNewAbstraction(accessPath, defStmt));
                        }
                    } else if (AliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && rightValue instanceof StaticFieldRef) {
                        ref = (StaticFieldRef)rightValue;
                        if (source.getAccessPath().isStaticFieldRef() && source.getAccessPath().firstFieldMatches(((StaticFieldRef)ref).getField())) {
                            AccessPath accessPath = AliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), leftValue, source.getAccessPath().getBaseType(), true);
                            newLeftAbs = this.checkAbstraction(source.deriveNewAbstraction(accessPath, defStmt));
                        }
                    } else if (rightValue == source.getAccessPath().getPlainValue()) {
                        Object newType = source.getAccessPath().getBaseType();
                        if (leftValue instanceof ArrayRef) {
                            ArrayRef arrayRef = (ArrayRef)leftValue;
                            newType = TypeUtils.buildArrayOrAddDimension((Type)newType, arrayRef.getType().getArrayType());
                        } else if (defStmt.getRightOp() instanceof ArrayRef) {
                            newType = ((ArrayType)newType).getElementType();
                        } else if (!AliasProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath(), leftValue.getType())) {
                            return null;
                        }
                        if (defStmt.getRightOp() instanceof CastExpr) {
                            CastExpr castExpr = (CastExpr)defStmt.getRightOp();
                            if (!AliasProblem.this.manager.getHierarchy().canStoreType((Type)newType, castExpr.getCastType())) {
                                newType = castExpr.getCastType();
                            }
                        } else {
                            if (defStmt.getRightOp() instanceof LengthExpr) {
                                return res;
                            }
                            if (defStmt.getRightOp() instanceof InstanceOfExpr) {
                                return res;
                            }
                        }
                        AccessPath accessPath = AliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), leftValue, (Type)newType, false);
                        newLeftAbs = this.checkAbstraction(source.deriveNewAbstraction(accessPath, defStmt));
                    }
                    if (newLeftAbs != null && !newLeftAbs.getAccessPath().equals(source.getAccessPath())) {
                        for (Unit unit : AliasProblem.this.interproceduralCFG().getPredsOf(defStmt)) {
                            AliasProblem.this.manager.getMainSolver().processEdge(new PathEdge<Unit, Abstraction>(d1, unit, newLeftAbs));
                        }
                    }
                }
                if ((rightValue instanceof Local || rightValue instanceof FieldRef) && !(leftValue.getType() instanceof PrimType)) {
                    boolean addRightValue = false;
                    boolean cutFirstField = false;
                    Object var11_22 = null;
                    if (leftValue instanceof InstanceFieldRef) {
                        InstanceFieldRef leftRef;
                        if (source.getAccessPath().isInstanceFieldRef() && (leftRef = (InstanceFieldRef)leftValue).getBase() == source.getAccessPath().getPlainValue() && source.getAccessPath().firstFieldMatches(leftRef.getField())) {
                            Type type = source.getAccessPath().getFirstFieldType();
                            addRightValue = true;
                            cutFirstField = true;
                        }
                    } else if (leftValue instanceof Local && source.getAccessPath().isInstanceFieldRef()) {
                        Local base = source.getAccessPath().getPlainValue();
                        if (leftValue == base) {
                            Type type = source.getAccessPath().getBaseType();
                            addRightValue = true;
                        }
                    } else if (leftValue instanceof ArrayRef) {
                        ArrayRef ar = (ArrayRef)leftValue;
                        Local leftBase = (Local)ar.getBase();
                        if (leftBase == source.getAccessPath().getPlainValue()) {
                            addRightValue = true;
                            Type type = source.getAccessPath().getBaseType();
                        }
                    } else if (leftValue == source.getAccessPath().getPlainValue()) {
                        if (!AliasProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath(), defStmt.getRightOp().getType())) {
                            return null;
                        }
                        addRightValue = true;
                        Type type = source.getAccessPath().getBaseType();
                    }
                    if (addRightValue) {
                        AccessPath ap;
                        Abstraction newAbs;
                        void var11_37;
                        void var11_30;
                        if (var11_30 != null) {
                            if (defStmt.getRightOp() instanceof ArrayRef) {
                                ArrayRef arrayRef = (ArrayRef)defStmt.getRightOp();
                                Type type = TypeUtils.buildArrayOrAddDimension((Type)var11_30, arrayRef.getType().getArrayType());
                            } else if (leftValue instanceof ArrayRef) {
                                void var11_34;
                                assert (source.getAccessPath().getBaseType() instanceof ArrayType);
                                Type type = ((ArrayType)var11_30).getElementType();
                                if (TypeUtils.isObjectLikeType(type)) {
                                    Type type2 = rightValue.getType();
                                }
                                if (!AliasProblem.this.manager.getTypeUtils().checkCast(rightValue.getType(), (Type)var11_34)) {
                                    addRightValue = false;
                                }
                            }
                        }
                        if (defStmt.getRightOp() instanceof LengthExpr) {
                            Object var11_36 = null;
                        }
                        if ((var11_37 instanceof PrimType || var11_37 instanceof ArrayType && ((ArrayType)var11_37).getElementType() instanceof PrimType) && !source.getAccessPath().isStaticFieldRef() && !source.getAccessPath().isLocal()) {
                            return null;
                        }
                        if ((rightValue.getType() instanceof PrimType || rightValue.getType() instanceof ArrayType && ((ArrayType)rightValue.getType()).getElementType() instanceof PrimType) && !source.getAccessPath().isStaticFieldRef() && !source.getAccessPath().isLocal()) {
                            return null;
                        }
                        if (addRightValue && !AliasProblem.this.manager.getTypeUtils().checkCast(rightValue.getType(), (Type)var11_37)) {
                            addRightValue = false;
                        }
                        if (addRightValue && rightValue instanceof StaticFieldRef && AliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() == InfoflowConfiguration.StaticFieldTrackingMode.None) {
                            addRightValue = false;
                        }
                        if (addRightValue && (newAbs = this.checkAbstraction(source.deriveNewAbstraction(ap = AliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), rightValue, (Type)var11_37, cutFirstField), defStmt))) != null && !newAbs.getAccessPath().equals(source.getAccessPath())) {
                            if (rightValue instanceof StaticFieldRef && AliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() == InfoflowConfiguration.StaticFieldTrackingMode.ContextFlowInsensitive) {
                                AliasProblem.this.manager.getGlobalTaintManager().addToGlobalTaintState(newAbs);
                            } else {
                                res.add(newAbs);
                                for (Unit unit : AliasProblem.this.interproceduralCFG().getPredsOf(defStmt)) {
                                    AliasProblem.this.manager.getMainSolver().processEdge(new PathEdge<Unit, Abstraction>(d1, unit, newAbs));
                                }
                            }
                        }
                    }
                }
                return res;
            }

            @Override
            public FlowFunction<Abstraction> getNormalFlowFunction(final Unit src, Unit dest) {
                if (src instanceof DefinitionStmt) {
                    final DefinitionStmt defStmt = (DefinitionStmt)src;
                    final Value leftValue = BaseSelector.selectBase(defStmt.getLeftOp(), true);
                    final DefinitionStmt destDefStmt = dest instanceof DefinitionStmt ? (DefinitionStmt)dest : null;
                    final Value destLeftValue = destDefStmt == null ? null : BaseSelector.selectBase(destDefStmt.getLeftOp(), true);
                    return new SolverNormalFlowFunction(){

                        @Override
                        public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                            if (source == AliasProblem.this.getZeroValue()) {
                                return null;
                            }
                            assert (source.isAbstractionActive() || AliasProblem.this.manager.getConfig().getFlowSensitiveAliasing());
                            if (AliasProblem.this.taintPropagationHandler != null) {
                                AliasProblem.this.taintPropagationHandler.notifyFlowIn(src, source, AliasProblem.this.manager, TaintPropagationHandler.FlowFunctionType.NormalFlowFunction);
                            }
                            Set res = this.computeAliases(defStmt, leftValue, d1, source);
                            if (destDefStmt != null && res != null && !res.isEmpty() && AliasProblem.this.interproceduralCFG().isExitStmt(destDefStmt)) {
                                for (Abstraction abs : res) {
                                    this.computeAliases(destDefStmt, destLeftValue, d1, abs);
                                }
                            }
                            return AliasProblem.this.notifyOutFlowHandlers(src, d1, source, res, TaintPropagationHandler.FlowFunctionType.NormalFlowFunction);
                        }
                    };
                }
                return Identity.v();
            }

            @Override
            public FlowFunction<Abstraction> getCallFlowFunction(final Unit src, final SootMethod dest) {
                boolean isSource;
                if (!dest.isConcrete()) {
                    return KillAll.v();
                }
                final Stmt stmt = (Stmt)src;
                final InvokeExpr ie = stmt != null && stmt.containsInvokeExpr() ? stmt.getInvokeExpr() : null;
                final boolean isReflectiveCallSite = AliasProblem.this.interproceduralCFG().isReflectiveCallSite(ie);
                final Value[] paramLocals = new Value[dest.getParameterCount()];
                for (int i = 0; i < dest.getParameterCount(); ++i) {
                    paramLocals[i] = dest.getActiveBody().getParameterLocal(i);
                }
                boolean bl = AliasProblem.this.manager.getSourceSinkManager() != null ? AliasProblem.this.manager.getSourceSinkManager().getSourceInfo((Stmt)src, AliasProblem.this.manager) != null : (isSource = false);
                final boolean isSink = AliasProblem.this.manager.getSourceSinkManager() != null ? AliasProblem.this.manager.getSourceSinkManager().getSinkInfo(stmt, AliasProblem.this.manager, null) != null : false;
                final Local thisLocal = dest.isStatic() ? null : dest.getActiveBody().getThisLocal();
                final boolean isExecutorExecute = AliasProblem.this.interproceduralCFG().isExecutorExecute(ie, dest);
                return new SolverCallFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                        Abstraction abs;
                        DefinitionStmt defnStmt;
                        Value leftOp;
                        if (source == AliasProblem.this.getZeroValue()) {
                            return null;
                        }
                        assert (source.isAbstractionActive() || AliasProblem.this.manager.getConfig().getFlowSensitiveAliasing());
                        if (AliasProblem.this.taintPropagationHandler != null) {
                            AliasProblem.this.taintPropagationHandler.notifyFlowIn(stmt, source, AliasProblem.this.manager, TaintPropagationHandler.FlowFunctionType.CallFlowFunction);
                        }
                        if (!AliasProblem.this.manager.getConfig().getInspectSources() && isSource) {
                            return null;
                        }
                        if (!AliasProblem.this.manager.getConfig().getInspectSinks() && isSink) {
                            return null;
                        }
                        if (AliasProblem.this.isCallSiteActivatingTaint(stmt, source.getActivationUnit())) {
                            return null;
                        }
                        if (AliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() == InfoflowConfiguration.StaticFieldTrackingMode.None && dest.isStaticInitializer()) {
                            return null;
                        }
                        if (AliasProblem.this.taintWrapper != null && AliasProblem.this.taintWrapper.isExclusive(stmt, source)) {
                            return null;
                        }
                        if (AliasProblem.this.isExcluded(dest)) {
                            return null;
                        }
                        if (AliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef() && !AliasProblem.this.interproceduralCFG().isStaticFieldRead(dest, source.getAccessPath().getFirstField())) {
                            return null;
                        }
                        HashSet<Abstraction> res = new HashSet<Abstraction>();
                        if (src instanceof DefinitionStmt && (leftOp = (defnStmt = (DefinitionStmt)src).getLeftOp()) == source.getAccessPath().getPlainValue()) {
                            for (Unit u : dest.getActiveBody().getUnits()) {
                                AccessPath ap;
                                Abstraction abs2;
                                ReturnStmt rStmt;
                                if (!(u instanceof ReturnStmt) || !((rStmt = (ReturnStmt)u).getOp() instanceof Local) && !(rStmt.getOp() instanceof FieldRef) || !AliasProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath(), rStmt.getOp().getType()) || (abs2 = this.checkAbstraction(source.deriveNewAbstraction(ap = AliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), rStmt.getOp(), null, false), (Stmt)src))) == null) continue;
                                res.add(abs2);
                            }
                        }
                        if (AliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef() && (abs = this.checkAbstraction(source.deriveNewAbstraction(source.getAccessPath(), stmt))) != null) {
                            res.add(abs);
                        }
                        Local sourceBase = source.getAccessPath().getPlainValue();
                        if (!(isExecutorExecute || source.getAccessPath().isStaticFieldRef() || dest.isStatic())) {
                            Value callBase;
                            InstanceInvokeExpr iIExpr = (InstanceInvokeExpr)stmt.getInvokeExpr();
                            Value value = callBase = isReflectiveCallSite ? iIExpr.getArg(0) : iIExpr.getBase();
                            if (callBase == sourceBase && AliasProblem.this.manager.getTypeUtils().hasCompatibleTypesForCall(source.getAccessPath(), dest.getDeclaringClass())) {
                                AccessPath ap;
                                Abstraction abs3;
                                boolean param = false;
                                if (!isReflectiveCallSite) {
                                    for (int i = 0; i < dest.getParameterCount(); ++i) {
                                        if (stmt.getInvokeExpr().getArg(i) != sourceBase) continue;
                                        param = true;
                                        break;
                                    }
                                }
                                if (!param && (abs3 = this.checkAbstraction(source.deriveNewAbstraction(ap = AliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), thisLocal), (Stmt)src))) != null) {
                                    res.add(abs3);
                                }
                            }
                        }
                        if (isExecutorExecute) {
                            AccessPath ap;
                            Abstraction abs4;
                            if (ie.getArg(0) == source.getAccessPath().getPlainValue() && (abs4 = this.checkAbstraction(source.deriveNewAbstraction(ap = AliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), thisLocal), stmt))) != null) {
                                res.add(abs4);
                            }
                        } else if (ie != null && dest.getParameterCount() > 0 && (isReflectiveCallSite || dest.getParameterCount() == ie.getArgCount())) {
                            int i;
                            int n = i = isReflectiveCallSite ? 1 : 0;
                            while (i < ie.getArgCount()) {
                                if (ie.getArg(i) == source.getAccessPath().getPlainValue()) {
                                    if (isReflectiveCallSite) {
                                        int j = 0;
                                        while (i < paramLocals.length) {
                                            AccessPath ap = AliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), paramLocals[j], null, false);
                                            Abstraction abs5 = this.checkAbstraction(source.deriveNewAbstraction(ap, stmt));
                                            if (abs5 != null) {
                                                res.add(abs5);
                                            }
                                            ++i;
                                        }
                                    } else {
                                        AccessPath ap = AliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), paramLocals[i]);
                                        Abstraction abs6 = this.checkAbstraction(source.deriveNewAbstraction(ap, stmt));
                                        if (abs6 != null) {
                                            res.add(abs6);
                                        }
                                    }
                                }
                                ++i;
                            }
                        }
                        if (res != null && !res.isEmpty()) {
                            for (Abstraction d3 : res) {
                                AliasProblem.this.manager.getMainSolver().injectContext(AliasProblem.this.solver, dest, d3, src, source, d1);
                            }
                        }
                        return AliasProblem.this.notifyOutFlowHandlers(src, d1, source, res, TaintPropagationHandler.FlowFunctionType.CallFlowFunction);
                    }
                };
            }

            @Override
            public FlowFunction<Abstraction> getReturnFlowFunction(final Unit callSite, final SootMethod callee, final Unit exitStmt, Unit retSite) {
                final Value[] paramLocals = new Value[callee.getParameterCount()];
                for (int i = 0; i < callee.getParameterCount(); ++i) {
                    paramLocals[i] = callee.getActiveBody().getParameterLocal(i);
                }
                final Stmt stmt = (Stmt)callSite;
                final InvokeExpr ie = stmt != null && stmt.containsInvokeExpr() ? stmt.getInvokeExpr() : null;
                final boolean isReflectiveCallSite = AliasProblem.this.interproceduralCFG().isReflectiveCallSite(ie);
                final Local thisLocal = callee.isStatic() ? null : callee.getActiveBody().getThisLocal();
                final boolean isExecutorExecute = AliasProblem.this.interproceduralCFG().isExecutorExecute(ie, callee);
                return new SolverReturnFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction source, Abstraction d1, Collection<Abstraction> callerD1s) {
                        if (source == AliasProblem.this.getZeroValue()) {
                            return null;
                        }
                        assert (source.isAbstractionActive() || AliasProblem.this.manager.getConfig().getFlowSensitiveAliasing());
                        if (callSite == null) {
                            return null;
                        }
                        if (AliasProblem.this.taintPropagationHandler != null) {
                            AliasProblem.this.taintPropagationHandler.notifyFlowIn(stmt, source, AliasProblem.this.manager, TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                        }
                        if (AliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef()) {
                            AliasProblem.this.registerActivationCallSite(callSite, callee, source);
                            return AliasProblem.this.notifyOutFlowHandlers(exitStmt, d1, source, Collections.singleton(source), TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                        }
                        Local sourceBase = source.getAccessPath().getPlainValue();
                        HashSet<Abstraction> res = new HashSet<Abstraction>();
                        if (isExecutorExecute) {
                            AccessPath ap;
                            Abstraction abs;
                            if (source.getAccessPath().getPlainValue() == thisLocal && (abs = this.checkAbstraction(source.deriveNewAbstraction(ap = AliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), ie.getArg(0)), (Stmt)exitStmt))) != null) {
                                res.add(abs);
                                AliasProblem.this.registerActivationCallSite(callSite, callee, abs);
                            }
                        } else {
                            Stmt stmt2;
                            boolean parameterAliases = false;
                            block0: for (int i = 0; i < paramLocals.length; ++i) {
                                AccessPath ap;
                                Abstraction abs;
                                Value originalCallArg;
                                if (paramLocals[i] != sourceBase) continue;
                                parameterAliases = true;
                                if (!(callSite instanceof Stmt) || !AccessPath.canContainValue(originalCallArg = ie.getArg(isReflectiveCallSite ? 1 : i)) || !isReflectiveCallSite && !AliasProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath(), originalCallArg.getType()) || source.getAccessPath().getBaseType() instanceof PrimType || TypeUtils.isStringType(source.getAccessPath().getBaseType()) && !source.getAccessPath().getCanHaveImmutableAliases() || AliasProblem.this.interproceduralCFG().methodWritesValue(callee, paramLocals[i]) || (abs = this.checkAbstraction(source.deriveNewAbstraction(ap = AliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), originalCallArg, isReflectiveCallSite ? null : source.getAccessPath().getBaseType(), false), (Stmt)exitStmt))) == null) continue;
                                res.add(abs);
                                AliasProblem.this.registerActivationCallSite(callSite, callee, abs);
                                for (int argIndex = 0; !isReflectiveCallSite && argIndex < ie.getArgCount(); ++argIndex) {
                                    if (i == argIndex || originalCallArg != ie.getArg(argIndex)) continue;
                                    AccessPath aliasAp = AliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), paramLocals[argIndex], source.getAccessPath().getBaseType(), false);
                                    Abstraction aliasAbs = this.checkAbstraction(source.deriveNewAbstraction(aliasAp, (Stmt)exitStmt));
                                    AliasProblem.this.manager.getMainSolver().processEdge(new PathEdge<Unit, Abstraction>(d1, exitStmt, aliasAbs));
                                }
                                for (Unit u : AliasProblem.this.manager.getICFG().getStartPointsOf(callee)) {
                                    if (!(u instanceof ReturnStmt) || paramLocals[i] != ((ReturnStmt)u).getOp()) continue;
                                    AliasProblem.this.manager.getMainSolver().processEdge(new PathEdge<Unit, Abstraction>(d1, exitStmt, source));
                                    continue block0;
                                }
                            }
                            if (!callee.isStatic() && thisLocal == sourceBase && AliasProblem.this.manager.getTypeUtils().hasCompatibleTypesForCall(source.getAccessPath(), callee.getDeclaringClass()) && !parameterAliases && callSite instanceof Stmt && (stmt2 = (Stmt)callSite).getInvokeExpr() instanceof InstanceInvokeExpr) {
                                InstanceInvokeExpr iIExpr = (InstanceInvokeExpr)stmt2.getInvokeExpr();
                                Value callerBaseLocal = AliasProblem.this.interproceduralCFG().isReflectiveCallSite(iIExpr) ? iIExpr.getArg(0) : iIExpr.getBase();
                                AccessPath ap = AliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), callerBaseLocal, isReflectiveCallSite ? null : source.getAccessPath().getBaseType(), false);
                                Abstraction abs = this.checkAbstraction(source.deriveNewAbstraction(ap, (Stmt)exitStmt));
                                if (abs != null) {
                                    res.add(abs);
                                    AliasProblem.this.registerActivationCallSite(callSite, callee, abs);
                                }
                            }
                        }
                        for (Abstraction abs : res) {
                            if (abs == source) continue;
                            abs.setCorrespondingCallSite((Stmt)callSite);
                        }
                        return AliasProblem.this.notifyOutFlowHandlers(exitStmt, d1, source, res, TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                    }
                };
            }

            @Override
            public FlowFunction<Abstraction> getCallToReturnFlowFunction(final Unit call, Unit returnSite) {
                final Stmt iStmt = (Stmt)call;
                InvokeExpr invExpr = iStmt.getInvokeExpr();
                final Value[] callArgs = new Value[iStmt.getInvokeExpr().getArgCount()];
                for (int i = 0; i < iStmt.getInvokeExpr().getArgCount(); ++i) {
                    callArgs[i] = iStmt.getInvokeExpr().getArg(i);
                }
                final SootMethod callee = invExpr.getMethod();
                final DefinitionStmt defStmt = iStmt instanceof DefinitionStmt ? (DefinitionStmt)iStmt : null;
                return new SolverCallToReturnFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                        InstanceInvokeExpr iinv;
                        Set<Abstraction> wrapperAliases;
                        if (source == AliasProblem.this.getZeroValue()) {
                            return null;
                        }
                        assert (source.isAbstractionActive() || AliasProblem.this.manager.getConfig().getFlowSensitiveAliasing());
                        if (AliasProblem.this.taintPropagationHandler != null) {
                            AliasProblem.this.taintPropagationHandler.notifyFlowIn(call, source, AliasProblem.this.manager, TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                        }
                        if (AliasProblem.this.taintWrapper != null && (wrapperAliases = AliasProblem.this.taintWrapper.getAliasesForMethod(iStmt, d1, source)) != null && !wrapperAliases.isEmpty()) {
                            HashSet<Abstraction> passOnSet = new HashSet<Abstraction>(wrapperAliases.size());
                            for (Abstraction abs : wrapperAliases) {
                                if (defStmt == null || defStmt.getLeftOp() != abs.getAccessPath().getPlainValue()) {
                                    passOnSet.add(abs);
                                }
                                if (source.equals(abs)) continue;
                                for (Unit u : AliasProblem.this.interproceduralCFG().getPredsOf(call)) {
                                    AliasProblem.this.manager.getMainSolver().processEdge(new PathEdge<Unit, Abstraction>(d1, u, abs));
                                }
                            }
                            return AliasProblem.this.notifyOutFlowHandlers(call, d1, source, passOnSet, TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                        }
                        boolean mustPropagate = AliasProblem.this.isExcluded(callee);
                        if (!(mustPropagate |= AliasProblem.this.interproceduralCFG().getCalleesOfCallAt(call).isEmpty()) && AliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef() && AliasProblem.this.interproceduralCFG().isStaticFieldUsed(callee, source.getAccessPath().getFirstField())) {
                            return null;
                        }
                        if (iStmt instanceof DefinitionStmt && ((DefinitionStmt)iStmt).getLeftOp() == source.getAccessPath().getPlainValue()) {
                            return null;
                        }
                        if (!mustPropagate && iStmt.getInvokeExpr() instanceof InstanceInvokeExpr && (iinv = (InstanceInvokeExpr)iStmt.getInvokeExpr()).getBase() == source.getAccessPath().getPlainValue() && !AliasProblem.this.interproceduralCFG().getCalleesOfCallAt(call).isEmpty()) {
                            return null;
                        }
                        if (!mustPropagate) {
                            for (int i = 0; i < callArgs.length; ++i) {
                                if (callArgs[i] != source.getAccessPath().getPlainValue()) continue;
                                return null;
                            }
                        }
                        return AliasProblem.this.notifyOutFlowHandlers(call, d1, source, Collections.singleton(source), TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                    }
                };
            }
        };
    }
}

