/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.nativeCallHandler;

import java.util.Collections;
import java.util.Set;
import soot.Local;
import soot.Value;
import soot.jimple.Stmt;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.nativeCallHandler.AbstractNativeCallHandler;

public class BackwardNativeCallHandler
extends AbstractNativeCallHandler {
    private static final String SIG_ARRAYCOPY = "<java.lang.System: void arraycopy(java.lang.Object,int,java.lang.Object,int,int)>";
    private static final String SIG_COMPARE_AND_SWAP_OBJECT = "<sun.misc.Unsafe: boolean compareAndSwapObject(java.lang.Object,long,java.lang.Object,java.lang.Object)>";

    @Override
    public Set<Abstraction> getTaintedValues(Stmt call, Abstraction source, Value[] params) {
        if (source.isAbstractionActive()) {
            Local taintedValue = source.getAccessPath().getPlainValue();
            switch (call.getInvokeExpr().getMethod().getSignature()) {
                case "<java.lang.System: void arraycopy(java.lang.Object,int,java.lang.Object,int,int)>": {
                    if (!params[2].equals(taintedValue) || !this.manager.getTypeUtils().checkCast(source.getAccessPath(), params[0].getType())) break;
                    AccessPath ap = this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), params[0], source.getAccessPath().getBaseType(), false);
                    Abstraction abs = source.deriveNewAbstraction(ap, call);
                    abs.setCorrespondingCallSite(call);
                    return Collections.singleton(abs);
                }
                case "<sun.misc.Unsafe: boolean compareAndSwapObject(java.lang.Object,long,java.lang.Object,java.lang.Object)>": {
                    if (!params[0].equals(taintedValue) || !this.manager.getTypeUtils().checkCast(source.getAccessPath(), params[0].getType())) break;
                    AccessPath ap = this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), params[3], null, false, true, AccessPath.ArrayTaintType.Length);
                    Abstraction abs = source.deriveNewAbstraction(ap, call);
                    abs.setCorrespondingCallSite(call);
                    return Collections.singleton(abs);
                }
            }
        }
        return null;
    }

    @Override
    public boolean supportsCall(Stmt call) {
        return call.containsInvokeExpr() && call.getInvokeExpr().getMethod().getSignature().equals(SIG_ARRAYCOPY);
    }
}

