/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.taintWrappers.resolvers;

import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;

public class SummaryQuery {
    public final SootClass calleeClass;
    public final SootClass declaredClass;
    public final String subsignature;

    public SummaryQuery(SootClass calleeClass, SootClass declaredClass, String subsignature) {
        this.calleeClass = calleeClass;
        this.declaredClass = declaredClass;
        this.subsignature = subsignature;
    }

    public static SummaryQuery fromStmt(Stmt stmt) {
        if (stmt != null && stmt.containsInvokeExpr()) {
            InstanceInvokeExpr iiexpr;
            Type baseType;
            InvokeExpr iexpr = stmt.getInvokeExpr();
            SootClass declaredClass = null;
            if (iexpr instanceof InstanceInvokeExpr && (baseType = (iiexpr = (InstanceInvokeExpr)iexpr).getBase().getType()) instanceof RefType) {
                declaredClass = ((RefType)baseType).getSootClass();
            }
            SootMethod callee = iexpr.getMethod();
            SootClass calleeClass = callee.getDeclaringClass();
            return new SummaryQuery(calleeClass, declaredClass, callee.getSubSignature());
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.calleeClass.getName());
        sb.append(": ");
        sb.append(this.subsignature);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.calleeClass == null ? 0 : this.calleeClass.hashCode());
        result = 31 * result + (this.declaredClass == null ? 0 : this.declaredClass.hashCode());
        result = 31 * result + (this.subsignature == null ? 0 : this.subsignature.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SummaryQuery other = (SummaryQuery)obj;
        if (this.calleeClass == null ? other.calleeClass != null : !this.calleeClass.equals(other.calleeClass)) {
            return false;
        }
        if (this.declaredClass == null ? other.declaredClass != null : !this.declaredClass.equals(other.declaredClass)) {
            return false;
        }
        return !(this.subsignature == null ? other.subsignature != null : !this.subsignature.equals(other.subsignature));
    }
}

