/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.generator.gaps;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import soot.Local;
import soot.SootMethod;
import soot.ValueBox;
import soot.jimple.DefinitionStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.methodSummary.data.summary.GapDefinition;
import soot.jimple.infoflow.methodSummary.generator.gaps.IGapManager;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;

public abstract class AbstractGapManager
implements IGapManager {
    @Override
    public boolean isLocalReferencedInGap(Local local) {
        for (Stmt stmt : this.getAllGapStmts()) {
            for (ValueBox vb : stmt.getUseBoxes()) {
                if (vb.getValue() != local) continue;
                return true;
            }
            if (!(stmt instanceof DefinitionStmt) || ((DefinitionStmt)stmt).getLeftOp() != local) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<GapDefinition> getGapDefinitionsForLocalDef(Local local) {
        HashSet<GapDefinition> res = null;
        for (Stmt stmt : this.getAllGapStmts()) {
            if (!(stmt instanceof DefinitionStmt) || ((DefinitionStmt)stmt).getLeftOp() != local) continue;
            if (res == null) {
                res = new HashSet<GapDefinition>();
            }
            res.add(this.getGapForCall(stmt));
        }
        return res;
    }

    @Override
    public Set<GapDefinition> getGapDefinitionsForLocalUse(Local local) {
        HashSet<GapDefinition> res = null;
        block0: for (Stmt stmt : this.getAllGapStmts()) {
            for (ValueBox vb : stmt.getUseBoxes()) {
                if (vb.getValue() != local) continue;
                if (res == null) {
                    res = new HashSet<GapDefinition>();
                }
                res.add(this.getGapForCall(stmt));
                continue block0;
            }
        }
        return res;
    }

    @Override
    public boolean needsGapConstruction(Stmt stmt, Abstraction abs, IInfoflowCFG icfg) {
        SootMethod targetMethod = stmt.getInvokeExpr().getMethod();
        if (!abs.isAbstractionActive()) {
            return false;
        }
        if (targetMethod.isNative()) {
            return false;
        }
        if (targetMethod.isConstructor() || targetMethod.isStaticInitializer()) {
            return false;
        }
        if (abs.getSourceContext() != null && abs.getSourceContext().getStmt() == stmt) {
            return false;
        }
        if (!this.isValueUsedInStmt(stmt, abs)) {
            return false;
        }
        SootMethod sm = (SootMethod)icfg.getMethodOf(stmt);
        Collection callees = icfg.getCalleesOfCallAt(stmt);
        if (!(callees == null || callees.isEmpty() || callees.size() == 1 && callees.contains(sm) && stmt.getInvokeExpr().getMethod().isAbstract())) {
            return false;
        }
        if (sm.getDeclaringClass().getName().equals("java.lang.System")) {
            return false;
        }
        return !targetMethod.getDeclaringClass().getName().startsWith("sun.");
    }

    protected boolean isValueUsedInStmt(Stmt stmt, Abstraction abs) {
        if (!stmt.containsInvokeExpr()) {
            return false;
        }
        InvokeExpr iexpr = stmt.getInvokeExpr();
        for (int i = 0; i < iexpr.getArgCount(); ++i) {
            if (abs.getAccessPath().getPlainValue() != iexpr.getArg(i)) continue;
            return true;
        }
        return iexpr instanceof InstanceInvokeExpr && ((InstanceInvokeExpr)iexpr).getBase() == abs.getAccessPath().getPlainValue();
    }
}

