/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.generator;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import soot.Scene;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.SourceContext;
import soot.jimple.infoflow.handlers.PreAnalysisHandler;
import soot.jimple.infoflow.methodSummary.data.sourceSink.FlowSource;
import soot.jimple.infoflow.methodSummary.data.summary.GapDefinition;
import soot.jimple.infoflow.methodSummary.data.summary.MethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.SourceSinkType;
import soot.jimple.infoflow.methodSummary.generator.SummaryGeneratorConfiguration;
import soot.jimple.infoflow.methodSummary.generator.gaps.IGapManager;
import soot.jimple.infoflow.methodSummary.util.AliasUtils;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.toolkits.callgraph.Edge;

public class SummaryGenerationTaintWrapper
implements ITaintPropagationWrapper {
    protected InfoflowManager manager;
    protected final MethodSummaries summaries;
    protected final IGapManager gapManager;

    public SummaryGenerationTaintWrapper(MethodSummaries summaries, IGapManager gapManager) {
        this.summaries = summaries;
        this.gapManager = gapManager;
    }

    @Override
    public void initialize(InfoflowManager manager) {
        this.manager = manager;
    }

    @Override
    public Collection<PreAnalysisHandler> getPreAnalysisHandlers() {
        return Collections.emptyList();
    }

    @Override
    public Set<Abstraction> getTaintsForMethod(Stmt stmt, Abstraction d1, Abstraction taintedPath) {
        Object ap;
        if (!stmt.containsInvokeExpr()) {
            return Collections.singleton(taintedPath);
        }
        if (!this.gapManager.needsGapConstruction(stmt, taintedPath, this.manager.getICFG())) {
            return Collections.singleton(taintedPath);
        }
        if (!taintedPath.isAbstractionActive()) {
            return Collections.singleton(taintedPath);
        }
        if (((SootMethod)this.manager.getICFG().getMethodOf(stmt)).getDeclaringClass().getName().equals("java.lang.System")) {
            return Collections.singleton(taintedPath);
        }
        Set<Abstraction> res = this.getTaintsForHashCodeEquals(stmt, taintedPath);
        if (res != null) {
            return res;
        }
        GapDefinition gap = this.gapManager.getOrCreateGapForCall(this.summaries, stmt);
        if (gap == null) {
            return Collections.singleton(taintedPath);
        }
        res = new HashSet<Abstraction>();
        InvokeExpr iexpr = stmt.getInvokeExpr();
        if (iexpr instanceof InstanceInvokeExpr) {
            ap = this.manager.getAccessPathFactory().createAccessPath(((InstanceInvokeExpr)stmt.getInvokeExpr()).getBase(), true);
            res.add(this.getContinuation(taintedPath, (AccessPath)ap, gap, stmt));
        }
        for (Value paramVal : stmt.getInvokeExpr().getArgs()) {
            AccessPath ap2;
            if (!AccessPath.canContainValue(paramVal) || !AliasUtils.canAccessPathHaveAliases(ap2 = this.manager.getAccessPathFactory().createAccessPath(paramVal, true))) continue;
            res.add(this.getContinuation(taintedPath, ap2, gap, stmt));
        }
        if (stmt instanceof DefinitionStmt) {
            ap = this.manager.getAccessPathFactory().createAccessPath(((DefinitionStmt)stmt).getLeftOp(), true);
            res.add(this.getContinuation(taintedPath, (AccessPath)ap, gap, stmt));
        }
        return res;
    }

    protected Set<Abstraction> getTaintsForHashCodeEquals(Stmt stmt, Abstraction taintedPath) {
        InvokeExpr iexpr = stmt.getInvokeExpr();
        SummaryGeneratorConfiguration config = (SummaryGeneratorConfiguration)this.manager.getConfig();
        if (iexpr instanceof InstanceInvokeExpr && !config.getSummarizeHashCodeEquals()) {
            SootMethodRef ref = iexpr.getMethodRef();
            InstanceInvokeExpr iiexpr = (InstanceInvokeExpr)iexpr;
            AccessPath ap = taintedPath.getAccessPath();
            SummaryGeneratorConfiguration.TaintCondition taintCondition = config.getDefaultTaints().get(ref.getSubSignature().toString());
            if (taintCondition != null) {
                HashSet<Abstraction> taints = new HashSet<Abstraction>();
                taints.add(taintedPath);
                if (stmt instanceof DefinitionStmt) {
                    DefinitionStmt defStmt = (DefinitionStmt)stmt;
                    if ((ap.getPlainValue() == iiexpr.getBase() || iiexpr.getArgs().contains(ap.getPlainValue())) && (taintCondition.equals((Object)SummaryGeneratorConfiguration.TaintCondition.TaintAlways) || taintCondition.equals((Object)SummaryGeneratorConfiguration.TaintCondition.TaintOnImplicit) && config.getImplicitFlowMode().trackControlFlowDependencies())) {
                        taints.add(taintedPath.deriveNewAbstraction(this.manager.getAccessPathFactory().createAccessPath(defStmt.getLeftOp(), false), stmt));
                    }
                }
                return taints;
            }
        }
        return null;
    }

    private Abstraction getContinuation(Abstraction source, AccessPath accessPath, GapDefinition gap, Stmt stmt) {
        Abstraction newOutAbs = source.clone().deriveNewAbstraction(accessPath, stmt);
        newOutAbs.setPredecessor(null);
        newOutAbs.setSourceContext(new SourceContext((Collection<ISourceSinkDefinition>)null, accessPath, stmt, this.getFlowSource(accessPath, stmt, gap)));
        return newOutAbs;
    }

    private Set<FlowSource> getFlowSource(AccessPath accessPath, Stmt stmt, GapDefinition gap) {
        HashSet<FlowSource> res = new HashSet<FlowSource>();
        if (stmt.getInvokeExpr() instanceof InstanceInvokeExpr && ((InstanceInvokeExpr)stmt.getInvokeExpr()).getBase() == accessPath.getPlainValue()) {
            res.add(new FlowSource(SourceSinkType.Field, accessPath.getBaseType().toString(), gap));
        }
        for (int i = 0; i < stmt.getInvokeExpr().getArgCount(); ++i) {
            if (stmt.getInvokeExpr().getArg(i) != accessPath.getPlainValue()) continue;
            res.add(new FlowSource(SourceSinkType.Parameter, i, accessPath.getBaseType().toString(), gap));
        }
        if (stmt instanceof DefinitionStmt && ((DefinitionStmt)stmt).getLeftOp() == accessPath.getPlainValue()) {
            res.add(new FlowSource(SourceSinkType.Return, accessPath.getBaseType().toString(), gap));
        }
        return res;
    }

    @Override
    public boolean isExclusive(Stmt stmt, Abstraction taintedPath) {
        return this.gapManager.needsGapConstruction(stmt, taintedPath, this.manager.getICFG());
    }

    @Override
    public boolean supportsCallee(SootMethod method) {
        return true;
    }

    @Override
    public boolean supportsCallee(Stmt callSite) {
        Iterator<Edge> edgeIt = Scene.v().getCallGraph().edgesOutOf(callSite);
        return !edgeIt.hasNext();
    }

    @Override
    public int getWrapperHits() {
        return -1;
    }

    @Override
    public int getWrapperMisses() {
        return -1;
    }

    @Override
    public Set<Abstraction> getAliasesForMethod(Stmt stmt, Abstraction d1, Abstraction taintedPath) {
        return null;
    }
}

