/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.data.summary;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import soot.jimple.infoflow.methodSummary.data.summary.ClassMethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.ClassSummaries;

public class SummaryMetaData {
    private final Set<String> exclusiveClasses = new HashSet<String>();
    private final Set<String> exclusivePackages = new HashSet<String>();
    private final Map<String, String> classToSuperclass = new HashMap<String, String>();

    public SummaryMetaData() {
    }

    public SummaryMetaData(SummaryMetaData metaData) {
        if (metaData != null) {
            this.exclusiveClasses.addAll(metaData.exclusiveClasses);
            this.exclusivePackages.addAll(metaData.exclusivePackages);
        }
    }

    public Set<String> getExclusiveClasses() {
        return this.exclusiveClasses;
    }

    public Set<String> getExclusivePackages() {
        return this.exclusivePackages;
    }

    public void merge(SummaryMetaData original) {
        if (original != null) {
            this.exclusiveClasses.addAll(original.exclusiveClasses);
            this.exclusivePackages.addAll(original.exclusivePackages);
        }
    }

    public boolean isClassExclusive(String className) {
        int idx;
        if (this.exclusiveClasses.contains(className)) {
            return true;
        }
        String tempName = className;
        while (!tempName.isEmpty() && (idx = tempName.lastIndexOf(".")) >= 0) {
            if (!this.exclusivePackages.contains(tempName = tempName.substring(0, idx))) continue;
            return true;
        }
        return false;
    }

    public void setSuperclass(String name, String superclass) {
        this.classToSuperclass.put(name, superclass);
    }

    public String getSuperclass(String name) {
        return this.classToSuperclass.get(name);
    }

    public void mergeHierarchyData(ClassSummaries summaries) {
        for (String className : this.classToSuperclass.keySet()) {
            ClassMethodSummaries clazzSummaries = summaries.getOrCreateClassSummaries(className);
            if (clazzSummaries.hasSuperclass()) continue;
            clazzSummaries.setSuperClass(this.classToSuperclass.get(className));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.exclusiveClasses == null ? 0 : this.exclusiveClasses.hashCode());
        result = 31 * result + (this.exclusivePackages == null ? 0 : this.exclusivePackages.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SummaryMetaData other = (SummaryMetaData)obj;
        if (this.exclusiveClasses == null ? other.exclusiveClasses != null : !this.exclusiveClasses.equals(other.exclusiveClasses)) {
            return false;
        }
        return !(this.exclusivePackages == null ? other.exclusivePackages != null : !this.exclusivePackages.equals(other.exclusivePackages));
    }
}

