/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.methodSummary.data.provider;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import soot.jimple.infoflow.methodSummary.data.provider.AbstractMethodSummaryProvider;
import soot.jimple.infoflow.methodSummary.data.provider.IMethodSummaryProvider;
import soot.jimple.infoflow.methodSummary.data.summary.ClassMethodSummaries;
import soot.jimple.infoflow.methodSummary.data.summary.ClassSummaries;

public class MergingSummaryProvider
extends AbstractMethodSummaryProvider {
    protected final Collection<IMethodSummaryProvider> innerProviders;
    private ClassSummaries cachedSummaries;

    protected MergingSummaryProvider() {
        this.innerProviders = new HashSet<IMethodSummaryProvider>();
    }

    public MergingSummaryProvider(Collection<IMethodSummaryProvider> innerProviders) {
        this.innerProviders = innerProviders;
    }

    @Override
    public Set<String> getSupportedClasses() {
        HashSet<String> supportedClasses = new HashSet<String>();
        for (IMethodSummaryProvider provider : this.innerProviders) {
            Set<String> curClasses = provider.getSupportedClasses();
            if (curClasses == null || curClasses.isEmpty()) continue;
            supportedClasses.addAll(curClasses);
        }
        return supportedClasses;
    }

    @Override
    public boolean supportsClass(String clazz) {
        for (IMethodSummaryProvider provider : this.innerProviders) {
            if (!provider.supportsClass(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ClassMethodSummaries getMethodFlows(String className, String methodSignature) {
        ClassMethodSummaries summaries = null;
        for (IMethodSummaryProvider provider : this.innerProviders) {
            ClassMethodSummaries providerSummaries = provider.getMethodFlows(className, methodSignature);
            if (providerSummaries == null) continue;
            if (summaries == null) {
                summaries = new ClassMethodSummaries(className);
            }
            summaries.merge(providerSummaries);
        }
        return summaries;
    }

    @Override
    public ClassSummaries getMethodFlows(Set<String> classes, String methodSignature) {
        ClassSummaries summaries = null;
        for (IMethodSummaryProvider provider : this.innerProviders) {
            ClassSummaries providerSummaries = provider.getMethodFlows(classes, methodSignature);
            if (providerSummaries == null) continue;
            if (summaries == null) {
                summaries = this.createClassSummaries();
            }
            summaries.merge(providerSummaries);
        }
        return summaries;
    }

    @Override
    public ClassMethodSummaries getClassFlows(String clazz) {
        ClassMethodSummaries summaries = null;
        for (IMethodSummaryProvider provider : this.innerProviders) {
            ClassMethodSummaries providerSummaries = provider.getClassFlows(clazz);
            if (providerSummaries == null) continue;
            if (summaries == null) {
                summaries = new ClassMethodSummaries(clazz);
            }
            summaries.merge(providerSummaries);
        }
        return summaries;
    }

    @Override
    public boolean mayHaveSummaryForMethod(String subsig) {
        for (IMethodSummaryProvider provider : this.innerProviders) {
            if (!provider.mayHaveSummaryForMethod(subsig)) continue;
            return true;
        }
        return false;
    }

    public Collection<IMethodSummaryProvider> getInnerProviders() {
        return this.innerProviders;
    }

    @Override
    public ClassSummaries getSummaries() {
        ClassSummaries summaries = this.cachedSummaries;
        if (summaries != null) {
            return summaries;
        }
        for (IMethodSummaryProvider provider : this.innerProviders) {
            ClassSummaries providerSummaries = provider.getSummaries();
            if (providerSummaries == null) continue;
            if (summaries == null) {
                summaries = this.createClassSummaries();
            }
            summaries.merge(providerSummaries);
        }
        this.cachedSummaries = summaries;
        return summaries;
    }

    protected ClassSummaries createClassSummaries() {
        return new ClassSummaries();
    }

    @Override
    public boolean isMethodExcluded(String className, String subSignature) {
        for (IMethodSummaryProvider provider : this.innerProviders) {
            if (!provider.isMethodExcluded(className, subSignature)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getAllClassesWithSummaries() {
        HashSet<String> classes = new HashSet<String>();
        for (IMethodSummaryProvider provider : this.innerProviders) {
            Set<String> curClasses = provider.getAllClassesWithSummaries();
            if (curClasses == null || curClasses.isEmpty()) continue;
            classes.addAll(curClasses);
        }
        return classes;
    }
}

