/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.globalTaints;

import heros.solver.PathEdge;
import java.util.HashSet;
import java.util.Set;
import soot.MethodOrMethodContext;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.ValueBox;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.solver.IInfoflowSolver;
import soot.util.queue.QueueReader;

public class GlobalTaintManager {
    private final Set<Abstraction> globalTaintState = new HashSet<Abstraction>();
    private final Set<IInfoflowSolver> solvers;

    public GlobalTaintManager(Set<IInfoflowSolver> solvers) {
        this.solvers = solvers;
    }

    public boolean addToGlobalTaintState(Abstraction abs) {
        if (this.globalTaintState.add(abs) && this.solvers != null && !this.solvers.isEmpty()) {
            MethodOrMethodContext mmoc;
            HashSet<Stmt> injectionPoints = new HashSet<Stmt>();
            QueueReader<MethodOrMethodContext> methodListener = Scene.v().getReachableMethods().listener();
            while (methodListener.hasNext() && (mmoc = methodListener.next()) != null) {
                SootMethod sm = mmoc.method();
                if (sm == null || !sm.isConcrete()) continue;
                for (Unit u : sm.getActiveBody().getUnits()) {
                    if (!(u instanceof Stmt)) continue;
                    Stmt stmt = (Stmt)u;
                    for (ValueBox vb : stmt.getUseBoxes()) {
                        if (!(vb.getValue() instanceof StaticFieldRef)) continue;
                        StaticFieldRef fieldRef = (StaticFieldRef)vb.getValue();
                        if (!abs.getAccessPath().firstFieldMatches(fieldRef.getField())) continue;
                        injectionPoints.add(stmt);
                    }
                }
            }
            if (!injectionPoints.isEmpty()) {
                for (IInfoflowSolver solver : this.solvers) {
                    for (Stmt stmt : injectionPoints) {
                        solver.processEdge(new PathEdge<Unit, Abstraction>((Abstraction)solver.getTabulationProblem().zeroValue(), stmt, abs));
                    }
                }
            }
            return true;
        }
        return false;
    }
}

