/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data;

import java.util.Collection;
import java.util.Collections;
import soot.jimple.Stmt;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;

public class SourceContext
implements Cloneable {
    protected final Collection<ISourceSinkDefinition> definitions;
    protected final AccessPath accessPath;
    protected final Stmt stmt;
    protected final Object userData;
    private int hashCode = 0;

    public SourceContext(ISourceSinkDefinition definition, AccessPath accessPath, Stmt stmt) {
        this(definition, accessPath, stmt, null);
    }

    public SourceContext(ISourceSinkDefinition definition, AccessPath accessPath, Stmt stmt, Object userData) {
        this(Collections.singleton(definition), accessPath, stmt, userData);
    }

    public SourceContext(Collection<ISourceSinkDefinition> definitions, AccessPath accessPath, Stmt stmt) {
        this(definitions, accessPath, stmt, null);
    }

    public SourceContext(Collection<ISourceSinkDefinition> definitions, AccessPath accessPath, Stmt stmt, Object userData) {
        assert (accessPath != null);
        this.definitions = definitions;
        this.accessPath = accessPath;
        this.stmt = stmt;
        this.userData = userData;
    }

    public Collection<ISourceSinkDefinition> getDefinitions() {
        return this.definitions;
    }

    public AccessPath getAccessPath() {
        return this.accessPath;
    }

    public Stmt getStmt() {
        return this.stmt;
    }

    public Object getUserData() {
        return this.userData;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.definitions == null ? 0 : this.definitions.hashCode());
        result = 31 * result + (this.stmt == null ? 0 : this.stmt.hashCode());
        result = 31 * result + (this.accessPath == null ? 0 : this.accessPath.hashCode());
        this.hashCode = result = 31 * result + (this.userData == null ? 0 : this.userData.hashCode());
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SourceContext other = (SourceContext)obj;
        if (this.hashCode != 0 && other.hashCode != 0 && this.hashCode != other.hashCode) {
            return false;
        }
        if (this.definitions == null ? other.definitions != null : !this.definitions.equals(other.definitions)) {
            return false;
        }
        if (this.stmt == null ? other.stmt != null : !this.stmt.equals(other.stmt)) {
            return false;
        }
        if (this.accessPath == null ? other.accessPath != null : !this.accessPath.equals(other.accessPath)) {
            return false;
        }
        return !(this.userData == null ? other.userData != null : !this.userData.equals(other.userData));
    }

    public SourceContext clone() {
        SourceContext sc = new SourceContext(this.definitions, this.accessPath, this.stmt, this.userData);
        assert (sc.equals(this));
        return sc;
    }

    public String toString() {
        return this.accessPath.toString() + (this.stmt == null ? "" : " in " + this.stmt.toString());
    }
}

