/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data;

import java.util.Arrays;
import soot.Local;
import soot.NullType;
import soot.SootField;
import soot.Type;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.Jimple;
import soot.jimple.StaticFieldRef;
import soot.jimple.infoflow.data.AccessPathFragment;

public class AccessPath
implements Cloneable {
    private static AccessPath zeroAccessPath = null;
    private final Local value;
    private final Type baseType;
    private final AccessPathFragment[] fragments;
    private final boolean taintSubFields;
    private final boolean cutOffApproximation;
    private final ArrayTaintType arrayTaintType;
    private final boolean canHaveImmutableAliases;
    private int hashCode = 0;
    private static final AccessPath emptyAccessPath = new AccessPath();

    private AccessPath() {
        this.value = null;
        this.baseType = null;
        this.fragments = null;
        this.taintSubFields = true;
        this.cutOffApproximation = false;
        this.arrayTaintType = ArrayTaintType.ContentsAndLength;
        this.canHaveImmutableAliases = false;
    }

    AccessPath(Local val, SootField[] appendingFields, Type valType, Type[] appendingFieldTypes, boolean taintSubFields, boolean isCutOffApproximation, ArrayTaintType arrayTaintType, boolean canHaveImmutableAliases) {
        this.value = val;
        this.baseType = valType;
        this.fragments = AccessPathFragment.createFragmentArray(appendingFields, appendingFieldTypes);
        this.taintSubFields = taintSubFields;
        this.cutOffApproximation = isCutOffApproximation;
        this.arrayTaintType = arrayTaintType;
        this.canHaveImmutableAliases = canHaveImmutableAliases;
    }

    AccessPath(Local val, Type valType, AccessPathFragment[] fragments, boolean taintSubFields, boolean isCutOffApproximation, ArrayTaintType arrayTaintType, boolean canHaveImmutableAliases) {
        this.value = val;
        this.baseType = valType;
        this.fragments = fragments;
        this.taintSubFields = taintSubFields;
        this.cutOffApproximation = isCutOffApproximation;
        this.arrayTaintType = arrayTaintType;
        this.canHaveImmutableAliases = canHaveImmutableAliases;
    }

    public static boolean canContainValue(Value val) {
        if (val == null) {
            return false;
        }
        return val instanceof Local || val instanceof InstanceFieldRef || val instanceof StaticFieldRef || val instanceof ArrayRef;
    }

    public Local getPlainValue() {
        return this.value;
    }

    public Value getCompleteValue() {
        SootField f = this.getFirstField();
        if (this.value == null) {
            if (f == null) {
                return null;
            }
            return Jimple.v().newStaticFieldRef(f.makeRef());
        }
        if (f == null) {
            return this.value;
        }
        return Jimple.v().newInstanceFieldRef(this.value, f.makeRef());
    }

    public AccessPathFragment getLastFragment() {
        if (this.fragments == null || this.fragments.length == 0) {
            return null;
        }
        return this.fragments[this.fragments.length - 1];
    }

    public AccessPathFragment getFirstFragment() {
        if (this.fragments == null || this.fragments.length == 0) {
            return null;
        }
        return this.fragments[0];
    }

    public SootField getFirstField() {
        if (this.fragments == null || this.fragments.length == 0) {
            return null;
        }
        return this.fragments[0].getField();
    }

    public SootField getLastField() {
        if (this.fragments == null || this.fragments.length == 0) {
            return null;
        }
        return this.fragments[this.fragments.length - 1].getField();
    }

    public Type getFirstFieldType() {
        if (this.fragments == null || this.fragments.length == 0) {
            return null;
        }
        return this.fragments[0].getFieldType();
    }

    public Type getLastFieldType() {
        if (this.fragments == null || this.fragments.length == 0) {
            return this.getBaseType();
        }
        return this.fragments[this.fragments.length - 1].getFieldType();
    }

    public boolean firstFieldMatches(SootField field) {
        if (this.fragments == null || this.fragments.length == 0) {
            return false;
        }
        return field == this.fragments[0].getField();
    }

    public AccessPathFragment[] getFragments() {
        return this.fragments;
    }

    public int getFragmentCount() {
        return this.fragments == null ? 0 : this.fragments.length;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.baseType == null ? 0 : this.baseType.hashCode());
        result = 31 * result + (this.fragments == null ? 0 : Arrays.hashCode(this.fragments));
        result = 31 * result + (this.taintSubFields ? 1 : 0);
        result = 31 * result + this.arrayTaintType.hashCode();
        this.hashCode = result = 31 * result + (this.canHaveImmutableAliases ? 1 : 0);
        return this.hashCode;
    }

    public int getHashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this || super.equals(obj)) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AccessPath other = (AccessPath)obj;
        if (this.hashCode != 0 && other.hashCode != 0 && this.hashCode != other.hashCode) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        if (this.baseType == null ? other.baseType != null : !this.baseType.equals(other.baseType)) {
            return false;
        }
        if (!Arrays.equals(this.fragments, other.fragments)) {
            return false;
        }
        if (this.taintSubFields != other.taintSubFields) {
            return false;
        }
        if (this.arrayTaintType != other.arrayTaintType) {
            return false;
        }
        if (this.canHaveImmutableAliases != other.canHaveImmutableAliases) {
            return false;
        }
        assert (this.hashCode() == obj.hashCode());
        return true;
    }

    public boolean isStaticFieldRef() {
        return this.value == null && this.fragments != null && this.fragments.length > 0;
    }

    public boolean isInstanceFieldRef() {
        return this.value != null && this.fragments != null && this.fragments.length > 0;
    }

    public boolean isFieldRef() {
        return this.fragments != null && this.fragments.length > 0;
    }

    public boolean isLocal() {
        return this.value != null && this.value instanceof Local && (this.fragments == null || this.fragments.length == 0);
    }

    public String toString() {
        String str = "";
        if (this.value != null) {
            str = str + this.value.toString() + "(" + this.baseType + ")";
        }
        if (this.fragments != null && this.fragments.length > 0) {
            for (int i = 0; i < this.fragments.length; ++i) {
                if (this.fragments[i] == null) continue;
                if (!str.isEmpty()) {
                    str = str + " ";
                }
                str = str + this.fragments[i];
            }
        }
        if (this.taintSubFields) {
            str = str + " *";
        }
        if (this.arrayTaintType == ArrayTaintType.ContentsAndLength) {
            str = str + " <+length>";
        } else if (this.arrayTaintType == ArrayTaintType.Length) {
            str = str + " <length>";
        }
        return str;
    }

    public AccessPath clone() {
        if (this == emptyAccessPath) {
            return this;
        }
        AccessPath a = new AccessPath(this.value, this.baseType, this.fragments, this.taintSubFields, this.cutOffApproximation, this.arrayTaintType, this.canHaveImmutableAliases);
        assert (a.equals(this));
        return a;
    }

    public static AccessPath getEmptyAccessPath() {
        return emptyAccessPath;
    }

    public boolean isEmpty() {
        return this.value == null && (this.fragments == null || this.fragments.length == 0);
    }

    public boolean entails(AccessPath a2) {
        if (this.isEmpty() || a2.isEmpty()) {
            return false;
        }
        if (this.value != null && a2.value == null || this.value == null && a2.value != null) {
            return false;
        }
        if (this.value != null && !this.value.equals(a2.value)) {
            return false;
        }
        if (this.fragments != null && a2.fragments != null) {
            if (this.fragments.length > a2.fragments.length) {
                return false;
            }
            for (int i = 0; i < this.fragments.length; ++i) {
                if (this.fragments[i].getField().equals(a2.fragments[i].getField())) continue;
                return false;
            }
        }
        return true;
    }

    public AccessPath dropLastField() {
        AccessPathFragment[] newFragments;
        if (this.fragments == null || this.fragments.length == 0) {
            return this;
        }
        if (this.fragments.length > 1) {
            int newLength = this.fragments.length - 1;
            newFragments = new AccessPathFragment[newLength];
            System.arraycopy(this.fragments, 0, newFragments, 0, newLength);
        } else {
            newFragments = null;
        }
        return new AccessPath(this.value, this.baseType, newFragments, this.taintSubFields, this.cutOffApproximation, this.arrayTaintType, this.canHaveImmutableAliases);
    }

    public Type getBaseType() {
        return this.baseType;
    }

    public boolean getTaintSubFields() {
        return this.taintSubFields;
    }

    public boolean isCutOffApproximation() {
        return this.cutOffApproximation;
    }

    public ArrayTaintType getArrayTaintType() {
        return this.arrayTaintType;
    }

    public boolean startsWith(Value val) {
        if (!AccessPath.canContainValue(val)) {
            return false;
        }
        if (val instanceof Local && this.value == val) {
            return true;
        }
        if (val instanceof StaticFieldRef) {
            return this.value == null && this.getFirstField() == ((StaticFieldRef)val).getField();
        }
        if (val instanceof InstanceFieldRef) {
            InstanceFieldRef iref = (InstanceFieldRef)val;
            return this.value == iref.getBase() && this.getFirstField() == iref.getField();
        }
        return false;
    }

    public boolean getCanHaveImmutableAliases() {
        return this.canHaveImmutableAliases;
    }

    static AccessPath getZeroAccessPath() {
        if (zeroAccessPath == null) {
            zeroAccessPath = new AccessPath(Jimple.v().newLocal("zero", NullType.v()), null, NullType.v(), null, false, false, ArrayTaintType.ContentsAndLength, false);
        }
        return zeroAccessPath;
    }

    public static enum ArrayTaintType {
        Contents,
        Length,
        ContentsAndLength;

    }
}

