/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.source.parsers.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import soot.jimple.infoflow.android.data.AndroidMethod;
import soot.jimple.infoflow.android.data.CategoryDefinition;
import soot.jimple.infoflow.android.source.parsers.xml.ResourceUtils;
import soot.jimple.infoflow.data.AbstractMethodAndClass;
import soot.jimple.infoflow.river.AdditionalFlowCondition;
import soot.jimple.infoflow.sourcesSinks.definitions.AccessPathTuple;
import soot.jimple.infoflow.sourcesSinks.definitions.IAccessPathBasedSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkCategory;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.MethodSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.SourceSinkCondition;
import soot.jimple.infoflow.sourcesSinks.definitions.SourceSinkType;
import soot.util.MultiMap;

public abstract class AbstractXMLSourceSinkParser {
    private static final Logger logger = LoggerFactory.getLogger(AbstractXMLSourceSinkParser.class);
    protected MultiMap<String, ISourceSinkDefinition> sourcesAndSinks;
    protected Set<ISourceSinkDefinition> sources = new HashSet<ISourceSinkDefinition>();
    protected Set<ISourceSinkDefinition> sinks = new HashSet<ISourceSinkDefinition>();
    protected ICategoryFilter categoryFilter = null;
    protected final Map<ISourceSinkCategory, ISourceSinkCategory> categories = new HashMap<ISourceSinkCategory, ISourceSinkCategory>();

    private ISourceSinkCategory getOrMakeCategory(CategoryDefinition.CATEGORY systemCategory, String customCategory, String customDescription) {
        CategoryDefinition keyDef = new CategoryDefinition(systemCategory, customCategory);
        return this.categories.computeIfAbsent(keyDef, d -> new CategoryDefinition(systemCategory, customCategory, customDescription));
    }

    protected void parseInputStream(InputStream stream) {
        SAXParserFactory pf = SAXParserFactory.newInstance();
        try {
            pf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            pf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            pf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            SAXParser parser2 = pf.newSAXParser();
            this.runParse(parser2, stream);
        }
        catch (ParserConfigurationException e) {
            logger.error("Could not parse sources/sinks from stream", e);
        }
        catch (SAXException e) {
            logger.error("Could not parse sources/sinks from stream", e);
        }
        this.buildSourceSinkLists();
    }

    protected abstract void buildSourceSinkLists();

    protected abstract void runParse(SAXParser var1, InputStream var2);

    protected void addSourceSinkDefinition(String signature, IAccessPathBasedSourceSinkDefinition ssd) {
        this.sourcesAndSinks.put(signature, ssd);
    }

    public Set<ISourceSinkDefinition> getSources() {
        return this.sources;
    }

    public Set<ISourceSinkDefinition> getSinks() {
        return this.sinks;
    }

    protected static InputStream getStream(String fileName) throws IOException {
        File f = new File(fileName);
        if (f.exists()) {
            return new FileInputStream(f);
        }
        return ResourceUtils.getResourceStream(fileName);
    }

    public Set<ISourceSinkDefinition> getAllMethods() {
        HashSet<ISourceSinkDefinition> sourcesSinks = new HashSet<ISourceSinkDefinition>(this.sources.size() + this.sinks.size());
        sourcesSinks.addAll(this.sources);
        sourcesSinks.addAll(this.sinks);
        return sourcesSinks;
    }

    protected void addSourceSinkDefinition(String signature, ISourceSinkDefinition ssd) {
        this.sourcesAndSinks.put(signature, ssd);
    }

    protected abstract ISourceSinkDefinition createFieldSourceSinkDefinition(String var1, Set<AccessPathTuple> var2);

    protected abstract ISourceSinkDefinition createFieldSourceSinkDefinition(String var1, Set<AccessPathTuple> var2, Set<SourceSinkCondition> var3);

    protected abstract ISourceSinkDefinition createMethodSourceSinkDefinition(AbstractMethodAndClass var1, Set<AccessPathTuple> var2, Set<AccessPathTuple>[] var3, Set<AccessPathTuple> var4, MethodSourceSinkDefinition.CallType var5, ISourceSinkCategory var6);

    protected abstract ISourceSinkDefinition createMethodSourceSinkDefinition(AbstractMethodAndClass var1, Set<AccessPathTuple> var2, Set<AccessPathTuple>[] var3, Set<AccessPathTuple> var4, MethodSourceSinkDefinition.CallType var5, ISourceSinkCategory var6, Set<SourceSinkCondition> var7);

    protected String parseSignature(Attributes attributes) {
        String signature = attributes.getValue("signature").trim();
        if (signature != null && !signature.isEmpty() && !signature.startsWith("<")) {
            signature = "<" + signature + ">";
        }
        return signature;
    }

    public static interface ICategoryFilter {
        public boolean acceptsCategory(ISourceSinkCategory var1);

        public SourceSinkType filter(ISourceSinkCategory var1, SourceSinkType var2);
    }

    protected class SAXHandler
    extends DefaultHandler {
        protected String methodSignature = null;
        protected String fieldSignature = null;
        protected ISourceSinkCategory category;
        protected boolean isSource;
        protected boolean isSink;
        protected List<String> pathElements;
        protected List<String> pathElementTypes;
        protected int paramIndex;
        protected List<String> paramTypes = new ArrayList<String>();
        protected MethodSourceSinkDefinition.CallType callType;
        protected String accessPathParentElement = "";
        protected String description = "";
        protected Set<AccessPathTuple> baseAPs = new HashSet<AccessPathTuple>();
        protected List<Set<AccessPathTuple>> paramAPs = new ArrayList<Set<AccessPathTuple>>();
        protected Set<AccessPathTuple> returnAPs = new HashSet<AccessPathTuple>();
        protected ICategoryFilter categoryFilter = null;
        private Set<String> signaturesOnPath = new HashSet<String>();
        private Set<String> classNamesOnPath = new HashSet<String>();
        private Set<String> excludedClassNames = new HashSet<String>();
        private Set<SourceSinkCondition> conditions = new HashSet<SourceSinkCondition>();

        public SAXHandler() {
        }

        public SAXHandler(ICategoryFilter categoryFilter) {
            this.categoryFilter = categoryFilter;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String qNameLower;
            switch (qNameLower = qName.toLowerCase()) {
                case "category": {
                    this.handleStarttagCategory(attributes);
                    break;
                }
                case "field": {
                    this.handleStarttagField(attributes);
                    break;
                }
                case "method": {
                    this.handleStarttagMeethod(attributes);
                    break;
                }
                case "accesspath": {
                    this.handleStarttagAccesspath(attributes);
                    break;
                }
                case "base": {
                    this.accessPathParentElement = qNameLower;
                    this.description = attributes.getValue("description");
                    break;
                }
                case "return": {
                    this.accessPathParentElement = qNameLower;
                    this.description = attributes.getValue("description");
                    break;
                }
                case "param": {
                    this.handleStarttagParam(attributes, qNameLower);
                    break;
                }
                case "pathelement": {
                    this.handleStarttagPathelement(attributes);
                    break;
                }
                case "signatureonpath": {
                    this.handleStarttagSignatureOnPath(attributes);
                    break;
                }
                case "classnameonpath": {
                    this.handleStarttagClassNameOnPath(attributes);
                    break;
                }
                case "excludeclassname": {
                    this.handleStarttagExcludeClassName(attributes);
                }
            }
        }

        protected void handleStarttagCategory(Attributes attributes) {
            String strCustomDescription;
            String strSysCategory = attributes.getValue("id").trim();
            String strCustomCategory = attributes.getValue("customId");
            if (strCustomCategory != null && !strCustomCategory.isEmpty()) {
                strCustomCategory = strCustomCategory.trim();
            }
            if ((strCustomDescription = attributes.getValue("description")) != null && !strCustomDescription.isEmpty()) {
                strCustomDescription = strCustomDescription.trim();
            }
            this.category = AbstractXMLSourceSinkParser.this.getOrMakeCategory(CategoryDefinition.CATEGORY.valueOf(strSysCategory), strCustomCategory, strCustomDescription);
            if (this.categoryFilter != null && !this.categoryFilter.acceptsCategory(this.category)) {
                this.category = null;
            }
        }

        protected void handleStarttagField(Attributes attributes) {
            if (this.category != null && attributes != null) {
                this.fieldSignature = this.parseSignature(attributes);
                this.accessPathParentElement = "base";
            }
        }

        protected void handleStarttagMeethod(Attributes attributes) {
            if (this.category != null && attributes != null) {
                this.methodSignature = this.parseSignature(attributes);
                this.callType = MethodSourceSinkDefinition.CallType.MethodCall;
                String strCallType = attributes.getValue("callType");
                if (strCallType != null && !strCallType.isEmpty()) {
                    if ((strCallType = strCallType.trim()).equalsIgnoreCase("MethodCall")) {
                        this.callType = MethodSourceSinkDefinition.CallType.MethodCall;
                    } else if (strCallType.equalsIgnoreCase("Callback")) {
                        this.callType = MethodSourceSinkDefinition.CallType.Callback;
                    }
                }
            }
        }

        protected void handleStarttagAccesspath(Attributes attributes) {
            if (this.methodSignature != null && !this.methodSignature.isEmpty() || this.fieldSignature != null && !this.fieldSignature.isEmpty()) {
                this.pathElements = new ArrayList<String>();
                this.pathElementTypes = new ArrayList<String>();
                if (attributes != null) {
                    String newDesc;
                    String tempStr = attributes.getValue("isSource");
                    if (tempStr != null && !tempStr.isEmpty()) {
                        this.isSource = tempStr.equalsIgnoreCase("true");
                    }
                    if ((tempStr = attributes.getValue("isSink")) != null && !tempStr.isEmpty()) {
                        this.isSink = tempStr.equalsIgnoreCase("true");
                    }
                    if ((newDesc = attributes.getValue("description")) != null && !newDesc.isEmpty()) {
                        this.description = newDesc;
                    }
                }
            }
        }

        protected void handleStarttagParam(Attributes attributes, String qNameLower) {
            if ((this.methodSignature != null || this.fieldSignature != null) && attributes != null) {
                String tempStr = attributes.getValue("index");
                if (tempStr != null && !tempStr.isEmpty()) {
                    this.paramIndex = Integer.parseInt(tempStr);
                }
                if ((tempStr = attributes.getValue("type")) != null && !tempStr.isEmpty()) {
                    this.paramTypes.add(tempStr.trim());
                }
            }
            this.accessPathParentElement = qNameLower;
            this.description = attributes.getValue("description");
        }

        protected void handleStarttagPathelement(Attributes attributes) {
            if (attributes != null) {
                String tempStr = attributes.getValue("field");
                if (tempStr != null && !tempStr.isEmpty()) {
                    this.pathElements.add(tempStr);
                }
                if ((tempStr = attributes.getValue("type")) != null && !tempStr.isEmpty()) {
                    this.pathElementTypes.add(tempStr);
                }
            }
        }

        protected void handleStarttagSignatureOnPath(Attributes attributes) {
            String signature = this.getStringAttribute(attributes, "signature");
            if (signature != null) {
                if (this.signaturesOnPath == null) {
                    this.signaturesOnPath = new HashSet<String>();
                }
                this.signaturesOnPath.add("<" + signature + ">");
            }
        }

        protected void handleStarttagClassNameOnPath(Attributes attributes) {
            String className = this.getStringAttribute(attributes, "className");
            if (className != null) {
                if (this.classNamesOnPath == null) {
                    this.classNamesOnPath = new HashSet<String>();
                }
                this.classNamesOnPath.add(className);
            }
        }

        protected void handleStarttagExcludeClassName(Attributes attributes) {
            String className = this.getStringAttribute(attributes, "className");
            if (className != null) {
                if (this.excludedClassNames == null) {
                    this.excludedClassNames = new HashSet<String>();
                }
                this.excludedClassNames.add(className);
            }
        }

        private String parseSignature(Attributes attributes) {
            String signature = attributes.getValue("signature").trim();
            if (signature != null && !signature.isEmpty() && !signature.startsWith("<")) {
                signature = "<" + signature + ">";
            }
            return signature;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        private String getStringAttribute(Attributes attributes, String name) {
            String value = attributes.getValue(name);
            if (value != null && !value.isEmpty() && !(value = value.trim()).isEmpty()) {
                return value;
            }
            return null;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String qNameLower;
            switch (qNameLower = qName.toLowerCase()) {
                case "category": {
                    this.category = null;
                    break;
                }
                case "method": {
                    this.handleEndtagMethod();
                    break;
                }
                case "field": {
                    this.handleEndtagField();
                    break;
                }
                case "accesspath": {
                    this.handleEndtagAccesspath();
                    break;
                }
                case "base": {
                    this.accessPathParentElement = "";
                    break;
                }
                case "return": {
                    this.accessPathParentElement = "";
                    break;
                }
                case "param": {
                    this.accessPathParentElement = "";
                    this.paramIndex = -1;
                    this.paramTypes.clear();
                    break;
                }
                case "additionalflowcondition": {
                    if (this.classNamesOnPath.isEmpty() && this.signaturesOnPath.isEmpty()) break;
                    AdditionalFlowCondition additionalFlowCondition = new AdditionalFlowCondition(this.classNamesOnPath, this.signaturesOnPath, this.excludedClassNames);
                    this.classNamesOnPath = new HashSet<String>();
                    this.signaturesOnPath = new HashSet<String>();
                    this.excludedClassNames = new HashSet<String>();
                    if (this.conditions == null) {
                        this.conditions = new HashSet<SourceSinkCondition>();
                    }
                    this.conditions.add(additionalFlowCondition);
                    break;
                }
            }
        }

        protected void handleEndtagMethod() {
            if (this.methodSignature == null) {
                return;
            }
            if (!(this.baseAPs.isEmpty() && this.paramAPs.isEmpty() && this.returnAPs.isEmpty())) {
                AndroidMethod tempMeth = AndroidMethod.createFromSignature(this.methodSignature);
                if (tempMeth != null) {
                    ISourceSinkDefinition ssd = AbstractXMLSourceSinkParser.this.createMethodSourceSinkDefinition(tempMeth, this.baseAPs, this.paramAPs.toArray(new Set[this.paramAPs.size()]), this.returnAPs, this.callType, this.category, this.conditions);
                    AbstractXMLSourceSinkParser.this.addSourceSinkDefinition(this.methodSignature, ssd);
                } else {
                    logger.error("Invalid method signature: " + this.methodSignature);
                }
            }
            this.methodSignature = null;
            this.fieldSignature = null;
            this.baseAPs = new HashSet<AccessPathTuple>();
            this.paramAPs = new ArrayList<Set<AccessPathTuple>>();
            this.returnAPs = new HashSet<AccessPathTuple>();
            this.description = null;
            this.conditions = new HashSet<SourceSinkCondition>();
        }

        protected void handleEndtagField() {
            if (!this.baseAPs.isEmpty()) {
                ISourceSinkDefinition ssd = AbstractXMLSourceSinkParser.this.createFieldSourceSinkDefinition(this.fieldSignature, this.baseAPs, this.conditions);
                ssd.setCategory(this.category);
                AbstractXMLSourceSinkParser.this.addSourceSinkDefinition(this.fieldSignature, ssd);
            }
            this.methodSignature = null;
            this.fieldSignature = null;
            this.baseAPs = new HashSet<AccessPathTuple>();
            this.paramAPs = new ArrayList<Set<AccessPathTuple>>();
            this.returnAPs = new HashSet<AccessPathTuple>();
            this.description = null;
        }

        protected void handleEndtagAccesspath() {
            if (this.isSource || this.isSink) {
                if (this.pathElements != null && this.pathElements.isEmpty() && this.pathElementTypes != null && this.pathElementTypes.isEmpty()) {
                    this.pathElements = null;
                    this.pathElementTypes = null;
                }
                if (this.pathElements != null && this.pathElementTypes != null && this.pathElements.size() != this.pathElementTypes.size()) {
                    throw new RuntimeException(String.format("Length mismatch between path elements (%d) and their types (%d)", this.pathElements.size(), this.pathElementTypes.size()));
                }
                if ((this.pathElements == null || this.pathElements.isEmpty()) && this.pathElementTypes != null && !this.pathElementTypes.isEmpty()) {
                    throw new RuntimeException("Got types for path elements, but no elements (i.e., fields)");
                }
                SourceSinkType sstype = SourceSinkType.fromFlags(this.isSink, this.isSource);
                if (this.categoryFilter != null) {
                    sstype = this.categoryFilter.filter(this.category, sstype);
                }
                if (sstype != SourceSinkType.Neither) {
                    AccessPathTuple apt = AccessPathTuple.fromPathElements(this.pathElements, this.pathElementTypes, sstype);
                    if (this.description != null && !this.description.isEmpty()) {
                        apt.setDescription(this.description);
                    }
                    apt = apt.simplify();
                    switch (this.accessPathParentElement) {
                        case "base": {
                            this.baseAPs.add(apt);
                            break;
                        }
                        case "return": {
                            this.returnAPs.add(apt);
                            break;
                        }
                        case "param": {
                            while (this.paramAPs.size() <= this.paramIndex) {
                                this.paramAPs.add(new HashSet());
                            }
                            this.paramAPs.get(this.paramIndex).add(apt);
                        }
                    }
                }
            }
            this.pathElements = null;
            this.pathElementTypes = null;
            this.isSource = false;
            this.isSink = false;
            this.pathElements = null;
            this.pathElementTypes = null;
            this.description = null;
        }
    }
}

