/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.manifest.binary;

import java.util.Map;
import soot.jimple.infoflow.android.axml.AXmlAttribute;
import soot.jimple.infoflow.android.axml.AXmlNode;
import soot.jimple.infoflow.android.manifest.BaseProcessManifest;
import soot.jimple.infoflow.android.manifest.IAndroidComponent;
import soot.jimple.infoflow.util.SystemClassHandler;

public abstract class AbstractBinaryAndroidComponent
implements IAndroidComponent {
    protected final AXmlNode node;
    protected final BaseProcessManifest<?, ?, ?, ?> manifest;
    protected boolean enabled;
    protected boolean exported;

    protected AbstractBinaryAndroidComponent(AXmlNode node, BaseProcessManifest<?, ?, ?, ?> manifest) {
        this.node = node;
        this.manifest = manifest;
        AXmlAttribute<?> attrEnabled = node.getAttribute("enabled");
        this.enabled = attrEnabled == null || !attrEnabled.getValue().equals(Boolean.FALSE);
        this.loadIntentFilters();
        AXmlAttribute<?> attrExported = node.getAttribute("exported");
        this.exported = attrExported == null ? this.getExportedDefault() : !attrExported.getValue().equals(Boolean.FALSE);
    }

    protected void loadIntentFilters() {
    }

    protected boolean getExportedDefault() {
        return false;
    }

    public AXmlNode getAXmlNode() {
        return this.node;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isExported() {
        return this.exported;
    }

    @Override
    public String getNameString() {
        AXmlAttribute<?> attr = this.node.getAttribute("name");
        if (attr != null) {
            return this.manifest.expandClassName((String)attr.getValue());
        }
        for (Map.Entry<String, AXmlAttribute<?>> a : this.node.getAttributes().entrySet()) {
            String name;
            String attrValueName;
            AXmlAttribute<?> attrValue = a.getValue();
            if (attrValue == null || (attrValueName = attrValue.getName()) != null && !attrValueName.isEmpty() || attrValue.getType() != 3 || !this.isValidComponentName(name = (String)attrValue.getValue())) continue;
            String expandedName = this.manifest.expandClassName(name);
            if (SystemClassHandler.v().isClassInSystemPackage(expandedName)) continue;
            return expandedName;
        }
        return null;
    }

    private boolean isValidComponentName(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        if (name.equals("true") || name.equals("false")) {
            return false;
        }
        if (Character.isDigit(name.charAt(0))) {
            return false;
        }
        return name.startsWith(".");
    }
}

