/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.iccta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.Immediate;
import soot.Local;
import soot.LocalGenerator;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jimple.AssignStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.IntConstant;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.infoflow.android.entryPointCreators.components.ActivityEntryPointInfo;
import soot.jimple.infoflow.android.entryPointCreators.components.ComponentEntryPointCollection;
import soot.jimple.infoflow.android.entryPointCreators.components.ServiceEntryPointInfo;
import soot.jimple.infoflow.android.iccta.IccLink;
import soot.jimple.infoflow.entryPointCreators.SimulatedCodeElementTag;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.tagkit.Tag;
import soot.util.HashMultiMap;
import soot.util.MultiMap;
import soot.util.NumberedString;

public class IccRedirectionCreator {
    private static int num = 0;
    private static final Logger logger = LoggerFactory.getLogger(IccRedirectionCreator.class);
    private final RefType INTENT_TYPE = RefType.v("android.content.Intent");
    private final RefType IBINDER_TYPE = RefType.v("android.os.IBinder");
    protected final Map<String, SootMethod> source2RedirectMethod = new HashMap<String, SootMethod>();
    protected final MultiMap<Body, Unit> instrumentedUnits = new HashMultiMap<Body, Unit>();
    protected final SootClass dummyMainClass;
    protected final ComponentEntryPointCollection componentToEntryPoint;
    protected final NumberedString subsigStartActivityForResult;
    protected IRedirectorCallInserted instrumentationCallback = null;

    public IccRedirectionCreator(SootClass dummyMainClass, ComponentEntryPointCollection componentToEntryPoint) {
        this.componentToEntryPoint = componentToEntryPoint;
        this.dummyMainClass = dummyMainClass;
        this.subsigStartActivityForResult = Scene.v().getSubSigNumberer().findOrAdd("void startActivityForResult(android.content.Intent,int)");
    }

    public void redirectToDestination(IccLink link) {
        if (link.getDestinationC().isPhantom()) {
            return;
        }
        if (SystemClassHandler.v().isClassInSystemPackage(link.getFromSM().getDeclaringClass().getName())) {
            return;
        }
        SootMethod redirectSM = this.getRedirectMethod(link);
        if (redirectSM == null) {
            return;
        }
        this.insertRedirectMethodCallAfterIccMethod(link, redirectSM);
    }

    protected SootMethod getRedirectMethod(IccLink link) {
        SootClass instrumentedDestinationSC = link.getDestinationC();
        if (!this.componentToEntryPoint.hasEntryPointForComponent(instrumentedDestinationSC)) {
            return null;
        }
        SootMethod redirectMethod = this.source2RedirectMethod.get(link.toString());
        if (redirectMethod == null) {
            RefType rt;
            Value v;
            RefType rt2;
            InstanceInvokeExpr iiexpr;
            Type tp;
            Value expr;
            String source = link.toString();
            Stmt stmt = (Stmt)link.getFromU();
            if (stmt.containsInvokeExpr() && (stmt.getInvokeExpr().getMethod().getName().equals("startActivityForResult") ? (expr = stmt.getInvokeExprBox().getValue()) instanceof InstanceInvokeExpr && (tp = (iiexpr = (InstanceInvokeExpr)expr).getBase().getType()) instanceof RefType && (redirectMethod = this.generateRedirectMethodForStartActivityForResult((rt2 = (RefType)tp).getSootClass(), instrumentedDestinationSC)) == null : (stmt.getInvokeExpr().getMethod().getName().equals("bindService") ? (v = stmt.getInvokeExpr().getArg(1)).getType() instanceof RefType && (redirectMethod = this.generateRedirectMethodForBindService((rt = (RefType)v.getType()).getSootClass(), instrumentedDestinationSC)) == null : (redirectMethod = this.generateRedirectMethod(instrumentedDestinationSC)) == null))) {
                return null;
            }
            if (redirectMethod == null) {
                throw new RuntimeException("Wrong IccLink [" + link.toString() + "]");
            }
            this.source2RedirectMethod.put(source, redirectMethod);
        }
        return redirectMethod;
    }

    protected SootMethod generateRedirectMethodForStartActivityForResult(SootClass originActivity, SootClass destComp) {
        String newSM_name = "redirector" + num++;
        ArrayList<Type> newSM_parameters = new ArrayList<Type>();
        newSM_parameters.add(originActivity.getType());
        newSM_parameters.add(this.INTENT_TYPE);
        SootMethod newSM = Scene.v().makeSootMethod(newSM_name, newSM_parameters, VoidType.v(), 9);
        this.dummyMainClass.addMethod(newSM);
        JimpleBody b = Jimple.v().newBody(newSM);
        newSM.setActiveBody(b);
        newSM.addTag(SimulatedCodeElementTag.TAG);
        LocalGenerator lg = Scene.v().createLocalGenerator(b);
        Local originActivityParameterLocal = lg.generateLocal((Type)originActivity.getType());
        IdentityStmt originActivityParameterU = Jimple.v().newIdentityStmt(originActivityParameterLocal, Jimple.v().newParameterRef(originActivity.getType(), 0));
        b.getUnits().add(originActivityParameterU);
        Local intentParameterLocal = lg.generateLocal((Type)this.INTENT_TYPE);
        b.getUnits().add(Jimple.v().newIdentityStmt(intentParameterLocal, Jimple.v().newParameterRef(this.INTENT_TYPE, 1)));
        Local componentLocal = lg.generateLocal((Type)destComp.getType());
        ActivityEntryPointInfo entryPointInfo = (ActivityEntryPointInfo)this.componentToEntryPoint.get(destComp);
        SootMethod targetDummyMain = this.componentToEntryPoint.getEntryPoint(destComp);
        if (targetDummyMain == null) {
            throw new RuntimeException(String.format("Destination component %s has no dummy main method", destComp.getName()));
        }
        b.getUnits().add(Jimple.v().newAssignStmt(componentLocal, Jimple.v().newStaticInvokeExpr(targetDummyMain.makeRef(), Collections.singletonList(intentParameterLocal))));
        Local arIntentLocal = lg.generateLocal((Type)this.INTENT_TYPE);
        b.getUnits().add(Jimple.v().newAssignStmt(arIntentLocal, Jimple.v().newInstanceFieldRef(componentLocal, entryPointInfo.getResultIntentField().makeRef())));
        SootMethod method = originActivity.getMethodUnsafe("void onActivityResult(int,int,android.content.Intent)");
        if (method != null) {
            ArrayList<Immediate> args = new ArrayList<Immediate>();
            args.add(IntConstant.v(-1));
            args.add(IntConstant.v(-1));
            args.add(arIntentLocal);
            b.getUnits().add(Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(originActivityParameterLocal, method.makeRef(), args)));
        }
        b.getUnits().add(Jimple.v().newReturnVoidStmt());
        return newSM;
    }

    protected SootMethod generateRedirectMethod(SootClass wrapper) {
        SootMethod targetDummyMain = this.componentToEntryPoint.getEntryPoint(wrapper);
        if (targetDummyMain == null) {
            logger.warn("Destination component {} has no dummy main method", (Object)wrapper.getName());
            return null;
        }
        String newSM_name = "redirector" + num++;
        SootMethod newSM = Scene.v().makeSootMethod(newSM_name, Collections.singletonList(this.INTENT_TYPE), VoidType.v(), 9);
        newSM.addTag(SimulatedCodeElementTag.TAG);
        this.dummyMainClass.addMethod(newSM);
        JimpleBody b = Jimple.v().newBody(newSM);
        newSM.setActiveBody(b);
        LocalGenerator lg = Scene.v().createLocalGenerator(b);
        Local intentParameterLocal = lg.generateLocal((Type)this.INTENT_TYPE);
        b.getUnits().add(Jimple.v().newIdentityStmt(intentParameterLocal, Jimple.v().newParameterRef(this.INTENT_TYPE, 0)));
        b.getUnits().add(Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(targetDummyMain.makeRef(), Collections.singletonList(intentParameterLocal))));
        b.getUnits().add(Jimple.v().newReturnVoidStmt());
        return newSM;
    }

    protected SootMethod generateRedirectMethodForStartActivity(SootClass wrapper) {
        SootMethod targetDummyMain = this.componentToEntryPoint.getEntryPoint(wrapper);
        if (targetDummyMain == null) {
            logger.warn("Destination component {} has no dummy main method", (Object)wrapper.getName());
            return null;
        }
        String newSM_name = "redirector" + num++;
        SootMethod newSM = Scene.v().makeSootMethod(newSM_name, Collections.singletonList(this.INTENT_TYPE), VoidType.v(), 9);
        newSM.addTag(SimulatedCodeElementTag.TAG);
        this.dummyMainClass.addMethod(newSM);
        JimpleBody b = Jimple.v().newBody(newSM);
        newSM.setActiveBody(b);
        LocalGenerator lg = Scene.v().createLocalGenerator(b);
        Local intentParameterLocal = lg.generateLocal((Type)this.INTENT_TYPE);
        b.getUnits().add(Jimple.v().newIdentityStmt(intentParameterLocal, Jimple.v().newParameterRef(this.INTENT_TYPE, 0)));
        b.getUnits().add(Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(targetDummyMain.makeRef(), Collections.singletonList(intentParameterLocal))));
        b.getUnits().add(Jimple.v().newReturnVoidStmt());
        return newSM;
    }

    protected SootMethod generateRedirectMethodForBindService(SootClass serviceConnection, SootClass destComp) {
        ServiceEntryPointInfo entryPointInfo = (ServiceEntryPointInfo)this.componentToEntryPoint.get(destComp);
        if (entryPointInfo == null) {
            logger.warn("Destination component {} has no dummy main method", (Object)destComp.getName());
            return null;
        }
        SootMethod targetDummyMain = entryPointInfo.getEntryPoint();
        if (targetDummyMain == null) {
            logger.warn("Destination component {} has no dummy main method", (Object)destComp.getName());
            return null;
        }
        String newSM_name = "redirector" + num++;
        ArrayList<Type> newSM_parameters = new ArrayList<Type>();
        newSM_parameters.add(serviceConnection.getType());
        newSM_parameters.add(this.INTENT_TYPE);
        SootMethod newSM = Scene.v().makeSootMethod(newSM_name, newSM_parameters, VoidType.v(), 9);
        newSM.addTag(SimulatedCodeElementTag.TAG);
        this.dummyMainClass.addMethod(newSM);
        JimpleBody b = Jimple.v().newBody(newSM);
        newSM.setActiveBody(b);
        LocalGenerator lg = Scene.v().createLocalGenerator(b);
        Local originActivityParameterLocal = lg.generateLocal((Type)serviceConnection.getType());
        b.getUnits().add(Jimple.v().newIdentityStmt(originActivityParameterLocal, Jimple.v().newParameterRef(serviceConnection.getType(), 0)));
        Local intentParameterLocal = lg.generateLocal((Type)this.INTENT_TYPE);
        b.getUnits().add(Jimple.v().newIdentityStmt(intentParameterLocal, Jimple.v().newParameterRef(this.INTENT_TYPE, 1)));
        Local componentLocal = lg.generateLocal((Type)destComp.getType());
        b.getUnits().add(Jimple.v().newAssignStmt(componentLocal, Jimple.v().newStaticInvokeExpr(targetDummyMain.makeRef(), Collections.singletonList(intentParameterLocal))));
        Local ibinderLocal = lg.generateLocal((Type)this.IBINDER_TYPE);
        b.getUnits().add(Jimple.v().newAssignStmt(ibinderLocal, Jimple.v().newInstanceFieldRef(componentLocal, entryPointInfo.getBinderField().makeRef())));
        ArrayList<Type> paramTypes = new ArrayList<Type>();
        paramTypes.add(RefType.v("android.content.ComponentName"));
        paramTypes.add(RefType.v("android.os.IBinder"));
        SootMethod method = serviceConnection.getMethod("onServiceConnected", paramTypes);
        Local iLocal1 = lg.generateLocal((Type)RefType.v("android.content.ComponentName"));
        b.getUnits().add(Jimple.v().newAssignStmt(iLocal1, NullConstant.v()));
        ArrayList<Local> args = new ArrayList<Local>();
        args.add(iLocal1);
        args.add(ibinderLocal);
        SootClass sc = Scene.v().getSootClass(originActivityParameterLocal.getType().toString());
        InstanceInvokeExpr invoke = sc.isInterface() ? Jimple.v().newInterfaceInvokeExpr(originActivityParameterLocal, method.makeRef(), args) : Jimple.v().newVirtualInvokeExpr(originActivityParameterLocal, method.makeRef(), args);
        b.getUnits().add(Jimple.v().newInvokeStmt(invoke));
        b.getUnits().add(Jimple.v().newReturnVoidStmt());
        return newSM;
    }

    protected SootMethod generateRedirectMethodForContentProvider(Stmt iccStmt, SootClass destProvider) {
        SootMethod iccMethod = iccStmt.getInvokeExpr().getMethod();
        String newSM_name = "redirector" + num++;
        SootMethod newSM = Scene.v().makeSootMethod(newSM_name, iccMethod.getParameterTypes(), iccMethod.getReturnType(), 9);
        newSM.addTag(SimulatedCodeElementTag.TAG);
        this.dummyMainClass.addMethod(newSM);
        JimpleBody b = Jimple.v().newBody(newSM);
        newSM.setActiveBody(b);
        LocalGenerator lg = Scene.v().createLocalGenerator(b);
        ArrayList<Local> locals = new ArrayList<Local>();
        for (int i = 0; i < iccMethod.getParameterCount(); ++i) {
            Type type = iccMethod.getParameterType(i);
            Local local = lg.generateLocal(type);
            locals.add(local);
            b.getUnits().add(Jimple.v().newIdentityStmt(local, Jimple.v().newParameterRef(type, i)));
        }
        Local al = lg.generateLocal((Type)destProvider.getType());
        b.getUnits().add(Jimple.v().newAssignStmt(al, Jimple.v().newNewExpr(destProvider.getType())));
        List<Type> parameters = new ArrayList<Type>();
        ArrayList args = new ArrayList();
        SootMethod method = destProvider.getMethod("<init>", parameters, VoidType.v());
        b.getUnits().add(Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(al, method.makeRef(), args)));
        Local rtLocal = lg.generateLocal(iccMethod.getReturnType());
        parameters = iccMethod.getParameterTypes();
        method = destProvider.getMethodByName(iccMethod.getName());
        VirtualInvokeExpr invoke = Jimple.v().newVirtualInvokeExpr(al, method.makeRef(), locals);
        b.getUnits().add(Jimple.v().newAssignStmt(rtLocal, invoke));
        b.getUnits().add(Jimple.v().newReturnStmt(rtLocal));
        return newSM;
    }

    protected void insertRedirectMethodCallAfterIccMethod(IccLink link, SootMethod redirectMethod) {
        Value arg0;
        Stmt fromStmt = (Stmt)link.getFromU();
        if (fromStmt == null || !fromStmt.containsInvokeExpr()) {
            return;
        }
        SootMethod callee = fromStmt.getInvokeExpr().getMethod();
        ArrayList<Value> args = new ArrayList<Value>();
        if (callee.getNumberedSubSignature().equals(this.subsigStartActivityForResult)) {
            InstanceInvokeExpr iiexpr = (InstanceInvokeExpr)fromStmt.getInvokeExpr();
            args.add(iiexpr.getBase());
            args.add(iiexpr.getArg(0));
        } else if (fromStmt.toString().contains("bindService")) {
            arg0 = fromStmt.getInvokeExpr().getArg(0);
            Value arg1 = fromStmt.getInvokeExpr().getArg(1);
            args.add(arg1);
            args.add(arg0);
        } else {
            if (fromStmt.getInvokeExpr().getArgCount() == 0) {
                return;
            }
            arg0 = fromStmt.getInvokeExpr().getArg(0);
            args.add(arg0);
        }
        if (redirectMethod == null) {
            return;
        }
        InvokeStmt redirectCallU = Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(redirectMethod.makeRef(), args));
        Body body = link.getFromSM().retrieveActiveBody();
        UnitPatchingChain units = body.getUnits();
        IccRedirectionCreator.copyTags(link.getFromU(), redirectCallU);
        redirectCallU.addTag(SimulatedCodeElementTag.TAG);
        units.insertAfter(redirectCallU, link.getFromU());
        this.instrumentedUnits.put(body, redirectCallU);
        if (this.instrumentationCallback != null) {
            this.instrumentationCallback.onRedirectorCallInserted(link, redirectCallU, redirectMethod);
        }
        NumberedString subsig = Scene.v().getSubSigNumberer().find("android.content.Intent createChooser(android.content.Intent,java.lang.CharSequence)");
        SootClass clazz = Scene.v().getSootClassUnsafe("android.content.Intent");
        if (subsig != null && clazz != null) {
            Iterator iter = units.snapshotIterator();
            while (iter.hasNext()) {
                InvokeExpr expr;
                SootMethodRef mr;
                Stmt stmt = (Stmt)iter.next();
                if (!stmt.containsInvokeExpr() || !(mr = (expr = stmt.getInvokeExpr()).getMethodRef()).getDeclaringClass().equals(clazz) || !mr.getSubSignature().equals(subsig)) continue;
                List<ValueBox> vbs = stmt.getUseAndDefBoxes();
                AssignStmt assignU = Jimple.v().newAssignStmt(vbs.get(0).getValue(), vbs.get(1).getValue());
                IccRedirectionCreator.copyTags(stmt, assignU);
                assignU.addTag(SimulatedCodeElementTag.TAG);
                units.insertAfter(assignU, stmt);
                this.instrumentedUnits.put(body, assignU);
            }
        }
    }

    protected static void copyTags(Unit from, Unit to) {
        List<Tag> tags = from.getTags();
        for (Tag tag : tags) {
            to.removeTag(tag.getName());
            to.addTag(tag);
        }
    }

    public void undoInstrumentation() {
        for (SootMethod sm : this.source2RedirectMethod.values()) {
            sm.getDeclaringClass().removeMethod(sm);
        }
        for (Body body : this.instrumentedUnits.keySet()) {
            for (Unit u : this.instrumentedUnits.get(body)) {
                body.getUnits().remove(u);
            }
        }
        this.instrumentedUnits.clear();
        this.source2RedirectMethod.clear();
    }

    public void setInstrumentationCallback(IRedirectorCallInserted instrumentationCallback) {
        this.instrumentationCallback = instrumentationCallback;
    }

    public static interface IRedirectorCallInserted {
        public void onRedirectorCallInserted(IccLink var1, Stmt var2, SootMethod var3);
    }
}

