/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.iccta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.Local;
import soot.LocalGenerator;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.Stmt;
import soot.jimple.infoflow.android.entryPointCreators.components.ComponentEntryPointCollection;
import soot.jimple.infoflow.android.iccta.Ic3Provider;
import soot.jimple.infoflow.android.iccta.IccLink;
import soot.jimple.infoflow.android.iccta.IccRedirectionCreator;
import soot.jimple.infoflow.android.iccta.MessageHandler;
import soot.jimple.infoflow.entryPointCreators.SimulatedCodeElementTag;
import soot.jimple.infoflow.handlers.PreAnalysisHandler;
import soot.util.Chain;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public class IccInstrumenter
implements PreAnalysisHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final String iccModel;
    protected final SootClass dummyMainClass;
    protected final ComponentEntryPointCollection componentToEntryPoint;
    protected IccRedirectionCreator redirectionCreator = null;
    protected final SootMethod smMessengerSend;
    protected final SootMethod smSendMessage;
    protected final Set<SootMethod> processedMethods = new HashSet<SootMethod>();
    protected final MultiMap<Body, Unit> instrumentedUnits = new HashMultiMap<Body, Unit>();

    public IccInstrumenter(String iccModel, SootClass dummyMainClass, ComponentEntryPointCollection componentToEntryPoint) {
        this.iccModel = iccModel;
        this.dummyMainClass = dummyMainClass;
        this.componentToEntryPoint = componentToEntryPoint;
        this.smMessengerSend = Scene.v().grabMethod("<android.os.Messenger: void send(android.os.Message)>");
        this.smSendMessage = Scene.v().grabMethod("<android.os.Handler: boolean sendMessage(android.os.Message)>");
    }

    @Override
    public void onBeforeCallgraphConstruction() {
        this.logger.info("[IccTA] Launching IccTA Transformer...");
        this.logger.info("[IccTA] Loading the ICC Model...");
        Ic3Provider provider = new Ic3Provider(this.iccModel);
        List<IccLink> iccLinks = provider.getIccLinks();
        this.logger.info("[IccTA] ...End Loading the ICC Model");
        if (this.redirectionCreator == null) {
            this.redirectionCreator = new IccRedirectionCreator(this.dummyMainClass, this.componentToEntryPoint);
        } else {
            this.redirectionCreator.undoInstrumentation();
        }
        this.logger.info("[IccTA] Lauching ICC Redirection Creation...");
        for (IccLink link : iccLinks) {
            if (link.fromU == null) continue;
            this.redirectionCreator.redirectToDestination(link);
        }
        this.undoInstrumentation();
        this.instrumentMessenger();
        this.processedMethods.clear();
        this.logger.info("[IccTA] ...End ICC Redirection Creation");
    }

    protected void undoInstrumentation() {
        for (Body body : this.instrumentedUnits.keySet()) {
            for (Unit u : this.instrumentedUnits.get(body)) {
                body.getUnits().remove(u);
            }
        }
        this.instrumentedUnits.clear();
    }

    protected void instrumentMessenger() {
        this.logger.info("Launching Messenger Transformer...");
        Chain<SootClass> applicationClasses = Scene.v().getApplicationClasses();
        HashMap appClasses = new HashMap();
        HashMap<String, String> handlerInner = new HashMap<String, String>();
        Iterator<SootClass> iter = applicationClasses.snapshotIterator();
        while (iter.hasNext()) {
            SootClass sootClass = iter.next();
            HashMap<Value, String> handlerClass = new HashMap<Value, String>();
            ArrayList<SootMethod> methodCopyList = new ArrayList<SootMethod>(sootClass.getMethods());
            for (SootMethod sootMethod : methodCopyList) {
                if (!sootMethod.isConcrete()) continue;
                Body body = sootMethod.retrieveActiveBody();
                if (!this.processedMethods.add(sootMethod)) continue;
                Iterator unitIter = body.getUnits().snapshotIterator();
                while (unitIter.hasNext()) {
                    Unit unit = (Unit)unitIter.next();
                    Stmt stmt = (Stmt)unit;
                    if (!stmt.containsFieldRef() || !(stmt.getFieldRef().getType() instanceof RefType) || !((RefType)stmt.getFieldRef().getType()).getSootClass().getName().contains("android.os.Handler")) continue;
                    if (stmt.getUseBoxes().size() > 1) {
                        handlerInner.putIfAbsent(stmt.getFieldRef().getField().getSignature(), stmt.getUseBoxes().get(1).getValue().getType().toString());
                    }
                    handlerClass.put(stmt.getDefBoxes().get(0).getValue(), stmt.getFieldRef().getField().getSignature());
                }
            }
            appClasses.putIfAbsent(sootClass, handlerClass);
        }
        for (SootClass sc : appClasses.keySet()) {
            if (sc == null) continue;
            this.generateSendMessage(sc, (Map)appClasses.get(sc), handlerInner);
        }
    }

    public void generateSendMessage(SootClass sootClass, Map<Value, String> appClasses, Map<String, String> handlerInner) {
        if (appClasses.isEmpty() || handlerInner.isEmpty()) {
            return;
        }
        ArrayList<SootMethod> methodCopyList = new ArrayList<SootMethod>(sootClass.getMethods());
        for (SootMethod sootMethod : methodCopyList) {
            if (!sootMethod.isConcrete()) continue;
            Body body = sootMethod.retrieveActiveBody();
            LocalGenerator lg = Scene.v().createLocalGenerator(body);
            Iterator unitIter = body.getUnits().snapshotIterator();
            block1: while (unitIter.hasNext()) {
                SootMethod callee;
                Unit unit = (Unit)unitIter.next();
                Stmt stmt = (Stmt)unit;
                if (!stmt.containsInvokeExpr() || (callee = stmt.getInvokeExpr().getMethod()) != this.smMessengerSend && callee != this.smSendMessage) continue;
                String hc = appClasses.get(stmt.getInvokeExpr().getUseBoxes().get(1).getValue());
                Set<SootClass> handlers = MessageHandler.v().getAllHandlers();
                for (SootClass handler : handlers) {
                    if (hc == null || handlerInner.get(hc) != handler.getName()) continue;
                    Local handlerLocal = lg.generateLocal((Type)handler.getType());
                    SootMethod hmMethod = handler.getMethod("void handleMessage(android.os.Message)");
                    InvokeStmt callHMU = Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(handlerLocal, hmMethod.makeRef(), stmt.getInvokeExpr().getArg(0)));
                    callHMU.addTag(SimulatedCodeElementTag.TAG);
                    body.getUnits().insertAfter(callHMU, stmt);
                    this.instrumentedUnits.put(body, callHMU);
                    continue block1;
                }
            }
        }
    }

    @Override
    public void onAfterCallgraphConstruction() {
    }
}

