/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.entryPointCreators.components;

import java.util.Collections;
import java.util.List;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.jimple.AssignStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NopStmt;
import soot.jimple.Stmt;
import soot.jimple.infoflow.android.entryPointCreators.AndroidEntryPointConstants;
import soot.jimple.infoflow.android.entryPointCreators.AndroidEntryPointUtils;
import soot.jimple.infoflow.android.entryPointCreators.components.AbstractComponentEntryPointCreator;
import soot.jimple.infoflow.android.entryPointCreators.components.ComponentEntryPointInfo;
import soot.jimple.infoflow.android.entryPointCreators.components.ServiceEntryPointInfo;
import soot.jimple.infoflow.android.manifest.IManifestHandler;
import soot.jimple.infoflow.entryPointCreators.SimulatedCodeElementTag;

public class ServiceEntryPointCreator
extends AbstractComponentEntryPointCreator {
    protected SootField binderField = null;

    public ServiceEntryPointCreator(SootClass component, SootClass applicationClass, IManifestHandler manifest) {
        super(component, applicationClass, manifest);
    }

    @Override
    protected void generateComponentLifecycle() {
        this.searchAndBuildMethod("void onCreate()", this.component, this.thisLocal);
        this.searchAndBuildMethod("void onStart(android.content.Intent,int)", this.component, this.thisLocal);
        NopStmt beforeStartCommand = Jimple.v().newNopStmt();
        NopStmt afterStartCommand = Jimple.v().newNopStmt();
        this.body.getUnits().add(beforeStartCommand);
        this.createIfStmt(afterStartCommand);
        this.searchAndBuildMethod("int onStartCommand(android.content.Intent,int,int)", this.component, this.thisLocal);
        this.createIfStmt(beforeStartCommand);
        this.body.getUnits().add(afterStartCommand);
        NopStmt startWhileStmt = Jimple.v().newNopStmt();
        NopStmt endWhileStmt = Jimple.v().newNopStmt();
        this.body.getUnits().add(startWhileStmt);
        this.createIfStmt(endWhileStmt);
        AndroidEntryPointUtils.ComponentType componentType = this.entryPointUtils.getComponentType(this.component);
        boolean hasAdditionalMethods = false;
        if (componentType == AndroidEntryPointUtils.ComponentType.GCMBaseIntentService) {
            hasAdditionalMethods |= this.createSpecialServiceMethodCalls(AndroidEntryPointConstants.getGCMIntentServiceMethods(), "com.google.android.gcm.GCMBaseIntentService");
        } else if (componentType == AndroidEntryPointUtils.ComponentType.GCMListenerService) {
            hasAdditionalMethods |= this.createSpecialServiceMethodCalls(AndroidEntryPointConstants.getGCMListenerServiceMethods(), "com.google.android.gms.gcm.GcmListenerService");
        } else if (componentType == AndroidEntryPointUtils.ComponentType.HostApduService) {
            hasAdditionalMethods |= this.createSpecialServiceMethodCalls(AndroidEntryPointConstants.getHostApduServiceMethods(), "android.nfc.cardemulation.HostApduService");
        }
        this.addCallbackMethods();
        this.body.getUnits().add(endWhileStmt);
        if (hasAdditionalMethods) {
            this.createIfStmt(startWhileStmt);
        }
        this.searchAndBuildMethod("android.os.IBinder onBind(android.content.Intent)", this.component, this.thisLocal);
        NopStmt beforemethodsStmt = Jimple.v().newNopStmt();
        this.body.getUnits().add(beforemethodsStmt);
        NopStmt startWhile2Stmt = Jimple.v().newNopStmt();
        NopStmt endWhile2Stmt = Jimple.v().newNopStmt();
        this.body.getUnits().add(startWhile2Stmt);
        hasAdditionalMethods = false;
        if (componentType == AndroidEntryPointUtils.ComponentType.GCMBaseIntentService) {
            for (String sig : AndroidEntryPointConstants.getGCMIntentServiceMethods()) {
                SootMethod sm = this.findMethod(this.component, sig);
                if (sm == null || sm.getName().equals("com.google.android.gcm.GCMBaseIntentService") || !this.createPlainMethodCall(this.thisLocal, sm)) continue;
                hasAdditionalMethods = true;
            }
        }
        this.addCallbackMethods();
        this.body.getUnits().add(endWhile2Stmt);
        if (hasAdditionalMethods) {
            this.createIfStmt(startWhile2Stmt);
        }
        NopStmt onDestroyStmt = Jimple.v().newNopStmt();
        this.searchAndBuildMethod("boolean onUnbind(android.content.Intent)", this.component, this.thisLocal);
        this.createIfStmt(onDestroyStmt);
        this.searchAndBuildMethod("void onRebind(android.content.Intent)", this.component, this.thisLocal);
        this.createIfStmt(beforemethodsStmt);
        this.body.getUnits().add(onDestroyStmt);
        this.searchAndBuildMethod("void onDestroy()", this.component, this.thisLocal);
    }

    protected boolean createSpecialServiceMethodCalls(List<String> methodSigs, String parentClass) {
        boolean hasAdditionalMethods = false;
        for (String sig : methodSigs) {
            SootMethod sm = this.findMethod(this.component, sig);
            if (sm == null || sm.getDeclaringClass().getName().equals(parentClass) || !this.createPlainMethodCall(this.thisLocal, sm)) continue;
            hasAdditionalMethods = true;
        }
        return hasAdditionalMethods;
    }

    @Override
    protected void createAdditionalFields() {
        super.createAdditionalFields();
        String fieldName = "ipcIntent";
        int fieldIdx = 0;
        while (this.component.declaresFieldByName(fieldName)) {
            fieldName = "ipcBinder_" + fieldIdx++;
        }
        this.binderField = Scene.v().makeSootField(fieldName, RefType.v("android.os.IBinder"), 1);
        this.component.addField(this.binderField);
    }

    @Override
    protected void createAdditionalMethods() {
        super.createAdditionalMethods();
        this.instrumentOnBind();
        this.createGetIntentMethod();
    }

    private void instrumentOnBind() {
        SootMethod sm = this.component.getMethodUnsafe("android.os.IBinder onBind(android.content.Intent)");
        RefType intentType = RefType.v("android.content.Intent");
        RefType binderType = RefType.v("android.os.IBinder");
        if (sm == null || !sm.hasActiveBody()) {
            if (sm == null) {
                sm = Scene.v().makeSootMethod("onBind", Collections.singletonList(intentType), binderType, 1);
                this.component.addMethod(sm);
                sm.addTag(SimulatedCodeElementTag.TAG);
            }
            JimpleBody b = Jimple.v().newBody(sm);
            sm.setActiveBody(b);
            b.insertIdentityStmts();
            Local thisLocal = b.getThisLocal();
            Local binderLocal = b.getParameterLocal(0);
            b.getUnits().add(Jimple.v().newAssignStmt(Jimple.v().newInstanceFieldRef(thisLocal, this.binderField.makeRef()), binderLocal));
            b.getUnits().add(Jimple.v().newReturnStmt(binderLocal));
        } else {
            JimpleBody b = (JimpleBody)sm.getActiveBody();
            Stmt firstNonIdentityStmt = b.getFirstNonIdentityStmt();
            Local thisLocal = b.getThisLocal();
            Local binderLocal = b.getParameterLocal(0);
            AssignStmt assignStmt = Jimple.v().newAssignStmt(Jimple.v().newInstanceFieldRef(thisLocal, this.binderField.makeRef()), binderLocal);
            assignStmt.addTag(SimulatedCodeElementTag.TAG);
            b.getUnits().insertAfter(assignStmt, firstNonIdentityStmt);
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.component.removeField(this.binderField);
        this.binderField = null;
    }

    @Override
    public ComponentEntryPointInfo getComponentInfo() {
        ServiceEntryPointInfo serviceInfo = new ServiceEntryPointInfo(this.mainMethod);
        serviceInfo.setIntentField(this.intentField);
        serviceInfo.setBinderField(this.binderField);
        return serviceInfo;
    }
}

