/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.entryPointCreators.components;

import heros.TwoElementSet;
import java.util.Collections;
import java.util.List;
import soot.Local;
import soot.RefType;
import soot.SootClass;
import soot.Type;
import soot.jimple.Jimple;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.infoflow.android.entryPointCreators.components.AbstractComponentEntryPointCreator;
import soot.jimple.infoflow.android.manifest.IManifestHandler;

public class FragmentEntryPointCreator
extends AbstractComponentEntryPointCreator {
    public FragmentEntryPointCreator(SootClass component, SootClass applicationClass, IManifestHandler manifest) {
        super(component, applicationClass, manifest);
    }

    @Override
    protected void generateComponentLifecycle() {
        Local lcActivity = this.body.getParameterLocal(this.getDefaultMainMethodParams().size());
        if (!(lcActivity.getType() instanceof RefType)) {
            throw new RuntimeException("Activities must be reference types");
        }
        RefType rtActivity = (RefType)lcActivity.getType();
        SootClass scActivity = rtActivity.getSootClass();
        TwoElementSet<SootClass> classAndFragment = new TwoElementSet<SootClass>(this.component, scActivity);
        NopStmt afterOnAttachFragment = Jimple.v().newNopStmt();
        this.createIfStmt(afterOnAttachFragment);
        this.searchAndBuildMethod("void onAttachFragment(android.app.Fragment)", this.component, this.thisLocal, classAndFragment);
        this.body.getUnits().add(afterOnAttachFragment);
        this.generateFragmentLifecycle(this.component, this.thisLocal, scActivity);
    }

    private void generateFragmentLifecycle(SootClass currentClass, Local classLocal, SootClass activity) {
        Stmt onStartStmt;
        Stmt onActCreatedStmt;
        Stmt onViewCreatedStmt;
        Stmt onCreateViewStmt;
        Stmt onCreateStmt;
        NopStmt endFragmentStmt = Jimple.v().newNopStmt();
        this.createIfStmt(endFragmentStmt);
        Stmt onAttachStmt = this.searchAndBuildMethod("void onAttach(android.app.Activity)", currentClass, classLocal, Collections.singleton(activity));
        if (onAttachStmt == null) {
            onAttachStmt = Jimple.v().newNopStmt();
            this.body.getUnits().add(onAttachStmt);
        }
        if ((onCreateStmt = this.searchAndBuildMethod("void onCreate(android.os.Bundle)", currentClass, classLocal)) == null) {
            onCreateStmt = Jimple.v().newNopStmt();
            this.body.getUnits().add(onCreateStmt);
        }
        if ((onCreateViewStmt = this.searchAndBuildMethod("android.view.View onCreateView(android.view.LayoutInflater,android.view.ViewGroup,android.os.Bundle)", currentClass, classLocal)) == null) {
            onCreateViewStmt = Jimple.v().newNopStmt();
            this.body.getUnits().add(onCreateViewStmt);
        }
        if ((onViewCreatedStmt = this.searchAndBuildMethod("void onViewCreated(android.view.View,android.os.Bundle)", currentClass, classLocal)) == null) {
            onViewCreatedStmt = Jimple.v().newNopStmt();
            this.body.getUnits().add(onViewCreatedStmt);
        }
        if ((onActCreatedStmt = this.searchAndBuildMethod("void onActivityCreated(android.os.Bundle)", currentClass, classLocal)) == null) {
            onActCreatedStmt = Jimple.v().newNopStmt();
            this.body.getUnits().add(onActCreatedStmt);
        }
        if ((onStartStmt = this.searchAndBuildMethod("void onStart()", currentClass, classLocal)) == null) {
            onStartStmt = Jimple.v().newNopStmt();
            this.body.getUnits().add(onStartStmt);
        }
        NopStmt onResumeStmt = Jimple.v().newNopStmt();
        this.body.getUnits().add(onResumeStmt);
        this.searchAndBuildMethod("void onResume()", currentClass, classLocal);
        this.addCallbackMethods();
        this.searchAndBuildMethod("void onPause()", currentClass, classLocal);
        this.createIfStmt(onResumeStmt);
        this.searchAndBuildMethod("void onSaveInstanceState(android.os.Bundle)", currentClass, classLocal);
        this.searchAndBuildMethod("void onStop()", currentClass, classLocal);
        this.createIfStmt(onCreateViewStmt);
        this.createIfStmt(onStartStmt);
        this.searchAndBuildMethod("void onDestroyView()", currentClass, classLocal);
        this.createIfStmt(onCreateViewStmt);
        this.searchAndBuildMethod("void onDestroy()", currentClass, classLocal);
        this.searchAndBuildMethod("void onDetach()", currentClass, classLocal);
        this.createIfStmt(onAttachStmt);
        this.body.getUnits().add(Jimple.v().newAssignStmt(classLocal, NullConstant.v()));
        this.body.getUnits().add(endFragmentStmt);
    }

    @Override
    protected List<Type> getAdditionalMainMethodParams() {
        return Collections.singletonList(RefType.v("android.app.Activity"));
    }
}

