/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.entryPointCreators.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.jimple.infoflow.android.entryPointCreators.components.ComponentEntryPointInfo;

public class ComponentEntryPointCollection {
    protected Map<SootClass, ComponentEntryPointInfo> componentToEntryPointInfo = new HashMap<SootClass, ComponentEntryPointInfo>();

    public void put(SootClass component, ComponentEntryPointInfo info) {
        this.componentToEntryPointInfo.put(component, info);
    }

    public void put(SootClass component, SootMethod lifecycleMethod) {
        this.componentToEntryPointInfo.put(component, new ComponentEntryPointInfo(lifecycleMethod));
    }

    public ComponentEntryPointInfo get(SootClass component) {
        return this.componentToEntryPointInfo.get(component);
    }

    public Collection<SootMethod> getLifecycleMethods() {
        ArrayList<SootMethod> list = new ArrayList<SootMethod>();
        for (ComponentEntryPointInfo info : this.componentToEntryPointInfo.values()) {
            list.add(info.getEntryPoint());
        }
        return list;
    }

    public Collection<SootField> getAdditionalFields() {
        ArrayList<SootField> list = new ArrayList<SootField>();
        for (ComponentEntryPointInfo info : this.componentToEntryPointInfo.values()) {
            list.addAll(info.getAdditionalFields());
        }
        return list;
    }

    public SootMethod getEntryPoint(SootClass component) {
        ComponentEntryPointInfo info = this.componentToEntryPointInfo.get(component);
        return info == null ? null : info.getEntryPoint();
    }

    public void clear() {
        this.componentToEntryPointInfo.clear();
    }

    public boolean hasEntryPointForComponent(SootClass component) {
        return this.componentToEntryPointInfo.containsKey(component);
    }
}

