/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.entryPointCreators.components;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.IntType;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.VoidType;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NopStmt;
import soot.jimple.Stmt;
import soot.jimple.infoflow.android.InfoflowAndroidConfiguration;
import soot.jimple.infoflow.android.entryPointCreators.components.AbstractComponentEntryPointCreator;
import soot.jimple.infoflow.android.entryPointCreators.components.ActivityEntryPointInfo;
import soot.jimple.infoflow.android.entryPointCreators.components.ComponentEntryPointInfo;
import soot.jimple.infoflow.android.manifest.IManifestHandler;
import soot.jimple.infoflow.cfg.LibraryClassPatcher;
import soot.jimple.infoflow.entryPointCreators.SimulatedCodeElementTag;
import soot.util.MultiMap;

public class ActivityEntryPointCreator
extends AbstractComponentEntryPointCreator {
    private final MultiMap<SootClass, String> activityLifecycleCallbacks;
    private final Map<SootClass, SootField> callbackClassToField;
    private final Map<SootClass, SootMethod> fragmentToMainMethod;
    protected SootField resultIntentField = null;

    public ActivityEntryPointCreator(SootClass component, SootClass applicationClass, MultiMap<SootClass, String> activityLifecycleCallbacks, Map<SootClass, SootField> callbackClassToField, Map<SootClass, SootMethod> fragmentToMainMethod, IManifestHandler manifest) {
        super(component, applicationClass, manifest);
        this.activityLifecycleCallbacks = activityLifecycleCallbacks;
        this.callbackClassToField = callbackClassToField;
        this.fragmentToMainMethod = fragmentToMainMethod;
    }

    @Override
    protected void generateComponentLifecycle() {
        Set<SootClass> currentClassSet = Collections.singleton(this.component);
        Body body = this.mainMethod.getActiveBody();
        HashSet<SootClass> referenceClasses = new HashSet<SootClass>();
        if (this.applicationClass != null) {
            referenceClasses.add(this.applicationClass);
        }
        if (this.activityLifecycleCallbacks != null) {
            for (SootClass callbackClass : this.activityLifecycleCallbacks.keySet()) {
                referenceClasses.add(callbackClass);
            }
        }
        referenceClasses.add(this.component);
        Local applicationLocal = null;
        if (this.applicationClass != null) {
            applicationLocal = this.generator.generateLocal((Type)RefType.v("android.app.Application"));
            Iterator<SootClass> scApplicationHolder = LibraryClassPatcher.createOrGetApplicationHolder();
            body.getUnits().add(Jimple.v().newAssignStmt(applicationLocal, Jimple.v().newStaticFieldRef(((SootClass)((Object)scApplicationHolder)).getFieldByName("application").makeRef())));
            this.localVarsForClasses.put(this.applicationClass, applicationLocal);
        }
        for (SootClass sootClass : this.callbackClassToField.keySet()) {
            Local local = this.generator.generateLocal((Type)RefType.v(sootClass));
            body.getUnits().add(Jimple.v().newAssignStmt(local, Jimple.v().newStaticFieldRef(this.callbackClassToField.get(sootClass).makeRef())));
            this.localVarsForClasses.put(sootClass, local);
        }
        this.searchAndBuildMethod("void onCreate(android.os.Bundle)", this.component, this.thisLocal);
        for (SootClass sootClass : this.activityLifecycleCallbacks.keySet()) {
            this.searchAndBuildMethod("void onActivityCreated(android.app.Activity,android.os.Bundle)", sootClass, (Local)this.localVarsForClasses.get(sootClass), currentClassSet);
        }
        if (this.fragmentToMainMethod != null && !this.fragmentToMainMethod.isEmpty()) {
            for (SootClass sootClass : this.fragmentToMainMethod.keySet()) {
                SootMethod sootMethod = this.fragmentToMainMethod.get(sootClass);
                ArrayList<Local> args = new ArrayList<Local>();
                args.add(this.intentLocal);
                args.add(this.thisLocal);
                body.getUnits().add(Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(sootMethod.makeRef(), args)));
            }
        }
        Stmt onStartStmt = this.searchAndBuildMethod("void onStart()", this.component, this.thisLocal);
        for (SootClass sootClass : this.activityLifecycleCallbacks.keySet()) {
            Stmt s2 = this.searchAndBuildMethod("void onActivityStarted(android.app.Activity)", sootClass, (Local)this.localVarsForClasses.get(sootClass), currentClassSet);
            if (onStartStmt != null) continue;
            onStartStmt = s2;
        }
        if (onStartStmt == null) {
            onStartStmt = Jimple.v().newNopStmt();
            body.getUnits().add(onStartStmt);
        }
        NopStmt nopStmt = Jimple.v().newNopStmt();
        this.createIfStmt(nopStmt);
        this.searchAndBuildMethod("void onRestoreInstanceState(android.os.Bundle)", this.component, this.thisLocal, currentClassSet);
        body.getUnits().add(nopStmt);
        this.searchAndBuildMethod("void onPostCreate(android.os.Bundle)", this.component, this.thisLocal);
        NopStmt nopStmt2 = Jimple.v().newNopStmt();
        body.getUnits().add(nopStmt2);
        this.searchAndBuildMethod("void onResume()", this.component, this.thisLocal);
        for (SootClass callbackClass : this.activityLifecycleCallbacks.keySet()) {
            this.searchAndBuildMethod("void onActivityResumed(android.app.Activity)", callbackClass, (Local)this.localVarsForClasses.get(callbackClass), currentClassSet);
        }
        this.searchAndBuildMethod("void onPostResume()", this.component, this.thisLocal);
        if (this.callbacks != null && !this.callbacks.isEmpty()) {
            NopStmt nopStmt3 = Jimple.v().newNopStmt();
            NopStmt endWhileStmt = Jimple.v().newNopStmt();
            body.getUnits().add(nopStmt3);
            this.createIfStmt(endWhileStmt);
            this.addCallbackMethods();
            body.getUnits().add(endWhileStmt);
            this.createIfStmt(nopStmt3);
        }
        this.searchAndBuildMethod("void onPause()", this.component, this.thisLocal);
        for (SootClass callbackClass : this.activityLifecycleCallbacks.keySet()) {
            this.searchAndBuildMethod("void onActivityPaused(android.app.Activity)", callbackClass, (Local)this.localVarsForClasses.get(callbackClass), currentClassSet);
        }
        this.searchAndBuildMethod("java.lang.CharSequence onCreateDescription()", this.component, this.thisLocal);
        this.searchAndBuildMethod("void onSaveInstanceState(android.os.Bundle)", this.component, this.thisLocal);
        for (SootClass callbackClass : this.activityLifecycleCallbacks.keySet()) {
            this.searchAndBuildMethod("void onActivitySaveInstanceState(android.app.Activity,android.os.Bundle)", callbackClass, (Local)this.localVarsForClasses.get(callbackClass), currentClassSet);
        }
        this.createIfStmt(nopStmt2);
        Stmt stmt = this.searchAndBuildMethod("void onStop()", this.component, this.thisLocal);
        boolean hasAppOnStop = false;
        for (SootClass callbackClass : this.activityLifecycleCallbacks.keySet()) {
            Stmt onActStoppedStmt = this.searchAndBuildMethod("void onActivityStopped(android.app.Activity)", callbackClass, (Local)this.localVarsForClasses.get(callbackClass), currentClassSet);
            hasAppOnStop |= onActStoppedStmt != null;
        }
        if (hasAppOnStop && stmt != null) {
            this.createIfStmt(stmt);
        }
        NopStmt stopToDestroyStmt = Jimple.v().newNopStmt();
        this.createIfStmt(stopToDestroyStmt);
        this.searchAndBuildMethod("void onRestart()", this.component, this.thisLocal);
        body.getUnits().add(Jimple.v().newGotoStmt(onStartStmt));
        body.getUnits().add(stopToDestroyStmt);
        this.searchAndBuildMethod("void onDestroy()", this.component, this.thisLocal);
        for (SootClass callbackClass : this.activityLifecycleCallbacks.keySet()) {
            this.searchAndBuildMethod("void onActivityDestroyed(android.app.Activity)", callbackClass, (Local)this.localVarsForClasses.get(callbackClass), currentClassSet);
        }
    }

    @Override
    protected void createAdditionalFields() {
        super.createAdditionalFields();
        String fieldName = "ipcResultIntent";
        int fieldIdx = 0;
        while (this.component.declaresFieldByName(fieldName)) {
            fieldName = "ipcResultIntent_" + fieldIdx++;
        }
        this.resultIntentField = Scene.v().makeSootField(fieldName, RefType.v("android.content.Intent"), 1);
        this.resultIntentField.addTag(SimulatedCodeElementTag.TAG);
        this.component.addField(this.resultIntentField);
    }

    @Override
    protected void createAdditionalMethods() {
        if (InfoflowAndroidConfiguration.getCreateActivityEntryMethods()) {
            this.createGetIntentMethod();
            this.createSetIntentMethod();
            this.createSetResultMethod();
        }
    }

    private void createSetIntentMethod() {
        if (this.component.declaresMethod("void setIntent(android.content.Intent)")) {
            return;
        }
        RefType intentType = RefType.v("android.content.Intent");
        SootMethod sm = Scene.v().makeSootMethod("setIntent", Collections.singletonList(intentType), VoidType.v(), 1);
        this.component.addMethod(sm);
        sm.addTag(SimulatedCodeElementTag.TAG);
        JimpleBody b = Jimple.v().newBody(sm);
        sm.setActiveBody(b);
        b.insertIdentityStmts();
        Local lcIntent = b.getParameterLocal(0);
        b.getUnits().add(Jimple.v().newAssignStmt(Jimple.v().newInstanceFieldRef(b.getThisLocal(), this.intentField.makeRef()), lcIntent));
        b.getUnits().add(Jimple.v().newReturnVoidStmt());
    }

    private void createSetResultMethod() {
        if (this.component.declaresMethod("void setResult(int,android.content.Intent)")) {
            return;
        }
        RefType intentType = RefType.v("android.content.Intent");
        ArrayList<Type> params = new ArrayList<Type>();
        params.add(IntType.v());
        params.add(intentType);
        SootMethod sm = Scene.v().makeSootMethod("setResult", params, VoidType.v(), 1);
        this.component.addMethod(sm);
        sm.addTag(SimulatedCodeElementTag.TAG);
        JimpleBody b = Jimple.v().newBody(sm);
        sm.setActiveBody(b);
        b.insertIdentityStmts();
        Local lcIntent = b.getParameterLocal(1);
        b.getUnits().add(Jimple.v().newAssignStmt(Jimple.v().newInstanceFieldRef(b.getThisLocal(), this.resultIntentField.makeRef()), lcIntent));
        b.getUnits().add(Jimple.v().newReturnVoidStmt());
        SootMethod smSetResult = Scene.v().grabMethod("<android.app.Activity: void setResult(int,android.content.Intent)>");
        if (smSetResult != null && smSetResult.getDeclaringClass().isApplicationClass()) {
            smSetResult.setModifiers(smSetResult.getModifiers() & 0xFFFFFFEF);
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.component.removeField(this.resultIntentField);
        this.resultIntentField = null;
    }

    @Override
    public ComponentEntryPointInfo getComponentInfo() {
        ActivityEntryPointInfo activityInfo = new ActivityEntryPointInfo(this.mainMethod);
        activityInfo.setIntentField(this.intentField);
        activityInfo.setResultIntentField(this.resultIntentField);
        return activityInfo;
    }
}

