/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.data.parsers;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import soot.jimple.infoflow.android.data.AndroidMethod;
import soot.jimple.infoflow.android.data.CategoryDefinition;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinitionProvider;
import soot.jimple.infoflow.sourcesSinks.definitions.MethodSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.SourceSinkType;

public class PScoutPermissionMethodParser
implements ISourceSinkDefinitionProvider {
    private static final int INITIAL_SET_SIZE = 10000;
    private Set<ISourceSinkDefinition> sourceList = null;
    private Set<ISourceSinkDefinition> sinkList = null;
    private Set<ISourceSinkDefinition> neitherList = null;
    private Map<String, CategoryDefinition> categories = new HashMap<String, CategoryDefinition>();
    private String fileName;
    private final String regex = "^<(.+):\\s*(.+)\\s+(.+)\\s*\\((.*)\\)>.+?(->.+)?$";
    private final boolean SET_IMPLICIT_SOURCE_TO_SOURCE = false;
    private final boolean SET_INDIRECT_SINK_TO_SINK = false;
    private Reader reader;

    public PScoutPermissionMethodParser(String filename) {
        this.fileName = filename;
        this.initializeCategoryMap();
    }

    public PScoutPermissionMethodParser(Reader reader) {
        this.reader = reader;
        this.initializeCategoryMap();
    }

    private void initializeCategoryMap() {
        this.categories.put("_NO_CATEGORY_", new CategoryDefinition(CategoryDefinition.CATEGORY.NO_CATEGORY));
        this.categories.put("_HARDWARE_INFO_", new CategoryDefinition(CategoryDefinition.CATEGORY.HARDWARE_INFO));
        this.categories.put("_NFC_", new CategoryDefinition(CategoryDefinition.CATEGORY.NFC));
        this.categories.put("_PHONE_CONNECTION_", new CategoryDefinition(CategoryDefinition.CATEGORY.PHONE_CONNECTION));
        this.categories.put("_INTER_APP_COMMUNICATION_", new CategoryDefinition(CategoryDefinition.CATEGORY.INTER_APP_COMMUNICATION));
        this.categories.put("_VOIP_", new CategoryDefinition(CategoryDefinition.CATEGORY.VOIP));
        this.categories.put("_CONTACT_INFORMATION_", new CategoryDefinition(CategoryDefinition.CATEGORY.CONTACT_INFORMATION));
        this.categories.put("_UNIQUE_IDENTIFIER_", new CategoryDefinition(CategoryDefinition.CATEGORY.UNIQUE_IDENTIFIER));
        this.categories.put("_PHONE_STATE_", new CategoryDefinition(CategoryDefinition.CATEGORY.PHONE_STATE));
        this.categories.put("_SYSTEM_SETTINGS_", new CategoryDefinition(CategoryDefinition.CATEGORY.SYSTEM_SETTINGS));
        this.categories.put("_LOCATION_INFORMATION_", new CategoryDefinition(CategoryDefinition.CATEGORY.LOCATION_INFORMATION));
        this.categories.put("_NETWORK_INFORMATION_", new CategoryDefinition(CategoryDefinition.CATEGORY.NETWORK_INFORMATION));
        this.categories.put("_EMAIL_", new CategoryDefinition(CategoryDefinition.CATEGORY.EMAIL));
        this.categories.put("_SMS_MMS_", new CategoryDefinition(CategoryDefinition.CATEGORY.SMS_MMS));
        this.categories.put("_CALENDAR_INFORMATION_", new CategoryDefinition(CategoryDefinition.CATEGORY.CALENDAR_INFORMATION));
        this.categories.put("_ACCOUNT_INFORMATION_", new CategoryDefinition(CategoryDefinition.CATEGORY.ACCOUNT_INFORMATION));
        this.categories.put("_BLUETOOTH_", new CategoryDefinition(CategoryDefinition.CATEGORY.BLUETOOTH));
        this.categories.put("_ACCOUNT_SETTINGS_", new CategoryDefinition(CategoryDefinition.CATEGORY.ACCOUNT_SETTINGS));
        this.categories.put("_VIDEO_", new CategoryDefinition(CategoryDefinition.CATEGORY.VIDEO));
        this.categories.put("_AUDIO_", new CategoryDefinition(CategoryDefinition.CATEGORY.AUDIO));
        this.categories.put("_SYNCHRONIZATION_DATA_", new CategoryDefinition(CategoryDefinition.CATEGORY.SYNCHRONIZATION_DATA));
        this.categories.put("_NETWORK_", new CategoryDefinition(CategoryDefinition.CATEGORY.NETWORK));
        this.categories.put("_EMAIL_SETTINGS_", new CategoryDefinition(CategoryDefinition.CATEGORY.EMAIL_SETTINGS));
        this.categories.put("_EMAIL_INFORMATION_", new CategoryDefinition(CategoryDefinition.CATEGORY.EMAIL_INFORMATION));
        this.categories.put("_IMAGE_", new CategoryDefinition(CategoryDefinition.CATEGORY.IMAGE));
        this.categories.put("_FILE_INFORMATION_", new CategoryDefinition(CategoryDefinition.CATEGORY.FILE_INFORMATION));
        this.categories.put("_BLUETOOTH_INFORMATION_", new CategoryDefinition(CategoryDefinition.CATEGORY.BLUETOOTH_INFORMATION));
        this.categories.put("_BROWSER_INFORMATION_", new CategoryDefinition(CategoryDefinition.CATEGORY.BROWSER_INFORMATION));
        this.categories.put("_FILE_", new CategoryDefinition(CategoryDefinition.CATEGORY.FILE));
        this.categories.put("_VOIP_INFORMATION_", new CategoryDefinition(CategoryDefinition.CATEGORY.VOIP_INFORMATION));
        this.categories.put("_DATABASE_INFORMATION_", new CategoryDefinition(CategoryDefinition.CATEGORY.DATABASE_INFORMATION));
        this.categories.put("_PHONE_INFORMATION_", new CategoryDefinition(CategoryDefinition.CATEGORY.PHONE_INFORMATION));
        this.categories.put("_LOG_", new CategoryDefinition(CategoryDefinition.CATEGORY.LOG));
    }

    private void parse() {
        this.sourceList = new HashSet<ISourceSinkDefinition>(10000);
        this.sinkList = new HashSet<ISourceSinkDefinition>(10000);
        this.neitherList = new HashSet<ISourceSinkDefinition>(10000);
        BufferedReader rdr = this.readFile();
        String line = null;
        Pattern p = Pattern.compile("^<(.+):\\s*(.+)\\s+(.+)\\s*\\((.*)\\)>.+?(->.+)?$");
        String currentPermission = null;
        try {
            while ((line = rdr.readLine()) != null) {
                if (line.startsWith("Permission:")) {
                    currentPermission = line.substring(11);
                    continue;
                }
                Matcher m4 = p.matcher(line);
                if (!m4.find()) continue;
                this.parseMethod(m4, currentPermission);
            }
            if (rdr != null) {
                rdr.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void addToList(Set<ISourceSinkDefinition> sourceList, MethodSourceSinkDefinition def, String currentPermission) {
        if (!sourceList.add(def)) {
            for (ISourceSinkDefinition ssdef : sourceList) {
                if (!(ssdef instanceof MethodSourceSinkDefinition)) continue;
                MethodSourceSinkDefinition mssdef = (MethodSourceSinkDefinition)ssdef;
                SootMethodAndClass singleMethod = def.getMethod();
                if (!(singleMethod instanceof AndroidMethod) || !mssdef.getMethod().equals(singleMethod)) continue;
                ((AndroidMethod)singleMethod).addPermission(currentPermission);
                break;
            }
        }
    }

    public Set<ISourceSinkDefinition> getSources() {
        if (this.sourceList == null || this.sinkList == null) {
            this.parse();
        }
        return this.sourceList;
    }

    public Set<ISourceSinkDefinition> getSinks() {
        if (this.sourceList == null || this.sinkList == null) {
            this.parse();
        }
        return this.sinkList;
    }

    private BufferedReader readFile() {
        Reader r = null;
        BufferedReader br = null;
        try {
            r = this.reader != null ? this.reader : new FileReader(this.fileName);
            br = new BufferedReader(r);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        return br;
    }

    private MethodSourceSinkDefinition parseMethod(Matcher m4, String currentPermission) {
        String params;
        assert (m4.group(1) != null && m4.group(2) != null && m4.group(3) != null && m4.group(4) != null);
        int groupIdx = 1;
        String className = m4.group(groupIdx++).trim();
        String returnType = m4.group(groupIdx++).trim();
        String methodName = m4.group(groupIdx++).trim();
        ArrayList<String> methodParameters = new ArrayList<String>();
        if (!(params = m4.group(groupIdx++).trim()).isEmpty()) {
            for (String parameter : params.split(",")) {
                methodParameters.add(parameter.trim());
            }
        }
        HashSet<String> permissions = null;
        if (currentPermission != null) {
            permissions = new HashSet<String>();
            permissions.add(currentPermission);
        }
        AndroidMethod singleMethod = new AndroidMethod(methodName, methodParameters, returnType, className, permissions);
        MethodSourceSinkDefinition sourceSinkDef = new MethodSourceSinkDefinition(singleMethod);
        if (m4.group(5) != null) {
            String targets = m4.group(5).substring(3);
            for (String target : targets.split(" ")) {
                String cat;
                if (target.startsWith("_SOURCE_")) {
                    singleMethod.setSourceSinkType(SourceSinkType.Source);
                    if (!target.contains("|")) continue;
                    cat = target.substring(target.indexOf(124) + 1);
                    sourceSinkDef.setCategory(this.returnCorrectCategory(cat));
                    continue;
                }
                if (target.startsWith("_SINK_")) {
                    singleMethod.setSourceSinkType(SourceSinkType.Sink);
                    if (!target.contains("|")) continue;
                    cat = target.substring(target.indexOf(124) + 1);
                    sourceSinkDef.setCategory(this.returnCorrectCategory(cat));
                    continue;
                }
                if (target.equals("_NONE_")) {
                    singleMethod.setSourceSinkType(SourceSinkType.Neither);
                    continue;
                }
                if (target.startsWith("_IMPSOURCE_")) {
                    singleMethod.setSourceSinkType(SourceSinkType.Neither);
                    continue;
                }
                if (target.startsWith("_INDSINK_")) {
                    singleMethod.setSourceSinkType(SourceSinkType.Neither);
                    continue;
                }
                if (target.equals("_IGNORE_")) {
                    return null;
                }
                if (target.startsWith("-")) {
                    cat = target.substring(target.indexOf(124) + 1);
                    sourceSinkDef.setCategory(this.returnCorrectCategory(cat));
                    continue;
                }
                throw new RuntimeException("error in target definition");
            }
        }
        if (singleMethod != null) {
            if (singleMethod.getSourceSinkType().isSource()) {
                this.addToList(this.sourceList, sourceSinkDef, currentPermission);
            } else if (singleMethod.getSourceSinkType().isSink()) {
                this.addToList(this.sinkList, sourceSinkDef, currentPermission);
            } else if (singleMethod.getSourceSinkType() == SourceSinkType.Neither) {
                this.addToList(this.neitherList, sourceSinkDef, currentPermission);
            }
        }
        return sourceSinkDef;
    }

    private CategoryDefinition returnCorrectCategory(String category) {
        CategoryDefinition def = this.categories.get(category);
        if (def == null) {
            throw new RuntimeException("The category -" + category + "- is not supported!");
        }
        return def;
    }

    public Set<ISourceSinkDefinition> getAllMethods() {
        if (this.sourceList == null || this.sinkList == null) {
            this.parse();
        }
        HashSet<ISourceSinkDefinition> sourcesSinks = new HashSet<ISourceSinkDefinition>(this.sourceList.size() + this.sinkList.size() + this.neitherList.size());
        sourcesSinks.addAll(this.sourceList);
        sourcesSinks.addAll(this.sinkList);
        sourcesSinks.addAll(this.neitherList);
        return sourcesSinks;
    }
}

