/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.data.parsers;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import soot.jimple.infoflow.android.data.AndroidMethod;
import soot.jimple.infoflow.android.data.CategoryDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.MethodSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.SourceSinkType;

public class CategorizedAndroidSourceSinkParser {
    private Set<CategoryDefinition> categories;
    private final String fileName;
    private SourceSinkType sourceSinkType;
    private final String regex = "^<(.+):\\s*(.+)\\s+(.+)\\s*\\((.*)\\)>.+?\\((.+)\\)$";

    public CategorizedAndroidSourceSinkParser(Set<CategoryDefinition> categories, String filename, SourceSinkType sourceSinkType) {
        this.categories = categories;
        this.fileName = filename;
        this.sourceSinkType = sourceSinkType;
    }

    public Set<ISourceSinkDefinition> parse() throws IOException {
        HashSet<ISourceSinkDefinition> definitions = new HashSet<ISourceSinkDefinition>();
        CategoryDefinition allCats = new CategoryDefinition(CategoryDefinition.CATEGORY.ALL);
        boolean loadAllCategories = this.categories.contains(allCats);
        BufferedReader rdr = this.readFile();
        if (rdr == null) {
            throw new RuntimeException("Could not read source/sink file");
        }
        String line = null;
        Pattern p = Pattern.compile("^<(.+):\\s*(.+)\\s+(.+)\\s*\\((.*)\\)>.+?\\((.+)\\)$");
        while ((line = rdr.readLine()) != null) {
            Matcher m4 = p.matcher(line);
            if (!m4.find()) continue;
            CategoryDefinition.CATEGORY strCat = CategoryDefinition.CATEGORY.valueOf(m4.group(5));
            CategoryDefinition cat = new CategoryDefinition(strCat);
            if (!loadAllCategories && !this.categories.contains(cat)) continue;
            AndroidMethod method = this.parseMethod(m4);
            method.setSourceSinkType(this.sourceSinkType);
            MethodSourceSinkDefinition def = new MethodSourceSinkDefinition(method);
            def.setCategory(cat);
            definitions.add(def);
        }
        try {
            if (rdr != null) {
                rdr.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return definitions;
    }

    private BufferedReader readFile() {
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(this.fileName);
            br = new BufferedReader(fr);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        return br;
    }

    private AndroidMethod parseMethod(Matcher m4) {
        String params;
        assert (m4.group(1) != null && m4.group(2) != null && m4.group(3) != null && m4.group(4) != null);
        int groupIdx = 1;
        String className = m4.group(groupIdx++).trim();
        String returnType = m4.group(groupIdx++).trim();
        String methodName = m4.group(groupIdx++).trim();
        ArrayList<String> methodParameters = new ArrayList<String>();
        if (!(params = m4.group(groupIdx++).trim()).isEmpty()) {
            for (String parameter : params.split(",")) {
                methodParameters.add(parameter.trim());
            }
        }
        return new AndroidMethod(methodName, methodParameters, returnType, className);
    }
}

