/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.data.parsers;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.infoflow.android.data.AndroidMethod;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinitionProvider;
import soot.jimple.infoflow.sourcesSinks.definitions.MethodSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.SourceSinkType;

public class CSVPermissionMethodParser
implements ISourceSinkDefinitionProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Set<ISourceSinkDefinition> sourceList = null;
    private Set<ISourceSinkDefinition> sinkList = null;
    private Set<ISourceSinkDefinition> neitherList = null;
    private static final int INITIAL_SET_SIZE = 10000;
    private final String fileName;

    public CSVPermissionMethodParser(String fileName) {
        this.fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() {
        this.sourceList = new HashSet<ISourceSinkDefinition>(10000);
        this.sinkList = new HashSet<ISourceSinkDefinition>(10000);
        this.neitherList = new HashSet<ISourceSinkDefinition>(10000);
        BufferedReader rdr = null;
        try {
            rdr = new BufferedReader(new FileReader(this.fileName));
            String line = null;
            boolean firstLine = true;
            while ((line = rdr.readLine()) != null) {
                String className;
                String methodName;
                if (firstLine) {
                    firstLine = false;
                    continue;
                }
                firstLine = false;
                String[] fields = line.split("\t");
                if (fields.length < 1) {
                    this.logger.warn("Found invalid line: %s", (Object)line);
                    continue;
                }
                ArrayList<String> methodParams = new ArrayList<String>();
                HashSet<String> permissions = new HashSet<String>();
                try {
                    methodName = fields[0].contains(")") ? fields[0].substring(0, fields[0].indexOf("(")) : fields[0];
                    className = methodName.substring(0, methodName.lastIndexOf("."));
                    methodName = methodName.substring(methodName.lastIndexOf(".") + 1);
                    if (fields[0].contains("(")) {
                        String parameters = fields[0].substring(fields[0].indexOf("(") + 1);
                        parameters = parameters.substring(0, parameters.indexOf(")"));
                        for (String p : parameters.split(",")) {
                            methodParams.add(p);
                        }
                    }
                    String perm = fields.length > 1 ? fields[1] : "";
                    perm = perm.replaceAll(" and ", " ");
                    if ((perm = perm.replaceAll(" or ", " ")).contains(".")) {
                        perm = perm.substring(perm.lastIndexOf(".") + 1);
                    }
                    for (String p : perm.split(" ")) {
                        permissions.add(p);
                    }
                }
                catch (StringIndexOutOfBoundsException ex) {
                    this.logger.warn("Could not parse line: " + line, ex);
                    continue;
                }
                AndroidMethod method = new AndroidMethod(methodName, methodParams, "", className, permissions);
                if (method.getSourceSinkType().isSource()) {
                    this.sourceList.add(new MethodSourceSinkDefinition(method));
                    continue;
                }
                if (method.getSourceSinkType().isSink()) {
                    this.sinkList.add(new MethodSourceSinkDefinition(method));
                    continue;
                }
                if (method.getSourceSinkType() != SourceSinkType.Neither) continue;
                this.neitherList.add(new MethodSourceSinkDefinition(method));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (rdr != null) {
                try {
                    rdr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public Set<ISourceSinkDefinition> getSources() {
        if (this.sourceList == null || this.sinkList == null) {
            this.parse();
        }
        return this.sourceList;
    }

    public Set<ISourceSinkDefinition> getSinks() {
        if (this.sourceList == null || this.sinkList == null) {
            this.parse();
        }
        return this.sinkList;
    }

    public Set<ISourceSinkDefinition> getAllMethods() {
        if (this.sourceList == null || this.sinkList == null) {
            this.parse();
        }
        HashSet<ISourceSinkDefinition> sourcesSinks = new HashSet<ISourceSinkDefinition>(this.sourceList.size() + this.sinkList.size() + this.neitherList.size());
        sourcesSinks.addAll(this.sourceList);
        sourcesSinks.addAll(this.sinkList);
        sourcesSinks.addAll(this.neitherList);
        return sourcesSinks;
    }
}

