/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import soot.SootMethod;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.sourcesSinks.definitions.SourceSinkType;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;

public class AndroidMethod
extends SootMethodAndClass {
    private Set<String> permissions;
    private SourceSinkType sourceSinkType = SourceSinkType.Undefined;

    public AndroidMethod(String methodName, String returnType, String className) {
        super(methodName, className, returnType, new ArrayList<String>());
        this.permissions = null;
    }

    public AndroidMethod(String methodName, List<String> parameters, String returnType, String className) {
        super(methodName, className, returnType, parameters);
        this.permissions = null;
    }

    public AndroidMethod(String methodName, List<String> parameters, String returnType, String className, Set<String> permissions) {
        super(methodName, className, returnType, parameters);
        this.permissions = permissions;
    }

    public AndroidMethod(SootMethod sm) {
        super(sm);
        this.permissions = null;
    }

    public AndroidMethod(SootMethodAndClass methodAndClass) {
        super(methodAndClass);
        this.permissions = null;
    }

    public Set<String> getPermissions() {
        return this.permissions == null ? Collections.emptySet() : this.permissions;
    }

    public void setSourceSinkType(SourceSinkType sourceSinkType) {
        this.sourceSinkType = sourceSinkType;
    }

    public void addPermission(String permission) {
        if (this.permissions == null) {
            this.permissions = new HashSet<String>();
        }
        this.permissions.add(permission);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSignature());
        if (this.permissions != null) {
            for (String perm : this.permissions) {
                sb.append(" ");
                sb.append(perm);
            }
        }
        if (this.sourceSinkType != SourceSinkType.Undefined) {
            sb.append(" ->");
        }
        if (this.sourceSinkType == SourceSinkType.Source) {
            sb.append(" _SOURCE_");
        } else if (this.sourceSinkType == SourceSinkType.Sink) {
            sb.append(" _SINK_ ");
        } else if (this.sourceSinkType == SourceSinkType.Neither) {
            sb.append(" _NONE_");
        } else if (this.sourceSinkType == SourceSinkType.Both) {
            sb.append(" _BOTH_");
        }
        return sb.toString();
    }

    public String getSignatureAndPermissions() {
        String s2 = this.getSignature();
        if (this.permissions != null) {
            for (String perm : this.permissions) {
                s2 = s2 + " " + perm;
            }
        }
        return s2;
    }

    public boolean isAnnotated() {
        return this.sourceSinkType != SourceSinkType.Undefined;
    }

    public SourceSinkType getSourceSinkType() {
        return this.sourceSinkType;
    }

    public static AndroidMethod createFromSignature(String signature) {
        SootMethodAndClass smac;
        if (!signature.startsWith("<")) {
            signature = "<" + signature;
        }
        if (!signature.endsWith(">")) {
            signature = signature + ">";
        }
        if ((smac = SootMethodRepresentationParser.v().parseSootMethodString(signature)) == null) {
            return null;
        }
        return new AndroidMethod(smac.getMethodName(), smac.getParameters(), smac.getReturnType(), smac.getClassName());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.permissions == null ? 0 : this.permissions.hashCode());
        result = 31 * result + (this.sourceSinkType == null ? 0 : this.sourceSinkType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AndroidMethod other = (AndroidMethod)obj;
        if (this.permissions == null ? other.permissions != null : !this.permissions.equals(other.permissions)) {
            return false;
        }
        return this.sourceSinkType == other.sourceSinkType;
    }
}

