/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.callbacks.xml;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.infoflow.android.InfoflowAndroidConfiguration;
import soot.jimple.infoflow.android.callbacks.AndroidCallbackDefinition;
import soot.jimple.infoflow.android.callbacks.xml.CollectedCallbacks;
import soot.util.HashMultiMap;

public class CollectedCallbacksSerializer {
    public static void serialize(CollectedCallbacks callbacks, InfoflowAndroidConfiguration.CallbackConfiguration config) throws IOException {
        Kryo kryo = CollectedCallbacksSerializer.initializeKryo();
        try (Output output = new Output(new FileOutputStream(config.getCallbacksFile()));){
            kryo.writeClassAndObject(output, callbacks);
        }
    }

    public static CollectedCallbacks deserialize(File callbackFile) throws KryoException, FileNotFoundException {
        Kryo kryo = CollectedCallbacksSerializer.initializeKryo();
        try (Input input = new Input(new FileInputStream(callbackFile));){
            CollectedCallbacks collectedCallbacks = (CollectedCallbacks)kryo.readClassAndObject(input);
            return collectedCallbacks;
        }
    }

    public static CollectedCallbacks deserialize(InfoflowAndroidConfiguration.CallbackConfiguration config) throws KryoException, FileNotFoundException {
        return CollectedCallbacksSerializer.deserialize(new File(config.getCallbacksFile()));
    }

    protected static Kryo initializeKryo() {
        Kryo kryo = new Kryo();
        kryo.register(CollectedCallbacks.class);
        kryo.register(AndroidCallbackDefinition.class, new AndroidCallbackDefinitionSerializer());
        kryo.register(AndroidCallbackDefinition.CallbackType.class);
        kryo.register(HashMultiMap.class);
        kryo.register(HashMap.class);
        kryo.register(HashSet.class);
        kryo.register(SootMethod.class, new SootMethodSerializer());
        kryo.register(SootClass.class, new SootClassSerializer());
        return kryo;
    }

    private static class AndroidCallbackDefinitionSerializer
    extends Serializer<AndroidCallbackDefinition> {
        private AndroidCallbackDefinitionSerializer() {
        }

        @Override
        public void write(Kryo kryo, Output output, AndroidCallbackDefinition object) {
            kryo.writeClassAndObject(output, object.getTargetMethod());
            kryo.writeClassAndObject(output, object.getParentMethod());
            kryo.writeClassAndObject(output, (Object)object.getCallbackType());
        }

        @Override
        public AndroidCallbackDefinition read(Kryo kryo, Input input, Class<? extends AndroidCallbackDefinition> type) {
            SootMethod targetMethod = (SootMethod)kryo.readClassAndObject(input);
            SootMethod parentMethod = (SootMethod)kryo.readClassAndObject(input);
            AndroidCallbackDefinition.CallbackType callbackType = (AndroidCallbackDefinition.CallbackType)((Object)kryo.readClassAndObject(input));
            return new AndroidCallbackDefinition(targetMethod, parentMethod, callbackType);
        }
    }

    private static class SootMethodSerializer
    extends Serializer<SootMethod> {
        private SootMethodSerializer() {
        }

        @Override
        public void write(Kryo kryo, Output output, SootMethod object) {
            output.writeString(object.getSignature());
        }

        @Override
        public SootMethod read(Kryo kryo, Input input, Class<? extends SootMethod> type) {
            String sig = input.readString();
            return Scene.v().grabMethod(sig);
        }
    }

    private static class SootClassSerializer
    extends Serializer<SootClass> {
        private SootClassSerializer() {
        }

        @Override
        public void write(Kryo kryo, Output output, SootClass object) {
            output.writeString(object.getName());
        }

        @Override
        public SootClass read(Kryo kryo, Input input, Class<? extends SootClass> type) {
            String className = input.readString();
            return Scene.v().getSootClassUnsafe(className);
        }
    }
}

