/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android.axml.flags;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class BitwiseFlagSystem<T> {
    private List<T> keys = new ArrayList<T>();
    private List<Integer> values = new ArrayList<Integer>();

    public void register(T key, int setBits) {
        this.keys.add(key);
        this.values.add(setBits);
    }

    public final Collection<T> getFlags(int value) {
        ArrayList<T> matchedResults = new ArrayList<T>(4);
        ArrayList<Integer> matchedValues = new ArrayList<Integer>(4);
        for (int i = 0; i < this.keys.size(); ++i) {
            int v = this.values.get(i);
            if ((v & value) != v || BitwiseFlagSystem.hadAnyMatch(v, matchedValues)) continue;
            matchedResults.add(this.keys.get(i));
            matchedValues.add(v);
        }
        return matchedResults;
    }

    private static boolean hadAnyMatch(int value, List<Integer> matchedValues) {
        for (int c : matchedValues) {
            if ((c & value) != value) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public final boolean isSet(int inputValue, T ... flag) {
        ArrayList<T> flagsLeft = new ArrayList<T>(flag.length);
        for (T i : flag) {
            flagsLeft.add(i);
        }
        for (Object t2 : this.getFlags(inputValue)) {
            Iterator it = flagsLeft.iterator();
            while (it.hasNext()) {
                if (!it.next().equals(t2)) continue;
                it.remove();
                if (!flagsLeft.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }
}

