/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.android;

import heros.solver.Pair;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParserException;
import soot.G;
import soot.Main;
import soot.PackManager;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.Stmt;
import soot.jimple.infoflow.AbstractInfoflow;
import soot.jimple.infoflow.BackwardsInfoflow;
import soot.jimple.infoflow.IInfoflow;
import soot.jimple.infoflow.Infoflow;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.android.InfoflowAndroidConfiguration;
import soot.jimple.infoflow.android.callbacks.AbstractCallbackAnalyzer;
import soot.jimple.infoflow.android.callbacks.AndroidCallbackDefinition;
import soot.jimple.infoflow.android.callbacks.DefaultCallbackAnalyzer;
import soot.jimple.infoflow.android.callbacks.FastCallbackAnalyzer;
import soot.jimple.infoflow.android.callbacks.filters.AlienFragmentFilter;
import soot.jimple.infoflow.android.callbacks.filters.AlienHostComponentFilter;
import soot.jimple.infoflow.android.callbacks.filters.ApplicationCallbackFilter;
import soot.jimple.infoflow.android.callbacks.filters.UnreachableConstructorFilter;
import soot.jimple.infoflow.android.callbacks.xml.CollectedCallbacks;
import soot.jimple.infoflow.android.callbacks.xml.CollectedCallbacksSerializer;
import soot.jimple.infoflow.android.config.SootConfigForAndroid;
import soot.jimple.infoflow.android.data.AndroidMemoryManager;
import soot.jimple.infoflow.android.data.AndroidMethod;
import soot.jimple.infoflow.android.data.parsers.PermissionMethodParser;
import soot.jimple.infoflow.android.entryPointCreators.AndroidEntryPointCreator;
import soot.jimple.infoflow.android.entryPointCreators.components.ComponentEntryPointCollection;
import soot.jimple.infoflow.android.iccta.IccInstrumenter;
import soot.jimple.infoflow.android.manifest.IAndroidApplication;
import soot.jimple.infoflow.android.manifest.IManifestHandler;
import soot.jimple.infoflow.android.manifest.ProcessManifest;
import soot.jimple.infoflow.android.resources.ARSCFileParser;
import soot.jimple.infoflow.android.resources.LayoutFileParser;
import soot.jimple.infoflow.android.resources.controls.AndroidLayoutControl;
import soot.jimple.infoflow.android.results.xml.InfoflowResultsSerializer;
import soot.jimple.infoflow.android.source.AccessPathBasedSourceSinkManager;
import soot.jimple.infoflow.android.source.ConfigurationBasedCategoryFilter;
import soot.jimple.infoflow.android.source.UnsupportedSourceSinkFormatException;
import soot.jimple.infoflow.android.source.parsers.xml.XMLSourceSinkParser;
import soot.jimple.infoflow.cfg.BiDirICFGFactory;
import soot.jimple.infoflow.cfg.LibraryClassPatcher;
import soot.jimple.infoflow.config.IInfoflowConfig;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.FlowDroidMemoryManager;
import soot.jimple.infoflow.handlers.PostAnalysisHandler;
import soot.jimple.infoflow.handlers.PreAnalysisHandler;
import soot.jimple.infoflow.handlers.ResultsAvailableHandler;
import soot.jimple.infoflow.handlers.TaintPropagationHandler;
import soot.jimple.infoflow.ipc.IIPCManager;
import soot.jimple.infoflow.memory.FlowDroidMemoryWatcher;
import soot.jimple.infoflow.memory.FlowDroidTimeoutWatcher;
import soot.jimple.infoflow.memory.IMemoryBoundedSolver;
import soot.jimple.infoflow.results.InfoflowPerformanceData;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.rifl.RIFLSourceSinkDefinitionProvider;
import soot.jimple.infoflow.river.IUsageContextProvider;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.solver.memory.IMemoryManager;
import soot.jimple.infoflow.solver.memory.IMemoryManagerFactory;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinitionProvider;
import soot.jimple.infoflow.sourcesSinks.definitions.MethodSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.manager.ISourceSinkManager;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.taintWrappers.ITaintWrapperDataFlowAnalysis;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.jimple.infoflow.values.IValueProvider;
import soot.options.Options;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public class SetupApplication
implements ITaintWrapperDataFlowAnalysis {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ISourceSinkDefinitionProvider sourceSinkProvider;
    protected MultiMap<SootClass, AndroidCallbackDefinition> callbackMethods = new HashMultiMap<SootClass, AndroidCallbackDefinition>();
    protected MultiMap<SootClass, SootClass> fragmentClasses = new HashMultiMap<SootClass, SootClass>();
    protected InfoflowAndroidConfiguration config = new InfoflowAndroidConfiguration();
    protected Set<SootClass> entrypoints = null;
    protected Set<String> callbackClasses = null;
    protected AndroidEntryPointCreator entryPointCreator = null;
    protected IccInstrumenter iccInstrumenter = null;
    protected ARSCFileParser resources = null;
    protected IManifestHandler manifest = null;
    protected IValueProvider valueProvider = null;
    protected final boolean forceAndroidJar;
    protected ITaintPropagationWrapper taintWrapper;
    protected ISourceSinkManager sourceSinkManager = null;
    protected IInfoflowConfig sootConfig = new SootConfigForAndroid();
    protected BiDirICFGFactory cfgFactory = null;
    protected IIPCManager ipcManager = null;
    protected Set<Stmt> collectedSources = null;
    protected Set<Stmt> collectedSinks = null;
    protected String callbackFile = "AndroidCallbacks.txt";
    protected SootClass scView = null;
    protected Set<PreAnalysisHandler> preprocessors = new HashSet<PreAnalysisHandler>();
    protected Set<ResultsAvailableHandler> resultsAvailableHandlers = new HashSet<ResultsAvailableHandler>();
    protected TaintPropagationHandler taintPropagationHandler = null;
    protected TaintPropagationHandler aliasPropagationHandler = null;
    protected IUsageContextProvider usageContextProvider = null;
    protected IInPlaceInfoflow infoflow = null;

    public SetupApplication(InfoflowAndroidConfiguration config) {
        this(config, null);
    }

    public SetupApplication(String androidJar, String apkFileLocation) {
        this(SetupApplication.getConfig(androidJar, apkFileLocation));
    }

    public SetupApplication(String androidJar, String apkFileLocation, IIPCManager ipcManager) {
        this(SetupApplication.getConfig(androidJar, apkFileLocation), ipcManager);
    }

    private static InfoflowAndroidConfiguration getConfig(String androidJar, String apkFileLocation) {
        InfoflowAndroidConfiguration config = new InfoflowAndroidConfiguration();
        config.getAnalysisFileConfig().setTargetAPKFile(apkFileLocation);
        config.getAnalysisFileConfig().setAndroidPlatformDir(androidJar);
        return config;
    }

    public SetupApplication(InfoflowAndroidConfiguration config, IIPCManager ipcManager) {
        this.config = config;
        this.ipcManager = ipcManager;
        if (config.getSootIntegrationMode() == InfoflowConfiguration.SootIntegrationMode.CreateNewInstance) {
            String platformDir = config.getAnalysisFileConfig().getAndroidPlatformDir();
            if (platformDir == null || platformDir.isEmpty()) {
                throw new RuntimeException("Android platform directory not specified");
            }
            File f = new File(platformDir);
            this.forceAndroidJar = f.isFile();
        } else {
            this.forceAndroidJar = false;
        }
    }

    public Collection<? extends ISourceSinkDefinition> getSinks() {
        return this.sourceSinkProvider == null ? null : this.sourceSinkProvider.getSinks();
    }

    public Set<Stmt> getCollectedSinks() {
        return this.collectedSinks;
    }

    public void printSinks() {
        if (this.sourceSinkProvider == null) {
            this.logger.error("Sinks not calculated yet");
            return;
        }
        this.logger.info("Sinks:");
        for (ISourceSinkDefinition iSourceSinkDefinition : this.getSinks()) {
            this.logger.info(String.format("- %s", iSourceSinkDefinition.toString()));
        }
        this.logger.info("End of Sinks");
    }

    public Collection<? extends ISourceSinkDefinition> getSources() {
        return this.sourceSinkProvider == null ? null : this.sourceSinkProvider.getSources();
    }

    public Set<Stmt> getCollectedSources() {
        return this.collectedSources;
    }

    public void printSources() {
        if (this.sourceSinkProvider == null) {
            this.logger.error("Sources not calculated yet");
            return;
        }
        this.logger.info("Sources:");
        for (ISourceSinkDefinition iSourceSinkDefinition : this.getSources()) {
            this.logger.info(String.format("- %s", iSourceSinkDefinition.toString()));
        }
        this.logger.info("End of Sources");
    }

    public Set<SootClass> getEntrypointClasses() {
        return this.entrypoints;
    }

    public void printEntrypoints() {
        if (this.entrypoints == null) {
            this.logger.error("Entry points not initialized");
        } else {
            this.logger.info("Classes containing entry points:");
            for (SootClass sc : this.entrypoints) {
                this.logger.info("\t" + sc.getName());
            }
            this.logger.info("End of Entrypoints");
        }
    }

    public void setCallbackClasses(Set<String> callbackClasses) {
        this.callbackClasses = callbackClasses;
    }

    public Set<String> getCallbackClasses() {
        return this.callbackClasses;
    }

    @Override
    public void setTaintWrapper(ITaintPropagationWrapper taintWrapper) {
        this.taintWrapper = taintWrapper;
    }

    @Override
    public ITaintPropagationWrapper getTaintWrapper() {
        return this.taintWrapper;
    }

    protected void parseAppResources() throws IOException, XmlPullParserException {
        File targetAPK = new File(this.config.getAnalysisFileConfig().getTargetAPKFile());
        if (!targetAPK.exists()) {
            throw new RuntimeException(String.format("Target APK file %s does not exist", targetAPK.getCanonicalPath()));
        }
        long beforeARSC = System.nanoTime();
        this.resources = new ARSCFileParser();
        this.resources.parse(targetAPK.getAbsolutePath());
        this.logger.info("ARSC file parsing took " + (double)(System.nanoTime() - beforeARSC) / 1.0E9 + " seconds");
        this.manifest = this.createManifestParser(targetAPK);
        SystemClassHandler.v().setExcludeSystemComponents(this.config.getIgnoreFlowsInSystemPackages());
        Set<String> entryPoints = this.manifest.getEntryPointClasses();
        this.entrypoints = new HashSet<SootClass>(entryPoints.size());
        for (String className : entryPoints) {
            SootClass sc = Scene.v().getSootClassUnsafe(className);
            if (sc == null) continue;
            this.entrypoints.add(sc);
        }
    }

    protected IManifestHandler createManifestParser(File targetAPK) throws IOException, XmlPullParserException {
        return new ProcessManifest(targetAPK, this.resources);
    }

    private void calculateCallbacks(ISourceSinkDefinitionProvider sourcesAndSinks) throws IOException, XmlPullParserException {
        this.calculateCallbacks(sourcesAndSinks, null);
    }

    private void calculateCallbacks(ISourceSinkDefinitionProvider sourcesAndSinks, SootClass entryPoint) throws IOException, XmlPullParserException {
        LayoutFileParser lfp = null;
        InfoflowAndroidConfiguration.CallbackConfiguration callbackConfig = this.config.getCallbackConfig();
        if (callbackConfig.getEnableCallbacks()) {
            CollectedCallbacks callbacks;
            File cbFile;
            String callbackFile = callbackConfig.getCallbacksFile();
            if (callbackFile != null && !callbackFile.isEmpty() && (cbFile = new File(callbackFile)).exists() && (callbacks = CollectedCallbacksSerializer.deserialize(callbackConfig)) != null) {
                this.entrypoints = callbacks.getEntryPoints();
                this.fragmentClasses = callbacks.getFragmentClasses();
                this.callbackMethods = callbacks.getCallbackMethods();
                this.createMainMethod(entryPoint);
                this.constructCallgraphInternal();
                this.createSourceSinkProvider(entryPoint, lfp);
                return;
            }
            if (this.callbackClasses != null && this.callbackClasses.isEmpty()) {
                this.logger.warn("Callback definition file is empty, disabling callbacks");
            } else {
                lfp = this.createLayoutFileParser();
                switch (callbackConfig.getCallbackAnalyzer()) {
                    case Fast: {
                        this.calculateCallbackMethodsFast(lfp, entryPoint);
                        break;
                    }
                    case Default: {
                        this.calculateCallbackMethods(lfp, entryPoint);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown callback analyzer");
                    }
                }
            }
        } else if (this.config.getSootIntegrationMode().needsToBuildCallgraph()) {
            this.createMainMethod(entryPoint);
            this.constructCallgraphInternal();
        }
        this.logger.info("Entry point calculation done.");
        this.createSourceSinkProvider(entryPoint, lfp);
    }

    protected void createSourceSinkProvider(SootClass entryPoint, LayoutFileParser lfp) {
        if (this.sourceSinkProvider != null) {
            Set<AndroidCallbackDefinition> callbacks = entryPoint == null ? this.callbackMethods.values() : this.callbackMethods.get(entryPoint);
            this.sourceSinkManager = this.createSourceSinkManager(lfp, callbacks);
        }
    }

    protected LayoutFileParser createLayoutFileParser() {
        return new LayoutFileParser(this.manifest.getPackageName(), this.resources);
    }

    protected ISourceSinkManager createSourceSinkManager(LayoutFileParser lfp, Set<AndroidCallbackDefinition> callbacks) {
        AccessPathBasedSourceSinkManager sourceSinkManager = new AccessPathBasedSourceSinkManager(this.sourceSinkProvider.getSources(), this.sourceSinkProvider.getSinks(), callbacks, this.config, lfp == null ? null : lfp.getUserControlsByID());
        sourceSinkManager.setAppPackageName(this.manifest.getPackageName());
        sourceSinkManager.setResourcePackages(this.resources.getPackages());
        return sourceSinkManager;
    }

    protected void constructCallgraphInternal() {
        if (this.config.getSootIntegrationMode() == InfoflowConfiguration.SootIntegrationMode.UseExistingCallgraph) {
            if (!Scene.v().hasCallGraph()) {
                throw new RuntimeException("FlowDroid is configured to use an existing callgraph, but there is none");
            }
            return;
        }
        if (this.config.getIccConfig().isIccEnabled()) {
            if (this.iccInstrumenter == null) {
                this.iccInstrumenter = this.createIccInstrumenter();
            }
            this.iccInstrumenter.onBeforeCallgraphConstruction();
        }
        for (PreAnalysisHandler handler : this.preprocessors) {
            handler.onBeforeCallgraphConstruction();
        }
        this.releaseCallgraph();
        if (this.config.getSootIntegrationMode() == InfoflowConfiguration.SootIntegrationMode.UseExistingInstance) {
            this.configureCallgraph();
        }
        this.logger.info("Constructing the callgraph...");
        PackManager.v().getPack("cg").apply();
        if (this.iccInstrumenter != null) {
            this.iccInstrumenter.onAfterCallgraphConstruction();
        }
        for (PreAnalysisHandler handler : this.preprocessors) {
            handler.onAfterCallgraphConstruction();
        }
        Scene.v().getOrMakeFastHierarchy();
    }

    protected IccInstrumenter createIccInstrumenter() {
        IccInstrumenter iccInstrumenter = new IccInstrumenter(this.config.getIccConfig().getIccModel(), this.entryPointCreator.getGeneratedMainMethod().getDeclaringClass(), this.entryPointCreator.getComponentToEntryPointInfo());
        return iccInstrumenter;
    }

    private void calculateCallbackMethods(LayoutFileParser lfp, SootClass component) throws IOException {
        DefaultCallbackAnalyzer jimpleClass;
        InfoflowAndroidConfiguration.CallbackConfiguration callbackConfig = this.config.getCallbackConfig();
        if (this.config.getSootIntegrationMode().needsToBuildCallgraph()) {
            this.releaseCallgraph();
        }
        PackManager.v().getPack("wjtp").remove("wjtp.lfp");
        PackManager.v().getPack("wjtp").remove("wjtp.ajc");
        Set<SootClass> entryPointClasses = this.getComponentsToAnalyze(component);
        DefaultCallbackAnalyzer defaultCallbackAnalyzer = jimpleClass = this.callbackClasses == null ? new DefaultCallbackAnalyzer(this.config, entryPointClasses, this.callbackMethods, this.callbackFile) : new DefaultCallbackAnalyzer(this.config, entryPointClasses, this.callbackMethods, this.callbackClasses);
        if (this.valueProvider != null) {
            jimpleClass.setValueProvider(this.valueProvider);
        }
        jimpleClass.addCallbackFilter(new AlienHostComponentFilter(this.entrypoints));
        jimpleClass.addCallbackFilter(new ApplicationCallbackFilter(this.entrypoints));
        jimpleClass.addCallbackFilter(new UnreachableConstructorFilter());
        ((AbstractCallbackAnalyzer)jimpleClass).collectCallbackMethods();
        lfp.parseLayoutFile(this.config.getAnalysisFileConfig().getTargetAPKFile());
        FlowDroidMemoryWatcher memoryWatcher = null;
        FlowDroidTimeoutWatcher timeoutWatcher = null;
        if (jimpleClass instanceof IMemoryBoundedSolver) {
            memoryWatcher = this.createCallbackMemoryWatcher(jimpleClass);
            timeoutWatcher = this.createCallbackTimeoutWatcher(callbackConfig, jimpleClass);
        }
        try {
            int depthIdx = 0;
            boolean hasChanged = true;
            boolean isInitial = true;
            while (hasChanged) {
                hasChanged = false;
                if (jimpleClass instanceof IMemoryBoundedSolver && ((IMemoryBoundedSolver)jimpleClass).isKilled()) {
                } else {
                    this.createMainMethod(component);
                    int numPrevEdges = 0;
                    if (Scene.v().hasCallGraph()) {
                        numPrevEdges = Scene.v().getCallGraph().size();
                    }
                    if (jimpleClass instanceof IMemoryBoundedSolver && ((IMemoryBoundedSolver)jimpleClass).isKilled()) {
                        this.logger.warn("Callback calculation aborted due to timeout");
                    } else {
                        if (!isInitial) {
                            this.releaseCallgraph();
                            PackManager.v().getPack("wjtp").remove("wjtp.lfp");
                        }
                        isInitial = false;
                        this.constructCallgraphInternal();
                        if (!Scene.v().hasCallGraph()) {
                            throw new RuntimeException("No callgraph in Scene even after creating one. That's very sad and should never happen.");
                        }
                        lfp.parseLayoutFileDirect(this.config.getAnalysisFileConfig().getTargetAPKFile());
                        PackManager.v().getPack("wjtp").apply();
                        if (jimpleClass instanceof IMemoryBoundedSolver && ((IMemoryBoundedSolver)jimpleClass).isKilled()) {
                            this.logger.warn("Aborted callback collection because of low memory");
                        } else {
                            if (numPrevEdges < Scene.v().getCallGraph().size()) {
                                hasChanged = true;
                            }
                            if (this.callbackMethods.putAll(jimpleClass.getCallbackMethods())) {
                                hasChanged = true;
                            }
                            if (this.entrypoints.addAll(jimpleClass.getDynamicManifestComponents())) {
                                hasChanged = true;
                            }
                            if (this.collectXmlBasedCallbackMethods(lfp, jimpleClass)) {
                                hasChanged = true;
                            }
                            if (callbackConfig.getMaxCallbacksPerComponent() > 0) {
                                Iterator<SootClass> componentIt = this.callbackMethods.keySet().iterator();
                                while (componentIt.hasNext()) {
                                    SootClass callbackComponent = componentIt.next();
                                    if (this.callbackMethods.get(callbackComponent).size() <= callbackConfig.getMaxCallbacksPerComponent()) continue;
                                    componentIt.remove();
                                    ((AbstractCallbackAnalyzer)jimpleClass).excludeEntryPoint(callbackComponent);
                                }
                            }
                            if (callbackConfig.getMaxAnalysisCallbackDepth() > 0 && ++depthIdx >= callbackConfig.getMaxAnalysisCallbackDepth()) {
                            } else if (this.config.getSootIntegrationMode() != InfoflowConfiguration.SootIntegrationMode.UseExistingCallgraph) continue;
                        }
                    }
                }
                break;
            }
        }
        catch (Exception ex) {
            this.logger.error("Could not calculate callback methods", ex);
            throw ex;
        }
        finally {
            if (timeoutWatcher != null) {
                timeoutWatcher.stop();
            }
            if (memoryWatcher != null) {
                memoryWatcher.close();
            }
        }
        AlienFragmentFilter fragmentFilter = new AlienFragmentFilter(this.invertMap(this.fragmentClasses));
        fragmentFilter.reset();
        Iterator cbIt = this.callbackMethods.iterator();
        while (cbIt.hasNext()) {
            Pair pair = (Pair)cbIt.next();
            if (!fragmentFilter.accepts((SootClass)pair.getO1(), ((AndroidCallbackDefinition)pair.getO2()).getTargetMethod())) {
                cbIt.remove();
                continue;
            }
            if (fragmentFilter.accepts((SootClass)pair.getO1(), ((AndroidCallbackDefinition)pair.getO2()).getTargetMethod().getDeclaringClass())) continue;
            cbIt.remove();
        }
        if (callbackConfig.getMaxCallbacksPerComponent() > 0) {
            Iterator<SootClass> componentIt = this.callbackMethods.keySet().iterator();
            while (componentIt.hasNext()) {
                SootClass callbackComponent = componentIt.next();
                if (this.callbackMethods.get(callbackComponent).size() <= callbackConfig.getMaxCallbacksPerComponent()) continue;
                componentIt.remove();
            }
        }
        PackManager.v().getPack("wjtp").remove("wjtp.lfp");
        PackManager.v().getPack("wjtp").remove("wjtp.ajc");
        boolean abortedEarly = false;
        if (jimpleClass instanceof IMemoryBoundedSolver && ((IMemoryBoundedSolver)jimpleClass).isKilled()) {
            this.logger.warn("Callback analysis aborted early due to time or memory exhaustion");
            abortedEarly = true;
        }
        if (!abortedEarly) {
            this.logger.info("Callback analysis terminated normally");
        }
        if (callbackConfig.isSerializeCallbacks()) {
            CollectedCallbacks callbacks = new CollectedCallbacks(entryPointClasses, this.callbackMethods, this.fragmentClasses);
            CollectedCallbacksSerializer.serialize(callbacks, callbackConfig);
        }
    }

    protected FlowDroidMemoryWatcher createCallbackMemoryWatcher(AbstractCallbackAnalyzer jimpleClass) {
        FlowDroidMemoryWatcher memoryWatcher = new FlowDroidMemoryWatcher(this.config.getMemoryThreshold());
        memoryWatcher.addSolver((IMemoryBoundedSolver)((Object)jimpleClass));
        return memoryWatcher;
    }

    protected FlowDroidTimeoutWatcher createCallbackTimeoutWatcher(InfoflowAndroidConfiguration.CallbackConfiguration callbackConfig, AbstractCallbackAnalyzer analyzer) {
        if (callbackConfig.getCallbackAnalysisTimeout() > 0) {
            FlowDroidTimeoutWatcher timeoutWatcher = new FlowDroidTimeoutWatcher(callbackConfig.getCallbackAnalysisTimeout());
            timeoutWatcher.addSolver((IMemoryBoundedSolver)((Object)analyzer));
            timeoutWatcher.start();
            return timeoutWatcher;
        }
        return null;
    }

    private <K, V> MultiMap<K, V> invertMap(MultiMap<V, K> original) {
        HashMultiMap<K, V> newTag = new HashMultiMap<K, V>();
        for (V key : original.keySet()) {
            for (K value : original.get(key)) {
                newTag.put(value, key);
            }
        }
        return newTag;
    }

    protected void releaseCallgraph() {
        if (this.config.getSootIntegrationMode() == InfoflowConfiguration.SootIntegrationMode.UseExistingCallgraph) {
            return;
        }
        Scene.v().releaseCallGraph();
        Scene.v().releasePointsToAnalysis();
        Scene.v().releaseReachableMethods();
        G.v().resetSpark();
    }

    private boolean collectXmlBasedCallbackMethods(LayoutFileParser lfp, AbstractCallbackAnalyzer jimpleClass) {
        SootMethod smViewOnClick = Scene.v().grabMethod("<android.view.View$OnClickListener: void onClick(android.view.View)>");
        boolean hasNewCallback = false;
        for (SootClass callbackClass : jimpleClass.getLayoutClasses().keySet()) {
            if (jimpleClass.isExcludedEntryPoint(callbackClass)) continue;
            Set<Integer> classIds = jimpleClass.getLayoutClasses().get(callbackClass);
            for (Integer classId : classIds) {
                ARSCFileParser.AbstractResource resource = this.resources.findResource(classId);
                if (resource instanceof ARSCFileParser.StringResource) {
                    Set<AndroidLayoutControl> set;
                    Set<SootClass> fragments;
                    String layoutFileName = ((ARSCFileParser.StringResource)resource).getValue();
                    Set<String> callbackMethods = lfp.getCallbackMethods().get(layoutFileName);
                    if (callbackMethods != null) {
                        block2: for (String string : callbackMethods) {
                            String subSig = "void " + string + "(android.view.View)";
                            SootClass currentClass = callbackClass;
                            while (true) {
                                SootMethod callbackMethod;
                                if ((callbackMethod = currentClass.getMethodUnsafe(subSig)) != null) {
                                    if (!this.callbackMethods.put(callbackClass, new AndroidCallbackDefinition(callbackMethod, smViewOnClick, AndroidCallbackDefinition.CallbackType.Widget))) continue block2;
                                    hasNewCallback = true;
                                    continue block2;
                                }
                                SootClass sclass = currentClass.getSuperclassUnsafe();
                                if (sclass == null) {
                                    this.logger.error(String.format("Callback method %s not found in class %s", string, callbackClass.getName()));
                                    continue block2;
                                }
                                currentClass = sclass;
                            }
                        }
                    }
                    if ((fragments = lfp.getFragments().get(layoutFileName)) != null) {
                        for (SootClass fragment : fragments) {
                            if (!this.fragmentClasses.put(callbackClass, fragment)) continue;
                            hasNewCallback = true;
                        }
                    }
                    if ((set = lfp.getUserControls().get(layoutFileName)) == null) continue;
                    for (AndroidLayoutControl lc : set) {
                        if (SystemClassHandler.v().isClassInSystemPackage(lc.getViewClass().getName())) continue;
                        hasNewCallback |= this.registerCallbackMethodsForView(callbackClass, lc);
                    }
                    continue;
                }
                this.logger.error("Unexpected resource type for layout class");
            }
        }
        if (this.fragmentClasses.putAll(jimpleClass.getFragmentClasses())) {
            hasNewCallback = true;
        }
        return hasNewCallback;
    }

    private void calculateCallbackMethodsFast(LayoutFileParser lfp, SootClass component) throws IOException {
        FastCallbackAnalyzer jimpleClass;
        this.releaseCallgraph();
        this.createMainMethod(component);
        this.constructCallgraphInternal();
        Set<SootClass> entryPointClasses = this.getComponentsToAnalyze(component);
        FastCallbackAnalyzer fastCallbackAnalyzer = jimpleClass = this.callbackClasses == null ? new FastCallbackAnalyzer(this.config, entryPointClasses, this.callbackFile) : new FastCallbackAnalyzer(this.config, entryPointClasses, this.callbackClasses);
        if (this.valueProvider != null) {
            jimpleClass.setValueProvider(this.valueProvider);
        }
        ((AbstractCallbackAnalyzer)jimpleClass).collectCallbackMethods();
        this.callbackMethods.putAll(jimpleClass.getCallbackMethods());
        this.entrypoints.addAll(jimpleClass.getDynamicManifestComponents());
        lfp.parseLayoutFileDirect(this.config.getAnalysisFileConfig().getTargetAPKFile());
        this.collectXmlBasedCallbackMethods(lfp, jimpleClass);
        this.releaseCallgraph();
        this.createMainMethod(component);
        this.constructCallgraphInternal();
    }

    private boolean registerCallbackMethodsForView(SootClass callbackClass, AndroidLayoutControl lc) {
        if (SystemClassHandler.v().isClassInSystemPackage(callbackClass.getName())) {
            return false;
        }
        if (this.scView == null) {
            this.scView = Scene.v().getSootClass("android.view.View");
        }
        if (!Scene.v().getOrMakeFastHierarchy().canStoreType(lc.getViewClass().getType(), this.scView.getType())) {
            return false;
        }
        SootClass sc = lc.getViewClass();
        HashMap<String, SootMethod> systemMethods = new HashMap<String, SootMethod>(10000);
        for (SootClass parentClass : Scene.v().getActiveHierarchy().getSuperclassesOf(sc)) {
            if (!parentClass.getName().startsWith("android.")) continue;
            for (SootMethod sm : parentClass.getMethods()) {
                if (sm.isConstructor()) continue;
                systemMethods.put(sm.getSubSignature(), sm);
            }
        }
        boolean changed = false;
        for (SootMethod sm : sc.getMethods()) {
            SootMethod parentMethod;
            if (sm.isConstructor() || (parentMethod = (SootMethod)systemMethods.get(sm.getSubSignature())) == null) continue;
            changed |= this.callbackMethods.put(callbackClass, new AndroidCallbackDefinition(sm, parentMethod, AndroidCallbackDefinition.CallbackType.Widget));
        }
        return changed;
    }

    private void createMainMethod(SootClass component) {
        if (this.config.getSootIntegrationMode() == InfoflowConfiguration.SootIntegrationMode.UseExistingCallgraph) {
            return;
        }
        this.entryPointCreator = this.createEntryPointCreator(component);
        SootMethod dummyMainMethod = this.entryPointCreator.createDummyMain();
        Scene.v().setEntryPoints(Collections.singletonList(dummyMainMethod));
        if (!dummyMainMethod.getDeclaringClass().isInScene()) {
            Scene.v().addClass(dummyMainMethod.getDeclaringClass());
        }
        dummyMainMethod.getDeclaringClass().setApplicationClass();
    }

    public ISourceSinkManager getSourceSinkManager() {
        return this.sourceSinkManager;
    }

    private String getClasspath() {
        String classpath;
        String androidJar = this.config.getAnalysisFileConfig().getAndroidPlatformDir();
        String apkFileLocation = this.config.getAnalysisFileConfig().getTargetAPKFile();
        String additionalClasspath = this.config.getAnalysisFileConfig().getAdditionalClasspath();
        String string = classpath = this.forceAndroidJar ? androidJar : Scene.v().getAndroidJarPath(androidJar, apkFileLocation);
        if (additionalClasspath != null && !additionalClasspath.isEmpty()) {
            classpath = classpath + File.pathSeparator + additionalClasspath;
        }
        this.logger.debug("soot classpath: " + classpath);
        return classpath;
    }

    private void initializeSoot() {
        this.logger.info("Initializing Soot...");
        String androidJar = this.config.getAnalysisFileConfig().getAndroidPlatformDir();
        String apkFileLocation = this.config.getAnalysisFileConfig().getTargetAPKFile();
        G.reset();
        Options.v().set_no_bodies_for_excluded(true);
        Options.v().set_allow_phantom_refs(true);
        if (this.config.getWriteOutputFiles()) {
            Options.v().set_output_format(1);
        } else {
            Options.v().set_output_format(12);
        }
        Options.v().set_whole_program(true);
        Options.v().set_process_dir(Collections.singletonList(apkFileLocation));
        if (this.forceAndroidJar) {
            Options.v().set_force_android_jar(androidJar);
        } else {
            Options.v().set_android_jars(androidJar);
        }
        Options.v().set_src_prec(6);
        Options.v().set_keep_offset(false);
        Options.v().set_keep_line_number(this.config.getEnableLineNumbers());
        Options.v().set_throw_analysis(3);
        Options.v().set_process_multiple_dex(this.config.getMergeDexFiles());
        Options.v().set_ignore_resolution_errors(true);
        if (this.config.getEnableOriginalNames()) {
            Options.v().setPhaseOption("jb", "use-original-names:true");
        }
        if (this.sootConfig != null) {
            this.sootConfig.setSootOptions(Options.v(), this.config);
        }
        Options.v().set_soot_classpath(this.getClasspath());
        Main.v().autoSetOptions();
        this.configureCallgraph();
        this.logger.info("Loading dex files...");
        Scene.v().loadNecessaryClasses();
        PackManager.v().getPack("wjpp").apply();
        LibraryClassPatcher patcher = this.getLibraryClassPatcher();
        patcher.patchLibraries();
    }

    protected LibraryClassPatcher getLibraryClassPatcher() {
        return new LibraryClassPatcher();
    }

    protected void configureCallgraph() {
        switch (this.config.getCallgraphAlgorithm()) {
            case AutomaticSelection: 
            case SPARK: {
                Options.v().setPhaseOption("cg.spark", "on");
                break;
            }
            case GEOM: {
                Options.v().setPhaseOption("cg.spark", "on");
                AbstractInfoflow.setGeomPtaSpecificOptions();
                break;
            }
            case CHA: {
                Options.v().setPhaseOption("cg.cha", "on");
                break;
            }
            case RTA: {
                Options.v().setPhaseOption("cg.spark", "on");
                Options.v().setPhaseOption("cg.spark", "rta:true");
                Options.v().setPhaseOption("cg.spark", "on-fly-cg:false");
                break;
            }
            case VTA: {
                Options.v().setPhaseOption("cg.spark", "on");
                Options.v().setPhaseOption("cg.spark", "vta:true");
                break;
            }
            default: {
                throw new RuntimeException("Invalid callgraph algorithm");
            }
        }
        if (this.config.getEnableReflection()) {
            Options.v().setPhaseOption("cg", "types-for-invoke:true");
        }
    }

    public void constructCallgraph() {
        boolean oldRunAnalysis = this.config.isTaintAnalysisEnabled();
        try {
            this.config.setTaintAnalysisEnabled(false);
            if (!this.config.getSootIntegrationMode().needsToBuildCallgraph()) {
                throw new RuntimeException("FlowDroid is configured to use an existing callgraph. Please change this option before trying to create a new callgraph.");
            }
            this.runInfoflow((ISourceSinkDefinitionProvider)null);
        }
        catch (RuntimeException ex) {
            this.logger.error("Could not construct callgraph", ex);
            throw ex;
        }
        finally {
            this.config.setTaintAnalysisEnabled(oldRunAnalysis);
        }
    }

    public InfoflowResults runInfoflow(Set<AndroidMethod> sources, Set<AndroidMethod> sinks) throws IOException, XmlPullParserException {
        final HashSet<MethodSourceSinkDefinition> sourceDefs = new HashSet<MethodSourceSinkDefinition>(sources.size());
        final HashSet<MethodSourceSinkDefinition> sinkDefs = new HashSet<MethodSourceSinkDefinition>(sinks.size());
        for (AndroidMethod am : sources) {
            sourceDefs.add(new MethodSourceSinkDefinition(am));
        }
        for (AndroidMethod am : sinks) {
            sinkDefs.add(new MethodSourceSinkDefinition(am));
        }
        ISourceSinkDefinitionProvider parser2 = new ISourceSinkDefinitionProvider(){

            public Set<ISourceSinkDefinition> getSources() {
                return sourceDefs;
            }

            public Set<ISourceSinkDefinition> getSinks() {
                return sinkDefs;
            }

            public Set<ISourceSinkDefinition> getAllMethods() {
                HashSet<ISourceSinkDefinition> sourcesSinks = new HashSet<ISourceSinkDefinition>(sourceDefs.size() + sinkDefs.size());
                sourcesSinks.addAll(sourceDefs);
                sourcesSinks.addAll(sinkDefs);
                return sourcesSinks;
            }
        };
        return this.runInfoflow(parser2);
    }

    public InfoflowResults runInfoflow(String sourceSinkFile) throws IOException, XmlPullParserException {
        if (sourceSinkFile != null && !sourceSinkFile.isEmpty()) {
            this.config.getAnalysisFileConfig().setSourceSinkFile(sourceSinkFile);
        }
        return this.runInfoflow();
    }

    public InfoflowResults runInfoflow() throws IOException, XmlPullParserException {
        ISourceSinkDefinitionProvider parser2;
        block6: {
            String sourceSinkFile = this.config.getAnalysisFileConfig().getSourceSinkFile();
            if (sourceSinkFile == null || sourceSinkFile.isEmpty()) {
                throw new RuntimeException("No source/sink file specified for the data flow analysis");
            }
            String fileExtension = sourceSinkFile.substring(sourceSinkFile.lastIndexOf("."));
            fileExtension = fileExtension.toLowerCase();
            parser2 = null;
            try {
                if (fileExtension.equals(".xml")) {
                    parser2 = XMLSourceSinkParser.fromFile(sourceSinkFile, new ConfigurationBasedCategoryFilter(this.config.getSourceSinkConfig()));
                    break block6;
                }
                if (fileExtension.equals(".txt")) {
                    parser2 = PermissionMethodParser.fromFile(sourceSinkFile);
                    break block6;
                }
                if (fileExtension.equals(".rifl")) {
                    parser2 = new RIFLSourceSinkDefinitionProvider(sourceSinkFile);
                    break block6;
                }
                throw new UnsupportedSourceSinkFormatException("The Inputfile isn't a .txt or .xml file.");
            }
            catch (SAXException ex) {
                throw new IOException("Could not read XML file", ex);
            }
        }
        return this.runInfoflow(parser2);
    }

    public InfoflowResults runInfoflow(ISourceSinkDefinitionProvider sourcesAndSinks) {
        this.collectedSources = this.config.getLogSourcesAndSinks() ? new HashSet() : null;
        this.collectedSinks = this.config.getLogSourcesAndSinks() ? new HashSet() : null;
        this.sourceSinkProvider = sourcesAndSinks;
        this.infoflow = null;
        if (this.config.getSourceSinkConfig().getEnableLifecycleSources() && this.config.getIccConfig().isIccEnabled()) {
            this.logger.warn("ICC model specified, automatically disabling lifecycle sources");
            this.config.getSourceSinkConfig().setEnableLifecycleSources(false);
        }
        if (this.config.getSootIntegrationMode() == InfoflowConfiguration.SootIntegrationMode.CreateNewInstance) {
            G.reset();
            this.initializeSoot();
        }
        try {
            this.parseAppResources();
        }
        catch (IOException | XmlPullParserException e) {
            this.logger.error("Parse app resource failed", e);
            throw new RuntimeException("Parse app resource failed", e);
        }
        MultiRunResultAggregator resultAggregator = new MultiRunResultAggregator(this.config.getPathAgnosticResults());
        if (this.entrypoints == null || this.entrypoints.isEmpty()) {
            this.logger.warn("No entry points");
            return null;
        }
        if (this.config.getOneComponentAtATime()) {
            ArrayList<SootClass> entrypointWorklist = new ArrayList<SootClass>(this.entrypoints);
            while (!entrypointWorklist.isEmpty()) {
                SootClass entrypoint = (SootClass)entrypointWorklist.remove(0);
                this.processEntryPoint(sourcesAndSinks, resultAggregator, entrypointWorklist.size(), entrypoint);
            }
        } else {
            this.processEntryPoint(sourcesAndSinks, resultAggregator, -1, null);
        }
        this.serializeResults(resultAggregator.getAggregatedResults(), resultAggregator.getLastICFG());
        this.infoflow = null;
        resultAggregator.clearLastResults();
        return resultAggregator.getAggregatedResults();
    }

    protected void processEntryPoint(ISourceSinkDefinitionProvider sourcesAndSinks, MultiRunResultAggregator resultAggregator, int numEntryPoints, SootClass entrypoint) {
        int resCount;
        long beforeEntryPoint = System.nanoTime();
        resultAggregator.clearLastResults();
        long callbackDuration = System.nanoTime();
        try {
            if (this.config.getOneComponentAtATime()) {
                this.calculateCallbacks(sourcesAndSinks, entrypoint);
            } else {
                this.calculateCallbacks(sourcesAndSinks);
            }
        }
        catch (IOException | XmlPullParserException e) {
            this.logger.error("Callgraph construction failed: " + e.getMessage(), e);
            throw new RuntimeException("Callgraph construction failed", e);
        }
        callbackDuration = Math.round((double)(System.nanoTime() - callbackDuration) / 1.0E9);
        this.logger.info(String.format("Collecting callbacks and building a callgraph took %d seconds", (int)callbackDuration));
        Collection<? extends ISourceSinkDefinition> sources = this.getSources();
        Collection<? extends ISourceSinkDefinition> sinks = this.getSinks();
        String apkFileLocation = this.config.getAnalysisFileConfig().getTargetAPKFile();
        if (this.config.getOneComponentAtATime()) {
            this.logger.info("Running data flow analysis on {} (component {}/{}: {}) with {} sources and {} sinks...", apkFileLocation, this.entrypoints.size() - numEntryPoints, this.entrypoints.size(), entrypoint, sources == null ? 0 : sources.size(), sinks == null ? 0 : sinks.size());
        } else {
            this.logger.info("Running data flow analysis on {} with {} sources and {} sinks...", apkFileLocation, sources == null ? 0 : sources.size(), sinks == null ? 0 : sinks.size());
        }
        if (this.config.getOneComponentAtATime() && this.config.getSootIntegrationMode().needsToBuildCallgraph()) {
            this.createMainMethod(entrypoint);
            this.constructCallgraphInternal();
        }
        this.infoflow = this.createInfoflow();
        this.infoflow.addResultsAvailableHandler(resultAggregator);
        this.infoflow.runAnalysis(this.sourceSinkManager, this.entryPointCreator.getGeneratedMainMethod());
        if (this.config.getLogSourcesAndSinks() && this.infoflow.getCollectedSources() != null) {
            this.collectedSources.addAll(this.infoflow.getCollectedSources());
        }
        if (this.config.getLogSourcesAndSinks() && this.infoflow.getCollectedSinks() != null) {
            this.collectedSinks.addAll(this.infoflow.getCollectedSinks());
        }
        int n = resCount = resultAggregator.getLastResults() == null ? 0 : resultAggregator.getLastResults().size();
        if (this.config.getOneComponentAtATime()) {
            this.logger.info("Found {} leaks for component {}", (Object)resCount, (Object)entrypoint);
        } else {
            this.logger.info("Found {} leaks", (Object)resCount);
        }
        InfoflowResults lastResults = resultAggregator.getLastResults();
        if (lastResults != null) {
            InfoflowPerformanceData perfData = lastResults.getPerformanceData();
            if (perfData == null) {
                perfData = new InfoflowPerformanceData();
                lastResults.setPerformanceData(perfData);
            }
            perfData.setCallgraphConstructionSeconds((int)callbackDuration);
            perfData.setTotalRuntimeSeconds((int)Math.round((double)(System.nanoTime() - beforeEntryPoint) / 1.0E9));
        }
        this.callbackMethods.clear();
        this.fragmentClasses.clear();
        for (ResultsAvailableHandler handler : this.resultsAvailableHandlers) {
            handler.onResultsAvailable(resultAggregator.getLastICFG(), resultAggregator.getLastResults());
        }
    }

    protected void serializeResults(InfoflowResults results, IInfoflowCFG cfg) {
        String resultsFile;
        if (results != null && !results.isEmpty() && (resultsFile = this.config.getAnalysisFileConfig().getOutputFile()) != null && !resultsFile.isEmpty()) {
            InfoflowResultsSerializer serializer = new InfoflowResultsSerializer(cfg, this.config);
            try {
                serializer.serialize(results, resultsFile);
            }
            catch (IOException ex) {
                System.err.println("Could not write data flow results to file: " + ex.getMessage());
                ex.printStackTrace();
            }
            catch (XMLStreamException ex) {
                System.err.println("Could not write data flow results to file: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    private IInPlaceInfoflow createInfoflow() {
        ComponentEntryPointCollection entryPoints;
        if (this.config.getSootIntegrationMode().needsToBuildCallgraph()) {
            if (this.entryPointCreator == null) {
                throw new RuntimeException("No entry point available");
            }
            if (this.entryPointCreator.getComponentToEntryPointInfo() == null) {
                throw new RuntimeException("No information about component entry points available");
            }
        }
        Collection<SootMethod> lifecycleMethods = Collections.emptySet();
        if (this.entryPointCreator != null && (entryPoints = this.entryPointCreator.getComponentToEntryPointInfo()) != null) {
            lifecycleMethods = entryPoints.getLifecycleMethods();
        }
        IInPlaceInfoflow info = this.createInfoflowInternal(lifecycleMethods);
        if (this.ipcManager != null) {
            info.setIPCManager(this.ipcManager);
        }
        info.setConfig(this.config);
        info.setSootConfig(this.sootConfig);
        info.setTaintWrapper(this.taintWrapper);
        info.setTaintPropagationHandler(this.taintPropagationHandler);
        info.setAliasPropagationHandler(this.aliasPropagationHandler);
        info.setUsageContextProvider(this.usageContextProvider);
        info.setMemoryManagerFactory(new IMemoryManagerFactory(){

            @Override
            public IMemoryManager<Abstraction, Unit> getMemoryManager(boolean tracingEnabled, FlowDroidMemoryManager.PathDataErasureMode erasePathData) {
                return new AndroidMemoryManager(tracingEnabled, erasePathData, SetupApplication.this.entrypoints);
            }
        });
        info.setMemoryManagerFactory(null);
        info.addPostProcessor(new PostAnalysisHandler(){

            @Override
            public InfoflowResults onResultsAvailable(InfoflowResults results, IInfoflowCFG cfg) {
                InfoflowAndroidConfiguration.IccConfiguration iccConfig = SetupApplication.this.config.getIccConfig();
                if (iccConfig.isIccResultsPurifyEnabled()) {
                    // empty if block
                }
                return results;
            }
        });
        return info;
    }

    protected IInPlaceInfoflow createInfoflowInternal(Collection<SootMethod> lifecycleMethods) {
        String androidJar = this.config.getAnalysisFileConfig().getAndroidPlatformDir();
        if (this.config.getDataFlowDirection() == InfoflowConfiguration.DataFlowDirection.Backwards) {
            return new InPlaceBackwardsInfoflow(androidJar, this.forceAndroidJar, this.cfgFactory, lifecycleMethods);
        }
        return new InPlaceInfoflow(androidJar, this.forceAndroidJar, this.cfgFactory, lifecycleMethods);
    }

    private AndroidEntryPointCreator createEntryPointCreator(SootClass component) {
        Set<SootClass> components = this.getComponentsToAnalyze(component);
        if (this.entryPointCreator == null) {
            this.entryPointCreator = this.createEntryPointCreator(components);
        } else {
            this.entryPointCreator.removeGeneratedMethods(false);
            this.entryPointCreator.reset();
        }
        HashMultiMap<SootClass, SootMethod> callbackMethodSigs = new HashMultiMap<SootClass, SootMethod>();
        if (component == null) {
            for (SootClass sc : this.callbackMethods.keySet()) {
                Set<AndroidCallbackDefinition> callbackDefs = this.callbackMethods.get(sc);
                if (callbackDefs == null) continue;
                for (AndroidCallbackDefinition cd2 : callbackDefs) {
                    callbackMethodSigs.put(sc, cd2.getTargetMethod());
                }
            }
        } else {
            for (SootClass sc : components) {
                Set<AndroidCallbackDefinition> callbackDefs = this.callbackMethods.get(sc);
                if (callbackDefs == null) continue;
                for (AndroidCallbackDefinition cd3 : callbackDefs) {
                    callbackMethodSigs.put(sc, cd3.getTargetMethod());
                }
            }
        }
        this.entryPointCreator.setCallbackFunctions(callbackMethodSigs);
        this.entryPointCreator.setFragments(this.fragmentClasses);
        this.entryPointCreator.setComponents(components);
        return this.entryPointCreator;
    }

    protected AndroidEntryPointCreator createEntryPointCreator(Set<SootClass> components) {
        return new AndroidEntryPointCreator(this.manifest, components);
    }

    private Set<SootClass> getComponentsToAnalyze(SootClass component) {
        String applicationName;
        if (component == null) {
            return this.entrypoints;
        }
        HashSet<SootClass> components = new HashSet<SootClass>(2);
        components.add(component);
        IAndroidApplication app = this.manifest.getApplication();
        if (app != null && (applicationName = app.getName()) != null && !applicationName.isEmpty()) {
            components.add(Scene.v().getSootClassUnsafe(applicationName));
        }
        return components;
    }

    public SootMethod getDummyMainMethod() {
        return this.entryPointCreator.getGeneratedMainMethod();
    }

    public IInfoflowConfig getSootConfig() {
        return this.sootConfig;
    }

    public void setSootConfig(IInfoflowConfig config) {
        this.sootConfig = config;
    }

    public void setIcfgFactory(BiDirICFGFactory factory) {
        this.cfgFactory = factory;
    }

    public InfoflowAndroidConfiguration getConfig() {
        return this.config;
    }

    public void setCallbackFile(String callbackFile) {
        this.callbackFile = callbackFile;
    }

    public void addPreprocessor(PreAnalysisHandler preprocessor) {
        this.preprocessors.add(preprocessor);
    }

    public void addResultsAvailableHandler(ResultsAvailableHandler handler) {
        this.resultsAvailableHandlers.add(handler);
    }

    public void clearResultsAvailableHandlers() {
        this.resultsAvailableHandlers.clear();
    }

    public void abortAnalysis() {
        if (this.infoflow != null) {
            this.infoflow.abortAnalysis();
        }
    }

    public void setIpcManager(IIPCManager ipcManager) {
        this.ipcManager = ipcManager;
    }

    public void setTaintPropagationHandler(TaintPropagationHandler taintPropagationHandler) {
        this.taintPropagationHandler = taintPropagationHandler;
    }

    public void setAliasPropagationHandler(TaintPropagationHandler aliasPropagationHandler) {
        this.aliasPropagationHandler = aliasPropagationHandler;
    }

    public void setValueProvider(IValueProvider valueProvider) {
        this.valueProvider = valueProvider;
    }

    public void removeSimulatedCodeElements() {
        Iterator<SootClass> scIt = Scene.v().getClasses().iterator();
        while (scIt.hasNext()) {
            SootClass sc = scIt.next();
            if (sc.hasTag("SimulatedCodeElementTag")) {
                scIt.remove();
                continue;
            }
            Iterator<SootMethod> smIt = sc.getMethods().iterator();
            while (smIt.hasNext()) {
                SootMethod sm = smIt.next();
                if (!sm.hasTag("SimulatedCodeElementTag")) continue;
                smIt.remove();
            }
            Iterator<SootField> sfIt = sc.getFields().iterator();
            while (sfIt.hasNext()) {
                SootField sf = sfIt.next();
                if (!sf.hasTag("SimulatedCodeElementTag")) continue;
                sfIt.remove();
            }
        }
    }

    public void setUsageContextProvider(IUsageContextProvider usageContextProvider) {
        this.usageContextProvider = usageContextProvider;
    }

    protected static interface IInPlaceInfoflow
    extends IInfoflow {
        public void runAnalysis(ISourceSinkManager var1, SootMethod var2);
    }

    private static class MultiRunResultAggregator
    implements ResultsAvailableHandler {
        private final InfoflowResults aggregatedResults;
        private InfoflowResults lastResults = null;
        private IInfoflowCFG lastICFG = null;

        public MultiRunResultAggregator(boolean pathAgnosticResults) {
            this.aggregatedResults = new InfoflowResults(pathAgnosticResults);
        }

        @Override
        public void onResultsAvailable(IInfoflowCFG cfg, InfoflowResults results) {
            this.aggregatedResults.addAll(results);
            this.lastResults = results;
            this.lastICFG = cfg;
        }

        public InfoflowResults getAggregatedResults() {
            return this.aggregatedResults;
        }

        public InfoflowResults getLastResults() {
            return this.lastResults;
        }

        public void clearLastResults() {
            this.lastResults = null;
            this.lastICFG = null;
        }

        public IInfoflowCFG getLastICFG() {
            return this.lastICFG;
        }
    }

    protected class InPlaceBackwardsInfoflow
    extends BackwardsInfoflow
    implements IInPlaceInfoflow {
        public InPlaceBackwardsInfoflow(String androidPath, boolean forceAndroidJar, BiDirICFGFactory icfgFactory, Collection<SootMethod> additionalEntryPointMethods) {
            super(androidPath, forceAndroidJar, icfgFactory);
            this.additionalEntryPointMethods = additionalEntryPointMethods;
        }

        @Override
        public void runAnalysis(ISourceSinkManager sourcesSinks, SootMethod entryPoint) {
            this.dummyMainMethod = entryPoint;
            super.runAnalysis(sourcesSinks);
        }

        @Override
        protected boolean isUserCodeClass(String className) {
            String packageName = SetupApplication.this.manifest.getPackageName() + ".";
            return super.isUserCodeClass(className) || className.startsWith(packageName);
        }
    }

    protected class InPlaceInfoflow
    extends Infoflow
    implements IInPlaceInfoflow {
        public InPlaceInfoflow(String androidPath, boolean forceAndroidJar, BiDirICFGFactory icfgFactory, Collection<SootMethod> additionalEntryPointMethods) {
            super(androidPath, forceAndroidJar, icfgFactory);
            this.additionalEntryPointMethods = additionalEntryPointMethods;
        }

        @Override
        public void runAnalysis(ISourceSinkManager sourcesSinks, SootMethod entryPoint) {
            this.dummyMainMethod = entryPoint;
            super.runAnalysis(sourcesSinks);
        }

        @Override
        protected boolean isUserCodeClass(String className) {
            String packageName = SetupApplication.this.manifest.getPackageName() + ".";
            return super.isUserCodeClass(className) || className.startsWith(packageName);
        }
    }
}

