/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.AbstractJasminClass;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.IntType;
import soot.IntegerType;
import soot.Local;
import soot.LongType;
import soot.Modifier;
import soot.NullType;
import soot.RefType;
import soot.ShortType;
import soot.SootClass;
import soot.SootFieldRef;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.StmtAddressType;
import soot.Timers;
import soot.Trap;
import soot.Type;
import soot.TypeSwitch;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPatchingChain;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.grimp.AbstractGrimpValueSwitch;
import soot.grimp.NewInvokeExpr;
import soot.jimple.AbstractJimpleValueSwitch;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.AddExpr;
import soot.jimple.AndExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.BreakpointStmt;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.ClassConstant;
import soot.jimple.CmpExpr;
import soot.jimple.CmpgExpr;
import soot.jimple.CmplExpr;
import soot.jimple.DivExpr;
import soot.jimple.DoubleConstant;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.EqExpr;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.FloatConstant;
import soot.jimple.GeExpr;
import soot.jimple.GotoStmt;
import soot.jimple.GroupIntPair;
import soot.jimple.GtExpr;
import soot.jimple.IdentityRef;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceOfExpr;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.LeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.LongConstant;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.LtExpr;
import soot.jimple.MulExpr;
import soot.jimple.NeExpr;
import soot.jimple.NegExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.OrExpr;
import soot.jimple.ParameterRef;
import soot.jimple.RemExpr;
import soot.jimple.RetStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.ShlExpr;
import soot.jimple.ShrExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.jimple.StringConstant;
import soot.jimple.SubExpr;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.UshrExpr;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.XorExpr;
import soot.jimple.internal.StmtBox;
import soot.options.Options;
import soot.tagkit.LineNumberTag;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.FastColorer;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.LocalUses;

public class JasminClass
extends AbstractJasminClass {
    private static final Logger logger = LoggerFactory.getLogger(JasminClass.class);
    Value plusPlusValue;
    Local plusPlusHolder;
    int plusPlusState;
    int plusPlusPlace;
    int plusPlusHeight;
    Stmt plusPlusIncrementer;

    void emit(String s2, int stackChange) {
        this.modifyStackHeight(stackChange);
        this.okayEmit(s2);
    }

    void modifyStackHeight(int stackChange) {
        if (this.currentStackHeight > this.maxStackHeight) {
            this.maxStackHeight = this.currentStackHeight;
        }
        this.currentStackHeight += stackChange;
        if (this.currentStackHeight < 0) {
            throw new RuntimeException("Stack height is negative!");
        }
        if (this.currentStackHeight > this.maxStackHeight) {
            this.maxStackHeight = this.currentStackHeight;
        }
    }

    public JasminClass(SootClass sootClass) {
        super(sootClass);
    }

    @Override
    protected void assignColorsToLocals(Body body) {
        super.assignColorsToLocals(body);
        FastColorer.assignColorsToLocals(body, this.localToGroup, this.localToColor, this.groupToColorCount);
        if (Options.v().time()) {
            Timers.v().packTimer.end();
        }
    }

    @Override
    protected void emitMethodBody(SootMethod method) {
        boolean disablePeephole;
        Body activeBody;
        if (Options.v().time()) {
            Timers.v().buildJasminTimer.end();
        }
        if (!((activeBody = method.getActiveBody()) instanceof StmtBody)) {
            throw new RuntimeException("method: " + method.getName() + " has an invalid active body!");
        }
        StmtBody body = (StmtBody)activeBody;
        body.validate();
        if (Options.v().time()) {
            Timers.v().buildJasminTimer.start();
        }
        UnitPatchingChain units = body.getUnits();
        ExceptionalUnitGraph stmtGraph = null;
        LocalDefs ld = null;
        LocalUses lu = null;
        if (Options.v().verbose()) {
            logger.debug("[" + body.getMethod().getName() + "] Performing peephole optimizations...");
        }
        if (!(disablePeephole = true)) {
            stmtGraph = new ExceptionalUnitGraph(body);
            ld = LocalDefs.Factory.newLocalDefs(stmtGraph);
            lu = LocalUses.Factory.newLocalUses(body, ld);
        }
        int stackLimitIndex = -1;
        this.subroutineToReturnAddressSlot = new HashMap(10, 0.7f);
        this.unitToLabel = new HashMap(units.size() * 2 + 1, 0.7f);
        this.labelCount = 0;
        for (UnitBox ubox : body.getUnitBoxes(true)) {
            StmtBox box = (StmtBox)ubox;
            if (this.unitToLabel.containsKey(box.getUnit())) continue;
            this.unitToLabel.put(box.getUnit(), "label" + this.labelCount++);
        }
        for (Trap trap : body.getTraps()) {
            if (trap.getBeginUnit() == trap.getEndUnit()) continue;
            this.emit(".catch " + JasminClass.slashify(trap.getException().getName()) + " from " + (String)this.unitToLabel.get(trap.getBeginUnit()) + " to " + (String)this.unitToLabel.get(trap.getEndUnit()) + " using " + (String)this.unitToLabel.get(trap.getHandlerUnit()));
        }
        int localCount = 0;
        int[] paramSlots = new int[method.getParameterCount()];
        int thisSlot = 0;
        HashSet<Local> assignedLocals = new HashSet<Local>();
        HashMap<GroupIntPair, Integer> groupColorPairToSlot = new HashMap<GroupIntPair, Integer>(body.getLocalCount() * 2 + 1, 0.7f);
        this.localToSlot = new HashMap(body.getLocalCount() * 2 + 1, 0.7f);
        this.assignColorsToLocals(body);
        Iterator<Local> paramTypes = method.getParameterTypes();
        if (!method.isStatic()) {
            thisSlot = 0;
            ++localCount;
        }
        for (int i = 0; i < paramTypes.size(); ++i) {
            paramSlots[i] = localCount;
            localCount += JasminClass.sizeOfType((Type)paramTypes.get(i));
        }
        for (Unit u : units) {
            Stmt s2 = (Stmt)u;
            if (!(s2 instanceof IdentityStmt) || !(((IdentityStmt)s2).getLeftOp() instanceof Local)) continue;
            Local l = (Local)((IdentityStmt)s2).getLeftOp();
            IdentityRef identity = (IdentityRef)((IdentityStmt)s2).getRightOp();
            int slot = 0;
            if (identity instanceof ThisRef) {
                if (method.isStatic()) {
                    throw new RuntimeException("Attempting to use 'this' in static method");
                }
                slot = thisSlot;
            } else {
                if (!(identity instanceof ParameterRef)) continue;
                slot = paramSlots[((ParameterRef)identity).getIndex()];
            }
            Iterator<ValueBox> pair = new GroupIntPair(this.localToGroup.get(l), (Integer)this.localToColor.get(l));
            groupColorPairToSlot.put((GroupIntPair)((Object)pair), new Integer(slot));
            this.localToSlot.put(l, new Integer(slot));
            assignedLocals.add(l);
        }
        for (Local local : body.getLocals()) {
            int slot;
            if (assignedLocals.contains(local)) continue;
            GroupIntPair pair = new GroupIntPair(this.localToGroup.get(local), (Integer)this.localToColor.get(local));
            if (groupColorPairToSlot.containsKey(pair)) {
                slot = (Integer)groupColorPairToSlot.get(pair);
            } else {
                slot = localCount;
                localCount += JasminClass.sizeOfType(local.getType());
                groupColorPairToSlot.put(pair, new Integer(slot));
            }
            this.localToSlot.put(local, new Integer(slot));
            assignedLocals.add(local);
        }
        if (!Modifier.isNative(method.getModifiers()) && !Modifier.isAbstract(method.getModifiers())) {
            this.emit("    .limit stack ?");
            stackLimitIndex = this.code.size() - 1;
            this.emit("    .limit locals " + localCount);
        }
        Iterator codeIt = units.iterator();
        this.isEmittingMethodCode = true;
        this.maxStackHeight = 0;
        this.isNextGotoAJsr = false;
        while (codeIt.hasNext()) {
            boolean contFlag;
            Stmt s3;
            block32: {
                Value rvalue;
                Value lvalue;
                Stmt nextNextStmt;
                AssignStmt nextStmt;
                AssignStmt stmt;
                block34: {
                    block33: {
                        Value added;
                        AddExpr addexp;
                        List<Unit> l;
                        Stmt ns;
                        s3 = (Stmt)codeIt.next();
                        if (this.unitToLabel.containsKey(s3)) {
                            this.emit((String)this.unitToLabel.get(s3) + ":");
                        }
                        if (this.subroutineToReturnAddressSlot.containsKey(s3)) {
                            AssignStmt assignStmt = (AssignStmt)s3;
                            this.modifyStackHeight(1);
                            int slot = (Integer)this.localToSlot.get(assignStmt.getLeftOp());
                            if (slot >= 0 && slot <= 3) {
                                this.emit("astore_" + slot, -1);
                            } else {
                                this.emit("astore " + slot, -1);
                            }
                        }
                        contFlag = false;
                        if (disablePeephole || !(s3 instanceof AssignStmt)) break block32;
                        stmt = (AssignStmt)s3;
                        if (!codeIt.hasNext() || !((ns = (Stmt)stmtGraph.getSuccsOf(stmt).get(0)) instanceof AssignStmt) || (l = stmtGraph.getSuccsOf(nextStmt = (AssignStmt)ns)).size() != 1) break block32;
                        nextNextStmt = (Stmt)l.get(0);
                        lvalue = stmt.getLeftOp();
                        rvalue = stmt.getRightOp();
                        if (!(lvalue instanceof Local) || !(lvalue instanceof Local) || !nextStmt.getLeftOp().equivTo(rvalue) || !(nextStmt.getRightOp() instanceof AddExpr)) break block32;
                        boolean foundExactlyOnce = false;
                        for (ValueBox box : nextNextStmt.getUseBoxes()) {
                            if (box.getValue() != lvalue) continue;
                            if (!foundExactlyOnce) {
                                foundExactlyOnce = true;
                                continue;
                            }
                            foundExactlyOnce = false;
                            break;
                        }
                        if (!foundExactlyOnce) break block32;
                        boolean found = false;
                        for (ValueBox box : nextNextStmt.getDefBoxes()) {
                            if (!box.getValue().equivTo(rvalue)) continue;
                            found = true;
                        }
                        if (found || !(addexp = (AddExpr)nextStmt.getRightOp()).getOp1().equivTo(lvalue) && !addexp.getOp1().equivTo(rvalue) || !((added = addexp.getOp2()) instanceof IntConstant) || ((IntConstant)added).value != 1) break block32;
                        if (!addexp.getOp1().equivTo(lvalue)) break block33;
                        if (lu.getUsesOf(stmt).size() != 2 || ld.getDefsOfAt((Local)lvalue, nextStmt).size() != 1 || ld.getDefsOfAt((Local)lvalue, nextNextStmt).size() != 1) break block32;
                        this.plusPlusState = 0;
                        break block34;
                    }
                    if (lu.getUsesOf(stmt).size() != 1 || ld.getDefsOfAt((Local)lvalue, nextNextStmt).size() != 1) break block32;
                    this.plusPlusState = 10;
                }
                if (lvalue.getType() == IntType.v()) {
                    this.currentStackHeight = 0;
                    this.plusPlusValue = rvalue;
                    this.plusPlusHolder = (Local)lvalue;
                    this.plusPlusIncrementer = nextStmt;
                    this.emitStmt(nextNextStmt);
                    if (this.plusPlusHolder != null) {
                        this.emitStmt(stmt);
                        this.emitStmt(nextStmt);
                    }
                    if (this.currentStackHeight != 0) {
                        throw new RuntimeException("Stack has height " + this.currentStackHeight + " after execution of stmt: " + s3);
                    }
                    contFlag = true;
                    codeIt.next();
                    codeIt.next();
                }
            }
            if (contFlag) continue;
            this.currentStackHeight = 0;
            this.emitStmt(s3);
            if (this.currentStackHeight == 0) continue;
            throw new RuntimeException("Stack has height " + this.currentStackHeight + " after execution of stmt: " + s3);
        }
        this.isEmittingMethodCode = false;
        if (!Modifier.isNative(method.getModifiers()) && !Modifier.isAbstract(method.getModifiers())) {
            this.code.set(stackLimitIndex, "    .limit stack " + this.maxStackHeight);
        }
    }

    void emitAssignStmt(AssignStmt stmt) {
        Value lvalue = stmt.getLeftOp();
        final Value rvalue = stmt.getRightOp();
        if (lvalue instanceof Local && (rvalue instanceof AddExpr || rvalue instanceof SubExpr)) {
            Local l = (Local)lvalue;
            BinopExpr expr = (BinopExpr)rvalue;
            Value op1 = expr.getOp1();
            Value op2 = expr.getOp2();
            if (lvalue == this.plusPlusHolder) {
                this.emitValue(lvalue);
                this.plusPlusHolder = null;
                this.plusPlusState = 0;
            }
            if (l.getType().equals(IntType.v())) {
                boolean isValidCase = false;
                int x = 0;
                if (op1 == l && op2 instanceof IntConstant) {
                    x = ((IntConstant)op2).value;
                    isValidCase = true;
                } else if (expr instanceof AddExpr && op2 == l && op1 instanceof IntConstant) {
                    x = ((IntConstant)op1).value;
                    isValidCase = true;
                }
                if (isValidCase && x >= Short.MIN_VALUE && x <= Short.MAX_VALUE) {
                    this.emit("iinc " + (Integer)this.localToSlot.get(l) + " " + (expr instanceof AddExpr ? x : -x), 0);
                    return;
                }
            }
        }
        lvalue.apply(new AbstractJimpleValueSwitch(){

            @Override
            public void caseArrayRef(ArrayRef v) {
                JasminClass.this.emitValue(v.getBase());
                JasminClass.this.emitValue(v.getIndex());
                JasminClass.this.emitValue(rvalue);
                v.getType().apply(new TypeSwitch(){

                    @Override
                    public void caseArrayType(ArrayType t2) {
                        JasminClass.this.emit("aastore", -3);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t2) {
                        JasminClass.this.emit("dastore", -4);
                    }

                    @Override
                    public void caseFloatType(FloatType t2) {
                        JasminClass.this.emit("fastore", -3);
                    }

                    @Override
                    public void caseIntType(IntType t2) {
                        JasminClass.this.emit("iastore", -3);
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("lastore", -4);
                    }

                    @Override
                    public void caseRefType(RefType t2) {
                        JasminClass.this.emit("aastore", -3);
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        JasminClass.this.emit("bastore", -3);
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        JasminClass.this.emit("bastore", -3);
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        JasminClass.this.emit("castore", -3);
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        JasminClass.this.emit("sastore", -3);
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("Invalid type: " + t2);
                    }
                });
            }

            @Override
            public void caseInstanceFieldRef(InstanceFieldRef v) {
                JasminClass.this.emitValue(v.getBase());
                JasminClass.this.emitValue(rvalue);
                JasminClass.this.emit("putfield " + AbstractJasminClass.slashify(v.getFieldRef().declaringClass().getName()) + "/" + v.getFieldRef().name() + " " + AbstractJasminClass.jasminDescriptorOf(v.getFieldRef().type()), -1 + -AbstractJasminClass.sizeOfType(v.getFieldRef().type()));
            }

            @Override
            public void caseLocal(Local v) {
                final int slot = (Integer)JasminClass.this.localToSlot.get(v);
                v.getType().apply(new TypeSwitch(){

                    private void handleIntegerType(IntegerType t2) {
                        JasminClass.this.emitValue(rvalue);
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("istore_" + slot, -1);
                        } else {
                            JasminClass.this.emit("istore " + slot, -1);
                        }
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        this.handleIntegerType(t2);
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        this.handleIntegerType(t2);
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        this.handleIntegerType(t2);
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        this.handleIntegerType(t2);
                    }

                    @Override
                    public void caseIntType(IntType t2) {
                        this.handleIntegerType(t2);
                    }

                    @Override
                    public void caseArrayType(ArrayType t2) {
                        JasminClass.this.emitValue(rvalue);
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("astore_" + slot, -1);
                        } else {
                            JasminClass.this.emit("astore " + slot, -1);
                        }
                    }

                    @Override
                    public void caseDoubleType(DoubleType t2) {
                        JasminClass.this.emitValue(rvalue);
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("dstore_" + slot, -2);
                        } else {
                            JasminClass.this.emit("dstore " + slot, -2);
                        }
                    }

                    @Override
                    public void caseFloatType(FloatType t2) {
                        JasminClass.this.emitValue(rvalue);
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("fstore_" + slot, -1);
                        } else {
                            JasminClass.this.emit("fstore " + slot, -1);
                        }
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emitValue(rvalue);
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("lstore_" + slot, -2);
                        } else {
                            JasminClass.this.emit("lstore " + slot, -2);
                        }
                    }

                    @Override
                    public void caseRefType(RefType t2) {
                        JasminClass.this.emitValue(rvalue);
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("astore_" + slot, -1);
                        } else {
                            JasminClass.this.emit("astore " + slot, -1);
                        }
                    }

                    @Override
                    public void caseStmtAddressType(StmtAddressType t2) {
                        JasminClass.this.isNextGotoAJsr = true;
                        JasminClass.this.returnAddressSlot = slot;
                    }

                    @Override
                    public void caseNullType(NullType t2) {
                        JasminClass.this.emitValue(rvalue);
                        if (slot >= 0 && slot <= 3) {
                            JasminClass.this.emit("astore_" + slot, -1);
                        } else {
                            JasminClass.this.emit("astore " + slot, -1);
                        }
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("Invalid local type: " + t2);
                    }
                });
            }

            @Override
            public void caseStaticFieldRef(StaticFieldRef v) {
                SootFieldRef field = v.getFieldRef();
                JasminClass.this.emitValue(rvalue);
                JasminClass.this.emit("putstatic " + AbstractJasminClass.slashify(field.declaringClass().getName()) + "/" + field.name() + " " + AbstractJasminClass.jasminDescriptorOf(field.type()), -AbstractJasminClass.sizeOfType(v.getFieldRef().type()));
            }
        });
    }

    void emitIfStmt(IfStmt stmt) {
        Value cond = stmt.getCondition();
        final Value op1 = ((BinopExpr)cond).getOp1();
        Value op2 = ((BinopExpr)cond).getOp2();
        final String label = (String)this.unitToLabel.get(stmt.getTarget());
        if (op2 instanceof NullConstant || op1 instanceof NullConstant) {
            if (op2 instanceof NullConstant) {
                this.emitValue(op1);
            } else {
                this.emitValue(op2);
            }
            if (cond instanceof EqExpr) {
                this.emit("ifnull " + label, -1);
            } else if (cond instanceof NeExpr) {
                this.emit("ifnonnull " + label, -1);
            } else {
                throw new RuntimeException("invalid condition");
            }
            return;
        }
        if (op2 instanceof IntConstant && ((IntConstant)op2).value == 0) {
            this.emitValue(op1);
            cond.apply(new AbstractJimpleValueSwitch(){

                @Override
                public void caseEqExpr(EqExpr expr) {
                    JasminClass.this.emit("ifeq " + label, -1);
                }

                @Override
                public void caseNeExpr(NeExpr expr) {
                    JasminClass.this.emit("ifne " + label, -1);
                }

                @Override
                public void caseLtExpr(LtExpr expr) {
                    JasminClass.this.emit("iflt " + label, -1);
                }

                @Override
                public void caseLeExpr(LeExpr expr) {
                    JasminClass.this.emit("ifle " + label, -1);
                }

                @Override
                public void caseGtExpr(GtExpr expr) {
                    JasminClass.this.emit("ifgt " + label, -1);
                }

                @Override
                public void caseGeExpr(GeExpr expr) {
                    JasminClass.this.emit("ifge " + label, -1);
                }
            });
            return;
        }
        if (op1 instanceof IntConstant && ((IntConstant)op1).value == 0) {
            this.emitValue(op2);
            cond.apply(new AbstractJimpleValueSwitch(){

                @Override
                public void caseEqExpr(EqExpr expr) {
                    JasminClass.this.emit("ifeq " + label, -1);
                }

                @Override
                public void caseNeExpr(NeExpr expr) {
                    JasminClass.this.emit("ifne " + label, -1);
                }

                @Override
                public void caseLtExpr(LtExpr expr) {
                    JasminClass.this.emit("ifgt " + label, -1);
                }

                @Override
                public void caseLeExpr(LeExpr expr) {
                    JasminClass.this.emit("ifge " + label, -1);
                }

                @Override
                public void caseGtExpr(GtExpr expr) {
                    JasminClass.this.emit("iflt " + label, -1);
                }

                @Override
                public void caseGeExpr(GeExpr expr) {
                    JasminClass.this.emit("ifle " + label, -1);
                }
            });
            return;
        }
        this.emitValue(op1);
        this.emitValue(op2);
        cond.apply(new AbstractJimpleValueSwitch(){

            @Override
            public void caseEqExpr(EqExpr expr) {
                op1.getType().apply(new TypeSwitch(){

                    @Override
                    public void caseIntType(IntType t2) {
                        JasminClass.this.emit("if_icmpeq " + label, -2);
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        JasminClass.this.emit("if_icmpeq " + label, -2);
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        JasminClass.this.emit("if_icmpeq " + label, -2);
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        JasminClass.this.emit("if_icmpeq " + label, -2);
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        JasminClass.this.emit("if_icmpeq " + label, -2);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t2) {
                        JasminClass.this.emit("dcmpg", -3);
                        JasminClass.this.emit("ifeq " + label, -1);
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("lcmp", -3);
                        JasminClass.this.emit("ifeq " + label, -1);
                    }

                    @Override
                    public void caseFloatType(FloatType t2) {
                        JasminClass.this.emit("fcmpg", -1);
                        JasminClass.this.emit("ifeq " + label, -1);
                    }

                    @Override
                    public void caseArrayType(ArrayType t2) {
                        JasminClass.this.emit("if_acmpeq " + label, -2);
                    }

                    @Override
                    public void caseRefType(RefType t2) {
                        JasminClass.this.emit("if_acmpeq " + label, -2);
                    }

                    @Override
                    public void caseNullType(NullType t2) {
                        JasminClass.this.emit("if_acmpeq " + label, -2);
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseNeExpr(NeExpr expr) {
                op1.getType().apply(new TypeSwitch(){

                    @Override
                    public void caseIntType(IntType t2) {
                        JasminClass.this.emit("if_icmpne " + label, -2);
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        JasminClass.this.emit("if_icmpne " + label, -2);
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        JasminClass.this.emit("if_icmpne " + label, -2);
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        JasminClass.this.emit("if_icmpne " + label, -2);
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        JasminClass.this.emit("if_icmpne " + label, -2);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t2) {
                        JasminClass.this.emit("dcmpg", -3);
                        JasminClass.this.emit("ifne " + label, -1);
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("lcmp", -3);
                        JasminClass.this.emit("ifne " + label, -1);
                    }

                    @Override
                    public void caseFloatType(FloatType t2) {
                        JasminClass.this.emit("fcmpg", -1);
                        JasminClass.this.emit("ifne " + label, -1);
                    }

                    @Override
                    public void caseArrayType(ArrayType t2) {
                        JasminClass.this.emit("if_acmpne " + label, -2);
                    }

                    @Override
                    public void caseRefType(RefType t2) {
                        JasminClass.this.emit("if_acmpne " + label, -2);
                    }

                    @Override
                    public void caseNullType(NullType t2) {
                        JasminClass.this.emit("if_acmpne " + label, -2);
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("invalid type for NeExpr: " + t2);
                    }
                });
            }

            @Override
            public void caseLtExpr(LtExpr expr) {
                op1.getType().apply(new TypeSwitch(){

                    @Override
                    public void caseIntType(IntType t2) {
                        JasminClass.this.emit("if_icmplt " + label, -2);
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        JasminClass.this.emit("if_icmplt " + label, -2);
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        JasminClass.this.emit("if_icmplt " + label, -2);
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        JasminClass.this.emit("if_icmplt " + label, -2);
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        JasminClass.this.emit("if_icmplt " + label, -2);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t2) {
                        JasminClass.this.emit("dcmpg", -3);
                        JasminClass.this.emit("iflt " + label, -1);
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("lcmp", -3);
                        JasminClass.this.emit("iflt " + label, -1);
                    }

                    @Override
                    public void caseFloatType(FloatType t2) {
                        JasminClass.this.emit("fcmpg", -1);
                        JasminClass.this.emit("iflt " + label, -1);
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseLeExpr(LeExpr expr) {
                op1.getType().apply(new TypeSwitch(){

                    @Override
                    public void caseIntType(IntType t2) {
                        JasminClass.this.emit("if_icmple " + label, -2);
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        JasminClass.this.emit("if_icmple " + label, -2);
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        JasminClass.this.emit("if_icmple " + label, -2);
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        JasminClass.this.emit("if_icmple " + label, -2);
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        JasminClass.this.emit("if_icmple " + label, -2);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t2) {
                        JasminClass.this.emit("dcmpg", -3);
                        JasminClass.this.emit("ifle " + label, -1);
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("lcmp", -3);
                        JasminClass.this.emit("ifle " + label, -1);
                    }

                    @Override
                    public void caseFloatType(FloatType t2) {
                        JasminClass.this.emit("fcmpg", -1);
                        JasminClass.this.emit("ifle " + label, -1);
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseGtExpr(GtExpr expr) {
                op1.getType().apply(new TypeSwitch(){

                    @Override
                    public void caseIntType(IntType t2) {
                        JasminClass.this.emit("if_icmpgt " + label, -2);
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        JasminClass.this.emit("if_icmpgt " + label, -2);
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        JasminClass.this.emit("if_icmpgt " + label, -2);
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        JasminClass.this.emit("if_icmpgt " + label, -2);
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        JasminClass.this.emit("if_icmpgt " + label, -2);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t2) {
                        JasminClass.this.emit("dcmpg", -3);
                        JasminClass.this.emit("ifgt " + label, -1);
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("lcmp", -3);
                        JasminClass.this.emit("ifgt " + label, -1);
                    }

                    @Override
                    public void caseFloatType(FloatType t2) {
                        JasminClass.this.emit("fcmpg", -1);
                        JasminClass.this.emit("ifgt " + label, -1);
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseGeExpr(GeExpr expr) {
                op1.getType().apply(new TypeSwitch(){

                    @Override
                    public void caseIntType(IntType t2) {
                        JasminClass.this.emit("if_icmpge " + label, -2);
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        JasminClass.this.emit("if_icmpge " + label, -2);
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        JasminClass.this.emit("if_icmpge " + label, -2);
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        JasminClass.this.emit("if_icmpge " + label, -2);
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        JasminClass.this.emit("if_icmpge " + label, -2);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t2) {
                        JasminClass.this.emit("dcmpg", -3);
                        JasminClass.this.emit("ifge " + label, -1);
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("lcmp", -3);
                        JasminClass.this.emit("ifge " + label, -1);
                    }

                    @Override
                    public void caseFloatType(FloatType t2) {
                        JasminClass.this.emit("fcmpg", -1);
                        JasminClass.this.emit("ifge " + label, -1);
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }
        });
    }

    void emitStmt(Stmt stmt) {
        LineNumberTag lnTag = (LineNumberTag)stmt.getTag("LineNumberTag");
        if (lnTag != null) {
            this.emit(".line " + lnTag.getLineNumber());
        }
        stmt.apply(new AbstractStmtSwitch(){

            @Override
            public void caseAssignStmt(AssignStmt s2) {
                JasminClass.this.emitAssignStmt(s2);
            }

            @Override
            public void caseIdentityStmt(IdentityStmt s2) {
                if (s2.getRightOp() instanceof CaughtExceptionRef && s2.getLeftOp() instanceof Local) {
                    int slot = (Integer)JasminClass.this.localToSlot.get(s2.getLeftOp());
                    JasminClass.this.modifyStackHeight(1);
                    if (slot >= 0 && slot <= 3) {
                        JasminClass.this.emit("astore_" + slot, -1);
                    } else {
                        JasminClass.this.emit("astore " + slot, -1);
                    }
                }
            }

            @Override
            public void caseBreakpointStmt(BreakpointStmt s2) {
                JasminClass.this.emit("breakpoint", 0);
            }

            @Override
            public void caseInvokeStmt(InvokeStmt s2) {
                JasminClass.this.emitValue(s2.getInvokeExpr());
                Type returnType = s2.getInvokeExpr().getMethodRef().returnType();
                if (!returnType.equals(VoidType.v())) {
                    if (AbstractJasminClass.sizeOfType(returnType) == 1) {
                        JasminClass.this.emit("pop", -1);
                    } else {
                        JasminClass.this.emit("pop2", -2);
                    }
                }
            }

            @Override
            public void caseEnterMonitorStmt(EnterMonitorStmt s2) {
                JasminClass.this.emitValue(s2.getOp());
                JasminClass.this.emit("monitorenter", -1);
            }

            @Override
            public void caseExitMonitorStmt(ExitMonitorStmt s2) {
                JasminClass.this.emitValue(s2.getOp());
                JasminClass.this.emit("monitorexit", -1);
            }

            @Override
            public void caseGotoStmt(GotoStmt s2) {
                if (JasminClass.this.isNextGotoAJsr) {
                    JasminClass.this.emit("jsr " + (String)JasminClass.this.unitToLabel.get(s2.getTarget()));
                    JasminClass.this.isNextGotoAJsr = false;
                    JasminClass.this.subroutineToReturnAddressSlot.put(s2.getTarget(), new Integer(JasminClass.this.returnAddressSlot));
                } else {
                    JasminClass.this.emit("goto " + (String)JasminClass.this.unitToLabel.get(s2.getTarget()));
                }
            }

            @Override
            public void caseIfStmt(IfStmt s2) {
                JasminClass.this.emitIfStmt(s2);
            }

            @Override
            public void caseLookupSwitchStmt(LookupSwitchStmt s2) {
                JasminClass.this.emitValue(s2.getKey());
                JasminClass.this.emit("lookupswitch", -1);
                List<IntConstant> lookupValues = s2.getLookupValues();
                List<Unit> targets = s2.getTargets();
                for (int i = 0; i < lookupValues.size(); ++i) {
                    JasminClass.this.emit("  " + lookupValues.get(i) + " : " + (String)JasminClass.this.unitToLabel.get(targets.get(i)));
                }
                JasminClass.this.emit("  default : " + (String)JasminClass.this.unitToLabel.get(s2.getDefaultTarget()));
            }

            @Override
            public void caseNopStmt(NopStmt s2) {
                JasminClass.this.emit("nop", 0);
            }

            @Override
            public void caseRetStmt(RetStmt s2) {
                JasminClass.this.emit("ret " + JasminClass.this.localToSlot.get(s2.getStmtAddress()), 0);
            }

            @Override
            public void caseReturnStmt(ReturnStmt s2) {
                JasminClass.this.emitValue(s2.getOp());
                Value returnValue = s2.getOp();
                returnValue.getType().apply(new TypeSwitch(){

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("invalid return type " + t2.toString());
                    }

                    @Override
                    public void caseDoubleType(DoubleType t2) {
                        JasminClass.this.emit("dreturn", -2);
                    }

                    @Override
                    public void caseFloatType(FloatType t2) {
                        JasminClass.this.emit("freturn", -1);
                    }

                    @Override
                    public void caseIntType(IntType t2) {
                        JasminClass.this.emit("ireturn", -1);
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        JasminClass.this.emit("ireturn", -1);
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        JasminClass.this.emit("ireturn", -1);
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        JasminClass.this.emit("ireturn", -1);
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        JasminClass.this.emit("ireturn", -1);
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("lreturn", -2);
                    }

                    @Override
                    public void caseArrayType(ArrayType t2) {
                        JasminClass.this.emit("areturn", -1);
                    }

                    @Override
                    public void caseRefType(RefType t2) {
                        JasminClass.this.emit("areturn", -1);
                    }

                    @Override
                    public void caseNullType(NullType t2) {
                        JasminClass.this.emit("areturn", -1);
                    }
                });
            }

            @Override
            public void caseReturnVoidStmt(ReturnVoidStmt s2) {
                JasminClass.this.emit("return", 0);
            }

            @Override
            public void caseTableSwitchStmt(TableSwitchStmt s2) {
                JasminClass.this.emitValue(s2.getKey());
                JasminClass.this.emit("tableswitch " + s2.getLowIndex() + " ; high = " + s2.getHighIndex(), -1);
                List<Unit> targets = s2.getTargets();
                for (int i = 0; i < targets.size(); ++i) {
                    JasminClass.this.emit("  " + (String)JasminClass.this.unitToLabel.get(targets.get(i)));
                }
                JasminClass.this.emit("default : " + (String)JasminClass.this.unitToLabel.get(s2.getDefaultTarget()));
            }

            @Override
            public void caseThrowStmt(ThrowStmt s2) {
                JasminClass.this.emitValue(s2.getOp());
                JasminClass.this.emit("athrow", -1);
            }
        });
    }

    void emitLocal(Local v) {
        final int slot = (Integer)this.localToSlot.get(v);
        final Local vAlias = v;
        v.getType().apply(new TypeSwitch(){

            @Override
            public void caseArrayType(ArrayType t2) {
                if (slot >= 0 && slot <= 3) {
                    JasminClass.this.emit("aload_" + slot, 1);
                } else {
                    JasminClass.this.emit("aload " + slot, 1);
                }
            }

            @Override
            public void defaultCase(Type t2) {
                throw new RuntimeException("invalid local type to load" + t2);
            }

            @Override
            public void caseDoubleType(DoubleType t2) {
                if (slot >= 0 && slot <= 3) {
                    JasminClass.this.emit("dload_" + slot, 2);
                } else {
                    JasminClass.this.emit("dload " + slot, 2);
                }
            }

            @Override
            public void caseFloatType(FloatType t2) {
                if (slot >= 0 && slot <= 3) {
                    JasminClass.this.emit("fload_" + slot, 1);
                } else {
                    JasminClass.this.emit("fload " + slot, 1);
                }
            }

            @Override
            public void caseBooleanType(BooleanType t2) {
                this.handleIntegerType(t2);
            }

            @Override
            public void caseByteType(ByteType t2) {
                this.handleIntegerType(t2);
            }

            @Override
            public void caseShortType(ShortType t2) {
                this.handleIntegerType(t2);
            }

            @Override
            public void caseCharType(CharType t2) {
                this.handleIntegerType(t2);
            }

            @Override
            public void caseIntType(IntType t2) {
                this.handleIntegerType(t2);
            }

            public void handleIntegerType(IntegerType t2) {
                if (vAlias.equals(JasminClass.this.plusPlusHolder)) {
                    switch (JasminClass.this.plusPlusState) {
                        case 0: {
                            JasminClass.this.plusPlusState = 1;
                            JasminClass.this.emitStmt(JasminClass.this.plusPlusIncrementer);
                            int diff = JasminClass.this.plusPlusHeight - JasminClass.this.currentStackHeight + 1;
                            if (diff > 0) {
                                JasminClass.this.code.set(JasminClass.this.plusPlusPlace, "    dup_x" + diff);
                            }
                            JasminClass.this.plusPlusHolder = null;
                            return;
                        }
                        case 1: {
                            JasminClass.this.plusPlusHeight = JasminClass.this.currentStackHeight;
                            JasminClass.this.plusPlusHolder = null;
                            JasminClass.this.emitValue(JasminClass.this.plusPlusValue);
                            JasminClass.this.plusPlusPlace = JasminClass.this.code.size();
                            JasminClass.this.emit("dup", 1);
                            return;
                        }
                        case 10: {
                            JasminClass.this.plusPlusState = 11;
                            JasminClass.this.plusPlusHolder = (Local)JasminClass.this.plusPlusValue;
                            JasminClass.this.emitStmt(JasminClass.this.plusPlusIncrementer);
                            int diff = JasminClass.this.plusPlusHeight - JasminClass.this.currentStackHeight + 1;
                            if (diff > 0 && JasminClass.this.plusPlusState == 11) {
                                JasminClass.this.code.set(JasminClass.this.plusPlusPlace, "    dup_x" + diff);
                            }
                            JasminClass.this.plusPlusHolder = null;
                            return;
                        }
                        case 11: {
                            JasminClass.this.plusPlusHeight = JasminClass.this.currentStackHeight;
                            JasminClass.this.plusPlusHolder = null;
                            JasminClass.this.emitValue(JasminClass.this.plusPlusValue);
                            if (JasminClass.this.plusPlusState != 11) {
                                JasminClass.this.emit("dup", 1);
                            }
                            JasminClass.this.plusPlusPlace = JasminClass.this.code.size();
                            return;
                        }
                    }
                }
                if (slot >= 0 && slot <= 3) {
                    JasminClass.this.emit("iload_" + slot, 1);
                } else {
                    JasminClass.this.emit("iload " + slot, 1);
                }
            }

            @Override
            public void caseLongType(LongType t2) {
                if (slot >= 0 && slot <= 3) {
                    JasminClass.this.emit("lload_" + slot, 2);
                } else {
                    JasminClass.this.emit("lload " + slot, 2);
                }
            }

            @Override
            public void caseRefType(RefType t2) {
                if (slot >= 0 && slot <= 3) {
                    JasminClass.this.emit("aload_" + slot, 1);
                } else {
                    JasminClass.this.emit("aload " + slot, 1);
                }
            }

            @Override
            public void caseNullType(NullType t2) {
                if (slot >= 0 && slot <= 3) {
                    JasminClass.this.emit("aload_" + slot, 1);
                } else {
                    JasminClass.this.emit("aload " + slot, 1);
                }
            }
        });
    }

    void emitValue(Value value) {
        value.apply(new AbstractGrimpValueSwitch(){

            @Override
            public void caseAddExpr(AddExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getType().apply(new TypeSwitch(){

                    private void handleIntCase() {
                        JasminClass.this.emit("iadd", -1);
                    }

                    @Override
                    public void caseIntType(IntType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("ladd", -2);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t2) {
                        JasminClass.this.emit("dadd", -2);
                    }

                    @Override
                    public void caseFloatType(FloatType t2) {
                        JasminClass.this.emit("fadd", -1);
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("Invalid argument type for add");
                    }
                });
            }

            @Override
            public void caseAndExpr(AndExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getType().apply(new TypeSwitch(){

                    private void handleIntCase() {
                        JasminClass.this.emit("iand", -1);
                    }

                    @Override
                    public void caseIntType(IntType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("land", -2);
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("Invalid argument type for and");
                    }
                });
            }

            @Override
            public void caseArrayRef(ArrayRef v) {
                JasminClass.this.emitValue(v.getBase());
                JasminClass.this.emitValue(v.getIndex());
                v.getType().apply(new TypeSwitch(){

                    @Override
                    public void caseArrayType(ArrayType ty) {
                        JasminClass.this.emit("aaload", -1);
                    }

                    @Override
                    public void caseBooleanType(BooleanType ty) {
                        JasminClass.this.emit("baload", -1);
                    }

                    @Override
                    public void caseByteType(ByteType ty) {
                        JasminClass.this.emit("baload", -1);
                    }

                    @Override
                    public void caseCharType(CharType ty) {
                        JasminClass.this.emit("caload", -1);
                    }

                    @Override
                    public void defaultCase(Type ty) {
                        throw new RuntimeException("invalid base type");
                    }

                    @Override
                    public void caseDoubleType(DoubleType ty) {
                        JasminClass.this.emit("daload", 0);
                    }

                    @Override
                    public void caseFloatType(FloatType ty) {
                        JasminClass.this.emit("faload", -1);
                    }

                    @Override
                    public void caseIntType(IntType ty) {
                        JasminClass.this.emit("iaload", -1);
                    }

                    @Override
                    public void caseLongType(LongType ty) {
                        JasminClass.this.emit("laload", 0);
                    }

                    @Override
                    public void caseNullType(NullType ty) {
                        JasminClass.this.emit("aaload", -1);
                    }

                    @Override
                    public void caseRefType(RefType ty) {
                        JasminClass.this.emit("aaload", -1);
                    }

                    @Override
                    public void caseShortType(ShortType ty) {
                        JasminClass.this.emit("saload", -1);
                    }
                });
            }

            @Override
            public void caseCastExpr(final CastExpr v) {
                final Type toType = v.getCastType();
                final Type fromType = v.getOp().getType();
                JasminClass.this.emitValue(v.getOp());
                if (toType instanceof RefType) {
                    JasminClass.this.emit("checkcast " + AbstractJasminClass.slashify(toType.toString()), 0);
                } else if (toType instanceof ArrayType) {
                    JasminClass.this.emit("checkcast " + AbstractJasminClass.jasminDescriptorOf(toType), 0);
                } else {
                    fromType.apply(new TypeSwitch(){

                        @Override
                        public void defaultCase(Type ty) {
                            throw new RuntimeException("invalid fromType " + fromType);
                        }

                        @Override
                        public void caseDoubleType(DoubleType ty) {
                            if (toType.equals(IntType.v())) {
                                JasminClass.this.emit("d2i", -1);
                            } else if (toType.equals(LongType.v())) {
                                JasminClass.this.emit("d2l", 0);
                            } else if (toType.equals(FloatType.v())) {
                                JasminClass.this.emit("d2f", -1);
                            } else {
                                throw new RuntimeException("invalid toType from double: " + toType);
                            }
                        }

                        @Override
                        public void caseFloatType(FloatType ty) {
                            if (toType.equals(IntType.v())) {
                                JasminClass.this.emit("f2i", 0);
                            } else if (toType.equals(LongType.v())) {
                                JasminClass.this.emit("f2l", 1);
                            } else if (toType.equals(DoubleType.v())) {
                                JasminClass.this.emit("f2d", 1);
                            } else {
                                throw new RuntimeException("invalid toType from float: " + toType);
                            }
                        }

                        @Override
                        public void caseIntType(IntType ty) {
                            this.emitIntToTypeCast();
                        }

                        @Override
                        public void caseBooleanType(BooleanType ty) {
                            this.emitIntToTypeCast();
                        }

                        @Override
                        public void caseByteType(ByteType ty) {
                            this.emitIntToTypeCast();
                        }

                        @Override
                        public void caseCharType(CharType ty) {
                            this.emitIntToTypeCast();
                        }

                        @Override
                        public void caseShortType(ShortType ty) {
                            this.emitIntToTypeCast();
                        }

                        private void emitIntToTypeCast() {
                            if (toType.equals(ByteType.v())) {
                                JasminClass.this.emit("i2b", 0);
                            } else if (toType.equals(CharType.v())) {
                                JasminClass.this.emit("i2c", 0);
                            } else if (toType.equals(ShortType.v())) {
                                JasminClass.this.emit("i2s", 0);
                            } else if (toType.equals(FloatType.v())) {
                                JasminClass.this.emit("i2f", 0);
                            } else if (toType.equals(LongType.v())) {
                                JasminClass.this.emit("i2l", 1);
                            } else if (toType.equals(DoubleType.v())) {
                                JasminClass.this.emit("i2d", 1);
                            } else if (!toType.equals(IntType.v()) && !toType.equals(BooleanType.v())) {
                                throw new RuntimeException("invalid toType from int: " + toType + " " + v.toString());
                            }
                        }

                        @Override
                        public void caseLongType(LongType ty) {
                            if (toType.equals(IntType.v())) {
                                JasminClass.this.emit("l2i", -1);
                            } else if (toType.equals(FloatType.v())) {
                                JasminClass.this.emit("l2f", -1);
                            } else if (toType.equals(DoubleType.v())) {
                                JasminClass.this.emit("l2d", 0);
                            } else if (toType.equals(ByteType.v())) {
                                JasminClass.this.emit("l2i", -1);
                                this.emitIntToTypeCast();
                            } else if (toType.equals(ShortType.v())) {
                                JasminClass.this.emit("l2i", -1);
                                this.emitIntToTypeCast();
                            } else if (toType.equals(CharType.v())) {
                                JasminClass.this.emit("l2i", -1);
                                this.emitIntToTypeCast();
                            } else if (toType.equals(BooleanType.v())) {
                                JasminClass.this.emit("l2i", -1);
                                this.emitIntToTypeCast();
                            } else {
                                throw new RuntimeException("invalid toType from long: " + toType);
                            }
                        }
                    });
                }
            }

            @Override
            public void caseCmpExpr(CmpExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                JasminClass.this.emit("lcmp", -3);
            }

            @Override
            public void caseCmpgExpr(CmpgExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                if (v.getOp1().getType().equals(FloatType.v())) {
                    JasminClass.this.emit("fcmpg", -1);
                } else {
                    JasminClass.this.emit("dcmpg", -3);
                }
            }

            @Override
            public void caseCmplExpr(CmplExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                if (v.getOp1().getType().equals(FloatType.v())) {
                    JasminClass.this.emit("fcmpl", -1);
                } else {
                    JasminClass.this.emit("dcmpl", -3);
                }
            }

            @Override
            public void caseDivExpr(DivExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getType().apply(new TypeSwitch(){

                    private void handleIntCase() {
                        JasminClass.this.emit("idiv", -1);
                    }

                    @Override
                    public void caseIntType(IntType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("ldiv", -2);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t2) {
                        JasminClass.this.emit("ddiv", -2);
                    }

                    @Override
                    public void caseFloatType(FloatType t2) {
                        JasminClass.this.emit("fdiv", -1);
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("Invalid argument type for div");
                    }
                });
            }

            @Override
            public void caseDoubleConstant(DoubleConstant v) {
                if (v.value == 0.0 && 1.0 / v.value > 0.0) {
                    JasminClass.this.emit("dconst_0", 2);
                } else if (v.value == 1.0) {
                    JasminClass.this.emit("dconst_1", 2);
                } else {
                    String s2 = JasminClass.this.doubleToString(v);
                    JasminClass.this.emit("ldc2_w " + s2, 2);
                }
            }

            @Override
            public void caseFloatConstant(FloatConstant v) {
                if (v.value == 0.0f && 1.0f / v.value > 0.0f) {
                    JasminClass.this.emit("fconst_0", 1);
                } else if (v.value == 1.0f) {
                    JasminClass.this.emit("fconst_1", 1);
                } else if (v.value == 2.0f) {
                    JasminClass.this.emit("fconst_2", 1);
                } else {
                    String s2 = JasminClass.this.floatToString(v);
                    JasminClass.this.emit("ldc " + s2, 1);
                }
            }

            @Override
            public void caseInstanceFieldRef(InstanceFieldRef v) {
                JasminClass.this.emitValue(v.getBase());
                JasminClass.this.emit("getfield " + AbstractJasminClass.slashify(v.getFieldRef().declaringClass().getName()) + "/" + v.getFieldRef().name() + " " + AbstractJasminClass.jasminDescriptorOf(v.getFieldRef().type()), -1 + AbstractJasminClass.sizeOfType(v.getFieldRef().type()));
            }

            @Override
            public void caseInstanceOfExpr(InstanceOfExpr v) {
                JasminClass.this.emitValue(v.getOp());
                Type checkType = v.getCheckType();
                if (checkType instanceof RefType) {
                    JasminClass.this.emit("instanceof " + AbstractJasminClass.slashify(checkType.toString()), 0);
                } else if (checkType instanceof ArrayType) {
                    JasminClass.this.emit("instanceof " + AbstractJasminClass.jasminDescriptorOf(checkType), 0);
                }
            }

            @Override
            public void caseIntConstant(IntConstant v) {
                if (v.value == -1) {
                    JasminClass.this.emit("iconst_m1", 1);
                } else if (v.value >= 0 && v.value <= 5) {
                    JasminClass.this.emit("iconst_" + v.value, 1);
                } else if (v.value >= -128 && v.value <= 127) {
                    JasminClass.this.emit("bipush " + v.value, 1);
                } else if (v.value >= Short.MIN_VALUE && v.value <= Short.MAX_VALUE) {
                    JasminClass.this.emit("sipush " + v.value, 1);
                } else {
                    JasminClass.this.emit("ldc " + v.toString(), 1);
                }
            }

            @Override
            public void caseInterfaceInvokeExpr(InterfaceInvokeExpr v) {
                SootMethodRef m4 = v.getMethodRef();
                JasminClass.this.emitValue(v.getBase());
                for (int i = 0; i < m4.parameterTypes().size(); ++i) {
                    JasminClass.this.emitValue(v.getArg(i));
                }
                JasminClass.this.emit("invokeinterface " + AbstractJasminClass.slashify(m4.declaringClass().getName()) + "/" + m4.name() + AbstractJasminClass.jasminDescriptorOf(m4) + " " + (AbstractJasminClass.argCountOf(m4) + 1), -(AbstractJasminClass.argCountOf(m4) + 1) + AbstractJasminClass.sizeOfType(m4.returnType()));
            }

            @Override
            public void caseLengthExpr(LengthExpr v) {
                JasminClass.this.emitValue(v.getOp());
                JasminClass.this.emit("arraylength", 0);
            }

            @Override
            public void caseLocal(Local v) {
                JasminClass.this.emitLocal(v);
            }

            @Override
            public void caseLongConstant(LongConstant v) {
                if (v.value == 0L) {
                    JasminClass.this.emit("lconst_0", 2);
                } else if (v.value == 1L) {
                    JasminClass.this.emit("lconst_1", 2);
                } else {
                    JasminClass.this.emit("ldc2_w " + v.toString(), 2);
                }
            }

            @Override
            public void caseMulExpr(MulExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getType().apply(new TypeSwitch(){

                    private void handleIntCase() {
                        JasminClass.this.emit("imul", -1);
                    }

                    @Override
                    public void caseIntType(IntType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("lmul", -2);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t2) {
                        JasminClass.this.emit("dmul", -2);
                    }

                    @Override
                    public void caseFloatType(FloatType t2) {
                        JasminClass.this.emit("fmul", -1);
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("Invalid argument type for mul");
                    }
                });
            }

            @Override
            public void caseLtExpr(LtExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getOp1().getType().apply(new TypeSwitch(){

                    @Override
                    public void caseDoubleType(DoubleType t2) {
                        JasminClass.this.emit("dcmpg", -3);
                        JasminClass.this.emitBooleanBranch("iflt");
                    }

                    @Override
                    public void caseFloatType(FloatType t2) {
                        JasminClass.this.emit("fcmpg", -1);
                        JasminClass.this.emitBooleanBranch("iflt");
                    }

                    private void handleIntCase() {
                        JasminClass.this.emit("if_icmplt", -2);
                    }

                    @Override
                    public void caseIntType(IntType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("lcmp", -3);
                        JasminClass.this.emitBooleanBranch("iflt");
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseLeExpr(LeExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getOp1().getType().apply(new TypeSwitch(){

                    @Override
                    public void caseDoubleType(DoubleType t2) {
                        JasminClass.this.emit("dcmpg", -3);
                        JasminClass.this.emitBooleanBranch("ifle");
                    }

                    @Override
                    public void caseFloatType(FloatType t2) {
                        JasminClass.this.emit("fcmpg", -1);
                        JasminClass.this.emitBooleanBranch("ifle");
                    }

                    private void handleIntCase() {
                        JasminClass.this.emit("if_icmple", -2);
                    }

                    @Override
                    public void caseIntType(IntType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("lcmp", -3);
                        JasminClass.this.emitBooleanBranch("ifle");
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseGtExpr(GtExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getOp1().getType().apply(new TypeSwitch(){

                    @Override
                    public void caseDoubleType(DoubleType t2) {
                        JasminClass.this.emit("dcmpg", -3);
                        JasminClass.this.emitBooleanBranch("ifgt");
                    }

                    @Override
                    public void caseFloatType(FloatType t2) {
                        JasminClass.this.emit("fcmpg", -1);
                        JasminClass.this.emitBooleanBranch("ifgt");
                    }

                    private void handleIntCase() {
                        JasminClass.this.emit("if_icmpgt", -2);
                    }

                    @Override
                    public void caseIntType(IntType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("lcmp", -3);
                        JasminClass.this.emitBooleanBranch("ifgt");
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseGeExpr(GeExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getOp1().getType().apply(new TypeSwitch(){

                    @Override
                    public void caseDoubleType(DoubleType t2) {
                        JasminClass.this.emit("dcmpg", -3);
                        JasminClass.this.emitBooleanBranch("ifge");
                    }

                    @Override
                    public void caseFloatType(FloatType t2) {
                        JasminClass.this.emit("fcmpg", -1);
                        JasminClass.this.emitBooleanBranch("ifge");
                    }

                    private void handleIntCase() {
                        JasminClass.this.emit("if_icmpge", -2);
                    }

                    @Override
                    public void caseIntType(IntType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("lcmp", -3);
                        JasminClass.this.emitBooleanBranch("ifge");
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseNeExpr(NeExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getOp1().getType().apply(new TypeSwitch(){

                    @Override
                    public void caseDoubleType(DoubleType t2) {
                        JasminClass.this.emit("dcmpg", -3);
                        JasminClass.this.emit("iconst_0", 1);
                        JasminClass.this.emitBooleanBranch("if_icmpne");
                    }

                    @Override
                    public void caseFloatType(FloatType t2) {
                        JasminClass.this.emit("fcmpg", -1);
                        JasminClass.this.emit("iconst_0", 1);
                        JasminClass.this.emitBooleanBranch("if_icmpne");
                    }

                    private void handleIntCase() {
                        JasminClass.this.emit("if_icmpne", -2);
                    }

                    @Override
                    public void caseIntType(IntType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("lcmp", -3);
                        JasminClass.this.emit("iconst_0", 1);
                        JasminClass.this.emitBooleanBranch("if_icmpne");
                    }

                    @Override
                    public void caseArrayType(ArrayType t2) {
                        JasminClass.this.emitBooleanBranch("if_acmpne");
                    }

                    @Override
                    public void caseRefType(RefType t2) {
                        JasminClass.this.emitBooleanBranch("if_acmpne");
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseEqExpr(EqExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getOp1().getType().apply(new TypeSwitch(){

                    @Override
                    public void caseDoubleType(DoubleType t2) {
                        JasminClass.this.emit("dcmpg", -3);
                        JasminClass.this.emit("iconst_0", 1);
                        JasminClass.this.emitBooleanBranch("if_icmpeq");
                    }

                    @Override
                    public void caseFloatType(FloatType t2) {
                        JasminClass.this.emit("fcmpg", -3);
                        JasminClass.this.emit("iconst_0", 1);
                        JasminClass.this.emitBooleanBranch("if_icmpeq");
                    }

                    private void handleIntCase() {
                        JasminClass.this.emit("if_icmpeq", -2);
                    }

                    @Override
                    public void caseIntType(IntType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("lcmp", -3);
                        JasminClass.this.emit("iconst_0", 1);
                        JasminClass.this.emitBooleanBranch("if_icmpeq");
                    }

                    @Override
                    public void caseArrayType(ArrayType t2) {
                        JasminClass.this.emitBooleanBranch("if_acmpeq");
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("invalid type");
                    }
                });
            }

            @Override
            public void caseNegExpr(final NegExpr v) {
                JasminClass.this.emitValue(v.getOp());
                v.getType().apply(new TypeSwitch(){

                    private void handleIntCase() {
                        JasminClass.this.emit("ineg", 0);
                    }

                    @Override
                    public void caseIntType(IntType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("lneg", 0);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t2) {
                        JasminClass.this.emit("dneg", 0);
                    }

                    @Override
                    public void caseFloatType(FloatType t2) {
                        JasminClass.this.emit("fneg", 0);
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("Invalid argument type for neg: " + t2 + ": " + v);
                    }
                });
            }

            @Override
            public void caseNewArrayExpr(NewArrayExpr v) {
                Value size = v.getSize();
                JasminClass.this.emitValue(size);
                if (v.getBaseType() instanceof RefType) {
                    JasminClass.this.emit("anewarray " + AbstractJasminClass.slashify(v.getBaseType().toString()), 0);
                } else if (v.getBaseType() instanceof ArrayType) {
                    JasminClass.this.emit("anewarray " + AbstractJasminClass.jasminDescriptorOf(v.getBaseType()), 0);
                } else {
                    JasminClass.this.emit("newarray " + v.getBaseType().toString(), 0);
                }
            }

            @Override
            public void caseNewMultiArrayExpr(NewMultiArrayExpr v) {
                for (Value val : v.getSizes()) {
                    JasminClass.this.emitValue(val);
                }
                int size = v.getSizeCount();
                JasminClass.this.emit("multianewarray " + AbstractJasminClass.jasminDescriptorOf(v.getBaseType()) + " " + size, -size + 1);
            }

            @Override
            public void caseNewExpr(NewExpr v) {
                JasminClass.this.emit("new " + AbstractJasminClass.slashify(v.getBaseType().toString()), 1);
            }

            @Override
            public void caseNewInvokeExpr(NewInvokeExpr v) {
                JasminClass.this.emit("new " + AbstractJasminClass.slashify(v.getBaseType().toString()), 1);
                JasminClass.this.emit("dup", 1);
                SootMethodRef m4 = v.getMethodRef();
                for (int i = 0; i < m4.parameterTypes().size(); ++i) {
                    JasminClass.this.emitValue(v.getArg(i));
                }
                JasminClass.this.emit("invokespecial " + AbstractJasminClass.slashify(m4.declaringClass().getName()) + "/" + m4.name() + AbstractJasminClass.jasminDescriptorOf(m4), -(AbstractJasminClass.argCountOf(m4) + 1) + AbstractJasminClass.sizeOfType(m4.returnType()));
            }

            @Override
            public void caseNullConstant(NullConstant v) {
                JasminClass.this.emit("aconst_null", 1);
            }

            @Override
            public void caseOrExpr(OrExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getType().apply(new TypeSwitch(){

                    private void handleIntCase() {
                        JasminClass.this.emit("ior", -1);
                    }

                    @Override
                    public void caseIntType(IntType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("lor", -2);
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("Invalid argument type for or");
                    }
                });
            }

            @Override
            public void caseRemExpr(RemExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getType().apply(new TypeSwitch(){

                    private void handleIntCase() {
                        JasminClass.this.emit("irem", -1);
                    }

                    @Override
                    public void caseIntType(IntType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("lrem", -2);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t2) {
                        JasminClass.this.emit("drem", -2);
                    }

                    @Override
                    public void caseFloatType(FloatType t2) {
                        JasminClass.this.emit("frem", -1);
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("Invalid argument type for rem");
                    }
                });
            }

            @Override
            public void caseShlExpr(ShlExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getType().apply(new TypeSwitch(){

                    private void handleIntCase() {
                        JasminClass.this.emit("ishl", -1);
                    }

                    @Override
                    public void caseIntType(IntType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("lshl", -1);
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("Invalid argument type for shl");
                    }
                });
            }

            @Override
            public void caseShrExpr(ShrExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getType().apply(new TypeSwitch(){

                    private void handleIntCase() {
                        JasminClass.this.emit("ishr", -1);
                    }

                    @Override
                    public void caseIntType(IntType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("lshr", -1);
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("Invalid argument type for shr");
                    }
                });
            }

            @Override
            public void caseSpecialInvokeExpr(SpecialInvokeExpr v) {
                SootMethodRef m4 = v.getMethodRef();
                JasminClass.this.emitValue(v.getBase());
                for (int i = 0; i < m4.parameterTypes().size(); ++i) {
                    JasminClass.this.emitValue(v.getArg(i));
                }
                JasminClass.this.emit("invokespecial " + AbstractJasminClass.slashify(m4.declaringClass().getName()) + "/" + m4.name() + AbstractJasminClass.jasminDescriptorOf(m4), -(AbstractJasminClass.argCountOf(m4) + 1) + AbstractJasminClass.sizeOfType(m4.returnType()));
            }

            @Override
            public void caseStaticInvokeExpr(StaticInvokeExpr v) {
                SootMethodRef m4 = v.getMethodRef();
                for (int i = 0; i < m4.parameterTypes().size(); ++i) {
                    JasminClass.this.emitValue(v.getArg(i));
                }
                JasminClass.this.emit("invokestatic " + AbstractJasminClass.slashify(m4.declaringClass().getName()) + "/" + m4.name() + AbstractJasminClass.jasminDescriptorOf(m4), -AbstractJasminClass.argCountOf(m4) + AbstractJasminClass.sizeOfType(m4.returnType()));
            }

            @Override
            public void caseStaticFieldRef(StaticFieldRef v) {
                JasminClass.this.emit("getstatic " + AbstractJasminClass.slashify(v.getFieldRef().declaringClass().getName()) + "/" + v.getFieldRef().name() + " " + AbstractJasminClass.jasminDescriptorOf(v.getFieldRef().type()), AbstractJasminClass.sizeOfType(v.getFieldRef().type()));
            }

            @Override
            public void caseStringConstant(StringConstant v) {
                JasminClass.this.emit("ldc " + v.toString(), 1);
            }

            @Override
            public void caseClassConstant(ClassConstant v) {
                JasminClass.this.emit("ldc " + v.toInternalString(), 1);
            }

            @Override
            public void caseSubExpr(SubExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getType().apply(new TypeSwitch(){

                    private void handleIntCase() {
                        JasminClass.this.emit("isub", -1);
                    }

                    @Override
                    public void caseIntType(IntType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("lsub", -2);
                    }

                    @Override
                    public void caseDoubleType(DoubleType t2) {
                        JasminClass.this.emit("dsub", -2);
                    }

                    @Override
                    public void caseFloatType(FloatType t2) {
                        JasminClass.this.emit("fsub", -1);
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("Invalid argument type for sub");
                    }
                });
            }

            @Override
            public void caseUshrExpr(UshrExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getType().apply(new TypeSwitch(){

                    private void handleIntCase() {
                        JasminClass.this.emit("iushr", -1);
                    }

                    @Override
                    public void caseIntType(IntType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("lushr", -1);
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("Invalid argument type for ushr");
                    }
                });
            }

            @Override
            public void caseVirtualInvokeExpr(VirtualInvokeExpr v) {
                SootMethodRef m4 = v.getMethodRef();
                JasminClass.this.emitValue(v.getBase());
                for (int i = 0; i < m4.parameterTypes().size(); ++i) {
                    JasminClass.this.emitValue(v.getArg(i));
                }
                JasminClass.this.emit("invokevirtual " + AbstractJasminClass.slashify(m4.declaringClass().getName()) + "/" + m4.name() + AbstractJasminClass.jasminDescriptorOf(m4), -(AbstractJasminClass.argCountOf(m4) + 1) + AbstractJasminClass.sizeOfType(m4.returnType()));
            }

            @Override
            public void caseXorExpr(XorExpr v) {
                JasminClass.this.emitValue(v.getOp1());
                JasminClass.this.emitValue(v.getOp2());
                v.getType().apply(new TypeSwitch(){

                    private void handleIntCase() {
                        JasminClass.this.emit("ixor", -1);
                    }

                    @Override
                    public void caseIntType(IntType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseBooleanType(BooleanType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseShortType(ShortType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseCharType(CharType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseByteType(ByteType t2) {
                        this.handleIntCase();
                    }

                    @Override
                    public void caseLongType(LongType t2) {
                        JasminClass.this.emit("lxor", -2);
                    }

                    @Override
                    public void defaultCase(Type t2) {
                        throw new RuntimeException("Invalid argument type for xor");
                    }
                });
            }
        });
    }

    public void emitBooleanBranch(String s2) {
        int count = s2.indexOf("icmp") != -1 || s2.indexOf("acmp") != -1 ? -2 : -1;
        this.emit(s2 + " label" + this.labelCount, count);
        this.emit("iconst_0", 1);
        this.emit("goto label" + this.labelCount + 1, 0);
        this.emit("label" + this.labelCount++ + ":");
        this.emit("iconst_1", 1);
        this.emit("label" + this.labelCount++ + ":");
    }
}

