/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.util;

import java.util.HashMap;
import java.util.Iterator;
import soot.Body;
import soot.PatchingChain;
import soot.Trap;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.baf.JSRInst;
import soot.baf.TableSwitchInst;
import soot.baf.TargetArgInst;

public class Debugger {
    public static void printBaf(Body b) {
        System.out.println(b.getMethod().getName() + "\n");
        int i = 0;
        HashMap index = new HashMap();
        Iterator it = b.getUnits().iterator();
        while (it.hasNext()) {
            index.put(it.next(), new Integer(i++));
        }
        for (Object o : b.getUnits()) {
            System.out.println(((Integer)index.get(o)).toString() + " " + o + " " + (o instanceof TargetArgInst ? ((Integer)index.get(((TargetArgInst)o).getTarget())).toString() : ""));
        }
        System.out.println("\n");
    }

    public static void printUnits(Body b, String msg) {
        int i = 0;
        HashMap numbers = new HashMap();
        UnitPatchingChain u = b.getUnits();
        Iterator it = u.snapshotIterator();
        while (it.hasNext()) {
            numbers.put(it.next(), new Integer(i++));
        }
        int jsr = 0;
        System.out.println("\r\r" + b.getMethod().getName() + "  " + msg);
        Iterator udit = u.snapshotIterator();
        while (udit.hasNext()) {
            Unit unit = (Unit)udit.next();
            Integer numb = (Integer)numbers.get(unit);
            if (numb == 149) {
                System.out.println("hi");
            }
            if (unit instanceof TargetArgInst) {
                TargetArgInst ti;
                if (unit instanceof JSRInst) {
                    ++jsr;
                }
                if ((ti = (TargetArgInst)unit).getTarget() == null) {
                    System.out.println(unit + " null null null null null null null null null");
                    continue;
                }
                System.out.println(((Integer)numbers.get(unit)).toString() + " " + unit + "   #" + ((Integer)numbers.get(ti.getTarget())).toString());
                continue;
            }
            if (unit instanceof TableSwitchInst) {
                TableSwitchInst tswi = (TableSwitchInst)unit;
                System.out.println(((Integer)numbers.get(unit)).toString() + " SWITCH:");
                System.out.println("\tdefault: " + tswi.getDefaultTarget() + "  " + ((Integer)numbers.get(tswi.getDefaultTarget())).toString());
                int index = 0;
                for (int x = tswi.getLowIndex(); x <= tswi.getHighIndex(); ++x) {
                    System.out.println("\t " + x + ": " + tswi.getTarget(index) + "  " + ((Integer)numbers.get(tswi.getTarget(index++))).toString());
                }
                continue;
            }
            System.out.println(numb.toString() + " " + unit);
        }
        for (Trap t2 : b.getTraps()) {
            System.out.println(numbers.get(t2.getBeginUnit()) + " " + t2.getBeginUnit() + " to " + numbers.get(t2.getEndUnit()) + " " + t2.getEndUnit() + "  at " + numbers.get(t2.getHandlerUnit()) + " " + t2.getHandlerUnit());
        }
        if (jsr > 0) {
            System.out.println("\r\tJSR Instructions: " + jsr);
        }
    }

    public static void printUnits(PatchingChain<Unit> u, String msg) {
        int i = 0;
        HashMap<Unit, Integer> numbers = new HashMap<Unit, Integer>();
        Iterator<Unit> it = u.snapshotIterator();
        while (it.hasNext()) {
            numbers.put(it.next(), new Integer(i++));
        }
        System.out.println("\r\r***********  " + msg);
        Iterator<Unit> udit = u.snapshotIterator();
        while (udit.hasNext()) {
            Unit unit = udit.next();
            Integer numb = (Integer)numbers.get(unit);
            if (numb == 149) {
                System.out.println("hi");
            }
            if (unit instanceof TargetArgInst) {
                TargetArgInst ti = (TargetArgInst)unit;
                if (ti.getTarget() == null) {
                    System.out.println(unit + " null null null null null null null null null");
                    continue;
                }
                System.out.println(((Integer)numbers.get(unit)).toString() + " " + unit + "   #" + ((Integer)numbers.get(ti.getTarget())).toString());
                continue;
            }
            if (unit instanceof TableSwitchInst) {
                TableSwitchInst tswi = (TableSwitchInst)unit;
                System.out.println(((Integer)numbers.get(unit)).toString() + " SWITCH:");
                System.out.println("\tdefault: " + tswi.getDefaultTarget() + "  " + ((Integer)numbers.get(tswi.getDefaultTarget())).toString());
                int index = 0;
                for (int x = tswi.getLowIndex(); x <= tswi.getHighIndex(); ++x) {
                    System.out.println("\t " + x + ": " + tswi.getTarget(index) + "  " + ((Integer)numbers.get(tswi.getTarget(index++))).toString());
                }
                continue;
            }
            System.out.println(numb.toString() + " " + unit);
        }
    }
}

