/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.jimpleTransformations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.Hierarchy;
import soot.NullType;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.UnitPatchingChain;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jbco.IJbcoTransform;
import soot.jbco.jimpleTransformations.FieldRenamer;
import soot.jbco.util.BodyBuilder;
import soot.jbco.util.Rand;
import soot.jimple.ClassConstant;
import soot.jimple.Constant;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.LongConstant;
import soot.jimple.NullConstant;
import soot.jimple.StringConstant;
import soot.util.Chain;

public class CollectConstants
extends SceneTransformer
implements IJbcoTransform {
    private static final Logger logger = LoggerFactory.getLogger(FieldRenamer.class);
    public static final String name = "wjtp.jbco_cc";
    private final Map<Type, List<Constant>> typeToConstants = new HashMap<Type, List<Constant>>();
    public static HashMap<Constant, SootField> constantsToFields = new HashMap();
    private int constants = 0;
    private int updatedConstants = 0;

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String[] getDependencies() {
        return new String[]{name};
    }

    @Override
    public void outputSummary() {
        logger.info("Found {} constants, updated {} ones", (Object)this.constants, (Object)this.updatedConstants);
    }

    @Override
    protected void internalTransform(String phaseName, Map<String, String> options) {
        if (this.isVerbose()) {
            logger.info("Collecting Constant Data");
        }
        BodyBuilder.retrieveAllNames();
        Chain<SootClass> applicationClasses = Scene.v().getApplicationClasses();
        for (SootClass applicationClass : applicationClasses) {
            for (SootMethod method : applicationClass.getMethods()) {
                if (!method.hasActiveBody() || method.getName().contains("<clinit>")) continue;
                for (ValueBox useBox : method.getActiveBody().getUseBoxes()) {
                    Constant constant;
                    Type type;
                    List constants;
                    Value value = useBox.getValue();
                    if (!(value instanceof Constant) || (constants = this.typeToConstants.computeIfAbsent(type = (constant = (Constant)value).getType(), t2 -> new ArrayList())).contains(constant)) continue;
                    ++this.constants;
                    constants.add(constant);
                }
            }
        }
        int count = 0;
        String name = "newConstantJbcoName";
        SootClass[] classes = applicationClasses.toArray(new SootClass[applicationClasses.size()]);
        for (Type type : this.typeToConstants.keySet()) {
            if (type instanceof NullType) continue;
            for (Constant constant : this.typeToConstants.get(type)) {
                SootClass randomClass;
                name = name + "_";
                while (!this.isSuitableClassToAddFieldConstant(randomClass = classes[Rand.getInt(classes.length)], constant)) {
                }
                SootField newField = Scene.v().makeSootField(FieldRenamer.v().getOrAddNewName(name), type, 9);
                randomClass.addField(newField);
                constantsToFields.put(constant, newField);
                this.addInitializingValue(randomClass, newField, constant);
                ++count;
            }
        }
        this.updatedConstants += count;
    }

    private boolean isSuitableClassToAddFieldConstant(SootClass sc, Constant constant) {
        if (sc.isInterface()) {
            return false;
        }
        if (constant instanceof ClassConstant) {
            ClassConstant classConstant = (ClassConstant)constant;
            RefType type = (RefType)classConstant.toSootType();
            SootClass classFromConstant = type.getSootClass();
            Hierarchy hierarchy = Scene.v().getActiveHierarchy();
            return hierarchy.isVisible(sc, classFromConstant);
        }
        return true;
    }

    private void addInitializingValue(SootClass sc, SootField f, Constant constant) {
        Body b;
        SootMethod m4;
        if (constant instanceof NullConstant) {
            return;
        }
        if (constant instanceof IntConstant ? ((IntConstant)constant).value == 0 : (constant instanceof LongConstant ? ((LongConstant)constant).value == 0L : (constant instanceof StringConstant ? ((StringConstant)constant).value == null : (constant instanceof DoubleConstant ? ((DoubleConstant)constant).value == 0.0 : constant instanceof FloatConstant && ((FloatConstant)constant).value == 0.0f)))) {
            return;
        }
        boolean newInit = false;
        if (!sc.declaresMethodByName("<clinit>")) {
            m4 = Scene.v().makeSootMethod("<clinit>", Collections.emptyList(), VoidType.v(), 8);
            sc.addMethod(m4);
            b = Jimple.v().newBody(m4);
            m4.setActiveBody(b);
            newInit = true;
        } else {
            m4 = sc.getMethodByName("<clinit>");
            if (!m4.hasActiveBody()) {
                b = Jimple.v().newBody(m4);
                m4.setActiveBody(b);
                newInit = true;
            } else {
                b = m4.getActiveBody();
            }
        }
        UnitPatchingChain units = b.getUnits();
        units.addFirst(Jimple.v().newAssignStmt(Jimple.v().newStaticFieldRef(f.makeRef()), constant));
        if (newInit) {
            units.addLast(Jimple.v().newReturnVoidStmt());
        }
    }
}

