/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.jimpleTransformations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import soot.Body;
import soot.BodyTransformer;
import soot.BooleanType;
import soot.IntType;
import soot.Local;
import soot.PrimType;
import soot.RefType;
import soot.SootField;
import soot.SootMethod;
import soot.Trap;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.jbco.IJbcoTransform;
import soot.jbco.Main;
import soot.jbco.jimpleTransformations.FieldRenamer;
import soot.jbco.jimpleTransformations.New2InitFlowAnalysis;
import soot.jbco.util.Rand;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.scalar.FlowSet;
import soot.util.Chain;

public class AddSwitches
extends BodyTransformer
implements IJbcoTransform {
    int switchesadded = 0;
    public static String[] dependancies = new String[]{"wjtp.jbco_fr", "jtp.jbco_adss", "bb.jbco_ful"};
    public static String name = "jtp.jbco_adss";

    @Override
    public void outputSummary() {
        out.println("Switches added: " + this.switchesadded);
    }

    @Override
    public String[] getDependencies() {
        return dependancies;
    }

    @Override
    public String getName() {
        return name;
    }

    public boolean checkTraps(Unit u, Body b) {
        for (Trap t2 : b.getTraps()) {
            if (t2.getBeginUnit() != u && t2.getEndUnit() != u && t2.getHandlerUnit() != u) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        Local B;
        SootMethod m4;
        RefType rt;
        if (b.getMethod().getSignature().indexOf("<clinit>") >= 0) {
            return;
        }
        int weight = Main.getWeight(phaseName, b.getMethod().getSignature());
        if (weight == 0) {
            return;
        }
        New2InitFlowAnalysis fa = new New2InitFlowAnalysis(new BriefUnitGraph(b));
        Vector<Unit> zeroheight = new Vector<Unit>();
        UnitPatchingChain units = b.getUnits();
        Unit first = null;
        for (Unit unit : units) {
            if (unit instanceof IdentityStmt) continue;
            first = unit;
            break;
        }
        Iterator it = units.snapshotIterator();
        while (it.hasNext()) {
            Unit unit;
            unit = (Unit)it.next();
            if (unit instanceof IdentityStmt || this.checkTraps(unit, b) || !((FlowSet)fa.getFlowAfter(unit)).isEmpty() || !((FlowSet)fa.getFlowBefore(unit)).isEmpty()) continue;
            zeroheight.add(unit);
        }
        if (zeroheight.size() < 3) {
            return;
        }
        int idx = 0;
        Unit u = null;
        for (int i = 0; i < zeroheight.size() && !(u = (Unit)zeroheight.get(idx = Rand.getInt(zeroheight.size() - 1) + 1)).fallsThrough(); ++i) {
            u = null;
        }
        if (u == null || Rand.getInt(10) > weight) {
            return;
        }
        zeroheight.remove(idx);
        while (zeroheight.size() > (weight > 3 ? weight : 3)) {
            zeroheight.remove(Rand.getInt(zeroheight.size()));
        }
        Chain<Local> locals = b.getLocals();
        ArrayList<Unit> targs = new ArrayList<Unit>();
        targs.addAll(zeroheight);
        SootField[] ops = FieldRenamer.v().getRandomOpaques();
        Local b1 = Jimple.v().newLocal("addswitchesbool1", BooleanType.v());
        locals.add(b1);
        Local b2 = Jimple.v().newLocal("addswitchesbool2", BooleanType.v());
        locals.add(b2);
        if (ops[0].getType() instanceof PrimType) {
            units.insertBefore(Jimple.v().newAssignStmt(b1, Jimple.v().newStaticFieldRef(ops[0].makeRef())), u);
        } else {
            rt = (RefType)ops[0].getType();
            m4 = rt.getSootClass().getMethodByName("booleanValue");
            B = Jimple.v().newLocal("addswitchesBOOL1", rt);
            locals.add(B);
            units.insertBefore(Jimple.v().newAssignStmt(B, Jimple.v().newStaticFieldRef(ops[0].makeRef())), u);
            units.insertBefore(Jimple.v().newAssignStmt(b1, Jimple.v().newVirtualInvokeExpr(B, m4.makeRef(), Collections.emptyList())), u);
        }
        if (ops[1].getType() instanceof PrimType) {
            units.insertBefore(Jimple.v().newAssignStmt(b2, Jimple.v().newStaticFieldRef(ops[1].makeRef())), u);
        } else {
            rt = (RefType)ops[1].getType();
            m4 = rt.getSootClass().getMethodByName("booleanValue");
            B = Jimple.v().newLocal("addswitchesBOOL2", rt);
            locals.add(B);
            units.insertBefore(Jimple.v().newAssignStmt(B, Jimple.v().newStaticFieldRef(ops[1].makeRef())), u);
            units.insertBefore(Jimple.v().newAssignStmt(b2, Jimple.v().newVirtualInvokeExpr(B, m4.makeRef(), Collections.emptyList())), u);
        }
        IfStmt ifstmt = Jimple.v().newIfStmt((Value)Jimple.v().newNeExpr(b1, b2), u);
        units.insertBefore(ifstmt, u);
        Local l = Jimple.v().newLocal("addswitchlocal", IntType.v());
        locals.add(l);
        units.insertBeforeNoRedirect(Jimple.v().newAssignStmt(l, IntConstant.v(0)), first);
        units.insertAfter(Jimple.v().newTableSwitchStmt((Value)l, 1, zeroheight.size(), targs, u), ifstmt);
        this.switchesadded += zeroheight.size() + 1;
        for (Unit nxt : targs) {
            if (Rand.getInt(5) >= 4) continue;
            units.insertBefore(Jimple.v().newAssignStmt(l, Jimple.v().newAddExpr(l, IntConstant.v(Rand.getInt(3) + 1))), nxt);
        }
        ifstmt.setTarget(u);
    }
}

