/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.bafTransformations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.BooleanType;
import soot.IntType;
import soot.Local;
import soot.PatchingChain;
import soot.RefType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.StmtAddressType;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.baf.Baf;
import soot.baf.GotoInst;
import soot.baf.IdentityInst;
import soot.baf.JSRInst;
import soot.baf.LoadInst;
import soot.baf.NopInst;
import soot.baf.PushInst;
import soot.baf.StoreInst;
import soot.baf.TargetArgInst;
import soot.jbco.IJbcoTransform;
import soot.jbco.Main;
import soot.jbco.bafTransformations.FixUndefinedLocals;
import soot.jbco.bafTransformations.StackTypeHeightCalculator;
import soot.jbco.jimpleTransformations.FieldRenamer;
import soot.jbco.util.Rand;
import soot.jimple.IntConstant;
import soot.jimple.NullConstant;
import soot.toolkits.graph.BriefUnitGraph;
import soot.util.Chain;

public class TryCatchCombiner
extends BodyTransformer
implements IJbcoTransform {
    private static final Logger logger = LoggerFactory.getLogger(TryCatchCombiner.class);
    int totalcount = 0;
    int changedcount = 0;
    public static String[] dependancies = new String[]{"bb.jbco_j2bl", "bb.jbco_ctbcb", "bb.jbco_ful", "bb.lp"};
    public static String name = "bb.jbco_ctbcb";

    @Override
    public String[] getDependencies() {
        return dependancies;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void outputSummary() {
        out.println("Total try blocks found: " + this.totalcount);
        out.println("Combined TryCatches: " + this.changedcount);
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        Unit unit;
        int weight = Main.getWeight(phaseName, b.getMethod().getSignature());
        if (weight == 0) {
            return;
        }
        int trapCount = 0;
        UnitPatchingChain units = b.getUnits();
        ArrayList<Unit> headList = new ArrayList<Unit>();
        ArrayList<Trap> trapList = new ArrayList<Trap>();
        for (Trap t2 : b.getTraps()) {
            ++this.totalcount;
            if (!this.isRewritable(t2)) continue;
            headList.add(t2.getBeginUnit());
            trapList.add(t2);
            ++trapCount;
        }
        if (trapCount == 0) {
            return;
        }
        for (int i = 0; i < headList.size(); ++i) {
            for (int j = 0; j < headList.size(); ++j) {
                if (i == j || headList.get(i) != headList.get(j)) continue;
                Trap t3 = (Trap)trapList.get(i);
                NopInst nop = Baf.v().newNopInst();
                units.insertBeforeNoRedirect(nop, (Unit)headList.get(i));
                headList.set(i, nop);
                t3.setBeginUnit(nop);
            }
        }
        Unit first = null;
        Iterator uit = units.iterator();
        while (uit.hasNext() && (unit = (Unit)uit.next()) instanceof IdentityInst) {
            first = unit;
        }
        if (first == null) {
            first = Baf.v().newNopInst();
            units.insertBefore(first, units.getFirst());
        } else {
            first = units.getSuccOf(first);
        }
        Chain<Local> locs = b.getLocals();
        Map<Unit, Stack<Type>> stackHeightsBefore = null;
        Map<Local, Local> bafToJLocals = Main.methods2Baf2JLocals.get(b.getMethod());
        int varCount = trapCount + 1;
        Iterator<Trap> traps = b.getTraps().snapshotIterator();
        while (traps.hasNext()) {
            Local varLocal;
            int i;
            Trap t4 = traps.next();
            Unit begUnit = t4.getBeginUnit();
            if (!this.isRewritable(t4) || Rand.getInt(10) > weight) continue;
            stackHeightsBefore = StackTypeHeightCalculator.calculateStackHeights(b, bafToJLocals);
            boolean badType = false;
            Stack<Type> s2 = (Stack<Type>)stackHeightsBefore.get(begUnit).clone();
            if (s2.size() > 0) {
                for (int i2 = 0; i2 < s2.size(); ++i2) {
                    if (!(s2.pop() instanceof StmtAddressType)) continue;
                    badType = true;
                    break;
                }
            }
            if (badType) continue;
            Local controlLocal = Baf.v().newLocal("controlLocal_tccomb" + trapCount, IntType.v());
            locs.add(controlLocal);
            PushInst pushZero = Baf.v().newPushInst(IntConstant.v(0));
            StoreInst storZero = Baf.v().newStoreInst(IntType.v(), controlLocal);
            units.insertBeforeNoRedirect((Unit)pushZero.clone(), first);
            units.insertBeforeNoRedirect((Unit)storZero.clone(), first);
            BriefUnitGraph graph = new BriefUnitGraph(b);
            List<Unit> l = graph.getPredsOf(begUnit);
            units.add(pushZero);
            units.add(storZero);
            Stack<Local> varsToLoad = new Stack<Local>();
            s2 = stackHeightsBefore.get(begUnit);
            if (s2.size() > 0) {
                for (i = 0; i < s2.size(); ++i) {
                    Type type = s2.pop();
                    varLocal = Baf.v().newLocal("varLocal_tccomb" + varCount++, type);
                    locs.add(varLocal);
                    varsToLoad.push(varLocal);
                    units.add(Baf.v().newStoreInst(type, varLocal));
                    units.insertBeforeNoRedirect(FixUndefinedLocals.getPushInitializer(varLocal, type), first);
                    units.insertBeforeNoRedirect(Baf.v().newStoreInst(type, varLocal), first);
                }
            }
            units.add(Baf.v().newPushInst(NullConstant.v()));
            units.add(Baf.v().newGotoInst(begUnit));
            for (i = 0; i < l.size(); ++i) {
                Unit pred = l.get(i);
                if (this.isIf(pred)) {
                    TargetArgInst succ;
                    TargetArgInst ifPred = (TargetArgInst)pred;
                    if (ifPred.getTarget() == begUnit) {
                        ifPred.setTarget(pushZero);
                    }
                    if ((succ = units.getSuccOf(ifPred)) != begUnit) continue;
                    units.insertAfter(Baf.v().newGotoInst(pushZero), ifPred);
                    continue;
                }
                if (pred instanceof GotoInst && ((GotoInst)pred).getTarget() == begUnit) {
                    ((GotoInst)pred).setTarget(pushZero);
                    continue;
                }
                units.insertAfter(Baf.v().newGotoInst(pushZero), pred);
            }
            Unit handlerUnit = t4.getHandlerUnit();
            LoadInst newBeginUnit = Baf.v().newLoadInst(IntType.v(), controlLocal);
            units.insertBefore(newBeginUnit, begUnit);
            units.insertBefore(Baf.v().newIfNeInst(handlerUnit), begUnit);
            units.insertBefore(Baf.v().newPopInst(RefType.v()), begUnit);
            while (varsToLoad.size() > 0) {
                varLocal = (Local)varsToLoad.pop();
                units.insertBefore(Baf.v().newLoadInst(varLocal.getType(), varLocal), begUnit);
            }
            try {
                SootField[] f = FieldRenamer.v().getRandomOpaques();
                if (f[0] != null && f[1] != null) {
                    this.loadBooleanValue(units, f[0], begUnit);
                    this.loadBooleanValue(units, f[1], begUnit);
                    units.insertBeforeNoRedirect(Baf.v().newIfCmpEqInst(BooleanType.v(), begUnit), begUnit);
                }
            }
            catch (NullPointerException npe) {
                logger.debug(npe.getMessage(), npe);
            }
            if (Rand.getInt() % 2 == 0) {
                units.insertBeforeNoRedirect(Baf.v().newPushInst(IntConstant.v(Rand.getInt(3) + 1)), begUnit);
                units.insertBeforeNoRedirect(Baf.v().newStoreInst(IntType.v(), controlLocal), begUnit);
            } else {
                units.insertBeforeNoRedirect(Baf.v().newIncInst(controlLocal, IntConstant.v(Rand.getInt(3) + 1)), begUnit);
            }
            --trapCount;
            t4.setBeginUnit(newBeginUnit);
            t4.setHandlerUnit(newBeginUnit);
            ++this.changedcount;
            if (!debug) continue;
            StackTypeHeightCalculator.printStack(units, StackTypeHeightCalculator.calculateStackHeights(b), false);
        }
    }

    private void loadBooleanValue(PatchingChain<Unit> units, SootField f, Unit insert) {
        units.insertBefore(Baf.v().newStaticGetInst(f.makeRef()), insert);
        if (f.getType() instanceof RefType) {
            SootMethod boolInit = ((RefType)f.getType()).getSootClass().getMethod("boolean booleanValue()");
            units.insertBefore(Baf.v().newVirtualInvokeInst(boolInit.makeRef()), insert);
        }
    }

    private boolean isIf(Unit u) {
        return u instanceof TargetArgInst && !(u instanceof GotoInst) && !(u instanceof JSRInst);
    }

    private boolean isRewritable(Trap t2) {
        if (t2.getBeginUnit() == t2.getHandlerUnit()) {
            return false;
        }
        SootClass exc = t2.getException();
        if (exc.getName().equals("java.lang.Throwable")) {
            return false;
        }
        do {
            if (!exc.getName().equals("java.lang.RuntimeException")) continue;
            return false;
        } while (exc.hasSuperclass() && (exc = exc.getSuperclass()) != null);
        return true;
    }
}

