/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.bafTransformations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.RefType;
import soot.Trap;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.baf.Baf;
import soot.baf.GotoInst;
import soot.baf.JSRInst;
import soot.baf.LookupSwitchInst;
import soot.baf.PopInst;
import soot.baf.TableSwitchInst;
import soot.baf.TargetArgInst;
import soot.jbco.IJbcoTransform;
import soot.jbco.Main;
import soot.jbco.bafTransformations.StackTypeHeightCalculator;
import soot.jbco.util.BodyBuilder;
import soot.jbco.util.Rand;

public class AddJSRs
extends BodyTransformer
implements IJbcoTransform {
    private static final Logger logger = LoggerFactory.getLogger(AddJSRs.class);
    int jsrcount = 0;
    public static String[] dependancies = new String[]{"jtp.jbco_jl", "bb.jbco_cb2ji", "bb.jbco_ful", "bb.lp"};
    public static String name = "bb.jbco_cb2ji";

    @Override
    public String[] getDependencies() {
        return dependancies;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public void outputSummary() {
        logger.info("{} If/Gotos replaced with JSRs.", (Object)this.jsrcount);
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        Object unit;
        int weight = Main.getWeight(phaseName, b.getMethod().getSignature());
        if (weight == 0) {
            return;
        }
        boolean fallsthrough = false;
        HashMap<Trap, Unit> trapsToHandler = new HashMap<Trap, Unit>();
        for (Trap t2 : b.getTraps()) {
            trapsToHandler.put(t2, t2.getHandlerUnit());
        }
        ArrayList<Unit> targets = new ArrayList<Unit>();
        ArrayList<Unit> seenUts = new ArrayList<Unit>();
        HashMap<Unit, ArrayList<Unit>> switches = new HashMap<Unit, ArrayList<Unit>>();
        HashMap<Unit, Unit> switchDefs = new HashMap<Unit, Unit>();
        HashMap<TargetArgInst, Unit> ignoreJumps = new HashMap<TargetArgInst, Unit>();
        UnitPatchingChain u = b.getUnits();
        Iterator<Object> it = u.snapshotIterator();
        while (it.hasNext()) {
            Unit unit2 = (Unit)it.next();
            if (unit2 instanceof TargetArgInst) {
                TargetArgInst ti = (TargetArgInst)unit2;
                Unit tu = ti.getTarget();
                if (Rand.getInt(10) > weight) {
                    ignoreJumps.put(ti, tu);
                } else if (!targets.contains(tu)) {
                    targets.add(tu);
                }
            }
            if (unit2 instanceof TableSwitchInst) {
                TableSwitchInst ts = (TableSwitchInst)unit2;
                switches.put(unit2, new ArrayList<Unit>(ts.getTargets()));
                switchDefs.put(unit2, ts.getDefaultTarget());
            } else if (unit2 instanceof LookupSwitchInst) {
                LookupSwitchInst ls = (LookupSwitchInst)unit2;
                switches.put(unit2, new ArrayList<Unit>(ls.getTargets()));
                switchDefs.put(unit2, ls.getDefaultTarget());
            }
            seenUts.add(unit2);
        }
        it = u.snapshotIterator();
        ArrayList processedLabels = new ArrayList();
        HashMap<Iterator<Object>, JSRInst> builtJsrs = new HashMap<Iterator<Object>, JSRInst>();
        HashMap popsBuilt = new HashMap();
        Iterator prev = null;
        while (it.hasNext()) {
            unit = (Unit)it.next();
            if (targets.contains(unit)) {
                if (fallsthrough) {
                    JSRInst ji = Baf.v().newJSRInst((Unit)unit);
                    builtJsrs.put((Iterator<Object>)unit, ji);
                    u.insertAfter(ji, prev);
                    ++this.jsrcount;
                }
                PopInst pop = Baf.v().newPopInst(RefType.v());
                u.insertBefore(pop, unit);
                processedLabels.add(unit);
                popsBuilt.put(pop, unit);
            }
            fallsthrough = unit.fallsThrough();
            prev = unit;
        }
        it = u.snapshotIterator();
        while (it.hasNext()) {
            unit = (Unit)it.next();
            if (builtJsrs.containsValue(unit) || !(unit instanceof TargetArgInst) || ignoreJumps.containsKey(unit)) continue;
            TargetArgInst ti = (TargetArgInst)unit;
            Unit tu = ti.getTarget();
            if (!popsBuilt.containsKey(tu)) {
                throw new RuntimeException("It appears a target was found that was not updated with a POP.\n\"This makes no sense,\" said the bug as it flew through the code.");
            }
            JSRInst ji = (JSRInst)builtJsrs.get(popsBuilt.get(tu));
            if (BodyBuilder.isBafIf((Unit)unit)) {
                if (Rand.getInt(10) > weight) {
                    ti.setTarget((Unit)popsBuilt.get(tu));
                    continue;
                }
                if (ji != null) {
                    ti.setTarget(ji);
                    continue;
                }
                ji = Baf.v().newJSRInst(tu);
                u.insertAfter(ji, u.getPredOf(tu));
                ti.setTarget(ji);
                builtJsrs.put((Iterator<Object>)popsBuilt.get(tu), ji);
                ++this.jsrcount;
                continue;
            }
            if (!(unit instanceof GotoInst)) continue;
            if (ji != null) {
                if (Rand.getInt(10) < weight) {
                    ((GotoInst)unit).setTarget(ji);
                    continue;
                }
                ((GotoInst)unit).setTarget((Unit)popsBuilt.get(tu));
                continue;
            }
            ((GotoInst)unit).setTarget((Unit)popsBuilt.get(tu));
        }
        for (Trap t3 : trapsToHandler.keySet()) {
            t3.setHandlerUnit((Unit)trapsToHandler.get(t3));
        }
        for (TargetArgInst ti : ignoreJumps.keySet()) {
            if (!popsBuilt.containsKey(ti.getTarget())) continue;
            ti.setTarget((Unit)popsBuilt.get(ti.getTarget()));
        }
        targets.clear();
        it = u.snapshotIterator();
        while (it.hasNext()) {
            Unit targ;
            unit = (Unit)it.next();
            if (!(unit instanceof TargetArgInst) || targets.contains(targ = ((TargetArgInst)unit).getTarget())) continue;
            targets.add(targ);
        }
        for (Unit pop : popsBuilt.keySet()) {
            if (targets.contains(pop)) continue;
            u.remove(pop);
        }
        for (Unit sw : switches.keySet()) {
            List targs = (List)switches.get(sw);
            for (int i = 0; i < targs.size(); ++i) {
                Unit unit3;
                Unit ji;
                if (Rand.getInt(10) > weight || (ji = (Unit)builtJsrs.get(unit3 = (Unit)targs.get(i))) == null) continue;
                targs.set(i, ji);
            }
            Unit def = (Unit)switchDefs.get(sw);
            if (Rand.getInt(10) < weight && builtJsrs.get(def) != null) {
                def = (Unit)builtJsrs.get(def);
            }
            if (sw instanceof TableSwitchInst) {
                ((TableSwitchInst)sw).setTargets(targs);
                ((TableSwitchInst)sw).setDefaultTarget(def);
                continue;
            }
            if (!(sw instanceof LookupSwitchInst)) continue;
            ((LookupSwitchInst)sw).setTargets(targs);
            ((LookupSwitchInst)sw).setDefaultTarget(def);
        }
        if (debug) {
            StackTypeHeightCalculator.calculateStackHeights(b);
        }
    }
}

