/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler.instructions;

import java.util.ArrayList;
import java.util.List;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.SwitchElement;
import org.jf.dexlib2.iface.instruction.formats.PackedSwitchPayload;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.dexpler.DexBody;
import soot.dexpler.instructions.SwitchInstruction;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.Stmt;

public class PackedSwitchInstruction
extends SwitchInstruction {
    public PackedSwitchInstruction(Instruction instruction, int codeAdress) {
        super(instruction, codeAdress);
    }

    @Override
    protected Stmt switchStatement(DexBody body, Instruction targetData, Local key) {
        PackedSwitchPayload i = (PackedSwitchPayload)targetData;
        List<? extends SwitchElement> seList = i.getSwitchElements();
        int defaultTargetAddress = this.codeAddress + this.instruction.getCodeUnits();
        Unit defaultTarget = body.instructionAtAddress(defaultTargetAddress).getUnit();
        ArrayList<IntConstant> lookupValues = new ArrayList<IntConstant>();
        ArrayList<Unit> targets = new ArrayList<Unit>();
        for (SwitchElement switchElement : seList) {
            lookupValues.add(IntConstant.v(switchElement.getKey()));
            int offset = switchElement.getOffset();
            targets.add(body.instructionAtAddress(this.codeAddress + offset).getUnit());
        }
        LookupSwitchStmt switchStmt = Jimple.v().newLookupSwitchStmt((Value)key, lookupValues, targets, defaultTarget);
        this.setUnit(switchStmt);
        return switchStmt;
    }

    @Override
    public void computeDataOffsets(DexBody body) {
    }
}

