/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import soot.ArrayType;
import soot.Body;
import soot.BodyTransformer;
import soot.Local;
import soot.NullType;
import soot.RefType;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AnyNewExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.Stmt;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.LocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;

public abstract class DexTransformer
extends BodyTransformer {
    protected List<Unit> collectDefinitionsWithAliases(Local l, LocalDefs localDefs, LocalUses localUses, Body body) {
        HashSet<Local> seenLocals = new HashSet<Local>();
        ArrayList<Local> newLocals = new ArrayList<Local>();
        ArrayList<Unit> defs = new ArrayList<Unit>();
        newLocals.add(l);
        seenLocals.add(l);
        while (!newLocals.isEmpty()) {
            Local local = (Local)newLocals.remove(0);
            for (Unit u : this.collectDefinitions(local, localDefs)) {
                Value r;
                if (u instanceof AssignStmt && (r = ((AssignStmt)u).getRightOp()) instanceof Local && seenLocals.add((Local)r)) {
                    newLocals.add((Local)r);
                }
                defs.add(u);
                List<UnitValueBoxPair> usesOf = localUses.getUsesOf(u);
                for (UnitValueBoxPair pair : usesOf) {
                    Unit unit = pair.getUnit();
                    if (!(unit instanceof AssignStmt)) continue;
                    AssignStmt assignStmt = (AssignStmt)unit;
                    Value right = assignStmt.getRightOp();
                    Value left = assignStmt.getLeftOp();
                    if (right != local || !(left instanceof Local) || !seenLocals.add((Local)left)) continue;
                    newLocals.add((Local)left);
                }
            }
        }
        return defs;
    }

    private List<Unit> collectDefinitions(Local l, LocalDefs localDefs) {
        return localDefs.getDefsOf(l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Type findArrayType(LocalDefs localDefs, Stmt arrayStmt, int depth, Set<Unit> alreadyVisitedDefs) {
        ArrayRef aRef = null;
        if (arrayStmt.containsArrayRef()) {
            aRef = arrayStmt.getArrayRef();
        }
        Local aBase = null;
        if (null == aRef) {
            if (!(arrayStmt instanceof AssignStmt)) throw new RuntimeException("ERROR: not an assign statement: " + arrayStmt);
            AssignStmt stmt = (AssignStmt)arrayStmt;
            aBase = (Local)stmt.getRightOp();
        } else {
            aBase = (Local)aRef.getBase();
        }
        List<Unit> defsOfaBaseList = localDefs.getDefsOfAt(aBase, arrayStmt);
        if (defsOfaBaseList == null || defsOfaBaseList.isEmpty()) {
            throw new RuntimeException("ERROR: no def statement found for array base local " + arrayStmt);
        }
        Type aType = null;
        int nullDefCount = 0;
        for (Unit baseDef : defsOfaBaseList) {
            Type t2;
            DefinitionStmt stmt;
            if (alreadyVisitedDefs.contains(baseDef)) continue;
            HashSet<Unit> newVisitedDefs = new HashSet<Unit>(alreadyVisitedDefs);
            newVisitedDefs.add(baseDef);
            if (baseDef instanceof AssignStmt) {
                AnyNewExpr expr;
                stmt = (AssignStmt)baseDef;
                Value r = stmt.getRightOp();
                if (r instanceof FieldRef) {
                    t2 = ((FieldRef)r).getFieldRef().type();
                    if (t2 instanceof ArrayType) {
                        ArrayType at = (ArrayType)t2;
                        t2 = at.getArrayElementType();
                    }
                    if (depth != 0) return t2;
                    aType = t2;
                    break;
                }
                if (r instanceof ArrayRef) {
                    ArrayRef ar = (ArrayRef)r;
                    if (ar.getType().toString().equals(".unknown") || ar.getType().toString().equals("unknown")) {
                        Type t3;
                        if ((t3 = this.findArrayType(localDefs, stmt, ++depth, newVisitedDefs)) instanceof ArrayType) {
                            ArrayType at = (ArrayType)t3;
                            t3 = at.getArrayElementType();
                        }
                        if (depth != 0) return t3;
                        aType = t3;
                        break;
                    }
                    ArrayType at = (ArrayType)stmt.getRightOp().getType();
                    Type t4 = at.getArrayElementType();
                    if (depth != 0) return t4;
                    aType = t4;
                    break;
                }
                if (r instanceof NewExpr) {
                    expr = (NewExpr)r;
                    RefType t5 = expr.getBaseType();
                    if (depth != 0) return t5;
                    aType = t5;
                    break;
                }
                if (r instanceof NewArrayExpr) {
                    expr = (NewArrayExpr)r;
                    Type t6 = expr.getBaseType();
                    if (depth != 0) return t6;
                    aType = t6;
                    break;
                }
                if (r instanceof CastExpr) {
                    t2 = ((CastExpr)r).getCastType();
                    if (t2 instanceof ArrayType) {
                        ArrayType at = (ArrayType)t2;
                        t2 = at.getArrayElementType();
                    }
                    if (depth != 0) return t2;
                    aType = t2;
                    break;
                }
                if (r instanceof InvokeExpr) {
                    t2 = ((InvokeExpr)r).getMethodRef().returnType();
                    if (t2 instanceof ArrayType) {
                        ArrayType at = (ArrayType)t2;
                        t2 = at.getArrayElementType();
                    }
                    if (depth != 0) return t2;
                    aType = t2;
                    break;
                }
                if (r instanceof Local) {
                    t2 = this.findArrayType(localDefs, stmt, ++depth, newVisitedDefs);
                    aType = depth == 0 ? t2 : t2;
                } else {
                    if (!(r instanceof Constant)) throw new RuntimeException(String.format("ERROR: def statement not possible! Statement: %s, right side: %s", stmt.toString(), r.getClass().getName()));
                    ++nullDefCount;
                }
            } else {
                if (!(baseDef instanceof IdentityStmt)) throw new RuntimeException("ERROR: base local def must be AssignStmt or IdentityStmt! " + baseDef);
                stmt = (IdentityStmt)baseDef;
                ArrayType at = (ArrayType)stmt.getRightOp().getType();
                t2 = at.getArrayElementType();
                if (depth != 0) return t2;
                aType = t2;
                break;
            }
            if (aType == null) continue;
            break;
        }
        if (depth != 0 || aType != null) return aType;
        if (nullDefCount != defsOfaBaseList.size()) throw new RuntimeException("ERROR: could not find type of array from statement '" + arrayStmt + "'");
        return NullType.v();
    }
}

