/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Body;
import soot.Local;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.toolkits.scalar.LocalDefs;

public class DexDefUseAnalysis
implements LocalDefs {
    private final Body body;
    private Map<Local, Set<Unit>> localToUses = new HashMap<Local, Set<Unit>>();
    private Map<Local, Set<Unit>> localToDefs = new HashMap<Local, Set<Unit>>();
    private Map<Local, Set<Unit>> localToDefsWithAliases = new HashMap<Local, Set<Unit>>();
    protected BitSet[] localToDefsBits;
    protected BitSet[] localToUsesBits;
    protected Map<Local, Integer> localToNumber = new HashMap<Local, Integer>();
    protected List<Unit> unitList;

    public DexDefUseAnalysis(Body body) {
        this.body = body;
        this.initialize();
    }

    protected void initialize() {
        int lastLocalNumber = 0;
        for (Local l : this.body.getLocals()) {
            this.localToNumber.put(l, lastLocalNumber++);
        }
        this.localToDefsBits = new BitSet[this.body.getLocalCount()];
        this.localToUsesBits = new BitSet[this.body.getLocalCount()];
        this.unitList = new ArrayList<Unit>(this.body.getUnits());
        for (int i = 0; i < this.unitList.size(); ++i) {
            Value val;
            Unit u = this.unitList.get(i);
            if (u instanceof DefinitionStmt && (val = ((DefinitionStmt)u).getLeftOp()) instanceof Local) {
                int localIdx = this.localToNumber.get(val);
                BitSet bs = this.localToDefsBits[localIdx];
                if (bs == null) {
                    this.localToDefsBits[localIdx] = bs = new BitSet();
                }
                bs.set(i);
            }
            for (ValueBox vb : u.getUseBoxes()) {
                Value val2 = vb.getValue();
                if (!(val2 instanceof Local)) continue;
                int localIdx = this.localToNumber.get(val2);
                BitSet bs = this.localToUsesBits[localIdx];
                if (bs == null) {
                    this.localToUsesBits[localIdx] = bs = new BitSet();
                }
                bs.set(i);
            }
        }
    }

    public Set<Unit> getUsesOf(Local l) {
        Set<Unit> uses = this.localToUses.get(l);
        if (uses == null) {
            uses = new HashSet<Unit>();
            BitSet bs = this.localToUsesBits[this.localToNumber.get(l)];
            if (bs != null) {
                int i = bs.nextSetBit(0);
                while (i >= 0) {
                    uses.add(this.unitList.get(i));
                    i = bs.nextSetBit(i + 1);
                }
            }
            this.localToUses.put(l, uses);
        }
        return uses;
    }

    protected Set<Unit> collectDefinitionsWithAliases(Local l) {
        Set<Unit> defs = this.localToDefsWithAliases.get(l);
        if (defs == null) {
            HashSet<Local> seenLocals = new HashSet<Local>();
            defs = new HashSet<Unit>();
            ArrayList<Local> newLocals = new ArrayList<Local>();
            newLocals.add(l);
            while (!newLocals.isEmpty()) {
                BitSet bsUses;
                Local curLocal = (Local)newLocals.remove(0);
                BitSet bsDefs = this.localToDefsBits[this.localToNumber.get(curLocal)];
                if (bsDefs != null) {
                    int i = bsDefs.nextSetBit(0);
                    while (i >= 0) {
                        Unit u = this.unitList.get(i);
                        defs.add(u);
                        DefinitionStmt defStmt = (DefinitionStmt)u;
                        if (defStmt.getRightOp() instanceof Local && seenLocals.add((Local)defStmt.getRightOp())) {
                            newLocals.add((Local)defStmt.getRightOp());
                        }
                        i = bsDefs.nextSetBit(i + 1);
                    }
                }
                if ((bsUses = this.localToUsesBits[this.localToNumber.get(curLocal)]) == null) continue;
                int i = bsUses.nextSetBit(0);
                while (i >= 0) {
                    AssignStmt assignUse;
                    Unit use = this.unitList.get(i);
                    if (use instanceof AssignStmt && (assignUse = (AssignStmt)use).getRightOp() == curLocal && assignUse.getLeftOp() instanceof Local && seenLocals.add((Local)assignUse.getLeftOp())) {
                        newLocals.add((Local)assignUse.getLeftOp());
                    }
                    i = bsUses.nextSetBit(i + 1);
                }
            }
            this.localToDefsWithAliases.put(l, defs);
        }
        return defs;
    }

    @Override
    public List<Unit> getDefsOfAt(Local l, Unit s2) {
        return this.getDefsOf(l);
    }

    @Override
    public List<Unit> getDefsOf(Local l) {
        Set<Unit> defs = this.localToDefs.get(l);
        if (defs == null) {
            defs = new HashSet<Unit>();
            BitSet bs = this.localToDefsBits[this.localToNumber.get(l)];
            if (bs != null) {
                int i = bs.nextSetBit(0);
                while (i >= 0) {
                    Unit u = this.unitList.get(i);
                    if (u instanceof DefinitionStmt && ((DefinitionStmt)u).getLeftOp() == l) {
                        defs.add(u);
                    }
                    i = bs.nextSetBit(i + 1);
                }
            }
            this.localToDefs.put(l, defs);
        }
        return new ArrayList<Unit>(defs);
    }
}

