/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.Iterator;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MultiDexContainer;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootResolver;
import soot.dexpler.DexAnnotation;
import soot.dexpler.DexField;
import soot.dexpler.DexInnerClassParser;
import soot.dexpler.DexMethod;
import soot.dexpler.DexType;
import soot.dexpler.Util;
import soot.javaToJimple.IInitialResolver;
import soot.options.Options;
import soot.tagkit.InnerClassAttribute;
import soot.tagkit.InnerClassTag;
import soot.tagkit.SourceFileTag;
import soot.tagkit.Tag;

public class DexClassLoader {
    protected void loadMethod(Method method, SootClass declaringClass, DexAnnotation annotations, DexMethod dexMethodFactory) {
        SootMethod sm = dexMethodFactory.makeSootMethod(method);
        if (declaringClass.declaresMethod(sm.getName(), sm.getParameterTypes(), sm.getReturnType())) {
            return;
        }
        declaringClass.addMethod(sm);
        annotations.handleMethodAnnotation(sm, method);
    }

    public IInitialResolver.Dependencies makeSootClass(SootClass sc, ClassDef defItem, MultiDexContainer.DexEntry<? extends DexFile> dexEntry) {
        String superClass = defItem.getSuperclass();
        IInitialResolver.Dependencies deps = new IInitialResolver.Dependencies();
        String sourceFile = defItem.getSourceFile();
        if (sourceFile != null) {
            sc.addTag(new SourceFileTag(sourceFile));
        }
        if (superClass != null) {
            String superClassName = Util.dottedClassName(superClass);
            SootClass sootSuperClass = SootResolver.v().makeClassRef(superClassName);
            sc.setSuperclass(sootSuperClass);
            deps.typesToHierarchy.add(sootSuperClass.getType());
        }
        int accessFlags = defItem.getAccessFlags();
        sc.setModifiers(accessFlags);
        if (defItem.getInterfaces() != null) {
            for (String string : defItem.getInterfaces()) {
                String string2 = Util.dottedClassName(string);
                if (sc.implementsInterface(string2)) continue;
                SootClass sootClass = SootResolver.v().makeClassRef(string2);
                sootClass.setModifiers(sootClass.getModifiers() | 0x200);
                sc.addInterface(sootClass);
                deps.typesToHierarchy.add(sootClass.getType());
            }
        }
        if (Options.v().oaat() && sc.resolvingLevel() <= 1) {
            return deps;
        }
        DexAnnotation da = this.createDexAnnotation(sc, deps);
        for (Field field : defItem.getStaticFields()) {
            this.loadField(sc, da, field);
        }
        for (Field field : defItem.getInstanceFields()) {
            this.loadField(sc, da, field);
        }
        DexMethod dexMethod = this.createDexMethodFactory(dexEntry, sc);
        for (Method method : defItem.getDirectMethods()) {
            this.loadMethod(method, sc, da, dexMethod);
        }
        for (Method method : defItem.getVirtualMethods()) {
            this.loadMethod(method, sc, da, dexMethod);
        }
        da.handleClassAnnotation(defItem);
        InnerClassAttribute innerClassAttribute = (InnerClassAttribute)sc.getTag("InnerClassAttribute");
        if (innerClassAttribute != null) {
            Iterator<InnerClassTag> iterator = innerClassAttribute.getSpecs().iterator();
            while (iterator.hasNext()) {
                Tag t2 = iterator.next();
                if (!(t2 instanceof InnerClassTag)) continue;
                InnerClassTag ict = (InnerClassTag)t2;
                String outer = DexInnerClassParser.getOuterClassNameFromTag(ict);
                if (outer == null || outer.length() == 0) {
                    iterator.remove();
                    continue;
                }
                if (outer.equals(sc.getName())) continue;
                String inner = ict.getInnerClass().replaceAll("/", ".");
                if (!inner.equals(sc.getName())) {
                    iterator.remove();
                    continue;
                }
                SootClass osc = SootResolver.v().makeClassRef(outer);
                if (osc == sc) {
                    if (!sc.hasOuterClass()) continue;
                    osc = sc.getOuterClass();
                } else {
                    deps.typesToHierarchy.add(osc.getType());
                }
                InnerClassAttribute icat = (InnerClassAttribute)osc.getTag("InnerClassAttribute");
                if (icat == null) {
                    icat = new InnerClassAttribute();
                    osc.addTag(icat);
                }
                InnerClassTag newt = new InnerClassTag(ict.getInnerClass(), ict.getOuterClass(), ict.getShortName(), ict.getAccessFlags());
                icat.add(newt);
                iterator.remove();
                if (sc.hasTag("InnerClassTag") || !((InnerClassTag)t2).getInnerClass().replaceAll("/", ".").equals(sc.toString())) continue;
                sc.addTag(t2);
            }
            if (innerClassAttribute.getSpecs().isEmpty()) {
                sc.getTags().remove(innerClassAttribute);
            }
        }
        return deps;
    }

    protected DexAnnotation createDexAnnotation(SootClass clazz, IInitialResolver.Dependencies deps) {
        return new DexAnnotation(clazz, deps);
    }

    protected DexMethod createDexMethodFactory(MultiDexContainer.DexEntry<? extends DexFile> dexEntry, SootClass sc) {
        return new DexMethod(dexEntry, sc);
    }

    protected void loadField(SootClass declaringClass, DexAnnotation annotations, Field sf) {
        if (declaringClass.declaresField(sf.getName(), DexType.toSoot(sf.getType()))) {
            return;
        }
        SootField sootField = DexField.makeSootField(sf);
        sootField = declaringClass.getOrAddField(sootField);
        annotations.handleFieldAnnotation(sootField, sf);
    }
}

