/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import com.google.common.collect.ArrayListMultimap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jf.dexlib2.analysis.ClassPath;
import org.jf.dexlib2.analysis.ClassPathResolver;
import org.jf.dexlib2.analysis.ClassProvider;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.iface.ExceptionHandler;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.MethodParameter;
import org.jf.dexlib2.iface.MultiDexContainer;
import org.jf.dexlib2.iface.TryBlock;
import org.jf.dexlib2.iface.debug.DebugItem;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.immutable.debug.ImmutableDebugItem;
import org.jf.dexlib2.immutable.debug.ImmutableEndLocal;
import org.jf.dexlib2.immutable.debug.ImmutableLineNumber;
import org.jf.dexlib2.immutable.debug.ImmutableRestartLocal;
import org.jf.dexlib2.immutable.debug.ImmutableStartLocal;
import org.jf.dexlib2.util.MethodUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.DoubleType;
import soot.Local;
import soot.LongType;
import soot.Modifier;
import soot.NullType;
import soot.PackManager;
import soot.PhaseOptions;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.UnknownType;
import soot.dexpler.DalvikThrowAnalysis;
import soot.dexpler.DexArrayInitReducer;
import soot.dexpler.DexIfTransformer;
import soot.dexpler.DexJumpChainShortener;
import soot.dexpler.DexNullArrayRefTransformer;
import soot.dexpler.DexNullInstanceofTransformer;
import soot.dexpler.DexNullThrowTransformer;
import soot.dexpler.DexNullTransformer;
import soot.dexpler.DexNumTransformer;
import soot.dexpler.DexReturnInliner;
import soot.dexpler.DexReturnPacker;
import soot.dexpler.DexReturnValuePropagator;
import soot.dexpler.DexTrapStackFixer;
import soot.dexpler.DexType;
import soot.dexpler.InvalidDalvikBytecodeException;
import soot.dexpler.TrapMinimizer;
import soot.dexpler.instructions.DanglingInstruction;
import soot.dexpler.instructions.DeferableInstruction;
import soot.dexpler.instructions.DexlibAbstractInstruction;
import soot.dexpler.instructions.InstructionFactory;
import soot.dexpler.instructions.MoveExceptionInstruction;
import soot.dexpler.instructions.OdexInstruction;
import soot.dexpler.instructions.PseudoInstruction;
import soot.dexpler.instructions.RetypeableInstruction;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.DefinitionStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NopStmt;
import soot.jimple.NullConstant;
import soot.jimple.internal.JIdentityStmt;
import soot.jimple.toolkits.base.Aggregator;
import soot.jimple.toolkits.scalar.ConditionalBranchFolder;
import soot.jimple.toolkits.scalar.ConstantCastEliminator;
import soot.jimple.toolkits.scalar.CopyPropagator;
import soot.jimple.toolkits.scalar.DeadAssignmentEliminator;
import soot.jimple.toolkits.scalar.FieldStaticnessCorrector;
import soot.jimple.toolkits.scalar.IdentityCastEliminator;
import soot.jimple.toolkits.scalar.IdentityOperationEliminator;
import soot.jimple.toolkits.scalar.MethodStaticnessCorrector;
import soot.jimple.toolkits.scalar.NopEliminator;
import soot.jimple.toolkits.scalar.UnreachableCodeEliminator;
import soot.jimple.toolkits.typing.TypeAssigner;
import soot.options.JBOptions;
import soot.options.Options;
import soot.tagkit.LineNumberTag;
import soot.tagkit.SourceLineNumberTag;
import soot.toolkits.exceptions.TrapTightener;
import soot.toolkits.scalar.LocalPacker;
import soot.toolkits.scalar.LocalSplitter;
import soot.toolkits.scalar.UnusedLocalEliminator;

public class DexBody {
    private static final Logger logger = LoggerFactory.getLogger(DexBody.class);
    protected List<DexlibAbstractInstruction> instructions;
    protected Local[] registerLocals;
    protected Local storeResultLocal;
    protected Map<Integer, DexlibAbstractInstruction> instructionAtAddress;
    protected List<DeferableInstruction> deferredInstructions;
    protected Set<RetypeableInstruction> instructionsToRetype;
    protected DanglingInstruction dangling;
    protected int numRegisters;
    protected int numParameterRegisters;
    protected final List<Type> parameterTypes;
    protected final List<String> parameterNames;
    protected boolean isStatic;
    protected JimpleBody jBody;
    protected List<? extends TryBlock<? extends ExceptionHandler>> tries;
    protected RefType declaringClassType;
    protected final MultiDexContainer.DexEntry<? extends DexFile> dexEntry;
    protected final Method method;
    private final ArrayListMultimap<Integer, RegDbgEntry> localDebugs;
    protected List<PseudoInstruction> pseudoInstructionData = new ArrayList<PseudoInstruction>();
    protected Set<String> takenLocalNames;
    private LocalSplitter localSplitter = null;
    private UnreachableCodeEliminator unreachableCodeEliminator = null;
    private CopyPropagator copyPropagator = null;

    PseudoInstruction isAddressInData(int a) {
        for (PseudoInstruction pi : this.pseudoInstructionData) {
            int fb = pi.getDataFirstByte();
            int lb = pi.getDataLastByte();
            if (fb > a || a > lb) continue;
            return pi;
        }
        return null;
    }

    protected String freshLocalName(String hint) {
        String fresh;
        if (hint == null || hint.equals("")) {
            hint = "$local";
        }
        if (!this.takenLocalNames.contains(hint)) {
            fresh = hint;
        } else {
            int i = 1;
            while (this.takenLocalNames.contains(fresh = hint + Integer.toString(i))) {
                ++i;
            }
        }
        this.takenLocalNames.add(fresh);
        return fresh;
    }

    protected DexBody(MultiDexContainer.DexEntry<? extends DexFile> dexFile, Method method, RefType declaringClassType) {
        MethodImplementation code = method.getImplementation();
        if (code == null) {
            throw new RuntimeException("error: no code for method " + method.getName());
        }
        this.declaringClassType = declaringClassType;
        this.tries = code.getTryBlocks();
        List<? extends MethodParameter> parameters = method.getParameters();
        if (parameters != null) {
            this.parameterNames = new ArrayList<String>();
            this.parameterTypes = new ArrayList<Type>();
            for (MethodParameter methodParameter : method.getParameters()) {
                this.parameterNames.add(methodParameter.getName());
                this.parameterTypes.add(DexType.toSoot(methodParameter.getType()));
            }
        } else {
            this.parameterNames = Collections.emptyList();
            this.parameterTypes = Collections.emptyList();
        }
        this.isStatic = Modifier.isStatic(method.getAccessFlags());
        this.numRegisters = code.getRegisterCount();
        this.numParameterRegisters = MethodUtil.getParameterRegisterCount(method);
        if (!this.isStatic) {
            --this.numParameterRegisters;
        }
        this.instructions = new ArrayList<DexlibAbstractInstruction>();
        this.instructionAtAddress = new HashMap<Integer, DexlibAbstractInstruction>();
        this.localDebugs = ArrayListMultimap.create();
        this.takenLocalNames = new HashSet<String>();
        this.registerLocals = new Local[this.numRegisters];
        this.extractDexInstructions(code);
        if (this.numParameterRegisters > this.numRegisters) {
            throw new RuntimeException("Malformed dex file: insSize (" + this.numParameterRegisters + ") > registersSize (" + this.numRegisters + ")");
        }
        for (DebugItem debugItem : code.getDebugItems()) {
            ImmutableEndLocal el;
            List lds;
            if (debugItem instanceof ImmutableLineNumber) {
                ImmutableLineNumber ln = (ImmutableLineNumber)debugItem;
                DexlibAbstractInstruction ins = this.instructionAtAddress(ln.getCodeAddress());
                if (ins == null) continue;
                ins.setLineNumber(ln.getLineNumber());
                continue;
            }
            if (debugItem instanceof ImmutableStartLocal || debugItem instanceof ImmutableRestartLocal) {
                String signature;
                String type;
                String name;
                int codeAddr;
                int reg;
                ImmutableDebugItem sl;
                if (debugItem instanceof ImmutableStartLocal) {
                    sl = (ImmutableStartLocal)debugItem;
                    reg = ((ImmutableStartLocal)sl).getRegister();
                    codeAddr = sl.getCodeAddress();
                    name = ((ImmutableStartLocal)sl).getName();
                    type = ((ImmutableStartLocal)sl).getType();
                    signature = ((ImmutableStartLocal)sl).getSignature();
                } else {
                    sl = (ImmutableRestartLocal)debugItem;
                    reg = ((ImmutableRestartLocal)sl).getRegister();
                    codeAddr = sl.getCodeAddress();
                    name = ((ImmutableRestartLocal)sl).getName();
                    type = ((ImmutableRestartLocal)sl).getType();
                    signature = ((ImmutableRestartLocal)sl).getSignature();
                }
                if (name == null || type == null) continue;
                this.localDebugs.put((Object)reg, (Object)new RegDbgEntry(codeAddr, -1, reg, name, type, signature));
                continue;
            }
            if (!(debugItem instanceof ImmutableEndLocal) || (lds = this.localDebugs.get((Object)(el = (ImmutableEndLocal)debugItem).getRegister())) == null || lds.isEmpty()) continue;
            ((RegDbgEntry)lds.get((int)(lds.size() - 1))).endAddress = el.getCodeAddress();
        }
        this.dexEntry = dexFile;
        this.method = method;
    }

    protected void extractDexInstructions(MethodImplementation code) {
        int address = 0;
        for (Instruction instruction : code.getInstructions()) {
            DexlibAbstractInstruction dexInstruction = InstructionFactory.fromInstruction(instruction, address);
            this.instructions.add(dexInstruction);
            this.instructionAtAddress.put(address, dexInstruction);
            address += instruction.getCodeUnits();
        }
    }

    public Set<Type> usedTypes() {
        HashSet<Type> types = new HashSet<Type>();
        for (DexlibAbstractInstruction dexlibAbstractInstruction : this.instructions) {
            types.addAll(dexlibAbstractInstruction.introducedTypes());
        }
        if (this.tries != null) {
            for (TryBlock tryBlock : this.tries) {
                List hList = tryBlock.getExceptionHandlers();
                for (ExceptionHandler handler : hList) {
                    String exType = handler.getExceptionType();
                    if (exType == null) continue;
                    types.add(DexType.toSoot(exType));
                }
            }
        }
        return types;
    }

    public void add(Unit u) {
        this.getBody().getUnits().add(u);
    }

    public void addDeferredJimplification(DeferableInstruction i) {
        this.deferredInstructions.add(i);
    }

    public void addRetype(RetypeableInstruction i) {
        this.instructionsToRetype.add(i);
    }

    public Body getBody() {
        if (this.jBody == null) {
            throw new RuntimeException("No jimplification happened yet, no body available.");
        }
        return this.jBody;
    }

    public Local[] getRegisterLocals() {
        return this.registerLocals;
    }

    public Local getRegisterLocal(int num) throws InvalidDalvikBytecodeException {
        int totalRegisters = this.registerLocals.length;
        if (num > totalRegisters) {
            throw new InvalidDalvikBytecodeException("Trying to access register " + num + " but only " + totalRegisters + " is/are available.");
        }
        return this.registerLocals[num];
    }

    public Local getStoreResultLocal() {
        return this.storeResultLocal;
    }

    public DexlibAbstractInstruction instructionAtAddress(int address) {
        DexlibAbstractInstruction i = null;
        while (i == null && address >= 0) {
            i = this.instructionAtAddress.get(address);
            --address;
        }
        return i;
    }

    /*
     * WARNING - void declaration
     */
    public Body jimplify(Body b, SootMethod m4) {
        Jimple jimple = Jimple.v();
        UnknownType unknownType = UnknownType.v();
        NullConstant nullConstant = NullConstant.v();
        Options options = Options.v();
        JBOptions jbOptions = new JBOptions(PhaseOptions.v().getPhaseOptions("jb"));
        this.jBody = (JimpleBody)b;
        this.deferredInstructions = new ArrayList<DeferableInstruction>();
        this.instructionsToRetype = new HashSet<RetypeableInstruction>();
        if (jbOptions.use_original_names()) {
            PhaseOptions.v().setPhaseOptionIfUnset("jb.lns", "only-stack-locals");
        }
        if (jbOptions.stabilize_local_names()) {
            PhaseOptions.v().setPhaseOption("jb.lns", "sort-locals:true");
        }
        LinkedList<Local> paramLocals = new LinkedList<Local>();
        if (!this.isStatic) {
            int thisRegister = this.numRegisters - this.numParameterRegisters - 1;
            Local thisLocal = jimple.newLocal(this.freshLocalName("this"), unknownType);
            this.jBody.getLocals().add(thisLocal);
            this.registerLocals[thisRegister] = thisLocal;
            JIdentityStmt idStmt = (JIdentityStmt)jimple.newIdentityStmt(thisLocal, jimple.newThisRef(this.declaringClassType));
            this.add(idStmt);
            paramLocals.add(thisLocal);
        }
        int i = 0;
        int argIdx = 0;
        int parameterRegister = this.numRegisters - this.numParameterRegisters;
        for (Type t2 : this.parameterTypes) {
            void var14_21;
            void var14_24;
            Object var14_22 = null;
            Type localType = null;
            if (jbOptions.use_original_names()) {
                try {
                    String string = this.parameterNames.get(argIdx);
                    localType = this.parameterTypes.get(argIdx);
                }
                catch (Exception ex) {
                    logger.error("Exception while reading original parameter names.", ex);
                }
            }
            if (var14_24 == null && this.localDebugs.containsKey(parameterRegister)) {
                String string = ((RegDbgEntry)this.localDebugs.get((Object)Integer.valueOf((int)parameterRegister)).get((int)0)).name;
            } else {
                String string = "$u" + parameterRegister;
            }
            if (localType == null) {
                localType = unknownType;
            }
            Local gen = jimple.newLocal(this.freshLocalName((String)var14_21), localType);
            this.jBody.getLocals().add(gen);
            this.registerLocals[parameterRegister] = gen;
            JIdentityStmt idStmt = (JIdentityStmt)jimple.newIdentityStmt(gen, jimple.newParameterRef(t2, i++));
            this.add(idStmt);
            paramLocals.add(gen);
            if (t2 instanceof LongType || t2 instanceof DoubleType) {
                String name = this.localDebugs.containsKey(++parameterRegister) ? ((RegDbgEntry)this.localDebugs.get((Object)Integer.valueOf((int)parameterRegister)).get((int)0)).name : "$u" + parameterRegister;
                Local g2 = jimple.newLocal(this.freshLocalName(name), unknownType);
                this.jBody.getLocals().add(g2);
                this.registerLocals[parameterRegister] = g2;
            }
            ++parameterRegister;
            ++argIdx;
        }
        for (i = 0; i < this.numRegisters - this.numParameterRegisters - (this.isStatic ? 0 : 1); ++i) {
            String name = this.localDebugs.containsKey(i) ? ((RegDbgEntry)this.localDebugs.get((Object)Integer.valueOf((int)i)).get((int)0)).name : "$u" + i;
            this.registerLocals[i] = jimple.newLocal(this.freshLocalName(name), unknownType);
            this.jBody.getLocals().add(this.registerLocals[i]);
        }
        this.storeResultLocal = jimple.newLocal(this.freshLocalName("$u-1"), unknownType);
        this.jBody.getLocals().add(this.storeResultLocal);
        DexFile dexFile = this.dexEntry.getDexFile();
        boolean isOdex = dexFile instanceof DexBackedDexFile ? ((DexBackedDexFile)dexFile).supportsOptimizedOpcodes() : false;
        ClassPath cp = null;
        if (isOdex) {
            String[] sootClasspath = options.soot_classpath().split(File.pathSeparator);
            Iterator<Object> classpathList = new ArrayList();
            for (String str : sootClasspath) {
                classpathList.add(str);
            }
            try {
                ClassPathResolver classPathResolver = new ClassPathResolver((List<String>)((Object)classpathList), (List<String>)((Object)classpathList), (List<String>)((Object)classpathList), this.dexEntry);
                cp = new ClassPath(classPathResolver.getResolvedClassProviders().toArray(new ClassProvider[0]));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        int prevLineNumber = -1;
        for (DexlibAbstractInstruction dexlibAbstractInstruction : this.instructions) {
            if (isOdex && dexlibAbstractInstruction instanceof OdexInstruction) {
                ((OdexInstruction)((Object)dexlibAbstractInstruction)).deOdex(dexFile, this.method, cp);
            }
            if (this.dangling != null) {
                this.dangling.finalize(this, dexlibAbstractInstruction);
                this.dangling = null;
            }
            dexlibAbstractInstruction.jimplify(this);
            if (dexlibAbstractInstruction.getLineNumber() > 0) {
                prevLineNumber = dexlibAbstractInstruction.getLineNumber();
                continue;
            }
            dexlibAbstractInstruction.setLineNumber(prevLineNumber);
        }
        if (this.dangling != null) {
            this.dangling.finalize(this, null);
        }
        for (DeferableInstruction deferableInstruction : this.deferredInstructions) {
            deferableInstruction.deferredJimplify(this);
        }
        if (this.tries != null) {
            this.addTraps();
        }
        if (options.keep_line_number()) {
            this.fixLineNumbers();
        }
        this.instructions = null;
        this.instructionAtAddress.clear();
        this.deferredInstructions = null;
        this.dangling = null;
        this.tries = null;
        this.parameterNames.clear();
        DexTrapStackFixer.v().transform(this.jBody);
        DexJumpChainShortener.v().transform(this.jBody);
        DexReturnInliner.v().transform(this.jBody);
        DexArrayInitReducer.v().transform(this.jBody);
        this.getLocalSplitter().transform(this.jBody);
        this.getUnreachableCodeEliminator().transform(this.jBody);
        DeadAssignmentEliminator.v().transform(this.jBody);
        UnusedLocalEliminator.v().transform(this.jBody);
        for (RetypeableInstruction retypeableInstruction : this.instructionsToRetype) {
            retypeableInstruction.retype(this.jBody);
        }
        DexNumTransformer.v().transform(this.jBody);
        DexReturnValuePropagator.v().transform(this.jBody);
        this.getCopyPopagator().transform(this.jBody);
        DexNullThrowTransformer.v().transform(this.jBody);
        DexNullTransformer.v().transform(this.jBody);
        DexIfTransformer.v().transform(this.jBody);
        DeadAssignmentEliminator.v().transform(this.jBody);
        UnusedLocalEliminator.v().transform(this.jBody);
        DexNullArrayRefTransformer.v().transform(this.jBody);
        DexNullInstanceofTransformer.v().transform(this.jBody);
        TypeAssigner.v().transform(this.jBody);
        RefType objectType = RefType.v("java.lang.Object");
        LocalPacker.v().transform(this.jBody);
        UnusedLocalEliminator.v().transform(this.jBody);
        PackManager.v().getTransform("jb.lns").apply(this.jBody);
        if (Options.v().wrong_staticness() == 3 || Options.v().wrong_staticness() == 4) {
            FieldStaticnessCorrector.v().transform(this.jBody);
            MethodStaticnessCorrector.v().transform(this.jBody);
        }
        TrapTightener.v().transform(this.jBody);
        TrapMinimizer.v().transform(this.jBody);
        Aggregator.v().transform(this.jBody);
        ConditionalBranchFolder.v().transform(this.jBody);
        ConstantCastEliminator.v().transform(this.jBody);
        IdentityCastEliminator.v().transform(this.jBody);
        IdentityOperationEliminator.v().transform(this.jBody);
        UnreachableCodeEliminator.v().transform(this.jBody);
        DeadAssignmentEliminator.v().transform(this.jBody);
        UnusedLocalEliminator.v().transform(this.jBody);
        NopEliminator.v().transform(this.jBody);
        DexReturnPacker.v().transform(this.jBody);
        for (Unit u : this.jBody.getUnits()) {
            RefType rt;
            Type t3;
            DefinitionStmt def;
            CastExpr c;
            AssignStmt ass;
            if (u instanceof AssignStmt && (ass = (AssignStmt)u).getRightOp() instanceof CastExpr && (c = (CastExpr)ass.getRightOp()).getType() instanceof NullType) {
                ass.setRightOp(nullConstant);
            }
            if (!(u instanceof DefinitionStmt) || !((def = (DefinitionStmt)u).getLeftOp() instanceof Local) || !(def.getRightOp() instanceof CaughtExceptionRef) || !((t3 = def.getLeftOp().getType()) instanceof RefType) || !(rt = (RefType)t3).getSootClass().isPhantom() || rt.getSootClass().hasSuperclass() || rt.getSootClass().getName().equals("java.lang.Throwable")) continue;
            rt.getSootClass().setSuperclass(Scene.v().getSootClass("java.lang.Throwable"));
        }
        for (Local l : this.jBody.getLocals()) {
            Type t4 = l.getType();
            if (!(t4 instanceof NullType)) continue;
            l.setType(objectType);
        }
        PackManager.v().getTransform("jb.lns").apply(this.jBody);
        return this.jBody;
    }

    protected void fixLineNumbers() {
        int prevLn = -1;
        for (DexlibAbstractInstruction instruction : this.instructions) {
            Unit unit = instruction.getUnit();
            int lineNumber = unit.getJavaSourceStartLineNumber();
            if (lineNumber < 0) {
                if (prevLn < 0) continue;
                unit.addTag(new LineNumberTag(prevLn));
                unit.addTag(new SourceLineNumberTag(prevLn));
                continue;
            }
            prevLn = lineNumber;
        }
    }

    protected LocalSplitter getLocalSplitter() {
        if (this.localSplitter == null) {
            this.localSplitter = new LocalSplitter(DalvikThrowAnalysis.v());
        }
        return this.localSplitter;
    }

    protected UnreachableCodeEliminator getUnreachableCodeEliminator() {
        if (this.unreachableCodeEliminator == null) {
            this.unreachableCodeEliminator = new UnreachableCodeEliminator(DalvikThrowAnalysis.v());
        }
        return this.unreachableCodeEliminator;
    }

    protected CopyPropagator getCopyPopagator() {
        if (this.copyPropagator == null) {
            this.copyPropagator = new CopyPropagator(DalvikThrowAnalysis.v(), false);
        }
        return this.copyPropagator;
    }

    public void setDanglingInstruction(DanglingInstruction i) {
        this.dangling = i;
    }

    public List<DexlibAbstractInstruction> instructionsAfter(DexlibAbstractInstruction instruction) {
        int i = this.instructions.indexOf(instruction);
        if (i == -1) {
            throw new IllegalArgumentException("Instruction" + instruction + "not part of this body.");
        }
        return this.instructions.subList(i + 1, this.instructions.size());
    }

    public List<DexlibAbstractInstruction> instructionsBefore(DexlibAbstractInstruction instruction) {
        int i = this.instructions.indexOf(instruction);
        if (i == -1) {
            throw new IllegalArgumentException("Instruction " + instruction + " not part of this body.");
        }
        ArrayList<DexlibAbstractInstruction> l = new ArrayList<DexlibAbstractInstruction>();
        l.addAll(this.instructions.subList(0, i));
        Collections.reverse(l);
        return l;
    }

    private void addTraps() {
        Jimple jimple = Jimple.v();
        for (TryBlock<? extends ExceptionHandler> tryBlock : this.tries) {
            int startAddress = tryBlock.getStartCodeAddress();
            int length = tryBlock.getCodeUnitCount();
            int endAddress = startAddress + length;
            Unit beginStmt = this.instructionAtAddress(startAddress).getUnit();
            Unit endStmt = this.instructionAtAddress(endAddress).getUnit();
            if (this.jBody.getUnits().getLast() == endStmt && this.instructionAtAddress(endAddress - 1).getUnit() == endStmt) {
                NopStmt nop = jimple.newNopStmt();
                this.jBody.getUnits().insertAfter(nop, endStmt);
                endStmt = nop;
            }
            List<? extends ExceptionHandler> hList = tryBlock.getExceptionHandlers();
            for (ExceptionHandler exceptionHandler : hList) {
                Type t2;
                String exceptionType = exceptionHandler.getExceptionType();
                if (exceptionType == null) {
                    exceptionType = "Ljava/lang/Throwable;";
                }
                if (!((t2 = DexType.toSoot(exceptionType)) instanceof RefType)) continue;
                SootClass exception = ((RefType)t2).getSootClass();
                DexlibAbstractInstruction instruction = this.instructionAtAddress(exceptionHandler.getHandlerCodeAddress());
                if (!(instruction instanceof MoveExceptionInstruction)) {
                    logger.debug("" + String.format("First instruction of trap handler unit not MoveException but %s", instruction.getClass().getName()));
                } else {
                    ((MoveExceptionInstruction)instruction).setRealType(this, exception.getType());
                }
                Trap trap = jimple.newTrap(exception, beginStmt, endStmt, instruction.getUnit());
                this.jBody.getTraps().add(trap);
            }
        }
    }

    protected class RegDbgEntry {
        public int startAddress;
        public int endAddress;
        public int register;
        public String name;
        public Type type;
        public String signature;

        public RegDbgEntry(int sa, int ea, int reg, String nam, String ty, String sig) {
            this.startAddress = sa;
            this.endAddress = ea;
            this.register = reg;
            this.name = nam;
            this.type = DexType.toSoot(ty);
            this.signature = sig;
        }
    }
}

