/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.misc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.G;
import soot.RefType;
import soot.Scene;
import soot.Singletons;
import soot.SootClass;
import soot.SootMethod;
import soot.Trap;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;
import soot.jimple.internal.JExitMonitorStmt;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.CallGraphBuilder;
import soot.jimple.toolkits.callgraph.Edge;
import soot.util.IterableSet;

public class ThrowFinder {
    private static final Logger logger = LoggerFactory.getLogger(ThrowFinder.class);
    private HashSet<SootMethod> registeredMethods;
    private HashMap<Stmt, HashSet<SootClass>> protectionSet;
    public static boolean DEBUG = false;

    public ThrowFinder(Singletons.Global g2) {
    }

    public static ThrowFinder v() {
        return G.v().soot_dava_toolkits_base_misc_ThrowFinder();
    }

    public void find() {
        CallGraph cg;
        logger.debug("Verifying exception handling.. ");
        this.registeredMethods = new HashSet();
        this.protectionSet = new HashMap();
        if (Scene.v().hasCallGraph()) {
            cg = Scene.v().getCallGraph();
        } else {
            new CallGraphBuilder().build();
            cg = Scene.v().getCallGraph();
            Scene.v().releaseCallGraph();
        }
        IterableSet<SootMethod> worklist = new IterableSet<SootMethod>();
        logger.debug("\b. ");
        Iterator<SootClass> classIt = Scene.v().getApplicationClasses().iterator();
        while (classIt.hasNext()) {
            Iterator<SootMethod> methodIt = classIt.next().methodIterator();
            while (methodIt.hasNext()) {
                SootMethod m4 = methodIt.next();
                this.register_AreasOfProtection(m4);
                worklist.add(m4);
            }
        }
        HashMap<SootClass, IterableSet> subClassSet = new HashMap<SootClass, IterableSet>();
        HashMap<SootClass, IterableSet> superClassSet = new HashMap<SootClass, IterableSet>();
        HashSet<SootClass> applicationClasses = new HashSet<SootClass>();
        applicationClasses.addAll(Scene.v().getApplicationClasses());
        for (SootClass c : Scene.v().getApplicationClasses()) {
            IterableSet subClasses;
            IterableSet<SootClass> superClasses = (IterableSet<SootClass>)superClassSet.get(c);
            if (superClasses == null) {
                superClasses = new IterableSet<SootClass>();
                superClassSet.put(c, superClasses);
            }
            if ((subClasses = (IterableSet)subClassSet.get(c)) == null) {
                subClasses = new IterableSet();
                subClassSet.put(c, subClasses);
            }
            if (c.hasSuperclass()) {
                SootClass superClass = c.getSuperclass();
                IterableSet<SootClass> superClassSubClasses = subClassSet.get(superClass);
                if (superClassSubClasses == null) {
                    superClassSubClasses = new IterableSet<SootClass>();
                    subClassSet.put(superClass, superClassSubClasses);
                }
                superClassSubClasses.add(c);
                superClasses.add(superClass);
            }
            for (SootClass interfaceClass : c.getInterfaces()) {
                IterableSet<SootClass> interfaceClassSubClasses = subClassSet.get(interfaceClass);
                if (interfaceClassSubClasses == null) {
                    interfaceClassSubClasses = new IterableSet<SootClass>();
                    subClassSet.put(interfaceClass, interfaceClassSubClasses);
                }
                interfaceClassSubClasses.add(c);
                superClasses.add(interfaceClass);
            }
        }
        HashMap<SootMethod, IterableSet> agreementMethodSet = new HashMap<SootMethod, IterableSet>();
        for (SootMethod m5 : worklist) {
            if (!m5.isAbstract() && !m5.isNative()) {
                List<SootClass> exceptionList = m5.getExceptions();
                IterableSet<SootClass> exceptionSet = new IterableSet<SootClass>(exceptionList);
                boolean changed = false;
                for (Unit u : m5.retrieveActiveBody().getUnits()) {
                    SootClass c;
                    Type t2;
                    HashSet<SootClass> handled = this.protectionSet.get(u);
                    if (!(u instanceof ThrowStmt) || !((t2 = ((ThrowStmt)u).getOp().getType()) instanceof RefType) || this.handled_Exception(handled, c = ((RefType)t2).getSootClass()) || exceptionSet.contains(c)) continue;
                    UnitPatchingChain list = m5.retrieveActiveBody().getUnits();
                    Unit pred = list.getPredOf(u);
                    if (!(pred instanceof JExitMonitorStmt)) {
                        exceptionSet.add(c);
                        changed = true;
                        if (!DEBUG) continue;
                        System.out.println("Added exception which is explicitly thrown" + c.getName());
                        continue;
                    }
                    if (!DEBUG) continue;
                    System.out.println("Found monitor exit" + pred + " hence not adding");
                }
                Iterator<Object> it = cg.edgesOutOf(m5);
                while (it.hasNext()) {
                    Edge e = (Edge)it.next();
                    Stmt callSite = e.srcStmt();
                    if (callSite == null) continue;
                    HashSet<SootClass> handled = this.protectionSet.get(callSite);
                    SootMethod target = e.tgt();
                    for (SootClass exception : target.getExceptions()) {
                        if (this.handled_Exception(handled, exception) || exceptionSet.contains(exception)) continue;
                        exceptionSet.add(exception);
                        changed = true;
                    }
                }
                if (changed) {
                    exceptionList.clear();
                    exceptionList.addAll(exceptionSet);
                }
            }
            this.find_OtherMethods(m5, agreementMethodSet, subClassSet, applicationClasses);
            this.find_OtherMethods(m5, agreementMethodSet, superClassSet, applicationClasses);
        }
        while (!worklist.isEmpty()) {
            SootMethod m5;
            m5 = (SootMethod)worklist.getFirst();
            worklist.removeFirst();
            IterableSet agreementMethods = (IterableSet)agreementMethodSet.get(m5);
            if (agreementMethods != null) {
                for (SootMethod otherMethod : agreementMethods) {
                    List<SootClass> otherExceptionsList = otherMethod.getExceptions();
                    IterableSet<SootClass> otherExceptionSet = new IterableSet<SootClass>(otherExceptionsList);
                    boolean changed = false;
                    for (SootClass exception : m5.getExceptions()) {
                        if (otherExceptionSet.contains(exception)) continue;
                        otherExceptionSet.add(exception);
                        changed = true;
                    }
                    if (!changed) continue;
                    otherExceptionsList.clear();
                    otherExceptionsList.addAll(otherExceptionSet);
                    if (worklist.contains(otherMethod)) continue;
                    worklist.addLast(otherMethod);
                }
            }
            Iterator<Edge> it = cg.edgesOutOf(m5);
            while (it.hasNext()) {
                Edge e = it.next();
                Stmt callingSite = e.srcStmt();
                if (callingSite == null) continue;
                SootMethod callingMethod = e.src();
                List<SootClass> exceptionList = callingMethod.getExceptions();
                IterableSet<SootClass> exceptionSet = new IterableSet<SootClass>(exceptionList);
                HashSet<SootClass> handled = this.protectionSet.get(callingSite);
                boolean changed = false;
                for (SootClass exception : m5.getExceptions()) {
                    if (this.handled_Exception(handled, exception) || exceptionSet.contains(exception)) continue;
                    exceptionSet.add(exception);
                    changed = true;
                }
                if (!changed) continue;
                exceptionList.clear();
                exceptionList.addAll(exceptionSet);
                if (worklist.contains(callingMethod)) continue;
                worklist.addLast(callingMethod);
            }
        }
    }

    private void find_OtherMethods(SootMethod startingMethod, HashMap<SootMethod, IterableSet> methodMapping, HashMap<SootClass, IterableSet> classMapping, HashSet<SootClass> applicationClasses) {
        IterableSet worklist = (IterableSet)classMapping.get(startingMethod.getDeclaringClass()).clone();
        HashSet<SootClass> touchSet = new HashSet<SootClass>();
        touchSet.addAll(worklist);
        String signature = startingMethod.getSubSignature();
        while (!worklist.isEmpty()) {
            SootClass currentClass = (SootClass)worklist.getFirst();
            worklist.removeFirst();
            if (!applicationClasses.contains(currentClass)) continue;
            if (currentClass.declaresMethod(signature)) {
                IterableSet<SootMethod> otherMethods = methodMapping.get(startingMethod);
                if (otherMethods == null) {
                    otherMethods = new IterableSet<SootMethod>();
                    methodMapping.put(startingMethod, otherMethods);
                }
                otherMethods.add(currentClass.getMethod(signature));
                continue;
            }
            IterableSet otherClasses = classMapping.get(currentClass);
            if (otherClasses == null) continue;
            for (SootClass otherClass : otherClasses) {
                if (touchSet.contains(otherClass)) continue;
                worklist.addLast(otherClass);
                touchSet.add(otherClass);
            }
        }
    }

    private void register_AreasOfProtection(SootMethod m4) {
        if (this.registeredMethods.contains(m4)) {
            return;
        }
        this.registeredMethods.add(m4);
        if (!m4.hasActiveBody()) {
            return;
        }
        Body b = m4.getActiveBody();
        UnitPatchingChain stmts = b.getUnits();
        for (Trap t2 : b.getTraps()) {
            SootClass exception = t2.getException();
            Iterator<Unit> sit = stmts.iterator(t2.getBeginUnit(), stmts.getPredOf(t2.getEndUnit()));
            while (sit.hasNext()) {
                Stmt s2 = (Stmt)sit.next();
                HashSet<SootClass> handled = null;
                handled = this.protectionSet.get(s2);
                if (handled == null) {
                    handled = new HashSet();
                    this.protectionSet.put(s2, handled);
                }
                if (handled.contains(exception)) continue;
                handled.add(exception);
            }
        }
    }

    private boolean handled_Exception(HashSet handledExceptions, SootClass c) {
        SootClass thrownException = c;
        if (this.is_HandledByRuntime(thrownException)) {
            return true;
        }
        if (handledExceptions == null) {
            return false;
        }
        while (!handledExceptions.contains(thrownException)) {
            if (!thrownException.hasSuperclass()) {
                return false;
            }
            thrownException = thrownException.getSuperclass();
        }
        return true;
    }

    private boolean is_HandledByRuntime(SootClass c) {
        SootClass thrownException = c;
        SootClass runtimeException = Scene.v().getSootClass("java.lang.RuntimeException");
        SootClass error = Scene.v().getSootClass("java.lang.Error");
        while (thrownException != runtimeException && thrownException != error) {
            if (!thrownException.hasSuperclass()) {
                return false;
            }
            thrownException = thrownException.getSuperclass();
        }
        return true;
    }
}

