/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.traversals;

import java.util.ArrayList;
import java.util.List;
import soot.Local;
import soot.Value;
import soot.ValueBox;
import soot.dava.internal.AST.ASTAggregatedCondition;
import soot.dava.internal.AST.ASTBinaryCondition;
import soot.dava.internal.AST.ASTCondition;
import soot.dava.internal.AST.ASTDoWhileNode;
import soot.dava.internal.AST.ASTForLoopNode;
import soot.dava.internal.AST.ASTIfElseNode;
import soot.dava.internal.AST.ASTIfNode;
import soot.dava.internal.AST.ASTMethodNode;
import soot.dava.internal.AST.ASTNode;
import soot.dava.internal.AST.ASTStatementSequenceNode;
import soot.dava.internal.AST.ASTSwitchNode;
import soot.dava.internal.AST.ASTSynchronizedBlockNode;
import soot.dava.internal.AST.ASTUnaryCondition;
import soot.dava.internal.AST.ASTWhileNode;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.toolkits.base.AST.analysis.DepthFirstAdapter;
import soot.dava.toolkits.base.AST.structuredAnalysis.DavaFlowSet;
import soot.dava.toolkits.base.AST.structuredAnalysis.ReachingCopies;
import soot.dava.toolkits.base.AST.traversals.ASTParentNodeFinder;
import soot.dava.toolkits.base.AST.traversals.ASTUsesAndDefs;
import soot.dava.toolkits.base.AST.traversals.ClosestAbruptTargetFinder;
import soot.jimple.ConditionExpr;
import soot.jimple.DefinitionStmt;
import soot.jimple.Stmt;

public class CopyPropagation
extends DepthFirstAdapter {
    public static boolean DEBUG = false;
    ASTNode AST;
    ASTUsesAndDefs useDefs;
    ReachingCopies reachingCopies;
    ASTParentNodeFinder parentOf;
    boolean someCopyStmtModified = false;
    boolean ASTMODIFIED;

    public CopyPropagation(ASTNode AST) {
        this.AST = AST;
        this.ASTMODIFIED = false;
        this.setup();
    }

    public CopyPropagation(boolean verbose, ASTNode AST) {
        super(verbose);
        this.AST = AST;
        this.ASTMODIFIED = false;
        this.setup();
    }

    private void setup() {
        if (DEBUG) {
            System.out.println("computing usesAnd Defs");
        }
        this.useDefs = new ASTUsesAndDefs(this.AST);
        this.AST.apply(this.useDefs);
        if (DEBUG) {
            System.out.println("computing usesAnd Defs....done");
        }
        this.reachingCopies = new ReachingCopies(this.AST);
        this.parentOf = new ASTParentNodeFinder();
        this.AST.apply(this.parentOf);
    }

    @Override
    public void outASTMethodNode(ASTMethodNode node) {
        if (this.ASTMODIFIED) {
            this.AST.apply(ClosestAbruptTargetFinder.v());
            CopyPropagation prop1 = new CopyPropagation(this.AST);
            this.AST.apply(prop1);
        }
    }

    @Override
    public void inASTStatementSequenceNode(ASTStatementSequenceNode node) {
        for (AugmentedStmt as : node.getStatements()) {
            Stmt s2 = as.get_Stmt();
            if (!this.isCopyStmt(s2)) continue;
            this.handleCopyStmt((DefinitionStmt)s2);
        }
    }

    public boolean isCopyStmt(Stmt s2) {
        if (!(s2 instanceof DefinitionStmt)) {
            return false;
        }
        Value leftOp = ((DefinitionStmt)s2).getLeftOp();
        Value rightOp = ((DefinitionStmt)s2).getRightOp();
        return leftOp instanceof Local && rightOp instanceof Local;
    }

    public void handleCopyStmt(DefinitionStmt copyStmt) {
        Local definedLocal = (Local)copyStmt.getLeftOp();
        List temp = this.useDefs.getDUChain(copyStmt);
        ArrayList uses = new ArrayList();
        if (temp != null) {
            uses = (ArrayList)temp;
        }
        if (uses.size() != 0) {
            if (DEBUG) {
                System.out.println(">>>>The defined local:" + definedLocal + " is used in the following");
                System.out.println("\n numof uses:" + uses.size() + uses + ">>>>>>>>>>>>>>>\n\n");
            }
            Local leftLocal = (Local)copyStmt.getLeftOp();
            Local rightLocal = (Local)copyStmt.getRightOp();
            ReachingCopies reachingCopies = this.reachingCopies;
            reachingCopies.getClass();
            ReachingCopies.LocalPair localPair = reachingCopies.new ReachingCopies.LocalPair(leftLocal, rightLocal);
            for (Object tempUse : uses) {
                DavaFlowSet reaching = this.reachingCopies.getReachingCopies(tempUse);
                if (reaching.contains(localPair)) continue;
                return;
            }
            for (Object tempUse : uses) {
                if (DEBUG) {
                    System.out.println("copy stmt reached this use" + tempUse);
                }
                this.replace(leftLocal, rightLocal, tempUse);
            }
            this.removeStmt(copyStmt);
            if (this.someCopyStmtModified) {
                this.setup();
                this.someCopyStmtModified = false;
            }
        } else {
            this.removeStmt(copyStmt);
        }
    }

    public void removeStmt(Stmt stmt) {
        Object tempParent = this.parentOf.getParentOf(stmt);
        if (tempParent == null) {
            return;
        }
        ASTNode parent = (ASTNode)tempParent;
        if (!(parent instanceof ASTStatementSequenceNode)) {
            throw new RuntimeException("Found a stmt whose parent is not an ASTStatementSequenceNode");
        }
        ASTStatementSequenceNode parentNode = (ASTStatementSequenceNode)parent;
        ArrayList<AugmentedStmt> newSequence = new ArrayList<AugmentedStmt>();
        for (AugmentedStmt as : parentNode.getStatements()) {
            Stmt s2 = as.get_Stmt();
            if (s2.toString().compareTo(stmt.toString()) == 0) continue;
            newSequence.add(as);
        }
        parentNode.setStatements(newSequence);
        this.ASTMODIFIED = true;
    }

    public void modifyUses(Local from, Local to, ASTCondition cond) {
        if (cond instanceof ASTAggregatedCondition) {
            this.modifyUses(from, to, ((ASTAggregatedCondition)cond).getLeftOp());
            this.modifyUses(from, to, ((ASTAggregatedCondition)cond).getRightOp());
        } else if (cond instanceof ASTUnaryCondition) {
            Value val = ((ASTUnaryCondition)cond).getValue();
            if (val instanceof Local) {
                Local local = (Local)val;
                if (local.getName().compareTo(from.getName()) == 0) {
                    ((ASTUnaryCondition)cond).setValue(to);
                    this.ASTMODIFIED = true;
                }
            } else {
                for (ValueBox valBox : val.getUseBoxes()) {
                    Local local;
                    Value tempVal = valBox.getValue();
                    if (!(tempVal instanceof Local) || (local = (Local)tempVal).getName().compareTo(from.getName()) != 0) continue;
                    valBox.setValue(to);
                    this.ASTMODIFIED = true;
                }
            }
        } else if (cond instanceof ASTBinaryCondition) {
            ConditionExpr val = ((ASTBinaryCondition)cond).getConditionExpr();
            for (ValueBox valBox : val.getUseBoxes()) {
                Local local;
                Value tempVal = valBox.getValue();
                if (!(tempVal instanceof Local) || (local = (Local)tempVal).getName().compareTo(from.getName()) != 0) continue;
                valBox.setValue(to);
                this.ASTMODIFIED = true;
            }
        } else {
            throw new RuntimeException("Method getUseList in CopyPropagation encountered unknown condition type");
        }
    }

    public void modifyUseBoxes(Local from, Local to, List useBoxes) {
        for (ValueBox valBox : useBoxes) {
            Local local;
            Value tempVal = valBox.getValue();
            if (!(tempVal instanceof Local) || (local = (Local)tempVal).getName().compareTo(from.getName()) != 0) continue;
            valBox.setValue(to);
            this.ASTMODIFIED = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void replace(Local from, Local to, Object use) {
        if (use instanceof Stmt) {
            Stmt s2 = (Stmt)use;
            if (this.isCopyStmt(s2)) {
                this.someCopyStmtModified = true;
            }
            List<ValueBox> useBoxes = s2.getUseBoxes();
            if (DEBUG) {
                System.out.println("Printing uses for stmt" + useBoxes);
            }
            this.modifyUseBoxes(from, to, useBoxes);
            return;
        } else {
            if (!(use instanceof ASTNode)) throw new RuntimeException("Encountered an unknown use in copyPropagation method replace");
            if (use instanceof ASTSwitchNode) {
                ASTSwitchNode temp = (ASTSwitchNode)use;
                Value val = temp.get_Key();
                if (val instanceof Local) {
                    if (((Local)val).getName().compareTo(from.getName()) != 0) return;
                    this.ASTMODIFIED = true;
                    temp.set_Key(to);
                    return;
                } else {
                    List<ValueBox> useBoxes = val.getUseBoxes();
                    this.modifyUseBoxes(from, to, useBoxes);
                }
                return;
            } else if (use instanceof ASTSynchronizedBlockNode) {
                ASTSynchronizedBlockNode temp = (ASTSynchronizedBlockNode)use;
                Local local = temp.getLocal();
                if (local.getName().compareTo(from.getName()) != 0) return;
                temp.setLocal(to);
                this.ASTMODIFIED = true;
                return;
            } else if (use instanceof ASTIfNode) {
                if (DEBUG) {
                    System.out.println("Use is an instanceof if node");
                }
                ASTIfNode temp = (ASTIfNode)use;
                ASTCondition cond = temp.get_Condition();
                this.modifyUses(from, to, cond);
                return;
            } else if (use instanceof ASTIfElseNode) {
                ASTIfElseNode temp = (ASTIfElseNode)use;
                ASTCondition cond = temp.get_Condition();
                this.modifyUses(from, to, cond);
                return;
            } else if (use instanceof ASTWhileNode) {
                ASTWhileNode temp = (ASTWhileNode)use;
                ASTCondition cond = temp.get_Condition();
                this.modifyUses(from, to, cond);
                return;
            } else if (use instanceof ASTDoWhileNode) {
                ASTDoWhileNode temp = (ASTDoWhileNode)use;
                ASTCondition cond = temp.get_Condition();
                this.modifyUses(from, to, cond);
                return;
            } else {
                Stmt s3;
                if (!(use instanceof ASTForLoopNode)) throw new RuntimeException("Encountered an unknown ASTNode in copyPropagation method replace");
                ASTForLoopNode temp = (ASTForLoopNode)use;
                for (AugmentedStmt as : temp.getInit()) {
                    s3 = as.get_Stmt();
                    this.replace(from, to, s3);
                }
                for (AugmentedStmt as : temp.getUpdate()) {
                    s3 = as.get_Stmt();
                    this.replace(from, to, s3);
                }
                ASTCondition cond = temp.get_Condition();
                this.modifyUses(from, to, cond);
            }
        }
    }
}

